/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kinesis;

import com.google.common.base.Preconditions;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.common.api.EncryptionContext;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.functions.source.RecordWithEncryptionContext;
import org.apache.pulsar.io.kinesis.fbs.EncryptionCtx;
import org.apache.pulsar.io.kinesis.fbs.EncryptionKey;
import org.apache.pulsar.io.kinesis.fbs.KeyValue;
import org.apache.pulsar.io.kinesis.fbs.Message;

public class Utils {
    private static final String PAYLOAD_FIELD = "payloadBase64";
    private static final String PROPERTIES_FIELD = "properties";
    private static final String KEY_MAP_FIELD = "keysMapBase64";
    private static final String KEY_METADATA_MAP_FIELD = "keysMetadataMap";
    private static final String ENCRYPTION_PARAM_FIELD = "encParamBase64";
    private static final String ALGO_FIELD = "algorithm";
    private static final String COMPRESSION_TYPE_FIELD = "compressionType";
    private static final String UNCPRESSED_MSG_SIZE_FIELD = "uncompressedMessageSize";
    private static final String BATCH_SIZE_FIELD = "batchSize";
    private static final String ENCRYPTION_CTX_FIELD = "encryptionCtx";
    private static final FlatBufferBuilder DEFAULT_FB_BUILDER = new FlatBufferBuilder(0);

    public static ByteBuffer serializeRecordToFlatBuffer(Record<byte[]> record) {
        DEFAULT_FB_BUILDER.clear();
        return Utils.serializeRecordToFlatBuffer(DEFAULT_FB_BUILDER, record);
    }

    public static ByteBuffer serializeRecordToFlatBuffer(FlatBufferBuilder builder, Record<byte[]> record) {
        Preconditions.checkNotNull(record, (Object)"record-context can't be null");
        Optional encryptionCtx = record instanceof RecordWithEncryptionContext ? ((RecordWithEncryptionContext)record).getEncryptionCtx() : Optional.empty();
        Map properties = record.getProperties();
        int encryptionCtxOffset = -1;
        int propertiesOffset = -1;
        if (properties != null && !properties.isEmpty()) {
            int[] propertiesOffsetArray = new int[properties.size()];
            int i = 0;
            for (Map.Entry property : properties.entrySet()) {
                propertiesOffsetArray[i++] = KeyValue.createKeyValue(builder, builder.createString((CharSequence)property.getKey()), builder.createString((CharSequence)property.getValue()));
            }
            propertiesOffset = Message.createPropertiesVector(builder, propertiesOffsetArray);
        }
        if (encryptionCtx.isPresent()) {
            encryptionCtxOffset = Utils.createEncryptionCtxOffset(builder, encryptionCtx);
        }
        int payloadOffset = Message.createPayloadVector(builder, (byte[])record.getValue());
        Message.startMessage(builder);
        Message.addPayload(builder, payloadOffset);
        if (encryptionCtxOffset != -1) {
            Message.addEncryptionCtx(builder, encryptionCtxOffset);
        }
        if (propertiesOffset != -1) {
            Message.addProperties(builder, propertiesOffset);
        }
        int endMessage = Message.endMessage(builder);
        builder.finish(endMessage);
        ByteBuffer bb = builder.dataBuffer();
        int space = bb.capacity() - builder.offset();
        return ByteBuffer.wrap(bb.array(), space, bb.capacity() - space);
    }

    private static int createEncryptionCtxOffset(FlatBufferBuilder builder, Optional<EncryptionContext> encryptionCtx) {
        byte compressionType;
        if (!encryptionCtx.isPresent()) {
            return -1;
        }
        EncryptionContext ctx = encryptionCtx.get();
        int[] keysOffsets = new int[ctx.getKeys().size()];
        int keyIndex = 0;
        for (Map.Entry entry : ctx.getKeys().entrySet()) {
            int key = builder.createString((CharSequence)entry.getKey());
            int value = EncryptionKey.createValueVector(builder, ((EncryptionContext.EncryptionKey)entry.getValue()).getKeyValue());
            Map metadata = ((EncryptionContext.EncryptionKey)entry.getValue()).getMetadata();
            int[] metadataOffsets = new int[metadata.size()];
            int i = 0;
            for (Map.Entry m : metadata.entrySet()) {
                metadataOffsets[i++] = KeyValue.createKeyValue(builder, builder.createString((CharSequence)m.getKey()), builder.createString((CharSequence)m.getValue()));
            }
            int metadataOffset = -1;
            if (metadata.size() > 0) {
                metadataOffset = EncryptionKey.createMetadataVector(builder, metadataOffsets);
            }
            EncryptionKey.startEncryptionKey(builder);
            EncryptionKey.addKey(builder, key);
            EncryptionKey.addValue(builder, value);
            if (metadataOffset != -1) {
                EncryptionKey.addMetadata(builder, metadataOffset);
            }
            keysOffsets[keyIndex++] = EncryptionKey.endEncryptionKey(builder);
        }
        int keysOffset = EncryptionCtx.createKeysVector(builder, keysOffsets);
        int param = EncryptionCtx.createParamVector(builder, ctx.getParam());
        int algo = builder.createString((CharSequence)ctx.getAlgorithm());
        int batchSize = ctx.getBatchSize().isPresent() ? (Integer)ctx.getBatchSize().get() : 1;
        switch (ctx.getCompressionType()) {
            case LZ4: {
                compressionType = 1;
                break;
            }
            case ZLIB: {
                compressionType = 2;
                break;
            }
            default: {
                compressionType = 0;
            }
        }
        return EncryptionCtx.createEncryptionCtx(builder, keysOffset, param, algo, compressionType, ctx.getUncompressedMessageSize(), batchSize, ctx.getBatchSize().isPresent());
    }

    public static String serializeRecordToJson(Record<byte[]> record) {
        Optional optEncryptionCtx;
        Preconditions.checkNotNull(record, (Object)"record can't be null");
        JsonObject result = new JsonObject();
        result.addProperty(PAYLOAD_FIELD, Base64.getEncoder().encodeToString((byte[])record.getValue()));
        if (record.getProperties() != null) {
            JsonObject properties = new JsonObject();
            record.getProperties().entrySet().forEach(e -> properties.addProperty((String)e.getKey(), (String)e.getValue()));
            result.add(PROPERTIES_FIELD, (JsonElement)properties);
        }
        Optional optional = optEncryptionCtx = record instanceof RecordWithEncryptionContext ? ((RecordWithEncryptionContext)record).getEncryptionCtx() : Optional.empty();
        if (optEncryptionCtx.isPresent()) {
            EncryptionContext encryptionCtx = (EncryptionContext)optEncryptionCtx.get();
            JsonObject encryptionCtxJson = new JsonObject();
            JsonObject keyBase64Map = new JsonObject();
            JsonObject keyMetadataMap = new JsonObject();
            encryptionCtx.getKeys().entrySet().forEach(entry -> {
                keyBase64Map.addProperty((String)entry.getKey(), Base64.getEncoder().encodeToString(((EncryptionContext.EncryptionKey)entry.getValue()).getKeyValue()));
                Map keyMetadata = ((EncryptionContext.EncryptionKey)entry.getValue()).getMetadata();
                if (keyMetadata != null && !keyMetadata.isEmpty()) {
                    JsonObject metadata = new JsonObject();
                    ((EncryptionContext.EncryptionKey)entry.getValue()).getMetadata().entrySet().forEach(m -> metadata.addProperty((String)m.getKey(), (String)m.getValue()));
                    keyMetadataMap.add((String)entry.getKey(), (JsonElement)metadata);
                }
            });
            encryptionCtxJson.add(KEY_MAP_FIELD, (JsonElement)keyBase64Map);
            encryptionCtxJson.add(KEY_METADATA_MAP_FIELD, (JsonElement)keyMetadataMap);
            encryptionCtxJson.addProperty(ENCRYPTION_PARAM_FIELD, Base64.getEncoder().encodeToString(encryptionCtx.getParam()));
            encryptionCtxJson.addProperty(ALGO_FIELD, encryptionCtx.getAlgorithm());
            if (encryptionCtx.getCompressionType() != null) {
                encryptionCtxJson.addProperty(COMPRESSION_TYPE_FIELD, encryptionCtx.getCompressionType().name());
                encryptionCtxJson.addProperty(UNCPRESSED_MSG_SIZE_FIELD, (Number)encryptionCtx.getUncompressedMessageSize());
            }
            if (encryptionCtx.getBatchSize().isPresent()) {
                encryptionCtxJson.addProperty(BATCH_SIZE_FIELD, (Number)encryptionCtx.getBatchSize().get());
            }
            result.add(ENCRYPTION_CTX_FIELD, (JsonElement)encryptionCtxJson);
        }
        return result.toString();
    }
}

