/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kinesis;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.avro.generic.GenericRecord;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.GenericObject;
import org.apache.pulsar.client.api.schema.KeyValueSchema;
import org.apache.pulsar.common.api.EncryptionContext;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.kinesis.fbs.EncryptionCtx;
import org.apache.pulsar.io.kinesis.fbs.EncryptionKey;
import org.apache.pulsar.io.kinesis.fbs.KeyValue;
import org.apache.pulsar.io.kinesis.fbs.Message;
import org.apache.pulsar.io.kinesis.json.JsonConverter;
import org.apache.pulsar.io.kinesis.json.JsonRecord;

public class Utils {
    private static final String PAYLOAD_FIELD = "payloadBase64";
    private static final String PROPERTIES_FIELD = "properties";
    private static final String KEY_MAP_FIELD = "keysMapBase64";
    private static final String KEY_METADATA_MAP_FIELD = "keysMetadataMap";
    private static final String ENCRYPTION_PARAM_FIELD = "encParamBase64";
    private static final String ALGO_FIELD = "algorithm";
    private static final String COMPRESSION_TYPE_FIELD = "compressionType";
    private static final String UNCPRESSED_MSG_SIZE_FIELD = "uncompressedMessageSize";
    private static final String BATCH_SIZE_FIELD = "batchSize";
    private static final String ENCRYPTION_CTX_FIELD = "encryptionCtx";
    private static final FlatBufferBuilder DEFAULT_FB_BUILDER = new FlatBufferBuilder(0);

    public static ByteBuffer serializeRecordToFlatBuffer(Record<GenericObject> record) {
        DEFAULT_FB_BUILDER.clear();
        return Utils.serializeRecordToFlatBuffer(DEFAULT_FB_BUILDER, record);
    }

    public static ByteBuffer serializeRecordToFlatBuffer(FlatBufferBuilder builder, Record<GenericObject> record) {
        Preconditions.checkNotNull(record, (Object)"record-context can't be null");
        org.apache.pulsar.client.api.Message<GenericObject> recordMessage = Utils.getMessage(record);
        Optional encryptionCtx = recordMessage.getEncryptionCtx();
        Map properties = record.getProperties();
        int encryptionCtxOffset = -1;
        int propertiesOffset = -1;
        if (properties != null && !properties.isEmpty()) {
            int[] propertiesOffsetArray = new int[properties.size()];
            int i = 0;
            for (Map.Entry property : properties.entrySet()) {
                propertiesOffsetArray[i++] = KeyValue.createKeyValue(builder, builder.createString((CharSequence)property.getKey()), builder.createString((CharSequence)property.getValue()));
            }
            propertiesOffset = Message.createPropertiesVector(builder, propertiesOffsetArray);
        }
        if (encryptionCtx.isPresent()) {
            encryptionCtxOffset = Utils.createEncryptionCtxOffset(builder, (EncryptionContext)encryptionCtx.get());
        }
        int payloadOffset = Message.createPayloadVector(builder, recordMessage.getData());
        Message.startMessage(builder);
        Message.addPayload(builder, payloadOffset);
        if (encryptionCtxOffset != -1) {
            Message.addEncryptionCtx(builder, encryptionCtxOffset);
        }
        if (propertiesOffset != -1) {
            Message.addProperties(builder, propertiesOffset);
        }
        int endMessage = Message.endMessage(builder);
        builder.finish(endMessage);
        ByteBuffer bb = builder.dataBuffer();
        int space = bb.capacity() - builder.offset();
        return ByteBuffer.wrap(bb.array(), space, bb.capacity() - space);
    }

    private static int createEncryptionCtxOffset(FlatBufferBuilder builder, EncryptionContext ctx) {
        byte compressionType;
        if (ctx == null) {
            return -1;
        }
        int[] keysOffsets = new int[ctx.getKeys().size()];
        int keyIndex = 0;
        for (Map.Entry entry : ctx.getKeys().entrySet()) {
            int key = builder.createString((CharSequence)entry.getKey());
            int value = EncryptionKey.createValueVector(builder, ((EncryptionContext.EncryptionKey)entry.getValue()).getKeyValue());
            Map metadata = ((EncryptionContext.EncryptionKey)entry.getValue()).getMetadata();
            int[] metadataOffsets = new int[metadata.size()];
            int i = 0;
            for (Map.Entry m : metadata.entrySet()) {
                metadataOffsets[i++] = KeyValue.createKeyValue(builder, builder.createString((CharSequence)m.getKey()), builder.createString((CharSequence)m.getValue()));
            }
            int metadataOffset = -1;
            if (metadata.size() > 0) {
                metadataOffset = EncryptionKey.createMetadataVector(builder, metadataOffsets);
            }
            EncryptionKey.startEncryptionKey(builder);
            EncryptionKey.addKey(builder, key);
            EncryptionKey.addValue(builder, value);
            if (metadataOffset != -1) {
                EncryptionKey.addMetadata(builder, metadataOffset);
            }
            keysOffsets[keyIndex++] = EncryptionKey.endEncryptionKey(builder);
        }
        int keysOffset = EncryptionCtx.createKeysVector(builder, keysOffsets);
        int param = EncryptionCtx.createParamVector(builder, ctx.getParam());
        int algo = builder.createString((CharSequence)ctx.getAlgorithm());
        int batchSize = ctx.getBatchSize().isPresent() ? (Integer)ctx.getBatchSize().get() : 1;
        switch (ctx.getCompressionType()) {
            case LZ4: {
                compressionType = 1;
                break;
            }
            case ZLIB: {
                compressionType = 2;
                break;
            }
            default: {
                compressionType = 0;
            }
        }
        return EncryptionCtx.createEncryptionCtx(builder, keysOffset, param, algo, compressionType, ctx.getUncompressedMessageSize(), batchSize, ctx.getBatchSize().isPresent());
    }

    public static String serializeRecordToJson(Record<GenericObject> record) {
        Optional optEncryptionCtx;
        Preconditions.checkNotNull(record, (Object)"record can't be null");
        org.apache.pulsar.client.api.Message<GenericObject> recordMessage = Utils.getMessage(record);
        JsonObject result = new JsonObject();
        result.addProperty(PAYLOAD_FIELD, Base64.getEncoder().encodeToString(recordMessage.getData()));
        if (record.getProperties() != null) {
            JsonObject properties = new JsonObject();
            record.getProperties().forEach((arg_0, arg_1) -> ((JsonObject)properties).addProperty(arg_0, arg_1));
            result.add(PROPERTIES_FIELD, (JsonElement)properties);
        }
        if ((optEncryptionCtx = recordMessage.getEncryptionCtx()).isPresent()) {
            EncryptionContext encryptionCtx = (EncryptionContext)optEncryptionCtx.get();
            JsonObject encryptionCtxJson = new JsonObject();
            JsonObject keyBase64Map = new JsonObject();
            JsonObject keyMetadataMap = new JsonObject();
            encryptionCtx.getKeys().forEach((key, value) -> {
                keyBase64Map.addProperty(key, Base64.getEncoder().encodeToString(value.getKeyValue()));
                Map keyMetadata = value.getMetadata();
                if (keyMetadata != null && !keyMetadata.isEmpty()) {
                    JsonObject metadata = new JsonObject();
                    value.getMetadata().forEach((arg_0, arg_1) -> ((JsonObject)metadata).addProperty(arg_0, arg_1));
                    keyMetadataMap.add(key, (JsonElement)metadata);
                }
            });
            encryptionCtxJson.add(KEY_MAP_FIELD, (JsonElement)keyBase64Map);
            encryptionCtxJson.add(KEY_METADATA_MAP_FIELD, (JsonElement)keyMetadataMap);
            encryptionCtxJson.addProperty(ENCRYPTION_PARAM_FIELD, Base64.getEncoder().encodeToString(encryptionCtx.getParam()));
            encryptionCtxJson.addProperty(ALGO_FIELD, encryptionCtx.getAlgorithm());
            if (encryptionCtx.getCompressionType() != null) {
                encryptionCtxJson.addProperty(COMPRESSION_TYPE_FIELD, encryptionCtx.getCompressionType().name());
                encryptionCtxJson.addProperty(UNCPRESSED_MSG_SIZE_FIELD, (Number)encryptionCtx.getUncompressedMessageSize());
            }
            if (encryptionCtx.getBatchSize().isPresent()) {
                encryptionCtxJson.addProperty(BATCH_SIZE_FIELD, (Number)encryptionCtx.getBatchSize().get());
            }
            result.add(ENCRYPTION_CTX_FIELD, (JsonElement)encryptionCtxJson);
        }
        return result.toString();
    }

    public static String serializeRecordToJsonExpandingValue(ObjectMapper mapper, Record<GenericObject> record) throws JsonProcessingException {
        JsonRecord jsonRecord = new JsonRecord();
        GenericObject value = (GenericObject)record.getValue();
        if (value != null) {
            jsonRecord.setPayload(Utils.toJsonSerializable(record.getSchema(), value.getNativeObject()));
        }
        record.getKey().ifPresent(jsonRecord::setKey);
        record.getTopicName().ifPresent(jsonRecord::setTopicName);
        record.getEventTime().ifPresent(jsonRecord::setEventTime);
        record.getProperties().forEach(jsonRecord::addProperty);
        return mapper.writeValueAsString((Object)jsonRecord);
    }

    public static org.apache.pulsar.client.api.Message<GenericObject> getMessage(Record<GenericObject> record) {
        return (org.apache.pulsar.client.api.Message)record.getMessage().orElseThrow(() -> new IllegalArgumentException("Record does not carry message information"));
    }

    private static Object toJsonSerializable(Schema<?> schema, Object val) {
        if (schema == null || schema.getSchemaInfo().getType().isPrimitive()) {
            return val;
        }
        switch (schema.getSchemaInfo().getType()) {
            case KEY_VALUE: {
                KeyValueSchema keyValueSchema = (KeyValueSchema)schema;
                org.apache.pulsar.common.schema.KeyValue keyValue = (org.apache.pulsar.common.schema.KeyValue)val;
                HashMap<String, Object> jsonKeyValue = new HashMap<String, Object>();
                jsonKeyValue.put("key", Utils.toJsonSerializable(keyValueSchema.getKeySchema(), ((GenericObject)keyValue.getKey()).getNativeObject()));
                jsonKeyValue.put("value", Utils.toJsonSerializable(keyValueSchema.getValueSchema(), ((GenericObject)keyValue.getValue()).getNativeObject()));
                return jsonKeyValue;
            }
            case AVRO: {
                return JsonConverter.toJson((GenericRecord)val);
            }
            case JSON: {
                return val;
            }
        }
        throw new UnsupportedOperationException("Unsupported key schemaType=" + schema.getSchemaInfo().getType());
    }
}

