/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kinesis;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.apache.pulsar.io.kinesis.BaseKinesisConfig;

public class KinesisSinkConfig
extends BaseKinesisConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="ONLY_RAW_PAYLOAD", help="Message format in which kinesis sink converts pulsar messages and publishes to kinesis streams.\n  #\n  # The available messages formats are: \n  #\n  # - ONLY_RAW_PAYLOAD \n  #\n  #   Kinesis sink directly publishes pulsar message payload as a message into the configured kinesis stream. \n  #\n  # - FULL_MESSAGE_IN_JSON \n  #\n  #   Kinesis sink creates a json payload with pulsar message payload, properties and encryptionCtx, \n  #   and publishes json payload into the configured kinesis stream.\n  #\n  # - FULL_MESSAGE_IN_FB \n  #\n  #   Kinesis sink creates a flatbuffer serialized paylaod with pulsar message payload, \n  #   properties and encryptionCtx, and publishes flatbuffer payload into the configured kinesis stream.")
    private MessageFormat messageFormat = MessageFormat.ONLY_RAW_PAYLOAD;
    @FieldDoc(required=false, defaultValue="false", help="A flag to tell Pulsar IO to retain ordering when moving messages from Pulsar to Kinesis")
    private boolean retainOrdering = false;
    @FieldDoc(required=false, defaultValue="100", help="The initial delay(in milliseconds) between retries.")
    private long retryInitialDelayInMillis = 100L;
    @FieldDoc(required=false, defaultValue="60000", help="The maximum delay(in milliseconds) between retries.")
    private long retryMaxDelayInMillis = 60000L;

    public static KinesisSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (KinesisSinkConfig)mapper.readValue(new File(yamlFile), KinesisSinkConfig.class);
    }

    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    public boolean isRetainOrdering() {
        return this.retainOrdering;
    }

    public long getRetryInitialDelayInMillis() {
        return this.retryInitialDelayInMillis;
    }

    public long getRetryMaxDelayInMillis() {
        return this.retryMaxDelayInMillis;
    }

    public void setMessageFormat(MessageFormat messageFormat) {
        this.messageFormat = messageFormat;
    }

    public void setRetainOrdering(boolean retainOrdering) {
        this.retainOrdering = retainOrdering;
    }

    public void setRetryInitialDelayInMillis(long retryInitialDelayInMillis) {
        this.retryInitialDelayInMillis = retryInitialDelayInMillis;
    }

    public void setRetryMaxDelayInMillis(long retryMaxDelayInMillis) {
        this.retryMaxDelayInMillis = retryMaxDelayInMillis;
    }

    @Override
    public String toString() {
        return "KinesisSinkConfig(messageFormat=" + (Object)((Object)this.getMessageFormat()) + ", retainOrdering=" + this.isRetainOrdering() + ", retryInitialDelayInMillis=" + this.getRetryInitialDelayInMillis() + ", retryMaxDelayInMillis=" + this.getRetryMaxDelayInMillis() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KinesisSinkConfig)) {
            return false;
        }
        KinesisSinkConfig other = (KinesisSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isRetainOrdering() != other.isRetainOrdering()) {
            return false;
        }
        if (this.getRetryInitialDelayInMillis() != other.getRetryInitialDelayInMillis()) {
            return false;
        }
        if (this.getRetryMaxDelayInMillis() != other.getRetryMaxDelayInMillis()) {
            return false;
        }
        MessageFormat this$messageFormat = this.getMessageFormat();
        MessageFormat other$messageFormat = other.getMessageFormat();
        return !(this$messageFormat == null ? other$messageFormat != null : !((Object)((Object)this$messageFormat)).equals((Object)other$messageFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KinesisSinkConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isRetainOrdering() ? 79 : 97);
        long $retryInitialDelayInMillis = this.getRetryInitialDelayInMillis();
        result = result * 59 + (int)($retryInitialDelayInMillis >>> 32 ^ $retryInitialDelayInMillis);
        long $retryMaxDelayInMillis = this.getRetryMaxDelayInMillis();
        result = result * 59 + (int)($retryMaxDelayInMillis >>> 32 ^ $retryMaxDelayInMillis);
        MessageFormat $messageFormat = this.getMessageFormat();
        result = result * 59 + ($messageFormat == null ? 43 : ((Object)((Object)$messageFormat)).hashCode());
        return result;
    }

    public static enum MessageFormat {
        ONLY_RAW_PAYLOAD,
        FULL_MESSAGE_IN_JSON,
        FULL_MESSAGE_IN_FB;

    }
}

