/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.jdbc;

import com.google.common.collect.Lists;
import java.sql.PreparedStatement;
import java.util.List;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.jdbc.JdbcAbstractSink;
import org.apache.pulsar.io.jdbc.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJdbcAutoSchemaSink
extends JdbcAbstractSink<GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(BaseJdbcAutoSchemaSink.class);

    @Override
    public void bindValue(PreparedStatement statement, Record<GenericRecord> message, String action) throws Exception {
        GenericRecord record = (GenericRecord)message.getValue();
        List<Object> columns = Lists.newArrayList();
        if (action == null || action.equals("INSERT")) {
            columns = this.tableDefinition.getColumns();
        } else if (action.equals("DELETE")) {
            columns.addAll(this.tableDefinition.getKeyColumns());
        } else if (action.equals("UPDATE")) {
            columns.addAll(this.tableDefinition.getNonKeyColumns());
            columns.addAll(this.tableDefinition.getKeyColumns());
        }
        int index = 1;
        for (JdbcUtils.ColumnId columnId : columns) {
            String colName = columnId.getName();
            int colType = columnId.getType();
            if (log.isDebugEnabled()) {
                log.debug("colName: {} colType: {}", (Object)colName, (Object)colType);
            }
            try {
                Object obj = record.getField(colName);
                if (obj != null) {
                    BaseJdbcAutoSchemaSink.setColumnValue(statement, index++, obj);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Column {} is null", (Object)colName);
                }
                BaseJdbcAutoSchemaSink.setColumnNull(statement, index++, colType);
            }
            catch (NullPointerException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Column {} is null", (Object)colName);
                }
                BaseJdbcAutoSchemaSink.setColumnNull(statement, index++, colType);
            }
        }
    }

    private static void setColumnNull(PreparedStatement statement, int index, int type) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Setting column value to null, statement: {}, index: {}", (Object)statement.toString(), (Object)index);
        }
        statement.setNull(index, type);
    }

    private static void setColumnValue(PreparedStatement statement, int index, Object value) throws Exception {
        log.debug("Setting column value, statement: {}, index: {}, value: {}", new Object[]{statement.toString(), index, value.toString()});
        if (value instanceof Integer) {
            statement.setInt(index, (Integer)value);
        } else if (value instanceof Long) {
            statement.setLong(index, (Long)value);
        } else if (value instanceof Double) {
            statement.setDouble(index, (Double)value);
        } else if (value instanceof Float) {
            statement.setFloat(index, ((Float)value).floatValue());
        } else if (value instanceof Boolean) {
            statement.setBoolean(index, (Boolean)value);
        } else if (value instanceof String) {
            statement.setString(index, (String)value);
        } else if (value instanceof Short) {
            statement.setShort(index, (Short)value);
        } else {
            throw new Exception("Not support value type, need to add it. " + value.getClass());
        }
    }
}

