/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import org.apache.pulsar.io.jdbc.JdbcDriverType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);

    public static TableId getTableId(Connection connection, String tableName) throws Exception {
        DatabaseMetaData metadata = connection.getMetaData();
        Throwable throwable = null;
        try (ResultSet rs = metadata.getTables(null, null, tableName, new String[]{"TABLE"});){
            if (rs.next()) {
                String catalogName = rs.getString(1);
                String schemaName = rs.getString(2);
                String gotTableName = rs.getString(3);
                Preconditions.checkState((boolean)tableName.equals(gotTableName), (Object)("TableName not match: " + tableName + " Got: " + gotTableName));
                if (log.isDebugEnabled()) {
                    log.debug("Get Table: {}, {}, {}", new Object[]{catalogName, schemaName, tableName});
                }
                TableId tableId = TableId.of(catalogName, schemaName, tableName);
                return tableId;
            }
            try {
                throw new Exception("Not able to find table: " + tableName);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static TableDefinition getTableDefinition(Connection connection, TableId tableId, List<String> keyList, List<String> nonKeyList) throws Exception {
        TableDefinition table = TableDefinition.of(tableId, Lists.newArrayList(), Lists.newArrayList(), Lists.newArrayList());
        try (ResultSet rs = connection.getMetaData().getColumns(tableId.getCatalogName(), tableId.getSchemaName(), tableId.getTableName(), null);){
            while (rs.next()) {
                String columnName = rs.getString(4);
                int sqlDataType = rs.getInt(5);
                String typeName = rs.getString(6);
                int position = rs.getInt(17);
                ColumnId columnId = ColumnId.of(tableId, columnName, sqlDataType, typeName, position);
                table.columns.add(columnId);
                if (keyList != null) {
                    keyList.forEach(key -> {
                        if (key.equals(columnName)) {
                            table.keyColumns.add(columnId);
                        }
                    });
                }
                if (nonKeyList != null) {
                    nonKeyList.forEach(key -> {
                        if (key.equals(columnName)) {
                            table.nonKeyColumns.add(columnId);
                        }
                    });
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Get column. name: {}, data type: {}, position: {}", new Object[]{columnName, typeName, position});
            }
            TableDefinition tableDefinition = table;
            return tableDefinition;
        }
    }

    public static String buildInsertSql(TableDefinition table) {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(table.tableId.getTableName());
        builder.append("(");
        table.columns.forEach(columnId -> builder.append(columnId.getName()).append(","));
        builder.deleteCharAt(builder.length() - 1);
        builder.append(") VALUES(");
        IntStream.range(0, table.columns.size() - 1).forEach(i -> builder.append("?,"));
        builder.append("?)");
        return builder.toString();
    }

    public static PreparedStatement buildInsertStatement(Connection connection, String insertSQL) throws SQLException {
        return connection.prepareStatement(insertSQL);
    }

    public static String combationWhere(List<ColumnId> columnIds) {
        StringBuilder builder = new StringBuilder();
        if (!columnIds.isEmpty()) {
            builder.append(" WHERE ");
            StringJoiner whereJoiner = new StringJoiner(" AND ");
            columnIds.forEach(columnId -> {
                StringJoiner equals = new StringJoiner("=");
                equals.add(columnId.getName()).add("?");
                whereJoiner.add(equals.toString());
            });
            builder.append(whereJoiner.toString());
            return builder.toString();
        }
        return "";
    }

    public static String buildUpdateSql(TableDefinition table) {
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(table.tableId.getTableName());
        builder.append(" SET ");
        StringJoiner setJoiner = new StringJoiner(",");
        table.nonKeyColumns.forEach(columnId -> {
            StringJoiner equals = new StringJoiner("=");
            equals.add(columnId.getName()).add("? ");
            setJoiner.add(equals.toString());
        });
        builder.append(setJoiner.toString());
        builder.append(JdbcUtils.combationWhere(table.keyColumns));
        return builder.toString();
    }

    public static PreparedStatement buildUpdateStatement(Connection connection, String updateSQL) throws SQLException {
        return connection.prepareStatement(updateSQL);
    }

    public static String buildDeleteSql(TableDefinition table) {
        return "DELETE FROM " + table.tableId.getTableName() + JdbcUtils.combationWhere(table.keyColumns);
    }

    public static PreparedStatement buildDeleteStatement(Connection connection, String deleteSQL) throws SQLException {
        return connection.prepareStatement(deleteSQL);
    }

    public static String getDriverClassName(String jdbcUrl) throws Exception {
        for (JdbcDriverType type : JdbcDriverType.values()) {
            if (!type.matches(jdbcUrl)) continue;
            return type.getDriverClass();
        }
        throw new Exception("Provided JDBC connection string contains unknown driver: " + jdbcUrl);
    }

    public static class TableDefinition {
        private final TableId tableId;
        private final List<ColumnId> columns;
        private final List<ColumnId> nonKeyColumns;
        private final List<ColumnId> keyColumns;

        private TableDefinition(TableId tableId, List<ColumnId> columns) {
            this(tableId, columns, null, null);
        }

        private TableDefinition(TableId tableId, List<ColumnId> columns, List<ColumnId> nonKeyColumns, List<ColumnId> keyColumns) {
            this.tableId = tableId;
            this.columns = columns;
            this.nonKeyColumns = nonKeyColumns;
            this.keyColumns = keyColumns;
        }

        public static TableDefinition of(TableId tableId, List<ColumnId> columns) {
            return new TableDefinition(tableId, columns);
        }

        public static TableDefinition of(TableId tableId, List<ColumnId> columns, List<ColumnId> nonKeyColumns, List<ColumnId> keyColumns) {
            return new TableDefinition(tableId, columns, nonKeyColumns, keyColumns);
        }

        public TableId getTableId() {
            return this.tableId;
        }

        public List<ColumnId> getColumns() {
            return this.columns;
        }

        public List<ColumnId> getNonKeyColumns() {
            return this.nonKeyColumns;
        }

        public List<ColumnId> getKeyColumns() {
            return this.keyColumns;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableDefinition)) {
                return false;
            }
            TableDefinition other = (TableDefinition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TableId this$tableId = this.getTableId();
            TableId other$tableId = other.getTableId();
            if (this$tableId == null ? other$tableId != null : !((Object)this$tableId).equals(other$tableId)) {
                return false;
            }
            List<ColumnId> this$columns = this.getColumns();
            List<ColumnId> other$columns = other.getColumns();
            if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
                return false;
            }
            List<ColumnId> this$nonKeyColumns = this.getNonKeyColumns();
            List<ColumnId> other$nonKeyColumns = other.getNonKeyColumns();
            if (this$nonKeyColumns == null ? other$nonKeyColumns != null : !((Object)this$nonKeyColumns).equals(other$nonKeyColumns)) {
                return false;
            }
            List<ColumnId> this$keyColumns = this.getKeyColumns();
            List<ColumnId> other$keyColumns = other.getKeyColumns();
            return !(this$keyColumns == null ? other$keyColumns != null : !((Object)this$keyColumns).equals(other$keyColumns));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TableDefinition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TableId $tableId = this.getTableId();
            result = result * 59 + ($tableId == null ? 43 : ((Object)$tableId).hashCode());
            List<ColumnId> $columns = this.getColumns();
            result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
            List<ColumnId> $nonKeyColumns = this.getNonKeyColumns();
            result = result * 59 + ($nonKeyColumns == null ? 43 : ((Object)$nonKeyColumns).hashCode());
            List<ColumnId> $keyColumns = this.getKeyColumns();
            result = result * 59 + ($keyColumns == null ? 43 : ((Object)$keyColumns).hashCode());
            return result;
        }

        public String toString() {
            return "JdbcUtils.TableDefinition(tableId=" + this.getTableId() + ", columns=" + this.getColumns() + ", nonKeyColumns=" + this.getNonKeyColumns() + ", keyColumns=" + this.getKeyColumns() + ")";
        }
    }

    public static class ColumnId {
        private final TableId tableId;
        private final String name;
        private final int type;
        private final String typeName;
        private final int position;

        @ConstructorProperties(value={"tableId", "name", "type", "typeName", "position"})
        private ColumnId(TableId tableId, String name, int type, String typeName, int position) {
            this.tableId = tableId;
            this.name = name;
            this.type = type;
            this.typeName = typeName;
            this.position = position;
        }

        public static ColumnId of(TableId tableId, String name, int type, String typeName, int position) {
            return new ColumnId(tableId, name, type, typeName, position);
        }

        public TableId getTableId() {
            return this.tableId;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnId)) {
                return false;
            }
            ColumnId other = (ColumnId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getType() != other.getType()) {
                return false;
            }
            if (this.getPosition() != other.getPosition()) {
                return false;
            }
            TableId this$tableId = this.getTableId();
            TableId other$tableId = other.getTableId();
            if (this$tableId == null ? other$tableId != null : !((Object)this$tableId).equals(other$tableId)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$typeName = this.getTypeName();
            String other$typeName = other.getTypeName();
            return !(this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ColumnId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getType();
            result = result * 59 + this.getPosition();
            TableId $tableId = this.getTableId();
            result = result * 59 + ($tableId == null ? 43 : ((Object)$tableId).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $typeName = this.getTypeName();
            result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
            return result;
        }

        public String toString() {
            return "JdbcUtils.ColumnId(tableId=" + this.getTableId() + ", name=" + this.getName() + ", type=" + this.getType() + ", typeName=" + this.getTypeName() + ", position=" + this.getPosition() + ")";
        }
    }

    public static class TableId {
        private final String catalogName;
        private final String schemaName;
        private final String tableName;

        @ConstructorProperties(value={"catalogName", "schemaName", "tableName"})
        private TableId(String catalogName, String schemaName, String tableName) {
            this.catalogName = catalogName;
            this.schemaName = schemaName;
            this.tableName = tableName;
        }

        public static TableId of(String catalogName, String schemaName, String tableName) {
            return new TableId(catalogName, schemaName, tableName);
        }

        public String getCatalogName() {
            return this.catalogName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableId)) {
                return false;
            }
            TableId other = (TableId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$catalogName = this.getCatalogName();
            String other$catalogName = other.getCatalogName();
            if (this$catalogName == null ? other$catalogName != null : !this$catalogName.equals(other$catalogName)) {
                return false;
            }
            String this$schemaName = this.getSchemaName();
            String other$schemaName = other.getSchemaName();
            if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
                return false;
            }
            String this$tableName = this.getTableName();
            String other$tableName = other.getTableName();
            return !(this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TableId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $catalogName = this.getCatalogName();
            result = result * 59 + ($catalogName == null ? 43 : $catalogName.hashCode());
            String $schemaName = this.getSchemaName();
            result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
            String $tableName = this.getTableName();
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            return result;
        }

        public String toString() {
            return "JdbcUtils.TableId(catalogName=" + this.getCatalogName() + ", schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ")";
        }
    }
}

