/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.file.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class GZipFiles {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGzip(File f) {
        boolean bl;
        FileInputStream input = null;
        try {
            input = new FileInputStream(f);
            PushbackInputStream pb = new PushbackInputStream(input, 2);
            byte[] signature = new byte[2];
            int len = pb.read(signature);
            pb.unread(signature, 0, len);
            bl = signature[0] == 31 && signature[1] == -117;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
            return bl2;
        }
        IOUtils.closeQuietly((InputStream)input);
        return bl;
    }

    public static Stream<String> lines(Path path) {
        GZIPInputStream gzipStream = null;
        try {
            gzipStream = new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            GZipFiles.closeSafely(gzipStream);
            throw new UncheckedIOException(e);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(gzipStream));
        return (Stream)reader.lines().onClose(() -> GZipFiles.closeSafely(reader));
    }

    private static void closeSafely(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

