/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.file.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.zip.ZipInputStream;

public class ZipFiles {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZip(File f) {
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));){
            int test = in.readInt();
            boolean bl = test == 1347093252;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Stream<String> lines(Path path) {
        ZipInputStream zipStream = null;
        try {
            zipStream = new ZipInputStream(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            ZipFiles.closeSafely(zipStream);
            throw new UncheckedIOException(e);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(zipStream));
        return (Stream)reader.lines().onClose(() -> ZipFiles.closeSafely(reader));
    }

    private static void closeSafely(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

