/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.file.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;

public class GZipFiles {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isGzip(File f) {
        try (FileInputStream input = new FileInputStream(f);){
            PushbackInputStream pb = new PushbackInputStream(input, 2);
            byte[] signature = new byte[2];
            int len = pb.read(signature);
            pb.unread(signature, 0, len);
            boolean bl = signature[0] == 31 && signature[1] == -117;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Stream<String> lines(Path path) {
        GZIPInputStream gzipStream = null;
        try {
            gzipStream = new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            GZipFiles.closeSafely(gzipStream);
            throw new UncheckedIOException(e);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(gzipStream));
        return (Stream)reader.lines().onClose(() -> GZipFiles.closeSafely(reader));
    }

    private static void closeSafely(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

