/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.dynamodb;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibDependencyException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ShutdownException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ThrottlingException;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.types.InitializationInput;
import com.amazonaws.services.kinesis.clientlibrary.types.ProcessRecordsInput;
import com.amazonaws.services.kinesis.clientlibrary.types.ShutdownInput;
import com.amazonaws.services.kinesis.model.Record;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.pulsar.io.dynamodb.DynamoDBSourceConfig;
import org.apache.pulsar.io.dynamodb.StreamsRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsRecordProcessor
implements IRecordProcessor {
    private static final Logger log = LoggerFactory.getLogger(StreamsRecordProcessor.class);
    private final int numRetries;
    private final long checkpointInterval;
    private final long backoffTime;
    private final LinkedBlockingQueue<StreamsRecord> queue;
    private long nextCheckpointTimeInNanos;
    private String kinesisShardId;

    public StreamsRecordProcessor(LinkedBlockingQueue<StreamsRecord> queue, DynamoDBSourceConfig config) {
        this.queue = queue;
        this.checkpointInterval = config.getCheckpointInterval();
        this.numRetries = config.getNumRetries();
        this.backoffTime = config.getBackoffTime();
    }

    private void checkpoint(IRecordProcessorCheckpointer checkpointer) {
        log.info("Checkpointing shard " + this.kinesisShardId);
        for (int i = 0; i < this.numRetries; ++i) {
            try {
                checkpointer.checkpoint();
                break;
            }
            catch (ShutdownException se) {
                log.info("Caught shutdown exception, skipping checkpoint.", (Throwable)se);
                break;
            }
            catch (InvalidStateException e) {
                log.error("Cannot save checkpoint to the DynamoDB table.", (Throwable)e);
                break;
            }
            catch (KinesisClientLibDependencyException | ThrottlingException e) {
                if (i >= this.numRetries - 1) {
                    log.error("Checkpoint failed after " + (i + 1) + "attempts.", e);
                    break;
                }
                try {
                    Thread.sleep(this.backoffTime);
                }
                catch (InterruptedException e2) {
                    log.debug("Interrupted sleep", (Throwable)e2);
                }
                continue;
            }
        }
    }

    public void initialize(InitializationInput initializationInput) {
        this.kinesisShardId = initializationInput.getShardId();
    }

    public void processRecords(ProcessRecordsInput processRecordsInput) {
        log.debug("Processing {} records from {}", (Object)processRecordsInput.getRecords().size(), (Object)this.kinesisShardId);
        for (Record record : processRecordsInput.getRecords()) {
            try {
                this.queue.put(new StreamsRecord(record));
            }
            catch (InterruptedException e) {
                log.warn("unable to create KinesisRecord ", (Throwable)e);
            }
        }
        if (System.nanoTime() > this.nextCheckpointTimeInNanos) {
            this.checkpoint(processRecordsInput.getCheckpointer());
            this.nextCheckpointTimeInNanos = System.nanoTime() + this.checkpointInterval;
        }
    }

    public void shutdown(ShutdownInput shutdownInput) {
        log.info("Shutting down record processor for shard: {}", (Object)this.kinesisShardId);
        this.checkpoint(shutdownInput.getCheckpointer());
    }
}

