/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.docs;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.base.Strings;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.pulsar.io.core.annotations.Connector;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorDocGenerator {
    private static final Logger log = LoggerFactory.getLogger(ConnectorDocGenerator.class);
    private static final String INDENT = "  ";
    private final Reflections reflections = ConnectorDocGenerator.newReflections();

    private static Reflections newReflections() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        ClassLoader[] classLoaders = new ClassLoader[]{ConnectorDocGenerator.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        for (int i = 0; i < classLoaders.length; ++i) {
            if (!(classLoaders[i] instanceof URLClassLoader)) {
                throw new RuntimeException("ClassLoader '" + classLoaders[i] + " is not an instance of URLClassLoader");
            }
            urls.addAll(Arrays.asList(((URLClassLoader)classLoaders[i]).getURLs()));
        }
        ConfigurationBuilder confBuilder = new ConfigurationBuilder();
        confBuilder.setUrls(urls);
        return new Reflections((Configuration)confBuilder);
    }

    private void generateConnectorYaml(Class configClass, PrintWriter writer) {
        Field[] fields;
        log.info("Processing connector config class : {}", (Object)configClass);
        writer.println("configs:");
        for (Field field : fields = configClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            FieldDoc fieldDoc = field.getDeclaredAnnotation(FieldDoc.class);
            if (null == fieldDoc) {
                throw new RuntimeException("Missing `FieldDoc` for field '" + field.getName() + "'");
            }
            writer.println("  # " + fieldDoc.help());
            String fieldPrefix = "";
            if (!fieldDoc.required()) {
                fieldPrefix = "# ";
            }
            if (Strings.isNullOrEmpty((String)fieldDoc.defaultValue())) {
                writer.println(INDENT + fieldPrefix + field.getName() + ":");
            } else {
                writer.println(INDENT + fieldPrefix + field.getName() + ": " + fieldDoc.defaultValue());
            }
            writer.println();
        }
        writer.flush();
    }

    private void generateConnectorYaml(Class connectorClass, Connector connectorDef, PrintWriter writer) {
        log.info("Processing connector definition : {}", (Object)connectorDef);
        writer.println("# " + connectorDef.type() + " connector : " + connectorClass.getName());
        writer.println();
        writer.println("# " + connectorDef.help());
        writer.println();
        this.generateConnectorYaml(connectorDef.configClass(), writer);
    }

    private void generatorConnectorYamls(String outputDir) throws IOException {
        Set connectorClasses = this.reflections.getTypesAnnotatedWith(Connector.class);
        log.info("Retrieve all `Connector` annotated classes : {}", (Object)connectorClasses);
        for (Class connectorClass : connectorClasses) {
            Connector connectorDef = connectorClass.getDeclaredAnnotation(Connector.class);
            FileWriter fileWriter = new FileWriter(Paths.get(outputDir, "pulsar-io-" + connectorDef.name() + "-" + connectorDef.type().name().toLowerCase()).toString() + ".yml");
            Throwable throwable = null;
            try {
                PrintWriter pw = new PrintWriter(fileWriter);
                this.generateConnectorYaml(connectorClass, connectorDef, pw);
                pw.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileWriter == null) continue;
                if (throwable != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fileWriter.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        MainArgs mainArgs = new MainArgs();
        JCommander commander = new JCommander();
        try {
            commander.setProgramName("connector-doc-gen");
            commander.addObject((Object)mainArgs);
            commander.parse(args);
            if (mainArgs.help) {
                commander.usage();
                Runtime.getRuntime().exit(0);
                return;
            }
        }
        catch (Exception e) {
            commander.usage();
            Runtime.getRuntime().exit(-1);
            return;
        }
        ConnectorDocGenerator docGen = new ConnectorDocGenerator();
        docGen.generatorConnectorYamls(mainArgs.outputDir);
    }

    private static class MainArgs {
        @Parameter(names={"-o", "--output-dir"}, description="The output dir to dump connector docs", required=true)
        String outputDir = null;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        boolean help = false;

        private MainArgs() {
        }
    }
}

