/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.pulsar.io.aws.AwsCredentialProviderPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.utils.StringUtils;

public abstract class AbstractAwsConnector {
    private static final Logger log = LoggerFactory.getLogger(AbstractAwsConnector.class);
    public static final String ACCESS_KEY_NAME = "accessKey";
    public static final String SECRET_KEY_NAME = "secretKey";

    public AwsCredentialProviderPlugin createCredentialProvider(String awsCredentialPluginName, String awsCredentialPluginParam) {
        if (StringUtils.isNotBlank((CharSequence)awsCredentialPluginName)) {
            return AbstractAwsConnector.createCredentialProviderWithPlugin(awsCredentialPluginName, awsCredentialPluginParam);
        }
        return this.defaultCredentialProvider(awsCredentialPluginParam);
    }

    public static AwsCredentialProviderPlugin createCredentialProviderWithPlugin(String pluginFQClassName, String param) throws IllegalArgumentException {
        try {
            Class<?> clazz = Class.forName(pluginFQClassName);
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            AwsCredentialProviderPlugin plugin = (AwsCredentialProviderPlugin)ctor.newInstance(new Object[0]);
            plugin.init(param);
            return plugin;
        }
        catch (Exception e) {
            log.error("Failed to initialize AwsCredentialProviderPlugin {}", (Object)pluginFQClassName, (Object)e);
            throw new IllegalArgumentException(String.format("invalid authplugin name %s , failed to init %s", pluginFQClassName, e.getMessage()));
        }
    }

    public AwsCredentialProviderPlugin defaultCredentialProvider(String awsCredentialPluginParam) {
        Map credentialMap = (Map)new Gson().fromJson(awsCredentialPluginParam, new TypeToken<Map<String, String>>(){}.getType());
        final String accessKey = (String)credentialMap.get(ACCESS_KEY_NAME);
        final String secretKey = (String)credentialMap.get(SECRET_KEY_NAME);
        if (!StringUtils.isNotBlank((CharSequence)accessKey) || !StringUtils.isNotBlank((CharSequence)secretKey)) {
            throw new IllegalArgumentException(String.format("Default %s and %s must be present into json-map if AwsCredentialProviderPlugin not provided", ACCESS_KEY_NAME, SECRET_KEY_NAME));
        }
        return new AwsCredentialProviderPlugin(){

            @Override
            public void init(String param) {
            }

            @Override
            public AWSCredentialsProvider getCredentialProvider() {
                return AbstractAwsConnector.this.defaultCredentialProvider(accessKey, secretKey);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    private AWSCredentialsProvider defaultCredentialProvider(final String accessKey, final String secretKey) {
        return new AWSCredentialsProvider(){

            public AWSCredentials getCredentials() {
                return new AWSCredentials(){

                    public String getAWSAccessKeyId() {
                        return accessKey;
                    }

                    public String getAWSSecretKey() {
                        return secretKey;
                    }
                };
            }

            public void refresh() {
            }
        };
    }
}

