/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.policies.data.FunctionInstanceStatsImpl;
import org.apache.pulsar.common.policies.data.WorkerFunctionInstanceStats;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.RestException;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.worker.FunctionRuntimeInfo;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.apache.pulsar.functions.worker.MembershipManager;
import org.apache.pulsar.functions.worker.PulsarWorkerService;
import org.apache.pulsar.functions.worker.SchedulerManager;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.apache.pulsar.functions.worker.rest.RestUtils;
import org.apache.pulsar.functions.worker.service.api.Workers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerImpl
implements Workers<PulsarWorkerService> {
    private static final Logger log = LoggerFactory.getLogger(WorkerImpl.class);
    private final Supplier<PulsarWorkerService> workerServiceSupplier;

    public WorkerImpl(Supplier<PulsarWorkerService> workerServiceSupplier) {
        this.workerServiceSupplier = workerServiceSupplier;
    }

    private PulsarWorkerService worker() {
        try {
            return (PulsarWorkerService)Preconditions.checkNotNull((Object)this.workerServiceSupplier.get());
        }
        catch (Throwable t) {
            log.info("Failed to get worker service", t);
            throw t;
        }
    }

    private boolean isWorkerServiceAvailable() {
        WorkerService workerService = this.workerServiceSupplier.get();
        if (workerService == null) {
            return false;
        }
        return workerService.isInitialized();
    }

    @Override
    public List<WorkerInfo> getCluster(String clientRole) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(clientRole)) {
            throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
        }
        List<WorkerInfo> workers = this.worker().getMembershipManager().getCurrentMembership();
        return workers;
    }

    @Override
    public WorkerInfo getClusterLeader(String clientRole) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(clientRole)) {
            log.error("Client [{}] is not authorized to get cluster leader", (Object)clientRole);
            throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
        }
        MembershipManager membershipManager = this.worker().getMembershipManager();
        WorkerInfo leader = membershipManager.getLeader();
        if (leader == null) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "Leader cannot be determined");
        }
        return leader;
    }

    @Override
    public Map<String, Collection<String>> getAssignments(String clientRole) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(clientRole)) {
            log.error("Client [{}] is not authorized to get cluster assignments", (Object)clientRole);
            throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
        }
        FunctionRuntimeManager functionRuntimeManager = this.worker().getFunctionRuntimeManager();
        Map<String, Map<String, Function.Assignment>> assignments = functionRuntimeManager.getCurrentAssignments();
        HashMap<String, Collection<String>> ret = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, Map<String, Function.Assignment>> entry : assignments.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().keySet());
        }
        return ret;
    }

    private boolean isSuperUser(String clientRole) {
        return clientRole != null && this.worker().getWorkerConfig().getSuperUserRoles().contains(clientRole);
    }

    @Override
    public List<Metrics> getWorkerMetrics(String clientRole) {
        if (!this.isWorkerServiceAvailable() || this.worker().getMetricsGenerator() == null) {
            RestUtils.throwUnavailableException();
        }
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(clientRole)) {
            log.error("Client [{}] is not authorized to get worker stats", (Object)clientRole);
            throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
        }
        return this.worker().getMetricsGenerator().generate();
    }

    @Override
    public List<WorkerFunctionInstanceStats> getFunctionsMetrics(String clientRole) throws IOException {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(clientRole)) {
            log.error("Client [{}] is not authorized to get function stats", (Object)clientRole);
            throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
        }
        Map<String, FunctionRuntimeInfo> functionRuntimes = this.worker().getFunctionRuntimeManager().getFunctionRuntimeInfos();
        ArrayList<WorkerFunctionInstanceStats> metricsList = new ArrayList<WorkerFunctionInstanceStats>(functionRuntimes.size());
        for (Map.Entry<String, FunctionRuntimeInfo> entry : functionRuntimes.entrySet()) {
            String fullyQualifiedInstanceName = entry.getKey();
            FunctionRuntimeInfo functionRuntimeInfo = entry.getValue();
            if (this.worker().getFunctionRuntimeManager().getRuntimeFactory().externallyManaged()) {
                Function.FunctionDetails functionDetails = functionRuntimeInfo.getFunctionInstance().getFunctionMetaData().getFunctionDetails();
                int parallelism = functionDetails.getParallelism();
                for (int i = 0; i < parallelism; ++i) {
                    FunctionInstanceStatsImpl functionInstanceStats = WorkerUtils.getFunctionInstanceStats(fullyQualifiedInstanceName, functionRuntimeInfo, i);
                    WorkerFunctionInstanceStats workerFunctionInstanceStats = new WorkerFunctionInstanceStats();
                    workerFunctionInstanceStats.setName(FunctionCommon.getFullyQualifiedInstanceId((String)functionDetails.getTenant(), (String)functionDetails.getNamespace(), (String)functionDetails.getName(), (int)i));
                    workerFunctionInstanceStats.setMetrics(functionInstanceStats.getMetrics());
                    metricsList.add(workerFunctionInstanceStats);
                }
                continue;
            }
            FunctionInstanceStatsImpl functionInstanceStats = WorkerUtils.getFunctionInstanceStats(fullyQualifiedInstanceName, functionRuntimeInfo, functionRuntimeInfo.getFunctionInstance().getInstanceId());
            WorkerFunctionInstanceStats workerFunctionInstanceStats = new WorkerFunctionInstanceStats();
            workerFunctionInstanceStats.setName(fullyQualifiedInstanceName);
            workerFunctionInstanceStats.setMetrics(functionInstanceStats.getMetrics());
            metricsList.add(workerFunctionInstanceStats);
        }
        return metricsList;
    }

    @Override
    public List<ConnectorDefinition> getListOfConnectors(String clientRole) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(clientRole)) {
            throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
        }
        return this.worker().getConnectorsManager().getConnectorDefinitions();
    }

    @Override
    public void rebalance(URI uri, String clientRole) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(clientRole)) {
            log.error("Client [{}] is not authorized rebalance cluster", (Object)clientRole);
            throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
        }
        if (this.worker().getLeaderService().isLeader()) {
            try {
                this.worker().getSchedulerManager().rebalanceIfNotInprogress();
            }
            catch (SchedulerManager.RebalanceInProgressException e) {
                throw new RestException(Response.Status.BAD_REQUEST, "Rebalance already in progress");
            }
        } else {
            WorkerInfo workerInfo = this.worker().getMembershipManager().getLeader();
            URI redirect = UriBuilder.fromUri((URI)uri).host(workerInfo.getWorkerHostname()).port(workerInfo.getPort()).build(new Object[0]);
            throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
        }
    }

    @Override
    public Boolean isLeaderReady(String clientRole) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (this.worker().getLeaderService().isLeader()) {
            return true;
        }
        RestUtils.throwUnavailableException();
        return false;
    }
}

