/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.common.util.Reflections;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.worker.ErrorNotifier;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.apache.pulsar.functions.worker.LeaderService;
import org.apache.pulsar.functions.worker.MembershipManager;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerStatsManager;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.apache.pulsar.functions.worker.scheduler.IScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SchedulerManager.class);
    private final WorkerConfig workerConfig;
    private final ErrorNotifier errorNotifier;
    private final WorkerStatsManager workerStatsManager;
    private ThreadPoolExecutor executorService;
    private final PulsarClient pulsarClient;
    private FunctionMetaDataManager functionMetaDataManager;
    private LeaderService leaderService;
    private MembershipManager membershipManager;
    private FunctionRuntimeManager functionRuntimeManager;
    private final IScheduler scheduler;
    private Producer<byte[]> exclusiveProducer;
    private ScheduledExecutorService scheduledExecutorService;
    private final PulsarAdmin admin;
    private Lock schedulerLock = new ReentrantLock(true);
    private volatile boolean isRunning = false;
    AtomicBoolean isCompactionNeeded = new AtomicBoolean(false);
    private static final long DEFAULT_ADMIN_API_BACKOFF_SEC = 60L;
    public static final String HEARTBEAT_TENANT = "pulsar-function";
    public static final String HEARTBEAT_NAMESPACE = "heartbeat";
    private MessageId lastMessageProduced = null;
    private MessageId metadataTopicLastMessage = MessageId.earliest;
    private Future<?> currentRebalanceFuture;
    private AtomicBoolean rebalanceInProgess = new AtomicBoolean(false);

    public SchedulerManager(WorkerConfig workerConfig, PulsarClient pulsarClient, PulsarAdmin admin, WorkerStatsManager workerStatsManager, ErrorNotifier errorNotifier) {
        this.workerConfig = workerConfig;
        this.pulsarClient = pulsarClient;
        this.admin = admin;
        this.scheduler = (IScheduler)Reflections.createInstance((String)workerConfig.getSchedulerClassName(), IScheduler.class, (ClassLoader)Thread.currentThread().getContextClassLoader());
        this.workerStatsManager = workerStatsManager;
        this.errorNotifier = errorNotifier;
    }

    public Producer<byte[]> acquireExclusiveWrite(Supplier<Boolean> isLeader) throws WorkerUtils.NotLeaderAnymore {
        return WorkerUtils.createExclusiveProducerWithRetry(this.pulsarClient, this.workerConfig.getFunctionAssignmentTopic(), this.workerConfig.getWorkerId() + "-scheduler-manager", isLeader, 10000);
    }

    public synchronized void initialize(Producer<byte[]> exclusiveProducer) {
        if (!this.isRunning) {
            log.info("Initializing scheduler manager");
            this.exclusiveProducer = exclusiveProducer;
            this.executorService = new ThreadPoolExecutor(1, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(5));
            this.executorService.setThreadFactory(new ThreadFactoryBuilder().setNameFormat("worker-scheduler-%d").build());
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("worker-assignment-topic-compactor"));
            if (this.workerConfig.getTopicCompactionFrequencySec() > 0L) {
                this.scheduleCompaction(this.scheduledExecutorService, this.workerConfig.getTopicCompactionFrequencySec());
            }
            this.isRunning = true;
            this.lastMessageProduced = null;
        } else {
            log.error("Scheduler Manager entered invalid state");
            this.errorNotifier.triggerError(new IllegalStateException());
        }
    }

    private Future<?> scheduleInternal(Runnable runnable, String errMsg) {
        if (!this.leaderService.isLeader()) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            return this.executorService.submit(() -> {
                try {
                    this.schedulerLock.lock();
                    boolean isLeader = this.leaderService.isLeader();
                    if (isLeader) {
                        try {
                            runnable.run();
                        }
                        catch (Throwable th) {
                            log.error("Encountered error when invoking scheduler [{}]", (Object)errMsg);
                            this.errorNotifier.triggerError(th);
                        }
                    }
                }
                finally {
                    this.schedulerLock.unlock();
                }
            });
        }
        catch (RejectedExecutionException e) {
            log.debug("Rejected task to invoke scheduler since task queue is already full");
            return CompletableFuture.completedFuture(null);
        }
    }

    public Future<?> schedule() {
        return this.scheduleInternal(() -> {
            this.workerStatsManager.scheduleTotalExecTimeStart();
            this.invokeScheduler();
            this.workerStatsManager.scheduleTotalExecTimeEnd();
        }, "Encountered error when invoking scheduler");
    }

    private Future<?> rebalance() {
        return this.scheduleInternal(() -> {
            this.workerStatsManager.rebalanceTotalExecTimeStart();
            this.invokeRebalance();
            this.workerStatsManager.rebalanceTotalExecTimeEnd();
        }, "Encountered error when invoking rebalance");
    }

    public Future<?> rebalanceIfNotInprogress() {
        if (this.rebalanceInProgess.compareAndSet(false, true)) {
            this.currentRebalanceFuture = this.rebalance();
            return this.currentRebalanceFuture;
        }
        throw new RebalanceInProgressException();
    }

    @VisibleForTesting
    void invokeScheduler() {
        long startTime = System.nanoTime();
        Set<String> currentMembership = this.membershipManager.getCurrentMembership().stream().map(workerInfo -> workerInfo.getWorkerId()).collect(Collectors.toSet());
        List<Function.FunctionMetaData> allFunctions = this.functionMetaDataManager.getAllFunctionMetaData();
        Map<String, Function.Instance> allInstances = SchedulerManager.computeAllInstances(allFunctions, this.functionRuntimeManager.getRuntimeFactory().externallyManaged());
        Map<String, Map<String, Function.Assignment>> workerIdToAssignments = this.functionRuntimeManager.getCurrentAssignments();
        SchedulerStats schedulerStats = new SchedulerStats(workerIdToAssignments, currentMembership);
        Iterator<Map.Entry<String, Map<String, Function.Assignment>>> it = workerIdToAssignments.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Map<String, Function.Assignment>> workerIdToAssignmentEntry2 = it.next();
            Map<String, Function.Assignment> functionMap = workerIdToAssignmentEntry2.getValue();
            functionMap.entrySet().removeIf(entry -> {
                boolean deleted;
                String fullyQualifiedInstanceId = (String)entry.getKey();
                boolean bl = deleted = !allInstances.containsKey(fullyQualifiedInstanceId);
                if (deleted) {
                    Function.Assignment assignment = (Function.Assignment)entry.getValue();
                    MessageId messageId = this.publishNewAssignment(assignment.toBuilder().build(), true);
                    log.info("Deleting assignment: {}", (Object)assignment);
                    this.functionRuntimeManager.deleteAssignment(fullyQualifiedInstanceId);
                    this.lastMessageProduced = messageId;
                    schedulerStats.removedAssignment(assignment);
                }
                return deleted;
            });
            for (Map.Entry<String, Function.Assignment> entry2 : functionMap.entrySet()) {
                String fullyQualifiedInstanceId = entry2.getKey();
                Function.Assignment assignment = entry2.getValue();
                Function.Instance instance = allInstances.get(fullyQualifiedInstanceId);
                if (!assignment.getInstance().equals((Object)instance)) {
                    functionMap.put(fullyQualifiedInstanceId, assignment.toBuilder().setInstance(instance).build());
                    Function.Assignment newAssignment = assignment.toBuilder().setInstance(instance).build().toBuilder().build();
                    MessageId messageId = this.publishNewAssignment(newAssignment, false);
                    log.info("Updating assignment: {}", (Object)newAssignment);
                    this.functionRuntimeManager.processAssignment(newAssignment);
                    this.lastMessageProduced = messageId;
                    schedulerStats.updatedAssignment(newAssignment);
                }
                if (!functionMap.isEmpty()) continue;
                it.remove();
            }
        }
        List<Function.Assignment> currentAssignments = workerIdToAssignments.entrySet().stream().filter(workerIdToAssignmentEntry -> {
            String workerId = (String)workerIdToAssignmentEntry.getKey();
            return currentMembership.contains(workerId);
        }).flatMap(stringMapEntry -> ((Map)stringMapEntry.getValue()).values().stream()).collect(Collectors.toList());
        Pair<List<Function.Instance>, List<Function.Assignment>> unassignedInstances = this.getUnassignedFunctionInstances(workerIdToAssignments, allInstances);
        this.workerStatsManager.scheduleStrategyExecTimeStartStart();
        List<Function.Assignment> assignments = this.scheduler.schedule((List)unassignedInstances.getLeft(), currentAssignments, currentMembership);
        this.workerStatsManager.scheduleStrategyExecTimeStartEnd();
        assignments.addAll((Collection)unassignedInstances.getRight());
        if (log.isDebugEnabled()) {
            log.debug("New assignments computed: {}", assignments);
        }
        this.isCompactionNeeded.set(!assignments.isEmpty());
        for (Function.Assignment assignment : assignments) {
            MessageId messageId = this.publishNewAssignment(assignment, false);
            log.info("Adding assignment: {}", (Object)assignment);
            this.functionRuntimeManager.processAssignment(assignment);
            this.lastMessageProduced = messageId;
            schedulerStats.newAssignment(assignment);
        }
        log.info("Schedule summary - execution time: {} sec | total unassigned: {} | stats: {}\n{}", new Object[]{(double)(System.nanoTime() - startTime) / Math.pow(10.0, 9.0), ((List)unassignedInstances.getLeft()).size(), schedulerStats.getSummary(), schedulerStats});
    }

    private void invokeRebalance() {
        long startTime = System.nanoTime();
        Set<String> currentMembership = this.membershipManager.getCurrentMembership().stream().map(workerInfo -> workerInfo.getWorkerId()).collect(Collectors.toSet());
        Map<String, Map<String, Function.Assignment>> workerIdToAssignments = this.functionRuntimeManager.getCurrentAssignments();
        SchedulerStats schedulerStats = new SchedulerStats(workerIdToAssignments, currentMembership);
        List<Function.Assignment> currentAssignments = workerIdToAssignments.entrySet().stream().filter(workerIdToAssignmentEntry -> {
            String workerId = (String)workerIdToAssignmentEntry.getKey();
            return currentMembership.contains(workerId);
        }).flatMap(stringMapEntry -> ((Map)stringMapEntry.getValue()).values().stream()).collect(Collectors.toList());
        this.workerStatsManager.rebalanceStrategyExecTimeStart();
        List<Function.Assignment> rebalancedAssignments = this.scheduler.rebalance(currentAssignments, currentMembership);
        this.workerStatsManager.rebalanceStrategyExecTimeEnd();
        for (Function.Assignment assignment : rebalancedAssignments) {
            MessageId messageId = this.publishNewAssignment(assignment, false);
            log.info("Rebalance - new assignment: {}", (Object)assignment);
            this.functionRuntimeManager.processAssignment(assignment);
            this.lastMessageProduced = messageId;
            schedulerStats.newAssignment(assignment);
        }
        log.info("Rebalance summary - execution time: {} sec | stats: {}\n{}", new Object[]{(double)(System.nanoTime() - startTime) / Math.pow(10.0, 9.0), schedulerStats.getSummary(), schedulerStats});
        this.rebalanceInProgess.set(false);
    }

    private void scheduleCompaction(ScheduledExecutorService executor, long scheduleFrequencySec) {
        if (executor != null) {
            executor.scheduleWithFixedDelay(() -> {
                if (this.leaderService.isLeader() && this.isCompactionNeeded.get()) {
                    this.compactAssignmentTopic();
                    this.isCompactionNeeded.set(false);
                }
            }, scheduleFrequencySec, scheduleFrequencySec, TimeUnit.SECONDS);
            executor.scheduleWithFixedDelay(() -> {
                if (this.leaderService.isLeader() && this.metadataTopicLastMessage.compareTo((Object)this.functionMetaDataManager.getLastMessageSeen()) != 0) {
                    this.metadataTopicLastMessage = this.functionMetaDataManager.getLastMessageSeen();
                    this.compactFunctionMetadataTopic();
                }
            }, scheduleFrequencySec, scheduleFrequencySec, TimeUnit.SECONDS);
        }
    }

    private void compactAssignmentTopic() {
        if (this.admin != null) {
            try {
                this.admin.topics().triggerCompaction(this.workerConfig.getFunctionAssignmentTopic());
            }
            catch (PulsarAdminException e) {
                log.error("Failed to trigger compaction", (Throwable)e);
                this.scheduledExecutorService.schedule(() -> this.compactAssignmentTopic(), 60L, TimeUnit.SECONDS);
            }
        }
    }

    private void compactFunctionMetadataTopic() {
        if (this.admin != null) {
            try {
                this.admin.topics().triggerCompaction(this.workerConfig.getFunctionMetadataTopic());
            }
            catch (PulsarAdminException e) {
                log.error("Failed to trigger compaction", (Throwable)e);
                this.scheduledExecutorService.schedule(() -> this.compactFunctionMetadataTopic(), 60L, TimeUnit.SECONDS);
            }
        }
    }

    private MessageId publishNewAssignment(Function.Assignment assignment, boolean deleted) {
        try {
            String fullyQualifiedInstanceId = FunctionCommon.getFullyQualifiedInstanceId((Function.Instance)assignment.getInstance());
            return this.exclusiveProducer.newMessage().key(fullyQualifiedInstanceId).value((Object)(deleted ? "".getBytes() : assignment.toByteArray())).send();
        }
        catch (Exception e) {
            log.error("Failed to {} assignment update {}", new Object[]{assignment, deleted ? "send" : "deleted", e});
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Function.Instance> computeAllInstances(List<Function.FunctionMetaData> allFunctions, boolean externallyManagedRuntime) {
        HashMap<String, Function.Instance> functionInstances = new HashMap<String, Function.Instance>();
        for (Function.FunctionMetaData functionMetaData : allFunctions) {
            for (Function.Instance instance : SchedulerManager.computeInstances(functionMetaData, externallyManagedRuntime)) {
                functionInstances.put(FunctionCommon.getFullyQualifiedInstanceId((Function.Instance)instance), instance);
            }
        }
        return functionInstances;
    }

    static List<Function.Instance> computeInstances(Function.FunctionMetaData functionMetaData, boolean externallyManagedRuntime) {
        LinkedList<Function.Instance> functionInstances = new LinkedList<Function.Instance>();
        if (!externallyManagedRuntime) {
            int instances = functionMetaData.getFunctionDetails().getParallelism();
            for (int i = 0; i < instances; ++i) {
                functionInstances.add(Function.Instance.newBuilder().setFunctionMetaData(functionMetaData).setInstanceId(i).build());
            }
        } else {
            functionInstances.add(Function.Instance.newBuilder().setFunctionMetaData(functionMetaData).setInstanceId(-1).build());
        }
        return functionInstances;
    }

    private Pair<List<Function.Instance>, List<Function.Assignment>> getUnassignedFunctionInstances(Map<String, Map<String, Function.Assignment>> currentAssignments, Map<String, Function.Instance> functionInstances) {
        LinkedList<Function.Instance> unassignedFunctionInstances = new LinkedList<Function.Instance>();
        ArrayList heartBeatAssignments = Lists.newArrayList();
        HashMap<String, Function.Assignment> assignmentMap = new HashMap<String, Function.Assignment>();
        for (Map<String, Function.Assignment> map : currentAssignments.values()) {
            assignmentMap.putAll(map);
        }
        for (Map.Entry entry : functionInstances.entrySet()) {
            String fullyQualifiedInstanceId = (String)entry.getKey();
            Function.Instance instance = (Function.Instance)entry.getValue();
            String heartBeatWorkerId = SchedulerManager.checkHeartBeatFunction(instance);
            if (heartBeatWorkerId != null) {
                heartBeatAssignments.add(Function.Assignment.newBuilder().setInstance(instance).setWorkerId(heartBeatWorkerId).build());
                continue;
            }
            if (assignmentMap.containsKey(fullyQualifiedInstanceId)) continue;
            unassignedFunctionInstances.add(instance);
        }
        return ImmutablePair.of(unassignedFunctionInstances, (Object)heartBeatAssignments);
    }

    @Override
    public synchronized void close() {
        log.info("Closing scheduler manager");
        try {
            this.schedulerLock.lock();
            this.isRunning = false;
            if (this.scheduledExecutorService != null) {
                this.scheduledExecutorService.shutdown();
            }
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
            if (this.exclusiveProducer != null) {
                try {
                    this.exclusiveProducer.close();
                }
                catch (PulsarClientException e) {
                    log.warn("Failed to shutdown scheduler manager assignment producer", (Throwable)e);
                }
            }
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    static String checkHeartBeatFunction(Function.Instance funInstance) {
        if (funInstance.getFunctionMetaData() != null && funInstance.getFunctionMetaData().getFunctionDetails() != null) {
            Function.FunctionDetails funDetails = funInstance.getFunctionMetaData().getFunctionDetails();
            return HEARTBEAT_TENANT.equals(funDetails.getTenant()) && HEARTBEAT_NAMESPACE.equals(funDetails.getNamespace()) ? funDetails.getName() : null;
        }
        return null;
    }

    public void setFunctionMetaDataManager(FunctionMetaDataManager functionMetaDataManager) {
        this.functionMetaDataManager = functionMetaDataManager;
    }

    public void setLeaderService(LeaderService leaderService) {
        this.leaderService = leaderService;
    }

    public void setMembershipManager(MembershipManager membershipManager) {
        this.membershipManager = membershipManager;
    }

    public void setFunctionRuntimeManager(FunctionRuntimeManager functionRuntimeManager) {
        this.functionRuntimeManager = functionRuntimeManager;
    }

    public Lock getSchedulerLock() {
        return this.schedulerLock;
    }

    public MessageId getLastMessageProduced() {
        return this.lastMessageProduced;
    }

    private static class SchedulerStats {
        private Map<String, WorkerStats> workerStatsMap = new HashMap<String, WorkerStats>();
        private Map<String, String> instanceToWorkerId = new HashMap<String, String>();

        public SchedulerStats(Map<String, Map<String, Function.Assignment>> workerIdToAssignments, Set<String> workers) {
            Map assignmentMap;
            for (String string : workers) {
                WorkerStats.WorkerStatsBuilder workerStats = WorkerStats.builder().alive(true);
                assignmentMap = workerIdToAssignments.get(string);
                if (assignmentMap != null) {
                    workerStats.originalNumAssignments(assignmentMap.size());
                    workerStats.finalNumAssignments(assignmentMap.size());
                    for (String fullyQualifiedInstanceId : assignmentMap.keySet()) {
                        this.instanceToWorkerId.put(fullyQualifiedInstanceId, string);
                    }
                } else {
                    workerStats.originalNumAssignments(0);
                    workerStats.finalNumAssignments(0);
                }
                this.workerStatsMap.put(string, workerStats.build());
            }
            for (Map.Entry entry : workerIdToAssignments.entrySet()) {
                String workerId = (String)entry.getKey();
                assignmentMap = (Map)entry.getValue();
                if (workers.contains(workerId)) continue;
                WorkerStats workerStats = WorkerStats.builder().alive(false).originalNumAssignments(assignmentMap.size()).finalNumAssignments(assignmentMap.size()).build();
                this.workerStatsMap.put(workerId, workerStats);
            }
        }

        public void removedAssignment(Function.Assignment assignment) {
            String workerId = assignment.getWorkerId();
            WorkerStats stats = this.workerStatsMap.get(workerId);
            Preconditions.checkNotNull((Object)stats);
            stats.instancesRemoved++;
            stats.finalNumAssignments--;
        }

        public void newAssignment(Function.Assignment assignment) {
            String fullyQualifiedInstanceId = FunctionCommon.getFullyQualifiedInstanceId((Function.Instance)assignment.getInstance());
            String newWorkerId = assignment.getWorkerId();
            String oldWorkerId = this.instanceToWorkerId.get(fullyQualifiedInstanceId);
            if (oldWorkerId != null) {
                WorkerStats oldWorkerStats = this.workerStatsMap.get(oldWorkerId);
                Preconditions.checkNotNull((Object)oldWorkerStats);
                oldWorkerStats.instancesRemoved++;
                oldWorkerStats.finalNumAssignments--;
            }
            WorkerStats newWorkerStats = this.workerStatsMap.get(newWorkerId);
            Preconditions.checkNotNull((Object)newWorkerStats);
            newWorkerStats.instancesAdded++;
            newWorkerStats.finalNumAssignments++;
        }

        public void updatedAssignment(Function.Assignment assignment) {
            String workerId = assignment.getWorkerId();
            WorkerStats stats = this.workerStatsMap.get(workerId);
            Preconditions.checkNotNull((Object)stats);
            stats.instancesUpdated++;
        }

        public String getSummary() {
            int totalAdded = 0;
            int totalUpdated = 0;
            int totalRemoved = 0;
            for (Map.Entry<String, WorkerStats> entry : this.workerStatsMap.entrySet()) {
                WorkerStats workerStats = entry.getValue();
                totalAdded += workerStats.instancesAdded;
                totalUpdated += workerStats.instancesUpdated;
                totalRemoved += workerStats.instancesRemoved;
            }
            return String.format("{\"Added\": %d, \"Updated\": %d, \"removed\": %d}", totalAdded, totalUpdated, totalRemoved);
        }

        public String toString() {
            try {
                return ObjectMapperFactory.getThreadLocal().writerWithDefaultPrettyPrinter().writeValueAsString(this.workerStatsMap);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        private static class WorkerStats {
            private int originalNumAssignments;
            private int finalNumAssignments;
            private int instancesAdded;
            private int instancesRemoved;
            private int instancesUpdated;
            private boolean alive;

            WorkerStats(int originalNumAssignments, int finalNumAssignments, int instancesAdded, int instancesRemoved, int instancesUpdated, boolean alive) {
                this.originalNumAssignments = originalNumAssignments;
                this.finalNumAssignments = finalNumAssignments;
                this.instancesAdded = instancesAdded;
                this.instancesRemoved = instancesRemoved;
                this.instancesUpdated = instancesUpdated;
                this.alive = alive;
            }

            public static WorkerStatsBuilder builder() {
                return new WorkerStatsBuilder();
            }

            public int getOriginalNumAssignments() {
                return this.originalNumAssignments;
            }

            public int getFinalNumAssignments() {
                return this.finalNumAssignments;
            }

            public int getInstancesAdded() {
                return this.instancesAdded;
            }

            public int getInstancesRemoved() {
                return this.instancesRemoved;
            }

            public int getInstancesUpdated() {
                return this.instancesUpdated;
            }

            public boolean isAlive() {
                return this.alive;
            }

            public void setOriginalNumAssignments(int originalNumAssignments) {
                this.originalNumAssignments = originalNumAssignments;
            }

            public void setFinalNumAssignments(int finalNumAssignments) {
                this.finalNumAssignments = finalNumAssignments;
            }

            public void setInstancesAdded(int instancesAdded) {
                this.instancesAdded = instancesAdded;
            }

            public void setInstancesRemoved(int instancesRemoved) {
                this.instancesRemoved = instancesRemoved;
            }

            public void setInstancesUpdated(int instancesUpdated) {
                this.instancesUpdated = instancesUpdated;
            }

            public void setAlive(boolean alive) {
                this.alive = alive;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WorkerStats)) {
                    return false;
                }
                WorkerStats other = (WorkerStats)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getOriginalNumAssignments() != other.getOriginalNumAssignments()) {
                    return false;
                }
                if (this.getFinalNumAssignments() != other.getFinalNumAssignments()) {
                    return false;
                }
                if (this.getInstancesAdded() != other.getInstancesAdded()) {
                    return false;
                }
                if (this.getInstancesRemoved() != other.getInstancesRemoved()) {
                    return false;
                }
                if (this.getInstancesUpdated() != other.getInstancesUpdated()) {
                    return false;
                }
                return this.isAlive() == other.isAlive();
            }

            protected boolean canEqual(Object other) {
                return other instanceof WorkerStats;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getOriginalNumAssignments();
                result = result * 59 + this.getFinalNumAssignments();
                result = result * 59 + this.getInstancesAdded();
                result = result * 59 + this.getInstancesRemoved();
                result = result * 59 + this.getInstancesUpdated();
                result = result * 59 + (this.isAlive() ? 79 : 97);
                return result;
            }

            public String toString() {
                return "SchedulerManager.SchedulerStats.WorkerStats(originalNumAssignments=" + this.getOriginalNumAssignments() + ", finalNumAssignments=" + this.getFinalNumAssignments() + ", instancesAdded=" + this.getInstancesAdded() + ", instancesRemoved=" + this.getInstancesRemoved() + ", instancesUpdated=" + this.getInstancesUpdated() + ", alive=" + this.isAlive() + ")";
            }

            public static class WorkerStatsBuilder {
                private int originalNumAssignments;
                private int finalNumAssignments;
                private int instancesAdded;
                private int instancesRemoved;
                private int instancesUpdated;
                private boolean alive;

                WorkerStatsBuilder() {
                }

                public WorkerStatsBuilder originalNumAssignments(int originalNumAssignments) {
                    this.originalNumAssignments = originalNumAssignments;
                    return this;
                }

                public WorkerStatsBuilder finalNumAssignments(int finalNumAssignments) {
                    this.finalNumAssignments = finalNumAssignments;
                    return this;
                }

                public WorkerStatsBuilder instancesAdded(int instancesAdded) {
                    this.instancesAdded = instancesAdded;
                    return this;
                }

                public WorkerStatsBuilder instancesRemoved(int instancesRemoved) {
                    this.instancesRemoved = instancesRemoved;
                    return this;
                }

                public WorkerStatsBuilder instancesUpdated(int instancesUpdated) {
                    this.instancesUpdated = instancesUpdated;
                    return this;
                }

                public WorkerStatsBuilder alive(boolean alive) {
                    this.alive = alive;
                    return this;
                }

                public WorkerStats build() {
                    return new WorkerStats(this.originalNumAssignments, this.finalNumAssignments, this.instancesAdded, this.instancesRemoved, this.instancesUpdated, this.alive);
                }

                public String toString() {
                    return "SchedulerManager.SchedulerStats.WorkerStats.WorkerStatsBuilder(originalNumAssignments=" + this.originalNumAssignments + ", finalNumAssignments=" + this.finalNumAssignments + ", instancesAdded=" + this.instancesAdded + ", instancesRemoved=" + this.instancesRemoved + ", instancesUpdated=" + this.instancesUpdated + ", alive=" + this.alive + ")";
                }
            }
        }
    }

    public static class RebalanceInProgressException
    extends RuntimeException {
    }
}

