/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.UpdateOptionsImpl;
import org.apache.pulsar.common.functions.Utils;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.policies.data.ExceptionInformation;
import org.apache.pulsar.common.policies.data.FunctionStatus;
import org.apache.pulsar.common.util.RestException;
import org.apache.pulsar.functions.auth.FunctionAuthData;
import org.apache.pulsar.functions.auth.FunctionAuthUtils;
import org.apache.pulsar.functions.instance.InstanceUtils;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.utils.ComponentTypeUtils;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.utils.FunctionConfigUtils;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.PulsarWorkerService;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.apache.pulsar.functions.worker.rest.RestUtils;
import org.apache.pulsar.functions.worker.rest.api.ComponentImpl;
import org.apache.pulsar.functions.worker.service.api.Functions;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsImpl
extends ComponentImpl
implements Functions<PulsarWorkerService> {
    private static final Logger log = LoggerFactory.getLogger(FunctionsImpl.class);

    public FunctionsImpl(Supplier<PulsarWorkerService> workerServiceSupplier) {
        super(workerServiceSupplier, Function.FunctionDetails.ComponentType.FUNCTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFunction(String tenant, String namespace, String functionName, InputStream uploadedInputStream, FormDataContentDisposition fileDetail, String functionPkgUrl, FunctionConfig functionConfig, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (tenant == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Tenant is not provided");
        }
        if (namespace == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Namespace is not provided");
        }
        if (functionName == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Function name is not provided");
        }
        if (functionConfig == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Function config is not provided");
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, clientAuthenticationDataHttps)) {
                log.error("{}/{}/{} Client [{}] is not authorized to register {}", new Object[]{tenant, namespace, functionName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, functionName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        try {
            this.worker().getBrokerAdmin().tenants().getTenantInfo(tenant);
            String qualifiedNamespace = tenant + "/" + namespace;
            List namespaces = this.worker().getBrokerAdmin().namespaces().getNamespaces(tenant);
            if (namespaces != null && !namespaces.contains(qualifiedNamespace)) {
                String qualifiedNamespaceWithCluster = String.format("%s/%s/%s", tenant, this.worker().getWorkerConfig().getPulsarFunctionsCluster(), namespace);
                if (namespaces != null && !namespaces.contains(qualifiedNamespaceWithCluster)) {
                    log.error("{}/{}/{} Namespace {} does not exist", new Object[]{tenant, namespace, functionName, namespace});
                    throw new RestException(Response.Status.BAD_REQUEST, "Namespace does not exist");
                }
            }
        }
        catch (PulsarAdminException.NotAuthorizedException e) {
            log.error("{}/{}/{} Client [{}] is not authorized to operate {} on tenant", new Object[]{tenant, namespace, functionName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
        }
        catch (PulsarAdminException.NotFoundException e) {
            log.error("{}/{}/{} Tenant {} does not exist", new Object[]{tenant, namespace, functionName, tenant});
            throw new RestException(Response.Status.BAD_REQUEST, "Tenant does not exist");
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Issues getting tenant data", new Object[]{tenant, namespace, functionName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (functionMetaDataManager.containsFunction(tenant, namespace, functionName)) {
            log.error("{} {}/{}/{} already exists", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, functionName});
            throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s already exists", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), functionName));
        }
        Function.FunctionDetails functionDetails = null;
        boolean isPkgUrlProvided = StringUtils.isNotBlank((CharSequence)functionPkgUrl);
        File componentPackageFile = null;
        try {
            Function.PackageLocationMetaData.Builder packageLocationMetaDataBuilder;
            block34: {
                try {
                    if (isPkgUrlProvided) {
                        if (Utils.hasPackageTypePrefix((String)functionPkgUrl)) {
                            componentPackageFile = this.downloadPackageFile(functionPkgUrl);
                        } else {
                            if (!Utils.isFunctionPackageUrlSupported((String)functionPkgUrl)) {
                                throw new IllegalArgumentException("Function Package url is not valid.supported url (http/https/file)");
                            }
                            try {
                                componentPackageFile = FunctionCommon.extractFileFromPkgURL((String)functionPkgUrl);
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException(String.format("Encountered error \"%s\" when getting %s package from %s", e.getMessage(), ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), functionPkgUrl), e);
                            }
                        }
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, functionName, functionConfig, componentPackageFile);
                        break block34;
                    }
                    if (uploadedInputStream != null) {
                        componentPackageFile = WorkerUtils.dumpToTmpFile(uploadedInputStream);
                    }
                    if (!(FunctionCommon.isFunctionCodeBuiltin((Function.FunctionDetailsOrBuilder)(functionDetails = this.validateUpdateRequestParams(tenant, namespace, functionName, functionConfig, componentPackageFile))) || componentPackageFile != null && fileDetail != null)) {
                        throw new IllegalArgumentException(ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType) + " Package is not provided");
                    }
                }
                catch (Exception e) {
                    log.error("Invalid register {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, functionName, e});
                    throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
                }
            }
            try {
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().doAdmissionChecks(functionDetails);
            }
            catch (Exception e) {
                log.error("{} {}/{}/{} cannot be admitted by the runtime factory", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, functionName});
                throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s cannot be admitted:- %s", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), functionName, e.getMessage()));
            }
            Function.FunctionMetaData.Builder functionMetaDataBuilder = Function.FunctionMetaData.newBuilder().setFunctionDetails(functionDetails).setCreateTime(System.currentTimeMillis()).setVersion(0L);
            if (this.worker().getWorkerConfig().isAuthenticationEnabled()) {
                Function.FunctionDetails finalFunctionDetails = functionDetails;
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().getAuthProvider().ifPresent(functionAuthProvider -> {
                    if (clientAuthenticationDataHttps != null) {
                        try {
                            Optional functionAuthData = functionAuthProvider.cacheAuthData(finalFunctionDetails, clientAuthenticationDataHttps);
                            functionAuthData.ifPresent(authData -> functionMetaDataBuilder.setFunctionAuthSpec(Function.FunctionAuthenticationSpec.newBuilder().setData(ByteString.copyFrom((byte[])authData.getData())).build()));
                        }
                        catch (Exception e) {
                            log.error("Error caching authentication data for {} {}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, functionName, e});
                            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, String.format("Error caching authentication data for %s %s:- %s", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), functionName, e.getMessage()));
                        }
                    }
                });
            }
            try {
                packageLocationMetaDataBuilder = this.getFunctionPackageLocation(functionMetaDataBuilder.build(), functionPkgUrl, fileDetail, componentPackageFile);
            }
            catch (Exception e) {
                log.error("Failed process {} {}/{}/{} package: ", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, functionName, e});
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
            }
            functionMetaDataBuilder.setPackageLocation(packageLocationMetaDataBuilder);
            this.updateRequest(null, functionMetaDataBuilder.build());
        }
        finally {
            if (componentPackageFile != null && componentPackageFile.exists() && (functionPkgUrl == null || !functionPkgUrl.startsWith("file"))) {
                componentPackageFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFunction(String tenant, String namespace, String functionName, InputStream uploadedInputStream, FormDataContentDisposition fileDetail, String functionPkgUrl, FunctionConfig functionConfig, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps, UpdateOptionsImpl updateOptions) {
        FunctionConfig mergedConfig;
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (tenant == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Tenant is not provided");
        }
        if (namespace == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Namespace is not provided");
        }
        if (functionName == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Function name is not provided");
        }
        if (functionConfig == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Function config is not provided");
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, clientAuthenticationDataHttps)) {
                log.error("{}/{}/{} Client [{}] is not authorized to update {}", new Object[]{tenant, namespace, functionName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, functionName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, functionName)) {
            throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), functionName));
        }
        Function.FunctionMetaData existingComponent = functionMetaDataManager.getFunctionMetaData(tenant, namespace, functionName);
        if (!InstanceUtils.calculateSubjectType((Function.FunctionDetails)existingComponent.getFunctionDetails()).equals((Object)this.componentType)) {
            log.error("{}/{}/{} is not a {}", new Object[]{tenant, namespace, functionName, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), functionName));
        }
        FunctionConfig existingFunctionConfig = FunctionConfigUtils.convertFromDetails((Function.FunctionDetails)existingComponent.getFunctionDetails());
        functionConfig.setTenant(tenant);
        functionConfig.setNamespace(namespace);
        functionConfig.setName(functionName);
        try {
            mergedConfig = FunctionConfigUtils.validateUpdate((FunctionConfig)existingFunctionConfig, (FunctionConfig)functionConfig);
        }
        catch (Exception e) {
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        if (existingFunctionConfig.equals((Object)mergedConfig) && StringUtils.isBlank((CharSequence)functionPkgUrl) && uploadedInputStream == null) {
            log.error("{}/{}/{} Update contains no changes", new Object[]{tenant, namespace, functionName});
            throw new RestException(Response.Status.BAD_REQUEST, "Update contains no change");
        }
        Function.FunctionDetails functionDetails = null;
        File componentPackageFile = null;
        try {
            Function.PackageLocationMetaData.Builder packageLocationMetaDataBuilder;
            block39: {
                try {
                    if (StringUtils.isNotBlank((CharSequence)functionPkgUrl)) {
                        if (Utils.hasPackageTypePrefix((String)functionPkgUrl)) {
                            componentPackageFile = this.downloadPackageFile(functionName);
                        } else {
                            try {
                                componentPackageFile = FunctionCommon.extractFileFromPkgURL((String)functionPkgUrl);
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException(String.format("Encountered error \"%s\" when getting %s package from %s", e.getMessage(), ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), functionPkgUrl));
                            }
                        }
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, functionName, mergedConfig, componentPackageFile);
                        break block39;
                    }
                    if (existingComponent.getPackageLocation().getPackagePath().startsWith("file") || existingComponent.getPackageLocation().getPackagePath().startsWith("http")) {
                        try {
                            componentPackageFile = FunctionCommon.extractFileFromPkgURL((String)existingComponent.getPackageLocation().getPackagePath());
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(String.format("Encountered error \"%s\" when getting %s package from %s", e.getMessage(), ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), functionPkgUrl));
                        }
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, functionName, mergedConfig, componentPackageFile);
                        break block39;
                    }
                    if (uploadedInputStream != null) {
                        componentPackageFile = WorkerUtils.dumpToTmpFile(uploadedInputStream);
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, functionName, mergedConfig, componentPackageFile);
                    } else if (existingComponent.getPackageLocation().getPackagePath().startsWith("builtin")) {
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, functionName, mergedConfig, componentPackageFile);
                        if (!(FunctionCommon.isFunctionCodeBuiltin((Function.FunctionDetailsOrBuilder)functionDetails) || componentPackageFile != null && fileDetail != null)) {
                            throw new IllegalArgumentException(ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType) + " Package is not provided");
                        }
                    } else {
                        componentPackageFile = FunctionCommon.createPkgTempFile();
                        componentPackageFile.deleteOnExit();
                        WorkerUtils.downloadFromBookkeeper(this.worker().getDlogNamespace(), componentPackageFile, existingComponent.getPackageLocation().getPackagePath());
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, functionName, mergedConfig, componentPackageFile);
                    }
                }
                catch (Exception e) {
                    log.error("Invalid update {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, functionName, e});
                    throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
                }
            }
            try {
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().doAdmissionChecks(functionDetails);
            }
            catch (Exception e) {
                log.error("Updated {} {}/{}/{} cannot be submitted to runtime factory", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, functionName});
                throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s cannot be admitted:- %s", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), functionName, e.getMessage()));
            }
            Function.FunctionMetaData.Builder functionMetaDataBuilder = Function.FunctionMetaData.newBuilder().mergeFrom(existingComponent).setFunctionDetails(functionDetails);
            if (this.worker().getWorkerConfig().isAuthenticationEnabled()) {
                Function.FunctionDetails finalFunctionDetails = functionDetails;
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().getAuthProvider().ifPresent(functionAuthProvider -> {
                    if (clientAuthenticationDataHttps != null && updateOptions != null && updateOptions.isUpdateAuthData()) {
                        Optional<Object> existingFunctionAuthData = Optional.empty();
                        if (functionMetaDataBuilder.hasFunctionAuthSpec()) {
                            existingFunctionAuthData = Optional.ofNullable(FunctionAuthUtils.getFunctionAuthData(Optional.ofNullable(functionMetaDataBuilder.getFunctionAuthSpec())));
                        }
                        try {
                            Optional newFunctionAuthData = functionAuthProvider.updateAuthData(finalFunctionDetails, existingFunctionAuthData, clientAuthenticationDataHttps);
                            if (newFunctionAuthData.isPresent()) {
                                functionMetaDataBuilder.setFunctionAuthSpec(Function.FunctionAuthenticationSpec.newBuilder().setData(ByteString.copyFrom((byte[])((FunctionAuthData)newFunctionAuthData.get()).getData())).build());
                            } else {
                                functionMetaDataBuilder.clearFunctionAuthSpec();
                            }
                        }
                        catch (Exception e) {
                            log.error("Error updating authentication data for {} {}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, functionName, e});
                            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, String.format("Error caching authentication data for %s %s:- %s", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), functionName, e.getMessage()));
                        }
                    }
                });
            }
            if (StringUtils.isNotBlank((CharSequence)functionPkgUrl) || uploadedInputStream != null) {
                try {
                    packageLocationMetaDataBuilder = this.getFunctionPackageLocation(functionMetaDataBuilder.build(), functionPkgUrl, fileDetail, componentPackageFile);
                }
                catch (Exception e) {
                    log.error("Failed process {} {}/{}/{} package: ", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, functionName, e});
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
                }
            } else {
                packageLocationMetaDataBuilder = Function.PackageLocationMetaData.newBuilder().mergeFrom(existingComponent.getPackageLocation());
            }
            functionMetaDataBuilder.setPackageLocation(packageLocationMetaDataBuilder);
            this.updateRequest(existingComponent, functionMetaDataBuilder.build());
        }
        finally {
            if (componentPackageFile != null && componentPackageFile.exists() && (functionPkgUrl != null && !functionPkgUrl.startsWith("file") || uploadedInputStream != null)) {
                componentPackageFile.delete();
            }
        }
    }

    private ExceptionInformation getExceptionInformation(InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry) {
        ExceptionInformation exceptionInformation = new ExceptionInformation();
        exceptionInformation.setTimestampMs(exceptionEntry.getMsSinceEpoch());
        exceptionInformation.setExceptionString(exceptionEntry.getExceptionString());
        return exceptionInformation;
    }

    @Override
    public FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData getFunctionInstanceStatus(String tenant, String namespace, String componentName, String instanceId, URI uri, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatusData;
        this.componentInstanceStatusRequestValidate(tenant, namespace, componentName, Integer.parseInt(instanceId), clientRole, clientAuthenticationDataHttps);
        try {
            functionInstanceStatusData = (FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData)new GetFunctionStatus().getComponentInstanceStatus(tenant, namespace, componentName, Integer.parseInt(instanceId), uri);
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Exception e) {
            log.error("{}/{}/{} Got Exception Getting Status", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return functionInstanceStatusData;
    }

    @Override
    public FunctionStatus getFunctionStatus(String tenant, String namespace, String componentName, URI uri, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        FunctionStatus functionStatus;
        this.componentStatusRequestValidate(tenant, namespace, componentName, clientRole, clientAuthenticationDataHttps);
        try {
            functionStatus = (FunctionStatus)new GetFunctionStatus().getComponentStatus(tenant, namespace, componentName, uri);
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Exception e) {
            log.error("{}/{}/{} Got Exception Getting Status", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return functionStatus;
    }

    @Override
    public void updateFunctionOnWorkerLeader(String tenant, String namespace, String functionName, InputStream uploadedInputStream, boolean delete, URI uri, String clientRole, AuthenticationDataSource authenticationData) {
        Function.FunctionMetaData functionMetaData;
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(clientRole, authenticationData)) {
            log.error("{}/{}/{} Client [{}] is not superuser to update on worker leader {}", new Object[]{tenant, namespace, functionName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
        }
        if (tenant == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Tenant is not provided");
        }
        if (namespace == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Namespace is not provided");
        }
        if (functionName == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Function name is not provided");
        }
        try {
            functionMetaData = Function.FunctionMetaData.parseFrom((InputStream)uploadedInputStream);
        }
        catch (IOException e) {
            throw new RestException(Response.Status.BAD_REQUEST, "Corrupt Function MetaData");
        }
        if (!this.worker().getLeaderService().isLeader()) {
            WorkerInfo workerInfo = this.worker().getMembershipManager().getLeader();
            if (workerInfo == null || workerInfo.getWorkerId().equals(this.worker().getWorkerConfig().getWorkerId())) {
                throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "Leader not yet ready. Please retry again");
            }
            URI redirect = UriBuilder.fromUri((URI)uri).host(workerInfo.getWorkerHostname()).port(workerInfo.getPort()).build(new Object[0]);
            throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        try {
            functionMetaDataManager.updateFunctionOnLeader(functionMetaData, delete);
        }
        catch (IllegalStateException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    private Function.FunctionDetails validateUpdateRequestParams(String tenant, String namespace, String componentName, FunctionConfig functionConfig, File componentPackageFile) throws IOException {
        Path archivePath = null;
        functionConfig.setTenant(tenant);
        functionConfig.setNamespace(namespace);
        functionConfig.setName(componentName);
        FunctionConfigUtils.inferMissingArguments((FunctionConfig)functionConfig, (boolean)this.worker().getWorkerConfig().isForwardSourceMessageProperty());
        if (!StringUtils.isEmpty((CharSequence)functionConfig.getJar())) {
            String builtinArchive = functionConfig.getJar();
            if (builtinArchive.startsWith("builtin")) {
                builtinArchive = builtinArchive.replaceFirst("^builtin://", "");
            }
            try {
                archivePath = this.worker().getFunctionsManager().getFunctionArchive(builtinArchive);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("No Function archive %s found", archivePath));
            }
        }
        ClassLoader clsLoader = null;
        clsLoader = archivePath != null ? FunctionConfigUtils.validate((FunctionConfig)functionConfig, (File)archivePath.toFile()) : FunctionConfigUtils.validate((FunctionConfig)functionConfig, (File)componentPackageFile);
        return FunctionConfigUtils.convert((FunctionConfig)functionConfig, (ClassLoader)clsLoader);
    }

    private File downloadPackageFile(String packageName) throws IOException, PulsarAdminException {
        return FunctionsImpl.downloadPackageFile(this.worker(), packageName);
    }

    static File downloadPackageFile(PulsarWorkerService worker, String packageName) throws IOException, PulsarAdminException {
        Path tempDirectory = worker.getWorkerConfig().getDownloadDirectory() != null ? Paths.get(worker.getWorkerConfig().getDownloadDirectory(), new String[0]) : Paths.get(worker.getWorkerConfig().getNarExtractionDirectory(), new String[0]);
        Files.createDirectories(tempDirectory, new FileAttribute[0]);
        File file = Files.createTempFile(tempDirectory, "function", ".tmp", new FileAttribute[0]).toFile();
        worker.getBrokerAdmin().packages().download(packageName, file.toString());
        return file;
    }

    private class GetFunctionStatus
    extends ComponentImpl.GetStatus<FunctionStatus, FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData> {
        private GetFunctionStatus() {
        }

        @Override
        public FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData notScheduledInstance() {
            FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatusData = new FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData();
            functionInstanceStatusData.setRunning(false);
            functionInstanceStatusData.setError("Function has not been scheduled");
            return functionInstanceStatusData;
        }

        @Override
        public FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData fromFunctionStatusProto(InstanceCommunication.FunctionStatus status, String assignedWorkerId) {
            ExceptionInformation exceptionInformation;
            FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatusData = new FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData();
            functionInstanceStatusData.setRunning(status.getRunning());
            functionInstanceStatusData.setError(status.getFailureException());
            functionInstanceStatusData.setNumRestarts(status.getNumRestarts());
            functionInstanceStatusData.setNumReceived(status.getNumReceived());
            functionInstanceStatusData.setNumSuccessfullyProcessed(status.getNumSuccessfullyProcessed());
            functionInstanceStatusData.setNumUserExceptions(status.getNumUserExceptions());
            LinkedList<ExceptionInformation> userExceptionInformationList = new LinkedList<ExceptionInformation>();
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestUserExceptionsList()) {
                ExceptionInformation exceptionInformation2 = FunctionsImpl.this.getExceptionInformation(exceptionEntry);
                userExceptionInformationList.add(exceptionInformation2);
            }
            functionInstanceStatusData.setLatestUserExceptions(userExceptionInformationList);
            functionInstanceStatusData.setNumSystemExceptions(status.getNumSystemExceptions() + status.getNumSourceExceptions() + status.getNumSinkExceptions());
            LinkedList<ExceptionInformation> systemExceptionInformationList = new LinkedList<ExceptionInformation>();
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestSystemExceptionsList()) {
                exceptionInformation = FunctionsImpl.this.getExceptionInformation(exceptionEntry);
                systemExceptionInformationList.add(exceptionInformation);
            }
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestSourceExceptionsList()) {
                exceptionInformation = FunctionsImpl.this.getExceptionInformation(exceptionEntry);
                systemExceptionInformationList.add(exceptionInformation);
            }
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestSinkExceptionsList()) {
                exceptionInformation = FunctionsImpl.this.getExceptionInformation(exceptionEntry);
                systemExceptionInformationList.add(exceptionInformation);
            }
            functionInstanceStatusData.setLatestSystemExceptions(systemExceptionInformationList);
            functionInstanceStatusData.setAverageLatency(status.getAverageLatency());
            functionInstanceStatusData.setLastInvocationTime(status.getLastInvocationTime());
            functionInstanceStatusData.setWorkerId(assignedWorkerId);
            return functionInstanceStatusData;
        }

        @Override
        public FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData notRunning(String assignedWorkerId, String error) {
            FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatusData = new FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData();
            functionInstanceStatusData.setRunning(false);
            if (error != null) {
                functionInstanceStatusData.setError(error);
            }
            functionInstanceStatusData.setWorkerId(assignedWorkerId);
            return functionInstanceStatusData;
        }

        @Override
        public FunctionStatus getStatus(String tenant, String namespace, String name, Collection<Function.Assignment> assignments, URI uri) throws PulsarAdminException {
            FunctionStatus functionStatus = new FunctionStatus();
            for (Function.Assignment assignment : assignments) {
                boolean isOwner = FunctionsImpl.this.worker().getWorkerConfig().getWorkerId().equals(assignment.getWorkerId());
                FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatusData = isOwner ? (FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData)this.getComponentInstanceStatus(tenant, namespace, name, assignment.getInstance().getInstanceId(), null) : FunctionsImpl.this.worker().getFunctionAdmin().functions().getFunctionStatus(assignment.getInstance().getFunctionMetaData().getFunctionDetails().getTenant(), assignment.getInstance().getFunctionMetaData().getFunctionDetails().getNamespace(), assignment.getInstance().getFunctionMetaData().getFunctionDetails().getName(), assignment.getInstance().getInstanceId());
                FunctionStatus.FunctionInstanceStatus instanceStatus = new FunctionStatus.FunctionInstanceStatus();
                instanceStatus.setInstanceId(assignment.getInstance().getInstanceId());
                instanceStatus.setStatus(functionInstanceStatusData);
                functionStatus.addInstance(instanceStatus);
            }
            functionStatus.setNumInstances(functionStatus.instances.size());
            functionStatus.getInstances().forEach(functionInstanceStatus -> {
                if (functionInstanceStatus.getStatus().isRunning()) {
                    ++functionStatus.numRunning;
                }
            });
            return functionStatus;
        }

        @Override
        public FunctionStatus getStatusExternal(String tenant, String namespace, String name, int parallelism) {
            FunctionStatus functionStatus = new FunctionStatus();
            for (int i = 0; i < parallelism; ++i) {
                FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatusData = (FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData)this.getComponentInstanceStatus(tenant, namespace, name, i, null);
                FunctionStatus.FunctionInstanceStatus functionInstanceStatus2 = new FunctionStatus.FunctionInstanceStatus();
                functionInstanceStatus2.setInstanceId(i);
                functionInstanceStatus2.setStatus(functionInstanceStatusData);
                functionStatus.addInstance(functionInstanceStatus2);
            }
            functionStatus.setNumInstances(functionStatus.instances.size());
            functionStatus.getInstances().forEach(functionInstanceStatus -> {
                if (functionInstanceStatus.getStatus().isRunning()) {
                    ++functionStatus.numRunning;
                }
            });
            return functionStatus;
        }

        @Override
        public FunctionStatus emptyStatus(int parallelism) {
            FunctionStatus functionStatus = new FunctionStatus();
            functionStatus.setNumInstances(parallelism);
            functionStatus.setNumRunning(0);
            for (int i = 0; i < parallelism; ++i) {
                FunctionStatus.FunctionInstanceStatus functionInstanceStatus = new FunctionStatus.FunctionInstanceStatus();
                functionInstanceStatus.setInstanceId(i);
                FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatusData = new FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData();
                functionInstanceStatusData.setRunning(false);
                functionInstanceStatusData.setError("Function has not been scheduled");
                functionInstanceStatus.setStatus(functionInstanceStatusData);
                functionStatus.addInstance(functionInstanceStatus);
            }
            return functionStatus;
        }
    }
}

