/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.worker.WorkerConfig;

public class PackageUrlValidator {
    private final Path connectionsDirectory;
    private final Path functionsDirectory;
    private final List<Pattern> additionalConnectionsPatterns;
    private final List<Pattern> additionalFunctionsPatterns;

    public PackageUrlValidator(WorkerConfig workerConfig) {
        this.connectionsDirectory = PackageUrlValidator.resolveDirectory(workerConfig.getEnableReferencingConnectorDirectoryFiles(), workerConfig.getConnectorsDirectory());
        this.functionsDirectory = PackageUrlValidator.resolveDirectory(workerConfig.getEnableReferencingFunctionsDirectoryFiles(), workerConfig.getFunctionsDirectory());
        this.additionalConnectionsPatterns = PackageUrlValidator.compilePatterns(workerConfig.getAdditionalEnabledConnectorUrlPatterns());
        this.additionalFunctionsPatterns = PackageUrlValidator.compilePatterns(workerConfig.getAdditionalEnabledFunctionsUrlPatterns());
    }

    private static Path resolveDirectory(Boolean enabled, String directory) {
        return enabled != null && enabled != false ? FileSystems.getDefault().getPath(directory, new String[0]).normalize().toAbsolutePath() : null;
    }

    private static List<Pattern> compilePatterns(List<String> additionalPatterns) {
        return additionalPatterns != null ? additionalPatterns.stream().map(Pattern::compile).collect(Collectors.toList()) : Collections.emptyList();
    }

    boolean isValidFunctionsPackageUrl(URI functionPkgUrl) {
        return this.doesMatch(functionPkgUrl, this.functionsDirectory, this.additionalFunctionsPatterns);
    }

    boolean isValidConnectionsPackageUrl(URI functionPkgUrl) {
        return this.doesMatch(functionPkgUrl, this.connectionsDirectory, this.additionalConnectionsPatterns);
    }

    private boolean doesMatch(URI functionPkgUrl, Path directory, List<Pattern> patterns) {
        Path filePath;
        if (directory != null && "file".equals(functionPkgUrl.getScheme()) && (filePath = FileSystems.getDefault().getPath(functionPkgUrl.getPath(), new String[0]).normalize().toAbsolutePath()).startsWith(directory)) {
            return true;
        }
        String functionPkgUrlString = functionPkgUrl.normalize().toString();
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(functionPkgUrlString).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isValidPackageUrl(Function.FunctionDetails.ComponentType componentType, String functionPkgUrl) {
        URI uri = URI.create(functionPkgUrl);
        if (componentType == null) {
            return this.isValidFunctionsPackageUrl(uri) || this.isValidConnectionsPackageUrl(uri);
        }
        switch (componentType) {
            case FUNCTION: {
                return this.isValidFunctionsPackageUrl(uri);
            }
            case SINK: 
            case SOURCE: {
                return this.isValidConnectionsPackageUrl(uri);
            }
        }
        throw new IllegalArgumentException("Unknown component type: " + componentType);
    }
}

