/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api;

import com.google.gson.Gson;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.MessageOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.FunctionState;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.policies.data.FunctionStatus;
import org.apache.pulsar.common.util.RestException;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.utils.FunctionConfigUtils;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.PulsarWorkerService;
import org.apache.pulsar.functions.worker.rest.api.FunctionsImpl;
import org.apache.pulsar.functions.worker.service.api.Functions;
import org.apache.pulsar.functions.worker.service.api.FunctionsV2;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsImplV2
implements FunctionsV2<PulsarWorkerService> {
    private static final Logger log = LoggerFactory.getLogger(FunctionsImplV2.class);
    private final Functions<PulsarWorkerService> delegate;

    public FunctionsImplV2(Supplier<PulsarWorkerService> workerServiceSupplier) {
        this.delegate = new FunctionsImpl(workerServiceSupplier);
    }

    public FunctionsImplV2(FunctionsImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public Response getFunctionInfo(String tenant, String namespace, String functionName, String clientRole) throws IOException {
        this.delegate.getFunctionInfo(tenant, namespace, functionName, clientRole, null);
        FunctionMetaDataManager functionMetaDataManager = ((PulsarWorkerService)this.delegate.worker()).getFunctionMetaDataManager();
        Function.FunctionMetaData functionMetaData = functionMetaDataManager.getFunctionMetaData(tenant, namespace, functionName);
        String functionDetailsJson = FunctionCommon.printJson((MessageOrBuilder)functionMetaData.getFunctionDetails());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)functionDetailsJson).build();
    }

    @Override
    public Response getFunctionInstanceStatus(String tenant, String namespace, String functionName, String instanceId, URI uri, String clientRole) throws IOException {
        FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatus = this.delegate.getFunctionInstanceStatus(tenant, namespace, functionName, instanceId, uri, clientRole, null);
        String jsonResponse = FunctionCommon.printJson((MessageOrBuilder)this.toProto(functionInstanceStatus, instanceId));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)jsonResponse).build();
    }

    @Override
    public Response getFunctionStatusV2(String tenant, String namespace, String functionName, URI requestUri, String clientRole) throws IOException {
        FunctionStatus functionStatus = this.delegate.getFunctionStatus(tenant, namespace, functionName, requestUri, clientRole, null);
        InstanceCommunication.FunctionStatusList.Builder functionStatusList = InstanceCommunication.FunctionStatusList.newBuilder();
        functionStatus.instances.forEach(functionInstanceStatus -> functionStatusList.addFunctionStatusList(this.toProto(functionInstanceStatus.getStatus(), String.valueOf(functionInstanceStatus.getInstanceId()))));
        String jsonResponse = FunctionCommon.printJson((MessageOrBuilder)functionStatusList);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)jsonResponse).build();
    }

    @Override
    public Response registerFunction(String tenant, String namespace, String functionName, InputStream uploadedInputStream, FormDataContentDisposition fileDetail, String functionPkgUrl, String functionDetailsJson, String clientRole) {
        Function.FunctionDetails.Builder functionDetailsBuilder = Function.FunctionDetails.newBuilder();
        try {
            FunctionCommon.mergeJson((String)functionDetailsJson, (AbstractMessage.Builder)functionDetailsBuilder);
        }
        catch (IOException e) {
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        FunctionConfig functionConfig = FunctionConfigUtils.convertFromDetails((Function.FunctionDetails)functionDetailsBuilder.build());
        this.delegate.registerFunction(tenant, namespace, functionName, uploadedInputStream, fileDetail, functionPkgUrl, functionConfig, clientRole, null);
        return Response.ok().build();
    }

    @Override
    public Response updateFunction(String tenant, String namespace, String functionName, InputStream uploadedInputStream, FormDataContentDisposition fileDetail, String functionPkgUrl, String functionDetailsJson, String clientRole) {
        Function.FunctionDetails.Builder functionDetailsBuilder = Function.FunctionDetails.newBuilder();
        try {
            FunctionCommon.mergeJson((String)functionDetailsJson, (AbstractMessage.Builder)functionDetailsBuilder);
        }
        catch (IOException e) {
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        FunctionConfig functionConfig = FunctionConfigUtils.convertFromDetails((Function.FunctionDetails)functionDetailsBuilder.build());
        this.delegate.updateFunction(tenant, namespace, functionName, uploadedInputStream, fileDetail, functionPkgUrl, functionConfig, clientRole, null, null);
        return Response.ok().build();
    }

    @Override
    public Response deregisterFunction(String tenant, String namespace, String functionName, String clientAppId) {
        this.delegate.deregisterFunction(tenant, namespace, functionName, clientAppId, null);
        return Response.ok().build();
    }

    @Override
    public Response listFunctions(String tenant, String namespace, String clientRole) {
        List<String> functionStateList = this.delegate.listFunctions(tenant, namespace, clientRole, null);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new Gson().toJson((Object)functionStateList.toArray())).build();
    }

    @Override
    public Response triggerFunction(String tenant, String namespace, String functionName, String triggerValue, InputStream triggerStream, String topic, String clientRole) {
        String result = this.delegate.triggerFunction(tenant, namespace, functionName, triggerValue, triggerStream, topic, clientRole, null);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @Override
    public Response getFunctionState(String tenant, String namespace, String functionName, String key, String clientRole) {
        FunctionState functionState = this.delegate.getFunctionState(tenant, namespace, functionName, key, clientRole, null);
        String value = functionState.getNumberValue() != null ? "value : " + functionState.getNumberValue() + ", version : " + functionState.getVersion() : "value : " + functionState.getStringValue() + ", version : " + functionState.getVersion();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)value).build();
    }

    @Override
    public Response restartFunctionInstance(String tenant, String namespace, String functionName, String instanceId, URI uri, String clientRole) {
        this.delegate.restartFunctionInstance(tenant, namespace, functionName, instanceId, uri, clientRole, null);
        return Response.ok().build();
    }

    @Override
    public Response restartFunctionInstances(String tenant, String namespace, String functionName, String clientRole) {
        this.delegate.restartFunctionInstances(tenant, namespace, functionName, clientRole, null);
        return Response.ok().build();
    }

    @Override
    public Response stopFunctionInstance(String tenant, String namespace, String functionName, String instanceId, URI uri, String clientRole) {
        this.delegate.stopFunctionInstance(tenant, namespace, functionName, instanceId, uri, clientRole, null);
        return Response.ok().build();
    }

    @Override
    public Response stopFunctionInstances(String tenant, String namespace, String functionName, String clientRole) {
        this.delegate.stopFunctionInstances(tenant, namespace, functionName, clientRole, null);
        return Response.ok().build();
    }

    @Override
    public Response uploadFunction(InputStream uploadedInputStream, String path, String clientRole) {
        this.delegate.uploadFunction(uploadedInputStream, path, clientRole, null);
        return Response.ok().build();
    }

    @Override
    public Response downloadFunction(String path, String clientRole) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.delegate.downloadFunction(path, clientRole, null)).build();
    }

    @Override
    public List<ConnectorDefinition> getListOfConnectors() {
        return this.delegate.getListOfConnectors();
    }

    private InstanceCommunication.FunctionStatus toProto(FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData functionInstanceStatus, String instanceId) {
        List latestSysExceptions = functionInstanceStatus.getLatestSystemExceptions().stream().map(exceptionInformation -> InstanceCommunication.FunctionStatus.ExceptionInformation.newBuilder().setExceptionString(exceptionInformation.getExceptionString()).setMsSinceEpoch(exceptionInformation.getTimestampMs()).build()).collect(Collectors.toList());
        List latestUserExceptions = functionInstanceStatus.getLatestUserExceptions().stream().map(exceptionInformation -> InstanceCommunication.FunctionStatus.ExceptionInformation.newBuilder().setExceptionString(exceptionInformation.getExceptionString()).setMsSinceEpoch(exceptionInformation.getTimestampMs()).build()).collect(Collectors.toList());
        InstanceCommunication.FunctionStatus functionStatus = InstanceCommunication.FunctionStatus.newBuilder().setRunning(functionInstanceStatus.isRunning()).setFailureException(functionInstanceStatus.getError()).setNumRestarts(functionInstanceStatus.getNumRestarts()).setNumSuccessfullyProcessed(functionInstanceStatus.getNumSuccessfullyProcessed()).setNumUserExceptions(functionInstanceStatus.getNumUserExceptions()).addAllLatestUserExceptions(latestUserExceptions).setNumSystemExceptions(functionInstanceStatus.getNumSystemExceptions()).addAllLatestSystemExceptions(latestSysExceptions).setAverageLatency(functionInstanceStatus.getAverageLatency()).setLastInvocationTime(functionInstanceStatus.getLastInvocationTime()).setInstanceId(instanceId).setWorkerId(((PulsarWorkerService)this.delegate.worker()).getWorkerConfig().getWorkerId()).build();
        return functionStatus;
    }
}

