/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.functions.UpdateOptionsImpl;
import org.apache.pulsar.common.functions.Utils;
import org.apache.pulsar.common.io.ConfigFieldDefinition;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.io.SinkConfig;
import org.apache.pulsar.common.policies.data.ExceptionInformation;
import org.apache.pulsar.common.policies.data.SinkStatus;
import org.apache.pulsar.common.util.ClassLoaderUtils;
import org.apache.pulsar.common.util.RestException;
import org.apache.pulsar.functions.auth.FunctionAuthData;
import org.apache.pulsar.functions.auth.FunctionAuthUtils;
import org.apache.pulsar.functions.instance.InstanceUtils;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.utils.ComponentTypeUtils;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.utils.SinkConfigUtils;
import org.apache.pulsar.functions.utils.io.Connector;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.PulsarWorkerService;
import org.apache.pulsar.functions.worker.WorkerUtils;
import org.apache.pulsar.functions.worker.rest.RestUtils;
import org.apache.pulsar.functions.worker.rest.api.ComponentImpl;
import org.apache.pulsar.functions.worker.rest.api.FunctionsImpl;
import org.apache.pulsar.functions.worker.service.api.Sinks;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinksImpl
extends ComponentImpl
implements Sinks<PulsarWorkerService> {
    private static final Logger log = LoggerFactory.getLogger(SinksImpl.class);

    public SinksImpl(Supplier<PulsarWorkerService> workerServiceSupplier) {
        super(workerServiceSupplier, Function.FunctionDetails.ComponentType.SINK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSink(String tenant, String namespace, String sinkName, InputStream uploadedInputStream, FormDataContentDisposition fileDetail, String sinkPkgUrl, SinkConfig sinkConfig, String clientRole, AuthenticationDataHttps clientAuthenticationDataHttps) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (tenant == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Tenant is not provided");
        }
        if (namespace == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Namespace is not provided");
        }
        if (sinkName == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Sink name is not provided");
        }
        if (sinkConfig == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Sink config is not provided");
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, (AuthenticationDataSource)clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not authorized to register {}", new Object[]{tenant, namespace, sinkName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, sinkName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        try {
            this.worker().getBrokerAdmin().tenants().getTenantInfo(tenant);
            String qualifiedNamespace = tenant + "/" + namespace;
            List namespaces = this.worker().getBrokerAdmin().namespaces().getNamespaces(tenant);
            if (namespaces != null && !namespaces.contains(qualifiedNamespace)) {
                String qualifiedNamespaceWithCluster = String.format("%s/%s/%s", tenant, this.worker().getWorkerConfig().getPulsarFunctionsCluster(), namespace);
                if (namespaces != null && !namespaces.contains(qualifiedNamespaceWithCluster)) {
                    log.error("{}/{}/{} Namespace {} does not exist", new Object[]{tenant, namespace, sinkName, namespace});
                    throw new RestException(Response.Status.BAD_REQUEST, "Namespace does not exist");
                }
            }
        }
        catch (PulsarAdminException.NotAuthorizedException e) {
            log.error("{}/{}/{} Client [{}] is not authorized to operate {} on tenant", new Object[]{tenant, namespace, sinkName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
        }
        catch (PulsarAdminException.NotFoundException e) {
            log.error("{}/{}/{} Tenant {} does not exist", new Object[]{tenant, namespace, sinkName, tenant});
            throw new RestException(Response.Status.BAD_REQUEST, "Tenant does not exist");
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Issues getting tenant data", new Object[]{tenant, namespace, sinkName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (functionMetaDataManager.containsFunction(tenant, namespace, sinkName)) {
            log.error("{} {}/{}/{} already exists", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sinkName});
            throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s already exists", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sinkName));
        }
        Function.FunctionDetails functionDetails = null;
        boolean isPkgUrlProvided = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sinkPkgUrl);
        File componentPackageFile = null;
        try {
            Function.PackageLocationMetaData.Builder packageLocationMetaDataBuilder;
            block34: {
                try {
                    if (isPkgUrlProvided) {
                        if (Utils.hasPackageTypePrefix((String)sinkPkgUrl)) {
                            componentPackageFile = this.downloadPackageFile(sinkPkgUrl);
                        } else {
                            if (!Utils.isFunctionPackageUrlSupported((String)sinkPkgUrl)) {
                                throw new IllegalArgumentException("Function Package url is not valid. supported url (http/https/file)");
                            }
                            try {
                                componentPackageFile = FunctionCommon.extractFileFromPkgURL((String)sinkPkgUrl);
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException(String.format("Encountered error \"%s\" when getting %s package from %s", e.getMessage(), ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sinkPkgUrl));
                            }
                        }
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, sinkName, sinkConfig, componentPackageFile);
                        break block34;
                    }
                    if (uploadedInputStream != null) {
                        componentPackageFile = WorkerUtils.dumpToTmpFile(uploadedInputStream);
                    }
                    if (!(FunctionCommon.isFunctionCodeBuiltin((Function.FunctionDetailsOrBuilder)(functionDetails = this.validateUpdateRequestParams(tenant, namespace, sinkName, sinkConfig, componentPackageFile))) || componentPackageFile != null && fileDetail != null)) {
                        throw new IllegalArgumentException(ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType) + " Package is not provided");
                    }
                }
                catch (Exception e) {
                    log.error("Invalid register {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sinkName, e});
                    throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
                }
            }
            try {
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().doAdmissionChecks(functionDetails);
            }
            catch (Exception e) {
                log.error("{} {}/{}/{} cannot be admitted by the runtime factory", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sinkName});
                throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s cannot be admitted:- %s", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sinkName, e.getMessage()));
            }
            Function.FunctionMetaData.Builder functionMetaDataBuilder = Function.FunctionMetaData.newBuilder().setFunctionDetails(functionDetails).setCreateTime(System.currentTimeMillis()).setVersion(0L);
            if (this.worker().getWorkerConfig().isAuthenticationEnabled()) {
                Function.FunctionDetails finalFunctionDetails = functionDetails;
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().getAuthProvider().ifPresent(functionAuthProvider -> {
                    if (clientAuthenticationDataHttps != null) {
                        try {
                            Optional functionAuthData = functionAuthProvider.cacheAuthData(finalFunctionDetails, (AuthenticationDataSource)clientAuthenticationDataHttps);
                            functionAuthData.ifPresent(authData -> functionMetaDataBuilder.setFunctionAuthSpec(Function.FunctionAuthenticationSpec.newBuilder().setData(ByteString.copyFrom((byte[])authData.getData())).build()));
                        }
                        catch (Exception e) {
                            log.error("Error caching authentication data for {} {}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sinkName, e});
                            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, String.format("Error caching authentication data for %s %s:- %s", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sinkName, e.getMessage()));
                        }
                    }
                });
            }
            try {
                packageLocationMetaDataBuilder = this.getFunctionPackageLocation(functionMetaDataBuilder.build(), sinkPkgUrl, fileDetail, componentPackageFile);
            }
            catch (Exception e) {
                log.error("Failed process {} {}/{}/{} package: ", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sinkName, e});
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
            }
            functionMetaDataBuilder.setPackageLocation(packageLocationMetaDataBuilder);
            this.updateRequest(null, functionMetaDataBuilder.build());
        }
        finally {
            if (componentPackageFile != null && componentPackageFile.exists() && (sinkPkgUrl == null || !sinkPkgUrl.startsWith("file"))) {
                componentPackageFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSink(String tenant, String namespace, String sinkName, InputStream uploadedInputStream, FormDataContentDisposition fileDetail, String sinkPkgUrl, SinkConfig sinkConfig, String clientRole, AuthenticationDataHttps clientAuthenticationDataHttps, UpdateOptionsImpl updateOptions) {
        SinkConfig mergedConfig;
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if (tenant == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Tenant is not provided");
        }
        if (namespace == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Namespace is not provided");
        }
        if (sinkName == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Sink name is not provided");
        }
        if (sinkConfig == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Sink config is not provided");
        }
        try {
            if (!this.isAuthorizedRole(tenant, namespace, clientRole, (AuthenticationDataSource)clientAuthenticationDataHttps)) {
                log.warn("{}/{}/{} Client [{}] is not authorized to update {}", new Object[]{tenant, namespace, sinkName, clientRole, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
                throw new RestException(Response.Status.UNAUTHORIZED, "Client is not authorized to perform operation");
            }
        }
        catch (PulsarAdminException e) {
            log.error("{}/{}/{} Failed to authorize [{}]", new Object[]{tenant, namespace, sinkName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, sinkName)) {
            throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sinkName));
        }
        Function.FunctionMetaData existingComponent = functionMetaDataManager.getFunctionMetaData(tenant, namespace, sinkName);
        if (!InstanceUtils.calculateSubjectType((Function.FunctionDetails)existingComponent.getFunctionDetails()).equals((Object)this.componentType)) {
            log.error("{}/{}/{} is not a {}", new Object[]{tenant, namespace, sinkName, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.NOT_FOUND, String.format("%s %s doesn't exist", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sinkName));
        }
        SinkConfig existingSinkConfig = SinkConfigUtils.convertFromDetails((Function.FunctionDetails)existingComponent.getFunctionDetails());
        sinkConfig.setTenant(tenant);
        sinkConfig.setNamespace(namespace);
        sinkConfig.setName(sinkName);
        try {
            mergedConfig = SinkConfigUtils.validateUpdate((SinkConfig)existingSinkConfig, (SinkConfig)sinkConfig);
        }
        catch (Exception e) {
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        if (existingSinkConfig.equals((Object)mergedConfig) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sinkPkgUrl) && uploadedInputStream == null) {
            log.error("{}/{}/{} Update contains no changes", new Object[]{tenant, namespace, sinkName});
            throw new RestException(Response.Status.BAD_REQUEST, "Update contains no change");
        }
        Function.FunctionDetails functionDetails = null;
        File componentPackageFile = null;
        try {
            Function.PackageLocationMetaData.Builder packageLocationMetaDataBuilder;
            block39: {
                try {
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sinkPkgUrl)) {
                        if (Utils.hasPackageTypePrefix((String)sinkPkgUrl)) {
                            componentPackageFile = this.downloadPackageFile(sinkPkgUrl);
                        } else {
                            try {
                                componentPackageFile = FunctionCommon.extractFileFromPkgURL((String)sinkPkgUrl);
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException(String.format("Encountered error \"%s\" when getting %s package from %s", e.getMessage(), ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sinkPkgUrl));
                            }
                        }
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, sinkName, mergedConfig, componentPackageFile);
                        break block39;
                    }
                    if (existingComponent.getPackageLocation().getPackagePath().startsWith("file") || existingComponent.getPackageLocation().getPackagePath().startsWith("http")) {
                        try {
                            componentPackageFile = FunctionCommon.extractFileFromPkgURL((String)existingComponent.getPackageLocation().getPackagePath());
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(String.format("Encountered error \"%s\" when getting %s package from %s", e.getMessage(), ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sinkPkgUrl));
                        }
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, sinkName, mergedConfig, componentPackageFile);
                        break block39;
                    }
                    if (uploadedInputStream != null) {
                        componentPackageFile = WorkerUtils.dumpToTmpFile(uploadedInputStream);
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, sinkName, mergedConfig, componentPackageFile);
                    } else if (existingComponent.getPackageLocation().getPackagePath().startsWith("builtin")) {
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, sinkName, mergedConfig, componentPackageFile);
                        if (!(FunctionCommon.isFunctionCodeBuiltin((Function.FunctionDetailsOrBuilder)functionDetails) || componentPackageFile != null && fileDetail != null)) {
                            throw new IllegalArgumentException(ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType) + " Package is not provided");
                        }
                    } else {
                        componentPackageFile = FunctionCommon.createPkgTempFile();
                        componentPackageFile.deleteOnExit();
                        WorkerUtils.downloadFromBookkeeper(this.worker().getDlogNamespace(), componentPackageFile, existingComponent.getPackageLocation().getPackagePath());
                        functionDetails = this.validateUpdateRequestParams(tenant, namespace, sinkName, mergedConfig, componentPackageFile);
                    }
                }
                catch (Exception e) {
                    log.error("Invalid update {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sinkName, e});
                    throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
                }
            }
            try {
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().doAdmissionChecks(functionDetails);
            }
            catch (Exception e) {
                log.error("Updated {} {}/{}/{} cannot be submitted to runtime factory", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sinkName});
                throw new RestException(Response.Status.BAD_REQUEST, String.format("%s %s cannot be admitted:- %s", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sinkName, e.getMessage()));
            }
            Function.FunctionMetaData.Builder functionMetaDataBuilder = Function.FunctionMetaData.newBuilder().mergeFrom(existingComponent).setFunctionDetails(functionDetails);
            if (this.worker().getWorkerConfig().isAuthenticationEnabled()) {
                Function.FunctionDetails finalFunctionDetails = functionDetails;
                this.worker().getFunctionRuntimeManager().getRuntimeFactory().getAuthProvider().ifPresent(functionAuthProvider -> {
                    if (clientAuthenticationDataHttps != null && updateOptions != null && updateOptions.isUpdateAuthData()) {
                        Optional<Object> existingFunctionAuthData = Optional.empty();
                        if (functionMetaDataBuilder.hasFunctionAuthSpec()) {
                            existingFunctionAuthData = Optional.ofNullable(FunctionAuthUtils.getFunctionAuthData(Optional.ofNullable(functionMetaDataBuilder.getFunctionAuthSpec())));
                        }
                        try {
                            Optional newFunctionAuthData = functionAuthProvider.updateAuthData(finalFunctionDetails, existingFunctionAuthData, (AuthenticationDataSource)clientAuthenticationDataHttps);
                            if (newFunctionAuthData.isPresent()) {
                                functionMetaDataBuilder.setFunctionAuthSpec(Function.FunctionAuthenticationSpec.newBuilder().setData(ByteString.copyFrom((byte[])((FunctionAuthData)newFunctionAuthData.get()).getData())).build());
                            } else {
                                functionMetaDataBuilder.clearFunctionAuthSpec();
                            }
                        }
                        catch (Exception e) {
                            log.error("Error updating authentication data for {} {}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sinkName, e});
                            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, String.format("Error caching authentication data for %s %s:- %s", ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), sinkName, e.getMessage()));
                        }
                    }
                });
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sinkPkgUrl) || uploadedInputStream != null) {
                try {
                    packageLocationMetaDataBuilder = this.getFunctionPackageLocation(functionMetaDataBuilder.build(), sinkPkgUrl, fileDetail, componentPackageFile);
                }
                catch (Exception e) {
                    log.error("Failed process {} {}/{}/{} package: ", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, sinkName, e});
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
                }
            } else {
                packageLocationMetaDataBuilder = Function.PackageLocationMetaData.newBuilder().mergeFrom(existingComponent.getPackageLocation());
            }
            functionMetaDataBuilder.setPackageLocation(packageLocationMetaDataBuilder);
            this.updateRequest(existingComponent, functionMetaDataBuilder.build());
        }
        finally {
            if (componentPackageFile != null && componentPackageFile.exists() && (sinkPkgUrl != null && !sinkPkgUrl.startsWith("file") || uploadedInputStream != null)) {
                componentPackageFile.delete();
            }
        }
    }

    private ExceptionInformation getExceptionInformation(InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry) {
        ExceptionInformation exceptionInformation = new ExceptionInformation();
        exceptionInformation.setTimestampMs(exceptionEntry.getMsSinceEpoch());
        exceptionInformation.setExceptionString(exceptionEntry.getExceptionString());
        return exceptionInformation;
    }

    @Override
    public SinkStatus.SinkInstanceStatus.SinkInstanceStatusData getSinkInstanceStatus(String tenant, String namespace, String sinkName, String instanceId, URI uri, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        SinkStatus.SinkInstanceStatus.SinkInstanceStatusData sinkInstanceStatusData;
        this.componentInstanceStatusRequestValidate(tenant, namespace, sinkName, Integer.parseInt(instanceId), clientRole, clientAuthenticationDataHttps);
        try {
            sinkInstanceStatusData = (SinkStatus.SinkInstanceStatus.SinkInstanceStatusData)new GetSinkStatus().getComponentInstanceStatus(tenant, namespace, sinkName, Integer.parseInt(instanceId), uri);
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Exception e) {
            log.error("{}/{}/{} Got Exception Getting Status", new Object[]{tenant, namespace, sinkName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return sinkInstanceStatusData;
    }

    @Override
    public SinkStatus getSinkStatus(String tenant, String namespace, String componentName, URI uri, String clientRole, AuthenticationDataSource clientAuthenticationDataHttps) {
        SinkStatus sinkStatus;
        this.componentStatusRequestValidate(tenant, namespace, componentName, clientRole, clientAuthenticationDataHttps);
        try {
            sinkStatus = (SinkStatus)new GetSinkStatus().getComponentStatus(tenant, namespace, componentName, uri);
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Exception e) {
            log.error("{}/{}/{} Got Exception Getting Status", new Object[]{tenant, namespace, componentName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return sinkStatus;
    }

    @Override
    public SinkConfig getSinkInfo(String tenant, String namespace, String componentName) {
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        try {
            this.validateGetFunctionRequestParams(tenant, namespace, componentName, this.componentType);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid get {} request @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName, e});
            throw new RestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        FunctionMetaDataManager functionMetaDataManager = this.worker().getFunctionMetaDataManager();
        if (!functionMetaDataManager.containsFunction(tenant, namespace, componentName)) {
            log.error("{} does not exist @ /{}/{}/{}", new Object[]{ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType), tenant, namespace, componentName});
            throw new RestException(Response.Status.NOT_FOUND, String.format(ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType) + " %s doesn't exist", componentName));
        }
        Function.FunctionMetaData functionMetaData = functionMetaDataManager.getFunctionMetaData(tenant, namespace, componentName);
        if (!InstanceUtils.calculateSubjectType((Function.FunctionDetails)functionMetaData.getFunctionDetails()).equals((Object)this.componentType)) {
            log.error("{}/{}/{} is not a {}", new Object[]{tenant, namespace, componentName, ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType)});
            throw new RestException(Response.Status.NOT_FOUND, String.format(ComponentTypeUtils.toString((Function.FunctionDetails.ComponentType)this.componentType) + " %s doesn't exist", componentName));
        }
        SinkConfig config = SinkConfigUtils.convertFromDetails((Function.FunctionDetails)functionMetaData.getFunctionDetails());
        return config;
    }

    @Override
    public List<ConnectorDefinition> getSinkList() {
        List<ConnectorDefinition> connectorDefinitions = this.getListOfConnectors();
        ArrayList<ConnectorDefinition> retval = new ArrayList<ConnectorDefinition>();
        for (ConnectorDefinition connectorDefinition : connectorDefinitions) {
            if (StringUtils.isEmpty((String)connectorDefinition.getSinkClass())) continue;
            retval.add(connectorDefinition);
        }
        return retval;
    }

    @Override
    public List<ConfigFieldDefinition> getSinkConfigDefinition(String name) {
        List retval;
        if (!this.isWorkerServiceAvailable()) {
            RestUtils.throwUnavailableException();
        }
        if ((retval = this.worker().getConnectorsManager().getSinkConfigDefinition(name)) == null) {
            throw new RestException(Response.Status.NOT_FOUND, "builtin sink does not exist");
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Function.FunctionDetails validateUpdateRequestParams(String tenant, String namespace, String sinkName, SinkConfig sinkConfig, File sinkPackageFile) throws IOException {
        Function.FunctionDetails functionDetails;
        block7: {
            String archive;
            sinkConfig.setTenant(tenant);
            sinkConfig.setNamespace(namespace);
            sinkConfig.setName(sinkName);
            Utils.inferMissingArguments((SinkConfig)sinkConfig);
            ClassLoader classLoader = null;
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)sinkConfig.getArchive()) && (archive = sinkConfig.getArchive()).startsWith("builtin")) {
                archive = archive.replaceFirst("^builtin://", "");
                Connector connector = this.worker().getConnectorsManager().getConnector(archive);
                if (connector == null) {
                    throw new IllegalArgumentException("Built-in sink is not available");
                }
                classLoader = connector.getClassLoader();
            }
            boolean shouldCloseClassLoader = false;
            try {
                if (classLoader == null && sinkPackageFile != null) {
                    classLoader = this.getClassLoaderFromPackage(sinkConfig.getClassName(), sinkPackageFile, this.worker().getWorkerConfig().getNarExtractionDirectory());
                    shouldCloseClassLoader = true;
                }
                if (classLoader == null) {
                    throw new IllegalArgumentException("Sink package is not provided");
                }
                SinkConfigUtils.ExtractedSinkDetails sinkDetails = SinkConfigUtils.validateAndExtractDetails((SinkConfig)sinkConfig, classLoader, (boolean)this.worker().getWorkerConfig().getValidateConnectorConfig());
                functionDetails = SinkConfigUtils.convert((SinkConfig)sinkConfig, (SinkConfigUtils.ExtractedSinkDetails)sinkDetails);
                if (!shouldCloseClassLoader) break block7;
            }
            catch (Throwable throwable) {
                if (shouldCloseClassLoader) {
                    ClassLoaderUtils.closeClassLoader(classLoader);
                }
                throw throwable;
            }
            ClassLoaderUtils.closeClassLoader((ClassLoader)classLoader);
        }
        return functionDetails;
    }

    private File downloadPackageFile(String packageName) throws IOException, PulsarAdminException {
        return FunctionsImpl.downloadPackageFile(this.worker(), packageName);
    }

    private class GetSinkStatus
    extends ComponentImpl.GetStatus<SinkStatus, SinkStatus.SinkInstanceStatus.SinkInstanceStatusData> {
        private GetSinkStatus() {
        }

        @Override
        public SinkStatus.SinkInstanceStatus.SinkInstanceStatusData notScheduledInstance() {
            SinkStatus.SinkInstanceStatus.SinkInstanceStatusData sinkInstanceStatusData = new SinkStatus.SinkInstanceStatus.SinkInstanceStatusData();
            sinkInstanceStatusData.setRunning(false);
            sinkInstanceStatusData.setError("Sink has not been scheduled");
            return sinkInstanceStatusData;
        }

        @Override
        public SinkStatus.SinkInstanceStatus.SinkInstanceStatusData fromFunctionStatusProto(InstanceCommunication.FunctionStatus status, String assignedWorkerId) {
            ExceptionInformation exceptionInformation;
            SinkStatus.SinkInstanceStatus.SinkInstanceStatusData sinkInstanceStatusData = new SinkStatus.SinkInstanceStatus.SinkInstanceStatusData();
            sinkInstanceStatusData.setRunning(status.getRunning());
            sinkInstanceStatusData.setError(status.getFailureException());
            sinkInstanceStatusData.setNumRestarts(status.getNumRestarts());
            sinkInstanceStatusData.setNumReadFromPulsar(status.getNumReceived());
            sinkInstanceStatusData.setNumSystemExceptions(status.getNumSystemExceptions() + status.getNumUserExceptions() + status.getNumSourceExceptions());
            LinkedList<ExceptionInformation> systemExceptionInformationList = new LinkedList<ExceptionInformation>();
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestUserExceptionsList()) {
                exceptionInformation = SinksImpl.this.getExceptionInformation(exceptionEntry);
                systemExceptionInformationList.add(exceptionInformation);
            }
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestSystemExceptionsList()) {
                exceptionInformation = SinksImpl.this.getExceptionInformation(exceptionEntry);
                systemExceptionInformationList.add(exceptionInformation);
            }
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestSourceExceptionsList()) {
                exceptionInformation = SinksImpl.this.getExceptionInformation(exceptionEntry);
                systemExceptionInformationList.add(exceptionInformation);
            }
            sinkInstanceStatusData.setLatestSystemExceptions(systemExceptionInformationList);
            sinkInstanceStatusData.setNumSinkExceptions(status.getNumSinkExceptions());
            LinkedList<ExceptionInformation> sinkExceptionInformationList = new LinkedList<ExceptionInformation>();
            for (InstanceCommunication.FunctionStatus.ExceptionInformation exceptionEntry : status.getLatestSinkExceptionsList()) {
                ExceptionInformation exceptionInformation2 = SinksImpl.this.getExceptionInformation(exceptionEntry);
                sinkExceptionInformationList.add(exceptionInformation2);
            }
            sinkInstanceStatusData.setLatestSinkExceptions(sinkExceptionInformationList);
            sinkInstanceStatusData.setNumWrittenToSink(status.getNumSuccessfullyProcessed());
            sinkInstanceStatusData.setLastReceivedTime(status.getLastInvocationTime());
            sinkInstanceStatusData.setWorkerId(assignedWorkerId);
            return sinkInstanceStatusData;
        }

        @Override
        public SinkStatus.SinkInstanceStatus.SinkInstanceStatusData notRunning(String assignedWorkerId, String error) {
            SinkStatus.SinkInstanceStatus.SinkInstanceStatusData sinkInstanceStatusData = new SinkStatus.SinkInstanceStatus.SinkInstanceStatusData();
            sinkInstanceStatusData.setRunning(false);
            if (error != null) {
                sinkInstanceStatusData.setError(error);
            }
            sinkInstanceStatusData.setWorkerId(assignedWorkerId);
            return sinkInstanceStatusData;
        }

        @Override
        public SinkStatus getStatus(String tenant, String namespace, String name, Collection<Function.Assignment> assignments, URI uri) throws PulsarAdminException {
            SinkStatus sinkStatus = new SinkStatus();
            for (Function.Assignment assignment : assignments) {
                boolean isOwner = SinksImpl.this.worker().getWorkerConfig().getWorkerId().equals(assignment.getWorkerId());
                SinkStatus.SinkInstanceStatus.SinkInstanceStatusData sinkInstanceStatusData = isOwner ? (SinkStatus.SinkInstanceStatus.SinkInstanceStatusData)this.getComponentInstanceStatus(tenant, namespace, name, assignment.getInstance().getInstanceId(), null) : SinksImpl.this.worker().getFunctionAdmin().sink().getSinkStatus(assignment.getInstance().getFunctionMetaData().getFunctionDetails().getTenant(), assignment.getInstance().getFunctionMetaData().getFunctionDetails().getNamespace(), assignment.getInstance().getFunctionMetaData().getFunctionDetails().getName(), assignment.getInstance().getInstanceId());
                SinkStatus.SinkInstanceStatus instanceStatus = new SinkStatus.SinkInstanceStatus();
                instanceStatus.setInstanceId(assignment.getInstance().getInstanceId());
                instanceStatus.setStatus(sinkInstanceStatusData);
                sinkStatus.addInstance(instanceStatus);
            }
            sinkStatus.setNumInstances(sinkStatus.instances.size());
            sinkStatus.getInstances().forEach(sinkInstanceStatus -> {
                if (sinkInstanceStatus.getStatus().isRunning()) {
                    ++sinkStatus.numRunning;
                }
            });
            return sinkStatus;
        }

        @Override
        public SinkStatus getStatusExternal(String tenant, String namespace, String name, int parallelism) {
            SinkStatus sinkStatus = new SinkStatus();
            for (int i = 0; i < parallelism; ++i) {
                SinkStatus.SinkInstanceStatus.SinkInstanceStatusData sinkInstanceStatusData = (SinkStatus.SinkInstanceStatus.SinkInstanceStatusData)this.getComponentInstanceStatus(tenant, namespace, name, i, null);
                SinkStatus.SinkInstanceStatus sinkInstanceStatus2 = new SinkStatus.SinkInstanceStatus();
                sinkInstanceStatus2.setInstanceId(i);
                sinkInstanceStatus2.setStatus(sinkInstanceStatusData);
                sinkStatus.addInstance(sinkInstanceStatus2);
            }
            sinkStatus.setNumInstances(sinkStatus.instances.size());
            sinkStatus.getInstances().forEach(sinkInstanceStatus -> {
                if (sinkInstanceStatus.getStatus().isRunning()) {
                    ++sinkStatus.numRunning;
                }
            });
            return sinkStatus;
        }

        @Override
        public SinkStatus emptyStatus(int parallelism) {
            SinkStatus sinkStatus = new SinkStatus();
            sinkStatus.setNumInstances(parallelism);
            sinkStatus.setNumRunning(0);
            for (int i = 0; i < parallelism; ++i) {
                SinkStatus.SinkInstanceStatus sinkInstanceStatus = new SinkStatus.SinkInstanceStatus();
                sinkInstanceStatus.setInstanceId(i);
                SinkStatus.SinkInstanceStatus.SinkInstanceStatusData sinkInstanceStatusData = new SinkStatus.SinkInstanceStatus.SinkInstanceStatusData();
                sinkInstanceStatusData.setRunning(false);
                sinkInstanceStatusData.setError("Sink has not been scheduled");
                sinkInstanceStatus.setStatus(sinkInstanceStatusData);
                sinkStatus.addInstance(sinkInstanceStatus);
            }
            return sinkStatus;
        }
    }
}

