/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils.functioncache;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.functions.utils.Exceptions;
import org.apache.pulsar.functions.utils.functioncache.FunctionCacheEntry;
import org.apache.pulsar.functions.utils.functioncache.FunctionCacheManager;

public class FunctionCacheManagerImpl
implements FunctionCacheManager {
    private final Map<String, FunctionCacheEntry> cacheFunctions = new ConcurrentHashMap<String, FunctionCacheEntry>();
    private ClassLoader rootClassLoader;

    public FunctionCacheManagerImpl(ClassLoader rootClassLoader) {
        this.rootClassLoader = rootClassLoader;
    }

    Map<String, FunctionCacheEntry> getCacheFunctions() {
        return this.cacheFunctions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassLoader getClassLoader(String fid) {
        if (fid == null) {
            throw new NullPointerException("FunctionID not set");
        }
        Map<String, FunctionCacheEntry> map = this.cacheFunctions;
        synchronized (map) {
            FunctionCacheEntry entry = this.cacheFunctions.get(fid);
            if (entry == null) {
                throw new IllegalStateException("No dependencies are registered for function " + fid);
            }
            return entry.getClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFunctionInstance(String fid, String eid, List<String> requiredJarFiles, List<URL> requiredClasspaths) throws IOException {
        if (fid == null) {
            throw new NullPointerException("FunctionID not set");
        }
        Map<String, FunctionCacheEntry> map = this.cacheFunctions;
        synchronized (map) {
            FunctionCacheEntry entry = this.cacheFunctions.get(fid);
            if (null == entry) {
                URL[] urls = new URL[requiredJarFiles.size() + requiredClasspaths.size()];
                int count = 0;
                try {
                    for (String jarFile : requiredJarFiles) {
                        urls[count++] = new File(jarFile).toURI().toURL();
                    }
                    for (URL url : requiredClasspaths) {
                        urls[count++] = url;
                    }
                    this.cacheFunctions.put(fid, new FunctionCacheEntry(requiredJarFiles, requiredClasspaths, urls, eid, this.rootClassLoader));
                }
                catch (Throwable cause) {
                    Exceptions.rethrowIOException(cause);
                }
            } else {
                entry.register(eid, requiredJarFiles, requiredClasspaths);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFunctionInstanceWithArchive(String fid, String eid, String narArchive, String narExtractionDirectory) throws IOException {
        if (fid == null) {
            throw new NullPointerException("FunctionID not set");
        }
        Map<String, FunctionCacheEntry> map = this.cacheFunctions;
        synchronized (map) {
            FunctionCacheEntry entry = this.cacheFunctions.get(fid);
            if (null != entry) {
                entry.register(eid, Collections.singleton(narArchive), Collections.emptyList());
                return;
            }
            try {
                this.cacheFunctions.put(fid, new FunctionCacheEntry(narArchive, eid, this.rootClassLoader, narExtractionDirectory));
            }
            catch (Throwable cause) {
                Exceptions.rethrowIOException(cause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterFunctionInstance(String fid, String eid) {
        Map<String, FunctionCacheEntry> map = this.cacheFunctions;
        synchronized (map) {
            FunctionCacheEntry entry = this.cacheFunctions.get(fid);
            if (null != entry && entry.unregister(eid)) {
                this.cacheFunctions.remove(fid);
                entry.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<String, FunctionCacheEntry> map = this.cacheFunctions;
        synchronized (map) {
            this.cacheFunctions.values().forEach(FunctionCacheEntry::close);
        }
    }
}

