/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils.functions;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.functions.FunctionDefinition;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.utils.functions.FunctionArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.zip.ZipUtil;

public final class FunctionUtils {
    private static final Logger log = LoggerFactory.getLogger(FunctionUtils.class);
    private static final String PULSAR_IO_SERVICE_NAME = "pulsar-io.yaml";

    public static String getFunctionClass(File narFile) throws IOException {
        return FunctionUtils.getFunctionDefinition(narFile).getFunctionClass();
    }

    public static FunctionDefinition getFunctionDefinition(File narFile) throws IOException {
        return FunctionUtils.getPulsarIOServiceConfig(narFile, FunctionDefinition.class);
    }

    public static <T> T getPulsarIOServiceConfig(File narFile, Class<T> valueType) throws IOException {
        String filename = "META-INF/services/pulsar-io.yaml";
        byte[] configEntry = ZipUtil.unpackEntry((File)narFile, (String)filename);
        if (configEntry != null) {
            return (T)ObjectMapperFactory.getThreadLocalYaml().reader().readValue(configEntry, valueType);
        }
        return null;
    }

    public static String getFunctionClass(NarClassLoader narClassLoader) throws IOException {
        return FunctionUtils.getFunctionDefinition(narClassLoader).getFunctionClass();
    }

    public static FunctionDefinition getFunctionDefinition(NarClassLoader narClassLoader) throws IOException {
        return FunctionUtils.getPulsarIOServiceConfig(narClassLoader, FunctionDefinition.class);
    }

    public static <T> T getPulsarIOServiceConfig(NarClassLoader narClassLoader, Class<T> valueType) throws IOException {
        return (T)ObjectMapperFactory.getThreadLocalYaml().reader().readValue(narClassLoader.getServiceDefinition(PULSAR_IO_SERVICE_NAME), valueType);
    }

    public static TreeMap<String, FunctionArchive> searchForFunctions(String functionsDirectory, String narExtractionDirectory, boolean enableClassloading) throws IOException {
        Path path = Paths.get(functionsDirectory, new String[0]).toAbsolutePath();
        log.info("Searching for functions in {}", (Object)path);
        TreeMap<String, FunctionArchive> functions = new TreeMap<String, FunctionArchive>();
        if (!path.toFile().exists()) {
            log.warn("Functions archive directory not found");
            return functions;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.nar");){
            for (Path archive : stream) {
                try {
                    FunctionDefinition cntDef = FunctionUtils.getFunctionDefinition(archive.toFile());
                    log.info("Found function {} from {}", (Object)cntDef, (Object)archive);
                    if (StringUtils.isEmpty((CharSequence)cntDef.getFunctionClass())) continue;
                    FunctionArchive functionArchive = new FunctionArchive(archive, cntDef, narExtractionDirectory, enableClassloading);
                    functions.put(cntDef.getName(), functionArchive);
                }
                catch (Throwable t) {
                    log.warn("Failed to load function from {}", (Object)archive, (Object)t);
                }
            }
        }
        return functions;
    }

    private FunctionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

