/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.pool.TypePool;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.nar.NarClassLoaderBuilder;
import org.apache.pulsar.functions.utils.ValidatableFunctionPackage;
import org.apache.pulsar.functions.utils.functions.FunctionUtils;
import org.zeroturnaround.zip.ZipUtil;

public class FunctionFilePackage
implements AutoCloseable,
ValidatableFunctionPackage {
    private final File file;
    private final ClassFileLocator.Compound classFileLocator;
    private final TypePool typePool;
    private final boolean isNar;
    private final String narExtractionDirectory;
    private final boolean enableClassloading;
    private ClassLoader classLoader;
    private final Object configMetadata;

    public FunctionFilePackage(File file, String narExtractionDirectory, boolean enableClassloading, Class<?> configClass) {
        this.file = file;
        boolean nonZeroFile = file.isFile() && file.length() > 0L;
        this.isNar = nonZeroFile ? ZipUtil.containsAnyEntry((File)file, (String[])new String[]{"META-INF/services/pulsar-io.yaml", "META-INF/bundled-dependencies"}) : false;
        this.narExtractionDirectory = narExtractionDirectory;
        this.enableClassloading = enableClassloading;
        if (this.isNar) {
            List classpathFromArchive = null;
            try {
                classpathFromArchive = NarClassLoader.getClasspathFromArchive((File)file, (String)narExtractionDirectory);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();
            classFileLocators.add(ClassFileLocator.ForClassLoader.ofSystemLoader());
            for (File classpath : classpathFromArchive) {
                if (!classpath.exists()) continue;
                try {
                    Object locator = classpath.isDirectory() ? new ClassFileLocator.ForFolder(classpath) : ClassFileLocator.ForJarFile.of((File)classpath);
                    classFileLocators.add((ClassFileLocator)locator);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            this.classFileLocator = new ClassFileLocator.Compound(classFileLocators);
            this.typePool = TypePool.Default.of((ClassFileLocator)this.classFileLocator);
            try {
                this.configMetadata = FunctionUtils.getPulsarIOServiceConfig(file, configClass);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try {
            this.classFileLocator = nonZeroFile ? new ClassFileLocator.Compound(new ClassFileLocator[]{ClassFileLocator.ForClassLoader.ofSystemLoader(), ClassFileLocator.ForJarFile.of((File)file)}) : new ClassFileLocator.Compound(new ClassFileLocator[]{ClassFileLocator.ForClassLoader.ofSystemLoader()});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.typePool = TypePool.Default.of((ClassFileLocator)this.classFileLocator);
        this.configMetadata = null;
    }

    @Override
    public TypeDescription resolveType(String className) {
        return this.typePool.describe(className).resolve();
    }

    public boolean isNar() {
        return this.isNar;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public TypePool getTypePool() {
        return this.typePool;
    }

    @Override
    public <T> T getFunctionMetaData(Class<T> clazz) {
        return this.configMetadata != null ? (T)clazz.cast(this.configMetadata) : null;
    }

    @Override
    public synchronized void close() throws IOException {
        this.classFileLocator.close();
        if (this.classLoader instanceof Closeable) {
            ((Closeable)((Object)this.classLoader)).close();
        }
    }

    @Override
    public boolean isEnableClassloading() {
        return this.enableClassloading;
    }

    @Override
    public synchronized ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.createClassLoader();
        }
        return this.classLoader;
    }

    private ClassLoader createClassLoader() {
        if (this.enableClassloading) {
            if (this.isNar) {
                try {
                    return NarClassLoaderBuilder.builder().narFile(this.file).extractionDirectory(this.narExtractionDirectory).build();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            try {
                return new URLClassLoader(new URL[]{this.file.toURI().toURL()}, NarClassLoader.class.getClassLoader());
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }
        throw new IllegalStateException("Classloading is not enabled");
    }

    public String toString() {
        return "FunctionFilePackage{file=" + this.file + ", isNar=" + this.isNar + '}';
    }
}

