/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance.state;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.functions.api.StateStoreContext;
import org.apache.pulsar.functions.instance.state.DefaultStateStore;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStore;

public class PulsarMetadataStateStoreImpl
implements DefaultStateStore {
    private final MetadataStore store;
    private final String prefixPath;
    private final MetadataCache<Long> countersCache;
    private final String namespace;
    private final String tenant;
    private final String name;
    private final String fqsn;

    PulsarMetadataStateStoreImpl(MetadataStore store, String prefix, String tenant, String namespace, String name) {
        this.store = store;
        this.tenant = tenant;
        this.namespace = namespace;
        this.name = name;
        this.fqsn = tenant + '/' + namespace + '/' + name;
        this.prefixPath = prefix + '/' + this.fqsn + '/';
        this.countersCache = store.getMetadataCache(Long.class);
    }

    public String tenant() {
        return this.tenant;
    }

    public String namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public String fqsn() {
        return this.fqsn;
    }

    public void init(StateStoreContext ctx) {
    }

    public void close() {
    }

    public void put(String key, ByteBuffer value) {
        this.putAsync(key, value).join();
    }

    public CompletableFuture<Void> putAsync(String key, ByteBuffer value) {
        byte[] bytes = new byte[value.remaining()];
        value.get(bytes);
        return this.store.put(this.getPath(key), bytes, Optional.empty()).thenApply(__ -> null);
    }

    public void delete(String key) {
        this.deleteAsync(key).join();
    }

    public CompletableFuture<Void> deleteAsync(String key) {
        return this.store.delete(this.getPath(key), Optional.empty());
    }

    public ByteBuffer get(String key) {
        return this.getAsync(key).join();
    }

    public CompletableFuture<ByteBuffer> getAsync(String key) {
        return this.store.get(this.getPath(key)).thenApply(optRes -> optRes.map(x -> ByteBuffer.wrap(x.getValue())).orElse(null));
    }

    public void incrCounter(String key, long amount) {
        this.incrCounterAsync(key, amount);
    }

    public CompletableFuture<Void> incrCounterAsync(String key, long amount) {
        return this.countersCache.readModifyUpdateOrCreate(this.getPath(key), optValue -> optValue.orElse(0L) + amount).thenApply(__ -> null);
    }

    public long getCounter(String key) {
        return this.getCounterAsync(key).join();
    }

    public CompletableFuture<Long> getCounterAsync(String key) {
        return this.countersCache.get(this.getPath(key)).thenApply(optValue -> optValue.orElse(0L));
    }

    private String getPath(String key) {
        return this.prefixPath + key;
    }
}

