/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.api;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.functions.api.StateStore;
import org.slf4j.Logger;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface BaseContext {
    public String getTenant();

    public String getNamespace();

    public int getInstanceId();

    public int getNumInstances();

    public Logger getLogger();

    public String getSecret(String var1);

    default public <S extends StateStore> S getStateStore(String name) {
        throw new UnsupportedOperationException("Component cannot get state store");
    }

    default public <S extends StateStore> S getStateStore(String tenant, String ns, String name) {
        throw new UnsupportedOperationException("Component cannot get state store");
    }

    public void putState(String var1, ByteBuffer var2);

    public CompletableFuture<Void> putStateAsync(String var1, ByteBuffer var2);

    public ByteBuffer getState(String var1);

    public CompletableFuture<ByteBuffer> getStateAsync(String var1);

    public void deleteState(String var1);

    public CompletableFuture<Void> deleteStateAsync(String var1);

    public void incrCounter(String var1, long var2);

    public CompletableFuture<Void> incrCounterAsync(String var1, long var2);

    public long getCounter(String var1);

    public CompletableFuture<Long> getCounterAsync(String var1);

    public void recordMetric(String var1, double var2);

    default public PulsarClient getPulsarClient() {
        throw new UnsupportedOperationException("not implemented");
    }

    default public ClientBuilder getPulsarClientBuilder() {
        throw new UnsupportedOperationException("not implemented");
    }
}

