/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.api;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.functions.api.StateStore;
import org.slf4j.Logger;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface Context {
    public Record<?> getCurrentRecord();

    public Collection<String> getInputTopics();

    public String getOutputTopic();

    public String getOutputSchemaType();

    public String getTenant();

    public String getNamespace();

    public String getFunctionName();

    public String getFunctionId();

    public int getInstanceId();

    public int getNumInstances();

    public String getFunctionVersion();

    public Logger getLogger();

    public <S extends StateStore> S getStateStore(String var1);

    public <S extends StateStore> S getStateStore(String var1, String var2, String var3);

    public void incrCounter(String var1, long var2);

    public CompletableFuture<Void> incrCounterAsync(String var1, long var2);

    public long getCounter(String var1);

    public CompletableFuture<Long> getCounterAsync(String var1);

    public void putState(String var1, ByteBuffer var2);

    public CompletableFuture<Void> putStateAsync(String var1, ByteBuffer var2);

    public void deleteState(String var1);

    public CompletableFuture<Void> deleteStateAsync(String var1);

    public ByteBuffer getState(String var1);

    public CompletableFuture<ByteBuffer> getStateAsync(String var1);

    public Map<String, Object> getUserConfigMap();

    public Optional<Object> getUserConfigValue(String var1);

    public Object getUserConfigValueOrDefault(String var1, Object var2);

    public String getSecret(String var1);

    public PulsarAdmin getPulsarAdmin();

    public PulsarAdmin getPulsarAdmin(String var1);

    public void recordMetric(String var1, double var2);

    public <O> CompletableFuture<Void> publish(String var1, O var2, String var3);

    public <O> CompletableFuture<Void> publish(String var1, O var2);

    public <O> TypedMessageBuilder<O> newOutputMessage(String var1, Schema<O> var2) throws PulsarClientException;

    public <O> TypedMessageBuilder<O> newOutputMessage(String var1, String var2, Schema<O> var3) throws PulsarClientException;

    public <O> ConsumerBuilder<O> newConsumerBuilder(Schema<O> var1) throws PulsarClientException;
}

