/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service.server;

import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModelProperty;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.common.configuration.PulsarConfiguration;

public class ServiceConfig
implements PulsarConfiguration {
    @ApiModelProperty(name="zookeeperServers", value="Local ZooKeeper quorum connection string")
    private String zookeeperServers;
    @Deprecated
    private String globalZookeeperServers;
    @ApiModelProperty(name="configurationStoreServers", value="Configuration store connection string")
    private String configurationStoreServers;
    @ApiModelProperty(name="zookeeperSessionTimeoutMs", value="ZooKeeper session timeout (in million seconds)")
    private int zookeeperSessionTimeoutMs = 30000;
    @ApiModelProperty(name="zooKeeperCacheExpirySeconds", value="ZooKeeper cache expiry time (in seconds)")
    private int zooKeeperCacheExpirySeconds = 300;
    @ApiModelProperty(name="servicePort", value="Port used to server binary-proto request")
    private Optional<Integer> servicePort = Optional.ofNullable(5000);
    @ApiModelProperty(name="servicePortTls", value="Port used to server binary-proto-tls request")
    private Optional<Integer> servicePortTls = Optional.empty();
    @ApiModelProperty(name="webServicePort", value="Port used to server HTTP request")
    private Optional<Integer> webServicePort = Optional.ofNullable(8080);
    @ApiModelProperty(name="webServicePortTls", value="Port used to server HTTPS request")
    private Optional<Integer> webServicePortTls = Optional.empty();
    @ApiModelProperty(name="bindOnLocalhost", value="Control whether to bind directly on localhost rather than on normal hostname")
    private boolean bindOnLocalhost = false;
    @ApiModelProperty(name="superUserRoles", value="Role names that are treated as \"super-user\", meaning they are able to do all admin operations and publish to or consume from all topics")
    private Set<String> superUserRoles = Sets.newTreeSet();
    @ApiModelProperty(name="authorizationAllowWildcardsMatching", value="Allow wildcard matching in authorization (wildcard matching only applicable if wildcard char * presents at first or last position. For example, *.pulsar.service, pulsar.service.*")
    private boolean authorizationAllowWildcardsMatching = false;
    @ApiModelProperty(name="authenticationEnabled", value="Whether enable authentication")
    private boolean authenticationEnabled = false;
    @ApiModelProperty(name="authenticationProviders", value="Authentication provider name list, which is a list of class names")
    private Set<String> authenticationProviders = Sets.newTreeSet();
    @ApiModelProperty(name="authorizationEnabled", value="Whether enforce authorization")
    private boolean authorizationEnabled = false;
    @ApiModelProperty(name="authorizationProvider", value="Authorization provider fully qualified class-name")
    private String authorizationProvider = PulsarAuthorizationProvider.class.getName();
    @Deprecated
    private boolean tlsEnabled = false;
    @ApiModelProperty(name="tlsCertRefreshCheckDurationSec", value="TLS cert refresh duration (in seconds). 0 means checking every new connection.")
    private long tlsCertRefreshCheckDurationSec = 300L;
    @ApiModelProperty(name="tlsCertificateFilePath", value="Path for the TLS certificate file")
    private String tlsCertificateFilePath;
    @ApiModelProperty(name="tlsKeyFilePath", value="Path for the TLS private key file")
    private String tlsKeyFilePath;
    @ApiModelProperty(name="tlsTrustCertsFilePath", value="Path for the trusted TLS certificate file")
    private String tlsTrustCertsFilePath = "";
    @ApiModelProperty(name="tlsAllowInsecureConnection", value="Accept untrusted TLS certificate from client")
    private boolean tlsAllowInsecureConnection = false;
    @ApiModelProperty(name="tlsProtocols", value="Specify the TLS protocols the broker uses to negotiate during TLS Handshake. Example: [TLSv1.3, TLSv1.2]")
    private Set<String> tlsProtocols = Sets.newTreeSet();
    @ApiModelProperty(name="tlsCiphers", value="Specify the tls cipher the broker will use to negotiate during TLS Handshake. Example: [TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256]")
    private Set<String> tlsCiphers = Sets.newTreeSet();
    @ApiModelProperty(name="tlsRequireTrustedClientCertOnConnect", value="Specify whether client certificates are required for TLS. Reject the connection if the client certificate is not trusted.")
    private boolean tlsRequireTrustedClientCertOnConnect = false;
    @ApiModelProperty(name="tlsEnabledWithKeyStore", value="Enable TLS with KeyStore type configuration in broker")
    private boolean tlsEnabledWithKeyStore = false;
    @ApiModelProperty(name="tlsProvider", value="Full class name of TLS Provider")
    private String tlsProvider = null;
    @ApiModelProperty(name="tlsKeyStoreType", value="TLS KeyStore type configurations in broker are JKS or PKCS12")
    private String tlsKeyStoreType = "JKS";
    @ApiModelProperty(name="tlsKeyStore", value="TLS KeyStore path in broker")
    private String tlsKeyStore = null;
    @ApiModelProperty(name="tlsKeyStorePassword", value="TLS KeyStore password in broker")
    private String tlsKeyStorePassword = null;
    @ApiModelProperty(name="tlsTrustStoreType", value="TLS TrustStore type configuration in broker are JKS or PKCS12")
    private String tlsTrustStoreType = "JKS";
    @ApiModelProperty(name="tlsTrustStore", value="TLS TrustStore path in broker")
    private String tlsTrustStore = null;
    @ApiModelProperty(name="tlsTrustStorePassword", value="TLS TrustStore password in broker")
    private String tlsTrustStorePassword = null;
    @ApiModelProperty(name="properties", value="You can store string in key-value format")
    private Properties properties = new Properties();

    public String getConfigurationStoreServers() {
        return null == this.configurationStoreServers ? this.getGlobalZookeeperServers() : this.configurationStoreServers;
    }

    public String getZookeeperServers() {
        return this.zookeeperServers;
    }

    @Deprecated
    public String getGlobalZookeeperServers() {
        return this.globalZookeeperServers;
    }

    public int getZookeeperSessionTimeoutMs() {
        return this.zookeeperSessionTimeoutMs;
    }

    public int getZooKeeperCacheExpirySeconds() {
        return this.zooKeeperCacheExpirySeconds;
    }

    public Optional<Integer> getServicePort() {
        return this.servicePort;
    }

    public Optional<Integer> getServicePortTls() {
        return this.servicePortTls;
    }

    public Optional<Integer> getWebServicePort() {
        return this.webServicePort;
    }

    public Optional<Integer> getWebServicePortTls() {
        return this.webServicePortTls;
    }

    public boolean isBindOnLocalhost() {
        return this.bindOnLocalhost;
    }

    public Set<String> getSuperUserRoles() {
        return this.superUserRoles;
    }

    public boolean isAuthorizationAllowWildcardsMatching() {
        return this.authorizationAllowWildcardsMatching;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public Set<String> getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    public String getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    @Deprecated
    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public long getTlsCertRefreshCheckDurationSec() {
        return this.tlsCertRefreshCheckDurationSec;
    }

    public String getTlsCertificateFilePath() {
        return this.tlsCertificateFilePath;
    }

    public String getTlsKeyFilePath() {
        return this.tlsKeyFilePath;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public Set<String> getTlsProtocols() {
        return this.tlsProtocols;
    }

    public Set<String> getTlsCiphers() {
        return this.tlsCiphers;
    }

    public boolean isTlsRequireTrustedClientCertOnConnect() {
        return this.tlsRequireTrustedClientCertOnConnect;
    }

    public boolean isTlsEnabledWithKeyStore() {
        return this.tlsEnabledWithKeyStore;
    }

    public String getTlsProvider() {
        return this.tlsProvider;
    }

    public String getTlsKeyStoreType() {
        return this.tlsKeyStoreType;
    }

    public String getTlsKeyStore() {
        return this.tlsKeyStore;
    }

    public String getTlsKeyStorePassword() {
        return this.tlsKeyStorePassword;
    }

    public String getTlsTrustStoreType() {
        return this.tlsTrustStoreType;
    }

    public String getTlsTrustStore() {
        return this.tlsTrustStore;
    }

    public String getTlsTrustStorePassword() {
        return this.tlsTrustStorePassword;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setZookeeperServers(String zookeeperServers) {
        this.zookeeperServers = zookeeperServers;
    }

    @Deprecated
    public void setGlobalZookeeperServers(String globalZookeeperServers) {
        this.globalZookeeperServers = globalZookeeperServers;
    }

    public void setConfigurationStoreServers(String configurationStoreServers) {
        this.configurationStoreServers = configurationStoreServers;
    }

    public void setZookeeperSessionTimeoutMs(int zookeeperSessionTimeoutMs) {
        this.zookeeperSessionTimeoutMs = zookeeperSessionTimeoutMs;
    }

    public void setZooKeeperCacheExpirySeconds(int zooKeeperCacheExpirySeconds) {
        this.zooKeeperCacheExpirySeconds = zooKeeperCacheExpirySeconds;
    }

    public void setServicePort(Optional<Integer> servicePort) {
        this.servicePort = servicePort;
    }

    public void setServicePortTls(Optional<Integer> servicePortTls) {
        this.servicePortTls = servicePortTls;
    }

    public void setWebServicePort(Optional<Integer> webServicePort) {
        this.webServicePort = webServicePort;
    }

    public void setWebServicePortTls(Optional<Integer> webServicePortTls) {
        this.webServicePortTls = webServicePortTls;
    }

    public void setBindOnLocalhost(boolean bindOnLocalhost) {
        this.bindOnLocalhost = bindOnLocalhost;
    }

    public void setSuperUserRoles(Set<String> superUserRoles) {
        this.superUserRoles = superUserRoles;
    }

    public void setAuthorizationAllowWildcardsMatching(boolean authorizationAllowWildcardsMatching) {
        this.authorizationAllowWildcardsMatching = authorizationAllowWildcardsMatching;
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    public void setAuthenticationProviders(Set<String> authenticationProviders) {
        this.authenticationProviders = authenticationProviders;
    }

    public void setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationEnabled = authorizationEnabled;
    }

    public void setAuthorizationProvider(String authorizationProvider) {
        this.authorizationProvider = authorizationProvider;
    }

    @Deprecated
    public void setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
    }

    public void setTlsCertRefreshCheckDurationSec(long tlsCertRefreshCheckDurationSec) {
        this.tlsCertRefreshCheckDurationSec = tlsCertRefreshCheckDurationSec;
    }

    public void setTlsCertificateFilePath(String tlsCertificateFilePath) {
        this.tlsCertificateFilePath = tlsCertificateFilePath;
    }

    public void setTlsKeyFilePath(String tlsKeyFilePath) {
        this.tlsKeyFilePath = tlsKeyFilePath;
    }

    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    public void setTlsProtocols(Set<String> tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
    }

    public void setTlsCiphers(Set<String> tlsCiphers) {
        this.tlsCiphers = tlsCiphers;
    }

    public void setTlsRequireTrustedClientCertOnConnect(boolean tlsRequireTrustedClientCertOnConnect) {
        this.tlsRequireTrustedClientCertOnConnect = tlsRequireTrustedClientCertOnConnect;
    }

    public void setTlsEnabledWithKeyStore(boolean tlsEnabledWithKeyStore) {
        this.tlsEnabledWithKeyStore = tlsEnabledWithKeyStore;
    }

    public void setTlsProvider(String tlsProvider) {
        this.tlsProvider = tlsProvider;
    }

    public void setTlsKeyStoreType(String tlsKeyStoreType) {
        this.tlsKeyStoreType = tlsKeyStoreType;
    }

    public void setTlsKeyStore(String tlsKeyStore) {
        this.tlsKeyStore = tlsKeyStore;
    }

    public void setTlsKeyStorePassword(String tlsKeyStorePassword) {
        this.tlsKeyStorePassword = tlsKeyStorePassword;
    }

    public void setTlsTrustStoreType(String tlsTrustStoreType) {
        this.tlsTrustStoreType = tlsTrustStoreType;
    }

    public void setTlsTrustStore(String tlsTrustStore) {
        this.tlsTrustStore = tlsTrustStore;
    }

    public void setTlsTrustStorePassword(String tlsTrustStorePassword) {
        this.tlsTrustStorePassword = tlsTrustStorePassword;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceConfig)) {
            return false;
        }
        ServiceConfig other = (ServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getZookeeperSessionTimeoutMs() != other.getZookeeperSessionTimeoutMs()) {
            return false;
        }
        if (this.getZooKeeperCacheExpirySeconds() != other.getZooKeeperCacheExpirySeconds()) {
            return false;
        }
        if (this.isBindOnLocalhost() != other.isBindOnLocalhost()) {
            return false;
        }
        if (this.isAuthorizationAllowWildcardsMatching() != other.isAuthorizationAllowWildcardsMatching()) {
            return false;
        }
        if (this.isAuthenticationEnabled() != other.isAuthenticationEnabled()) {
            return false;
        }
        if (this.isAuthorizationEnabled() != other.isAuthorizationEnabled()) {
            return false;
        }
        if (this.isTlsEnabled() != other.isTlsEnabled()) {
            return false;
        }
        if (this.getTlsCertRefreshCheckDurationSec() != other.getTlsCertRefreshCheckDurationSec()) {
            return false;
        }
        if (this.isTlsAllowInsecureConnection() != other.isTlsAllowInsecureConnection()) {
            return false;
        }
        if (this.isTlsRequireTrustedClientCertOnConnect() != other.isTlsRequireTrustedClientCertOnConnect()) {
            return false;
        }
        if (this.isTlsEnabledWithKeyStore() != other.isTlsEnabledWithKeyStore()) {
            return false;
        }
        String this$zookeeperServers = this.getZookeeperServers();
        String other$zookeeperServers = other.getZookeeperServers();
        if (this$zookeeperServers == null ? other$zookeeperServers != null : !this$zookeeperServers.equals(other$zookeeperServers)) {
            return false;
        }
        String this$globalZookeeperServers = this.getGlobalZookeeperServers();
        String other$globalZookeeperServers = other.getGlobalZookeeperServers();
        if (this$globalZookeeperServers == null ? other$globalZookeeperServers != null : !this$globalZookeeperServers.equals(other$globalZookeeperServers)) {
            return false;
        }
        String this$configurationStoreServers = this.getConfigurationStoreServers();
        String other$configurationStoreServers = other.getConfigurationStoreServers();
        if (this$configurationStoreServers == null ? other$configurationStoreServers != null : !this$configurationStoreServers.equals(other$configurationStoreServers)) {
            return false;
        }
        Optional<Integer> this$servicePort = this.getServicePort();
        Optional<Integer> other$servicePort = other.getServicePort();
        if (this$servicePort == null ? other$servicePort != null : !((Object)this$servicePort).equals(other$servicePort)) {
            return false;
        }
        Optional<Integer> this$servicePortTls = this.getServicePortTls();
        Optional<Integer> other$servicePortTls = other.getServicePortTls();
        if (this$servicePortTls == null ? other$servicePortTls != null : !((Object)this$servicePortTls).equals(other$servicePortTls)) {
            return false;
        }
        Optional<Integer> this$webServicePort = this.getWebServicePort();
        Optional<Integer> other$webServicePort = other.getWebServicePort();
        if (this$webServicePort == null ? other$webServicePort != null : !((Object)this$webServicePort).equals(other$webServicePort)) {
            return false;
        }
        Optional<Integer> this$webServicePortTls = this.getWebServicePortTls();
        Optional<Integer> other$webServicePortTls = other.getWebServicePortTls();
        if (this$webServicePortTls == null ? other$webServicePortTls != null : !((Object)this$webServicePortTls).equals(other$webServicePortTls)) {
            return false;
        }
        Set<String> this$superUserRoles = this.getSuperUserRoles();
        Set<String> other$superUserRoles = other.getSuperUserRoles();
        if (this$superUserRoles == null ? other$superUserRoles != null : !((Object)this$superUserRoles).equals(other$superUserRoles)) {
            return false;
        }
        Set<String> this$authenticationProviders = this.getAuthenticationProviders();
        Set<String> other$authenticationProviders = other.getAuthenticationProviders();
        if (this$authenticationProviders == null ? other$authenticationProviders != null : !((Object)this$authenticationProviders).equals(other$authenticationProviders)) {
            return false;
        }
        String this$authorizationProvider = this.getAuthorizationProvider();
        String other$authorizationProvider = other.getAuthorizationProvider();
        if (this$authorizationProvider == null ? other$authorizationProvider != null : !this$authorizationProvider.equals(other$authorizationProvider)) {
            return false;
        }
        String this$tlsCertificateFilePath = this.getTlsCertificateFilePath();
        String other$tlsCertificateFilePath = other.getTlsCertificateFilePath();
        if (this$tlsCertificateFilePath == null ? other$tlsCertificateFilePath != null : !this$tlsCertificateFilePath.equals(other$tlsCertificateFilePath)) {
            return false;
        }
        String this$tlsKeyFilePath = this.getTlsKeyFilePath();
        String other$tlsKeyFilePath = other.getTlsKeyFilePath();
        if (this$tlsKeyFilePath == null ? other$tlsKeyFilePath != null : !this$tlsKeyFilePath.equals(other$tlsKeyFilePath)) {
            return false;
        }
        String this$tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        String other$tlsTrustCertsFilePath = other.getTlsTrustCertsFilePath();
        if (this$tlsTrustCertsFilePath == null ? other$tlsTrustCertsFilePath != null : !this$tlsTrustCertsFilePath.equals(other$tlsTrustCertsFilePath)) {
            return false;
        }
        Set<String> this$tlsProtocols = this.getTlsProtocols();
        Set<String> other$tlsProtocols = other.getTlsProtocols();
        if (this$tlsProtocols == null ? other$tlsProtocols != null : !((Object)this$tlsProtocols).equals(other$tlsProtocols)) {
            return false;
        }
        Set<String> this$tlsCiphers = this.getTlsCiphers();
        Set<String> other$tlsCiphers = other.getTlsCiphers();
        if (this$tlsCiphers == null ? other$tlsCiphers != null : !((Object)this$tlsCiphers).equals(other$tlsCiphers)) {
            return false;
        }
        String this$tlsProvider = this.getTlsProvider();
        String other$tlsProvider = other.getTlsProvider();
        if (this$tlsProvider == null ? other$tlsProvider != null : !this$tlsProvider.equals(other$tlsProvider)) {
            return false;
        }
        String this$tlsKeyStoreType = this.getTlsKeyStoreType();
        String other$tlsKeyStoreType = other.getTlsKeyStoreType();
        if (this$tlsKeyStoreType == null ? other$tlsKeyStoreType != null : !this$tlsKeyStoreType.equals(other$tlsKeyStoreType)) {
            return false;
        }
        String this$tlsKeyStore = this.getTlsKeyStore();
        String other$tlsKeyStore = other.getTlsKeyStore();
        if (this$tlsKeyStore == null ? other$tlsKeyStore != null : !this$tlsKeyStore.equals(other$tlsKeyStore)) {
            return false;
        }
        String this$tlsKeyStorePassword = this.getTlsKeyStorePassword();
        String other$tlsKeyStorePassword = other.getTlsKeyStorePassword();
        if (this$tlsKeyStorePassword == null ? other$tlsKeyStorePassword != null : !this$tlsKeyStorePassword.equals(other$tlsKeyStorePassword)) {
            return false;
        }
        String this$tlsTrustStoreType = this.getTlsTrustStoreType();
        String other$tlsTrustStoreType = other.getTlsTrustStoreType();
        if (this$tlsTrustStoreType == null ? other$tlsTrustStoreType != null : !this$tlsTrustStoreType.equals(other$tlsTrustStoreType)) {
            return false;
        }
        String this$tlsTrustStore = this.getTlsTrustStore();
        String other$tlsTrustStore = other.getTlsTrustStore();
        if (this$tlsTrustStore == null ? other$tlsTrustStore != null : !this$tlsTrustStore.equals(other$tlsTrustStore)) {
            return false;
        }
        String this$tlsTrustStorePassword = this.getTlsTrustStorePassword();
        String other$tlsTrustStorePassword = other.getTlsTrustStorePassword();
        if (this$tlsTrustStorePassword == null ? other$tlsTrustStorePassword != null : !this$tlsTrustStorePassword.equals(other$tlsTrustStorePassword)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getZookeeperSessionTimeoutMs();
        result = result * 59 + this.getZooKeeperCacheExpirySeconds();
        result = result * 59 + (this.isBindOnLocalhost() ? 79 : 97);
        result = result * 59 + (this.isAuthorizationAllowWildcardsMatching() ? 79 : 97);
        result = result * 59 + (this.isAuthenticationEnabled() ? 79 : 97);
        result = result * 59 + (this.isAuthorizationEnabled() ? 79 : 97);
        result = result * 59 + (this.isTlsEnabled() ? 79 : 97);
        long $tlsCertRefreshCheckDurationSec = this.getTlsCertRefreshCheckDurationSec();
        result = result * 59 + (int)($tlsCertRefreshCheckDurationSec >>> 32 ^ $tlsCertRefreshCheckDurationSec);
        result = result * 59 + (this.isTlsAllowInsecureConnection() ? 79 : 97);
        result = result * 59 + (this.isTlsRequireTrustedClientCertOnConnect() ? 79 : 97);
        result = result * 59 + (this.isTlsEnabledWithKeyStore() ? 79 : 97);
        String $zookeeperServers = this.getZookeeperServers();
        result = result * 59 + ($zookeeperServers == null ? 43 : $zookeeperServers.hashCode());
        String $globalZookeeperServers = this.getGlobalZookeeperServers();
        result = result * 59 + ($globalZookeeperServers == null ? 43 : $globalZookeeperServers.hashCode());
        String $configurationStoreServers = this.getConfigurationStoreServers();
        result = result * 59 + ($configurationStoreServers == null ? 43 : $configurationStoreServers.hashCode());
        Optional<Integer> $servicePort = this.getServicePort();
        result = result * 59 + ($servicePort == null ? 43 : ((Object)$servicePort).hashCode());
        Optional<Integer> $servicePortTls = this.getServicePortTls();
        result = result * 59 + ($servicePortTls == null ? 43 : ((Object)$servicePortTls).hashCode());
        Optional<Integer> $webServicePort = this.getWebServicePort();
        result = result * 59 + ($webServicePort == null ? 43 : ((Object)$webServicePort).hashCode());
        Optional<Integer> $webServicePortTls = this.getWebServicePortTls();
        result = result * 59 + ($webServicePortTls == null ? 43 : ((Object)$webServicePortTls).hashCode());
        Set<String> $superUserRoles = this.getSuperUserRoles();
        result = result * 59 + ($superUserRoles == null ? 43 : ((Object)$superUserRoles).hashCode());
        Set<String> $authenticationProviders = this.getAuthenticationProviders();
        result = result * 59 + ($authenticationProviders == null ? 43 : ((Object)$authenticationProviders).hashCode());
        String $authorizationProvider = this.getAuthorizationProvider();
        result = result * 59 + ($authorizationProvider == null ? 43 : $authorizationProvider.hashCode());
        String $tlsCertificateFilePath = this.getTlsCertificateFilePath();
        result = result * 59 + ($tlsCertificateFilePath == null ? 43 : $tlsCertificateFilePath.hashCode());
        String $tlsKeyFilePath = this.getTlsKeyFilePath();
        result = result * 59 + ($tlsKeyFilePath == null ? 43 : $tlsKeyFilePath.hashCode());
        String $tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        result = result * 59 + ($tlsTrustCertsFilePath == null ? 43 : $tlsTrustCertsFilePath.hashCode());
        Set<String> $tlsProtocols = this.getTlsProtocols();
        result = result * 59 + ($tlsProtocols == null ? 43 : ((Object)$tlsProtocols).hashCode());
        Set<String> $tlsCiphers = this.getTlsCiphers();
        result = result * 59 + ($tlsCiphers == null ? 43 : ((Object)$tlsCiphers).hashCode());
        String $tlsProvider = this.getTlsProvider();
        result = result * 59 + ($tlsProvider == null ? 43 : $tlsProvider.hashCode());
        String $tlsKeyStoreType = this.getTlsKeyStoreType();
        result = result * 59 + ($tlsKeyStoreType == null ? 43 : $tlsKeyStoreType.hashCode());
        String $tlsKeyStore = this.getTlsKeyStore();
        result = result * 59 + ($tlsKeyStore == null ? 43 : $tlsKeyStore.hashCode());
        String $tlsKeyStorePassword = this.getTlsKeyStorePassword();
        result = result * 59 + ($tlsKeyStorePassword == null ? 43 : $tlsKeyStorePassword.hashCode());
        String $tlsTrustStoreType = this.getTlsTrustStoreType();
        result = result * 59 + ($tlsTrustStoreType == null ? 43 : $tlsTrustStoreType.hashCode());
        String $tlsTrustStore = this.getTlsTrustStore();
        result = result * 59 + ($tlsTrustStore == null ? 43 : $tlsTrustStore.hashCode());
        String $tlsTrustStorePassword = this.getTlsTrustStorePassword();
        result = result * 59 + ($tlsTrustStorePassword == null ? 43 : $tlsTrustStorePassword.hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "ServiceConfig(zookeeperServers=" + this.getZookeeperServers() + ", globalZookeeperServers=" + this.getGlobalZookeeperServers() + ", configurationStoreServers=" + this.getConfigurationStoreServers() + ", zookeeperSessionTimeoutMs=" + this.getZookeeperSessionTimeoutMs() + ", zooKeeperCacheExpirySeconds=" + this.getZooKeeperCacheExpirySeconds() + ", servicePort=" + this.getServicePort() + ", servicePortTls=" + this.getServicePortTls() + ", webServicePort=" + this.getWebServicePort() + ", webServicePortTls=" + this.getWebServicePortTls() + ", bindOnLocalhost=" + this.isBindOnLocalhost() + ", superUserRoles=" + this.getSuperUserRoles() + ", authorizationAllowWildcardsMatching=" + this.isAuthorizationAllowWildcardsMatching() + ", authenticationEnabled=" + this.isAuthenticationEnabled() + ", authenticationProviders=" + this.getAuthenticationProviders() + ", authorizationEnabled=" + this.isAuthorizationEnabled() + ", authorizationProvider=" + this.getAuthorizationProvider() + ", tlsEnabled=" + this.isTlsEnabled() + ", tlsCertRefreshCheckDurationSec=" + this.getTlsCertRefreshCheckDurationSec() + ", tlsCertificateFilePath=" + this.getTlsCertificateFilePath() + ", tlsKeyFilePath=" + this.getTlsKeyFilePath() + ", tlsTrustCertsFilePath=" + this.getTlsTrustCertsFilePath() + ", tlsAllowInsecureConnection=" + this.isTlsAllowInsecureConnection() + ", tlsProtocols=" + this.getTlsProtocols() + ", tlsCiphers=" + this.getTlsCiphers() + ", tlsRequireTrustedClientCertOnConnect=" + this.isTlsRequireTrustedClientCertOnConnect() + ", tlsEnabledWithKeyStore=" + this.isTlsEnabledWithKeyStore() + ", tlsProvider=" + this.getTlsProvider() + ", tlsKeyStoreType=" + this.getTlsKeyStoreType() + ", tlsKeyStore=" + this.getTlsKeyStore() + ", tlsKeyStorePassword=" + this.getTlsKeyStorePassword() + ", tlsTrustStoreType=" + this.getTlsTrustStoreType() + ", tlsTrustStore=" + this.getTlsTrustStore() + ", tlsTrustStorePassword=" + this.getTlsTrustStorePassword() + ", properties=" + this.getProperties() + ")";
    }
}

