/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service.web;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.pulsar.broker.resources.MetadataStoreCacheLoader;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.common.util.RestException;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final AtomicInteger counter = new AtomicInteger();
    private MetadataStoreExtended localMetadataStore;
    private MetadataStoreExtended configMetadataStore;
    private PulsarResources pulsarResources;
    private MetadataStoreCacheLoader metadataStoreCacheLoader;
    private static final Logger log = LoggerFactory.getLogger(DiscoveryServiceServlet.class);

    public void init(ServletConfig config) throws ServletException {
        log.info("Initializing DiscoveryServiceServlet resource");
        String zookeeperServers = config.getInitParameter("zookeeperServers");
        String zookeeperSessionTimeoutMsStr = config.getInitParameter("zookeeperSessionTimeoutMs");
        int zookeeperSessionTimeoutMs = zookeeperSessionTimeoutMsStr != null ? Integer.valueOf(zookeeperSessionTimeoutMsStr) : 30000;
        log.info("zookeeperServers={}", (Object)zookeeperServers);
        try {
            this.localMetadataStore = this.createLocalMetadataStore(zookeeperServers, zookeeperSessionTimeoutMs);
            this.pulsarResources = new PulsarResources((MetadataStore)this.localMetadataStore, (MetadataStore)this.configMetadataStore);
            this.metadataStoreCacheLoader = new MetadataStoreCacheLoader(this.pulsarResources, zookeeperSessionTimeoutMs);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    public void destroy() {
        try {
            this.localMetadataStore.close();
        }
        catch (Exception e) {
            log.warn("Failed to close the metadata-store {}", (Object)e.getMessage());
        }
        try {
            this.metadataStoreCacheLoader.close();
        }
        catch (IOException e) {
            log.warn("Failed to close the metadataStore-cache {}", (Object)e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    private void redirect(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            LoadManagerReport broker = this.nextBroker();
            URI brokerURI = request.getScheme().equals("http") ? new URI(broker.getWebServiceUrl()) : new URI(broker.getWebServiceUrlTls());
            StringBuilder location = new StringBuilder();
            location.append(brokerURI.getScheme()).append("://").append(brokerURI.getHost()).append(':').append(brokerURI.getPort()).append(request.getRequestURI());
            if (request.getQueryString() != null) {
                location.append('?').append(request.getQueryString());
            }
            if (log.isDebugEnabled()) {
                log.debug("Redirecting to {}", (Object)location);
            }
            response.setStatus(307);
            response.setHeader("Location", location.toString());
        }
        catch (URISyntaxException e) {
            log.warn("No broker found in zookeeper {}", (Object)e.getMessage(), (Object)e);
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "Broker is not available");
        }
    }

    LoadManagerReport nextBroker() {
        List availableBrokers = this.metadataStoreCacheLoader.getAvailableBrokers();
        if (availableBrokers.isEmpty()) {
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "No active broker is available");
        }
        int brokersCount = availableBrokers.size();
        int nextIdx = MathUtils.signSafeMod((long)this.counter.getAndIncrement(), (int)brokersCount);
        return (LoadManagerReport)availableBrokers.get(nextIdx);
    }

    public MetadataStoreExtended createLocalMetadataStore(String zookeeperServers, int operationimeoutMs) throws MetadataStoreException {
        return PulsarResources.createMetadataStore((String)zookeeperServers, (int)operationimeoutMs);
    }
}

