/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.base.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.util.CmdGenerateDocs;
import org.apache.pulsar.discovery.service.DiscoveryService;
import org.apache.pulsar.discovery.service.server.ServerManager;
import org.apache.pulsar.discovery.service.server.ServiceConfig;
import org.apache.pulsar.discovery.service.web.DiscoveryServiceServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class DiscoveryServiceStarter {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryServiceStarter.class);

    public static void checkConfig(ServiceConfig config) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)config.getZookeeperServers()) ? 1 : 0) != 0, (Object)"zookeeperServers must be provided");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)config.getConfigurationStoreServers()) ? 1 : 0) != 0, (Object)"configuration-store Servers must be provided");
    }

    public static void init(String configFile) throws Exception {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");
        Thread.setDefaultUncaughtExceptionHandler((thread, exception) -> System.out.println(String.format("%s [%s] error Uncaught exception in thread %s: %s", dateFormat.format(new Date()), thread.getContextClassLoader(), thread.getName(), exception.getMessage())));
        ServiceConfig config = (ServiceConfig)PulsarConfigurationLoader.create((String)configFile, ServiceConfig.class);
        DiscoveryServiceStarter.checkConfig(config);
        final DiscoveryService discoveryService = new DiscoveryService(config);
        final ServerManager server = new ServerManager(config);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    discoveryService.close();
                    server.stop();
                }
                catch (Exception e) {
                    log.warn("server couldn't stop gracefully {}", (Object)e.getMessage(), (Object)e);
                }
            }
        });
        discoveryService.start();
        DiscoveryServiceStarter.startWebService(server, config);
    }

    protected static void startWebService(ServerManager server, ServiceConfig config) throws Exception {
        TreeMap<String, String> initParameters = new TreeMap<String, String>();
        initParameters.put("zookeeperServers", config.getZookeeperServers());
        server.addServlet("/*", DiscoveryServiceServlet.class, initParameters);
        server.start();
        log.info("Discovery service is started at {}", (Object)server.getServiceUri().toString());
    }

    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject((Object)arguments);
            jcommander.parse(args);
            if (arguments.help) {
                jcommander.usage();
                return;
            }
            if (arguments.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("discovery", (Object)arguments);
                cmd.run(null);
                return;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            return;
        }
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Need to specify a configuration file");
        try {
            DiscoveryServiceStarter.init(args[0]);
        }
        catch (Exception e) {
            log.error("Failed to start discovery service.", (Throwable)e);
            Runtime.getRuntime().halt(1);
        }
    }

    private static class Arguments {
        @Parameter(description="config file")
        private String configFile = "";
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;
        @Parameter(names={"-g", "--generate-docs"}, description="Generate docs")
        private boolean generateDocs = false;

        private Arguments() {
        }
    }
}

