/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import org.apache.pulsar.common.util.NettyServerSslContextBuilder;
import org.apache.pulsar.common.util.SslContextAutoRefreshBuilder;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.common.util.keystoretls.NettySSLContextAutoRefreshBuilder;
import org.apache.pulsar.discovery.service.DiscoveryService;
import org.apache.pulsar.discovery.service.ServerConnection;
import org.apache.pulsar.discovery.service.server.ServiceConfig;

public class ServiceChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    private final DiscoveryService discoveryService;
    private final boolean enableTls;
    private final boolean tlsEnabledWithKeyStore;
    private SslContextAutoRefreshBuilder<SslContext> sslCtxRefresher;
    private NettySSLContextAutoRefreshBuilder nettySSLContextAutoRefreshBuilder;

    public ServiceChannelInitializer(DiscoveryService discoveryService, ServiceConfig serviceConfig, boolean e) throws Exception {
        this.discoveryService = discoveryService;
        this.enableTls = e;
        this.tlsEnabledWithKeyStore = serviceConfig.isTlsEnabledWithKeyStore();
        if (this.enableTls) {
            if (this.tlsEnabledWithKeyStore) {
                this.nettySSLContextAutoRefreshBuilder = new NettySSLContextAutoRefreshBuilder(serviceConfig.getTlsProvider(), serviceConfig.getTlsKeyStoreType(), serviceConfig.getTlsKeyStore(), serviceConfig.getTlsKeyStorePassword(), serviceConfig.isTlsAllowInsecureConnection(), serviceConfig.getTlsTrustStoreType(), serviceConfig.getTlsTrustStore(), serviceConfig.getTlsTrustStorePassword(), serviceConfig.isTlsRequireTrustedClientCertOnConnect(), serviceConfig.getTlsCiphers(), serviceConfig.getTlsProtocols(), serviceConfig.getTlsCertRefreshCheckDurationSec());
            } else {
                SslProvider sslProvider = null;
                if (serviceConfig.getTlsProvider() != null) {
                    sslProvider = SslProvider.valueOf((String)serviceConfig.getTlsProvider());
                }
                this.sslCtxRefresher = new NettyServerSslContextBuilder(sslProvider, serviceConfig.isTlsAllowInsecureConnection(), serviceConfig.getTlsTrustCertsFilePath(), serviceConfig.getTlsCertificateFilePath(), serviceConfig.getTlsKeyFilePath(), serviceConfig.getTlsCiphers(), serviceConfig.getTlsProtocols(), serviceConfig.isTlsRequireTrustedClientCertOnConnect(), serviceConfig.getTlsCertRefreshCheckDurationSec());
            }
        } else {
            this.sslCtxRefresher = null;
        }
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.sslCtxRefresher != null && this.enableTls) {
            if (this.tlsEnabledWithKeyStore) {
                ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)new SslHandler(((KeyStoreSSLContext)this.nettySSLContextAutoRefreshBuilder.get()).createSSLEngine()));
            } else {
                SslContext sslContext = (SslContext)this.sslCtxRefresher.get();
                if (sslContext != null) {
                    ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)sslContext.newHandler(ch.alloc()));
                }
            }
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(5253120, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)new ServerConnection(this.discoveryService));
    }
}

