/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service.web;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.zookeeper.LocalZooKeeperCache;
import org.apache.pulsar.zookeeper.LocalZooKeeperConnectionService;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperChildrenCache;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZooKeeperDataCache;
import org.apache.pulsar.zookeeper.ZooKeeperSessionWatcher;
import org.apache.pulsar.zookeeper.ZookeeperSessionExpiredHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperCacheLoader
implements Closeable {
    private final ZooKeeperCache localZkCache;
    private final LocalZooKeeperConnectionService localZkConnectionSvc;
    private final ZooKeeperDataCache<LoadManagerReport> brokerInfo;
    private final ZooKeeperChildrenCache availableBrokersCache;
    private volatile List<LoadManagerReport> availableBrokers;
    private final OrderedScheduler orderedExecutor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(8).name("pulsar-discovery-ordered-cache").build();
    public static final String LOADBALANCE_BROKERS_ROOT = "/loadbalance/brokers";
    private static final Logger log = LoggerFactory.getLogger(ZookeeperCacheLoader.class);

    public ZookeeperCacheLoader(ZooKeeperClientFactory zkClientFactory, String zookeeperServers, int zookeeperSessionTimeoutMs) throws Exception {
        this.localZkConnectionSvc = new LocalZooKeeperConnectionService(zkClientFactory, zookeeperServers, (long)zookeeperSessionTimeoutMs);
        this.localZkConnectionSvc.start(new ZookeeperSessionExpiredHandler(){

            public void onSessionExpired() {
                log.error("Shutting down ZK sessions: {}", (Object)-1);
            }

            public void setWatcher(ZooKeeperSessionWatcher watcher) {
            }
        });
        int zkOperationTimeoutSeconds = (int)TimeUnit.MILLISECONDS.toSeconds(zookeeperSessionTimeoutMs);
        this.localZkCache = new LocalZooKeeperCache(this.localZkConnectionSvc.getLocalZooKeeper(), zkOperationTimeoutSeconds, (OrderedExecutor)this.orderedExecutor);
        this.localZkConnectionSvc.start(new ZookeeperSessionExpiredHandler(){

            public void onSessionExpired() {
                try {
                    ZookeeperCacheLoader.this.localZkCache.getZooKeeper().close();
                }
                catch (InterruptedException e) {
                    log.warn("Failed to shutdown ZooKeeper gracefully {}", (Object)e.getMessage(), (Object)e);
                }
            }

            public void setWatcher(ZooKeeperSessionWatcher watcher) {
            }
        });
        this.brokerInfo = new ZooKeeperDataCache<LoadManagerReport>(this.localZkCache){

            public LoadManagerReport deserialize(String key, byte[] content) throws Exception {
                return (LoadManagerReport)ObjectMapperFactory.getThreadLocal().readValue(content, LoadManagerReport.class);
            }
        };
        this.availableBrokersCache = new ZooKeeperChildrenCache(this.getLocalZkCache(), LOADBALANCE_BROKERS_ROOT);
        this.availableBrokersCache.registerListener((path, brokerNodes, stat) -> ((CompletableFuture)this.updateBrokerList((Set<String>)brokerNodes).thenRun(() -> log.info("Successfully updated broker info {}", brokerNodes))).exceptionally(ex -> {
            log.warn("Error updating broker info after broker list changed", ex);
            return null;
        }));
        this.updateBrokerList(this.availableBrokersCache.get()).get(zkOperationTimeoutSeconds, TimeUnit.SECONDS);
    }

    public List<LoadManagerReport> getAvailableBrokers() {
        return this.availableBrokers;
    }

    public ZooKeeperCache getLocalZkCache() {
        return this.localZkCache;
    }

    @Override
    public void close() throws IOException {
        this.localZkCache.stop();
        this.localZkConnectionSvc.close();
        this.orderedExecutor.shutdown();
    }

    private CompletableFuture<Void> updateBrokerList(Set<String> brokerNodes) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (brokerNodes.isEmpty()) {
            this.availableBrokers = new ArrayList<LoadManagerReport>();
            future.complete(null);
            return future;
        }
        ArrayList<CompletableFuture> loadReportFutureList = new ArrayList<CompletableFuture>();
        for (String broker : brokerNodes) {
            loadReportFutureList.add(this.brokerInfo.getAsync("/loadbalance/brokers/" + broker));
        }
        ((CompletableFuture)FutureUtil.waitForAll(loadReportFutureList).thenRun(() -> {
            ArrayList<LoadManagerReport> newAvailableBrokers = new ArrayList<LoadManagerReport>(brokerNodes.size());
            for (CompletableFuture loadReportFuture : loadReportFutureList) {
                try {
                    Optional loadReport = (Optional)loadReportFuture.get();
                    if (!loadReport.isPresent()) continue;
                    newAvailableBrokers.add((LoadManagerReport)loadReport.get());
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                    return;
                }
            }
            this.availableBrokers = newAvailableBrokers;
            future.complete(null);
        })).exceptionally(ex -> {
            future.completeExceptionally((Throwable)ex);
            return null;
        });
        return future;
    }
}

