/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameters;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Operations to collect function-worker statistics")
public class CmdFunctionWorker
extends CmdBase {
    private static final Logger log = LoggerFactory.getLogger(CmdFunctionWorker.class);

    public CmdFunctionWorker(Supplier<PulsarAdmin> admin) throws PulsarClientException {
        super("functions-worker", admin);
        this.jcommander.addCommand("function-stats", (Object)new FunctionsStats());
        this.jcommander.addCommand("monitoring-metrics", (Object)new CmdMonitoringMetrics());
        this.jcommander.addCommand("get-cluster", (Object)new GetCluster());
        this.jcommander.addCommand("get-cluster-leader", (Object)new GetClusterLeader());
        this.jcommander.addCommand("get-function-assignments", (Object)new GetFunctionAssignments());
        this.jcommander.addCommand("rebalance", (Object)new Rebalance());
    }

    @Parameters(commandDescription="Dump all functions stats running on this broker")
    class FunctionsStats
    extends BaseCommand {
        FunctionsStats() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.getAdmin().worker().getFunctionsStats());
        }
    }

    @Parameters(commandDescription="Dump metrics for Monitoring")
    class CmdMonitoringMetrics
    extends BaseCommand {
        CmdMonitoringMetrics() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.getAdmin().worker().getMetrics());
        }
    }

    @Parameters(commandDescription="Get all workers belonging to this cluster")
    class GetCluster
    extends BaseCommand {
        GetCluster() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.getAdmin().worker().getCluster());
        }
    }

    @Parameters(commandDescription="Get the leader of the worker cluster")
    class GetClusterLeader
    extends BaseCommand {
        GetClusterLeader() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.getAdmin().worker().getClusterLeader());
        }
    }

    @Parameters(commandDescription="Get the assignments of the functions across the worker cluster")
    class GetFunctionAssignments
    extends BaseCommand {
        GetFunctionAssignments() {
        }

        @Override
        void runCmd() throws Exception {
            this.print(CmdFunctionWorker.this.getAdmin().worker().getAssignments());
        }
    }

    @Parameters(commandDescription="Triggers a rebalance of functions to workers")
    class Rebalance
    extends BaseCommand {
        Rebalance() {
        }

        @Override
        void runCmd() throws Exception {
            CmdFunctionWorker.this.getAdmin().worker().rebalance();
            this.print("Rebalance command sent successfully");
        }
    }

    abstract class BaseCommand
    extends CliCommand {
        BaseCommand() {
        }

        @Override
        void run() throws Exception {
            this.processArguments();
            this.runCmd();
        }

        void processArguments() throws Exception {
        }

        abstract void runCmd() throws Exception;
    }
}

