/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shell;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.pulsar.shell.AdminShell;
import org.apache.pulsar.shell.ClientShell;
import org.apache.pulsar.shell.ConfigShell;
import org.apache.pulsar.shell.JCommanderCompleter;
import org.apache.pulsar.shell.ShellCommandsProvider;
import org.apache.pulsar.shell.config.ConfigStore;
import org.apache.pulsar.shell.config.FileConfigStore;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;

public class PulsarShell {
    private static final String EXIT_MESSAGE = "Goodbye!";
    private static final String PROPERTY_PULSAR_SHELL_DIR = "shellHistoryDirectory";
    private static final String PROPERTY_PERSIST_HISTORY_ENABLED = "shellHistoryPersistEnabled";
    private static final String CHECKMARK = new String(Character.toChars(10004));
    private static final String XMARK = new String(Character.toChars(10006));
    private static final AttributedStyle LOG_STYLE = AttributedStyle.DEFAULT.foreground(25, 143, 255).background(230, 241, 255);
    private static final Substitutor[] SUBSTITUTORS = new Substitutor[]{(str, vars) -> new StringSubstitutor(vars, "${", "}", '\\').replace(str), (str, vars) -> {
        if (str.startsWith("\\$")) {
            return str.substring(1);
        }
        if (str.startsWith("$")) {
            String key = str.substring(1);
            if (!vars.containsKey(key)) {
                return str;
            }
            return (String)vars.get(key);
        }
        return str;
    }};
    private static final String DEFAULT_PULSAR_SHELL_ROOT_DIRECTORY = PulsarShell.computeDefaultPulsarShellRootDirectory();
    private Properties properties;
    private final ConfigStore configStore;
    private final File pulsarShellDir;
    private final JCommander mainCommander;
    private final MainOptions mainOptions;
    private JCommander shellCommander;
    private Function<Map<String, ShellCommandsProvider>, InteractiveLineReader> readerBuilder;
    private InteractiveLineReader reader;
    private final ConfigShell configShell;
    private ExecState execState = ExecState.IDLE;

    public PulsarShell(String[] args) throws IOException {
        this(args, new Properties());
    }

    public PulsarShell(String[] args, Properties props) throws IOException {
        this.properties = props;
        this.mainCommander = new JCommander();
        this.mainOptions = new MainOptions();
        this.mainCommander.addObject((Object)this.mainOptions);
        try {
            this.mainCommander.parse(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println();
            this.mainCommander.usage();
            this.exit(1);
            throw new IllegalArgumentException(e);
        }
        this.pulsarShellDir = PulsarShell.computePulsarShellFile();
        Files.createDirectories(this.pulsarShellDir.toPath(), new FileAttribute[0]);
        System.out.println(String.format("Using directory: %s", this.pulsarShellDir.getAbsolutePath()));
        ConfigStore.ConfigEntry defaultConfig = null;
        String configFile = this.mainOptions.configFile != null ? this.mainOptions.configFile : System.getProperty("pulsar.shell.config.default");
        if (configFile != null) {
            String defaultConfigValue = new String(Files.readAllBytes(new File(configFile).toPath()), StandardCharsets.UTF_8);
            defaultConfig = new ConfigStore.ConfigEntry("default", defaultConfigValue);
        }
        this.configStore = new FileConfigStore(Paths.get(this.pulsarShellDir.getAbsolutePath(), "configs.json").toFile(), defaultConfig);
        ConfigStore.ConfigEntry lastUsed = this.configStore.getLastUsed();
        String configName = "default";
        if (lastUsed != null) {
            this.properties.load(new StringReader(lastUsed.getValue()));
            configName = lastUsed.getName();
        } else if (defaultConfig != null) {
            this.properties.load(new StringReader(defaultConfig.getValue()));
        }
        this.configShell = new ConfigShell(this, configName);
    }

    private static File computePulsarShellFile() {
        String dir = System.getProperty(PROPERTY_PULSAR_SHELL_DIR, null);
        if (dir == null) {
            return Paths.get(DEFAULT_PULSAR_SHELL_ROOT_DIRECTORY, ".pulsar-shell").toFile();
        }
        return new File(dir);
    }

    private static String computeDefaultPulsarShellRootDirectory() {
        String userHome = System.getProperty("user.home");
        if (!StringUtils.isBlank((CharSequence)userHome) && !"?".equals(userHome)) {
            return userHome;
        }
        return System.getProperty("user.dir");
    }

    public static void main(String[] args) throws Exception {
        new PulsarShell(args).run();
    }

    public void reload(Properties properties) throws Exception {
        this.properties = properties;
        Map<String, ShellCommandsProvider> providersMap = this.registerProviders(this.shellCommander, properties);
        this.reader = this.readerBuilder.apply(providersMap);
    }

    public void run() throws Exception {
        Terminal terminal = TerminalBuilder.builder().nativeSignals(true).signalHandler(signal -> {
            if (signal == Terminal.Signal.INT || signal == Terminal.Signal.QUIT) {
                if (this.execState == ExecState.RUNNING) {
                    throw new InterruptShellException();
                }
                this.exit(0);
            }
        }).build();
        this.run(providersMap -> {
            ArrayList<Completer> completers = new ArrayList<Completer>();
            String serviceUrl = "";
            String adminUrl = "";
            JCommanderCompleter.ShellContext shellContext = new JCommanderCompleter.ShellContext(this.configStore);
            for (ShellCommandsProvider provider : providersMap.values()) {
                String providerAdminUrl;
                String providerServiceUrl;
                provider.setupState(this.properties);
                JCommander jCommander = provider.getJCommander();
                if (jCommander != null) {
                    jCommander.createDescriptions();
                    completers.addAll(JCommanderCompleter.createCompletersForCommand(provider.getName(), jCommander, shellContext));
                }
                if ((providerServiceUrl = provider.getServiceUrl()) != null) {
                    serviceUrl = providerServiceUrl;
                }
                if ((providerAdminUrl = provider.getAdminUrl()) == null) continue;
                adminUrl = providerAdminUrl;
            }
            AggregateCompleter completer = new AggregateCompleter(completers);
            LineReaderBuilder readerBuilder = LineReaderBuilder.builder().terminal(terminal).parser((Parser)new DefaultParser().eofOnUnclosedQuote(true)).completer((Completer)completer).variable("indentation", (Object)2).option(LineReader.Option.INSERT_BRACKET, true);
            this.configureHistory(this.properties, readerBuilder);
            final LineReader reader = readerBuilder.build();
            String welcomeMessage = String.format("Welcome to Pulsar shell!\n  %s: %s\n  %s: %s\n\nType %s to get started or try the autocompletion (TAB button).\nType %s or %s to end the shell session.\n", new AttributedStringBuilder().style(AttributedStyle.BOLD).append((CharSequence)"Service URL").toAnsi(), serviceUrl, new AttributedStringBuilder().style(AttributedStyle.BOLD).append((CharSequence)"Admin URL").toAnsi(), adminUrl, new AttributedStringBuilder().style(AttributedStyle.BOLD).append((CharSequence)"help").toAnsi(), new AttributedStringBuilder().style(AttributedStyle.BOLD).append((CharSequence)"exit").toAnsi(), new AttributedStringBuilder().style(AttributedStyle.BOLD).append((CharSequence)"quit").toAnsi());
            PulsarShell.output(welcomeMessage, terminal);
            String promptMessage = this.configShell.getCurrentConfig() != null ? String.format("%s(%s)", this.configShell.getCurrentConfig(), PulsarShell.getHostFromUrl(serviceUrl)) : PulsarShell.getHostFromUrl(serviceUrl);
            final String prompt = PulsarShell.createPrompt(promptMessage);
            return new InteractiveLineReader(){

                @Override
                public String readLine() {
                    return reader.readLine(prompt);
                }

                @Override
                public List<String> parseLine(String line) {
                    return reader.getParser().parse(line, 0).words();
                }
            };
        }, providerMap -> terminal);
    }

    private void configureHistory(Properties properties, LineReaderBuilder readerBuilder) {
        boolean isPersistHistoryEnabled = Boolean.parseBoolean(properties.getProperty(PROPERTY_PERSIST_HISTORY_ENABLED, "true"));
        if (isPersistHistoryEnabled) {
            String historyPath = Paths.get(this.pulsarShellDir.getAbsolutePath(), "history").toFile().getAbsolutePath();
            readerBuilder.variable("history-file", (Object)historyPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run(Function<Map<String, ShellCommandsProvider>, InteractiveLineReader> readerBuilder, Function<Map<String, ShellCommandsProvider>, Terminal> terminalBuilder) throws Exception {
        CommandReader commandReader;
        this.readerBuilder = readerBuilder;
        this.shellCommander = new JCommander();
        ShellOptions shellOptions = new ShellOptions();
        this.shellCommander.addObject((Object)shellOptions);
        Map<String, ShellCommandsProvider> providersMap = this.registerProviders(this.shellCommander, this.properties);
        this.reader = readerBuilder.apply(providersMap);
        final Terminal terminal = terminalBuilder.apply(providersMap);
        final Map<String, String> variables = System.getenv();
        CommandsInfo commandsInfo = null;
        boolean isNonInteractiveMode = this.isNonInteractiveMode();
        if (isNonInteractiveMode) {
            List<Object> lines;
            if (this.mainOptions.filename != null) {
                lines = Files.readAllLines(Paths.get(this.mainOptions.filename, new String[0])).stream().filter(PulsarShell::filterLine).collect(Collectors.toList());
            } else {
                if (this.mainOptions.readFromStdin) {
                    try (BufferedReader stdinReader = new BufferedReader(new InputStreamReader(System.in));){
                        lines = stdinReader.lines().filter(PulsarShell::filterLine).collect(Collectors.toList());
                    }
                }
                lines = new ArrayList();
                try (Scanner scanner = new Scanner(this.mainOptions.inlineCommand);){
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine().trim();
                        lines.add(line);
                    }
                }
            }
            if (!this.mainOptions.noProgress) {
                commandsInfo = new CommandsInfo();
                commandsInfo.totalCommands = lines.size();
            }
            final CommandsInfo finalCommandsInfo = commandsInfo;
            commandReader = new CommandReader(){
                private int index = 0;

                @Override
                public List<String> readCommand() {
                    if (this.index == lines.size()) {
                        throw new InterruptShellException();
                    }
                    String command = ((String)lines.get(this.index++)).trim();
                    List<String> words = PulsarShell.substituteVariables(PulsarShell.this.reader.parseLine(command), (Map<String, String>)variables);
                    command = words.stream().collect(Collectors.joining(" "));
                    if (finalCommandsInfo != null) {
                        finalCommandsInfo.executingCommand = command;
                    } else {
                        PulsarShell.output(String.format("[%d/%d] Executing %s", this.index, lines.size(), command), terminal);
                    }
                    return words;
                }
            };
        } else {
            commandReader = () -> {
                try {
                    String line = this.reader.readLine().trim();
                    return PulsarShell.substituteVariables(this.reader.parseLine(line), variables);
                }
                catch (EndOfFileException | UserInterruptException userInterruptException) {
                    throw new InterruptShellException();
                }
            };
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> PulsarShell.quit(terminal)));
        while (true) {
            List<String> words;
            this.execState = ExecState.IDLE;
            try {
                words = commandReader.readCommand();
            }
            catch (InterruptShellException interruptShellException) {
                this.exit(0);
                return;
            }
            this.execState = ExecState.RUNNING;
            String line = words.stream().collect(Collectors.joining(" "));
            if (StringUtils.isBlank((CharSequence)line)) continue;
            if (PulsarShell.isQuitCommand(line)) {
                this.exit(0);
                return;
            }
            if (shellOptions.help) {
                this.shellCommander.usage();
                continue;
            }
            ShellCommandsProvider pulsarShellCommandsProvider = PulsarShell.getProviderFromArgs(this.shellCommander, words);
            if (pulsarShellCommandsProvider == null) {
                this.shellCommander.usage();
                continue;
            }
            String[] argv = PulsarShell.extractAndConvertArgs(words);
            boolean commandOk = false;
            try {
                this.printExecutingCommands(terminal, commandsInfo, false);
                commandOk = pulsarShellCommandsProvider.runCommand(argv);
            }
            catch (InterruptShellException willExitWithError) {
                boolean bl = willExitWithError = this.mainOptions.failOnError && !commandOk;
                if (commandsInfo != null && !willExitWithError) {
                    commandsInfo.executingCommand = null;
                    commandsInfo.executedCommands.add(new CommandsInfo.ExecutedCommandInfo(line, commandOk));
                    this.printExecutingCommands(terminal, commandsInfo, true);
                }
                pulsarShellCommandsProvider.cleanupState(this.properties);
            }
            catch (Throwable t) {
                t.printStackTrace(terminal.writer());
                boolean bl = willExitWithError = this.mainOptions.failOnError && !commandOk;
                {
                    catch (Throwable throwable) {
                        boolean willExitWithError2;
                        boolean bl2 = willExitWithError2 = this.mainOptions.failOnError && !commandOk;
                        if (commandsInfo != null && !willExitWithError2) {
                            commandsInfo.executingCommand = null;
                            commandsInfo.executedCommands.add(new CommandsInfo.ExecutedCommandInfo(line, commandOk));
                            this.printExecutingCommands(terminal, commandsInfo, true);
                        }
                        pulsarShellCommandsProvider.cleanupState(this.properties);
                        throw throwable;
                    }
                }
                if (commandsInfo != null && !willExitWithError) {
                    commandsInfo.executingCommand = null;
                    commandsInfo.executedCommands.add(new CommandsInfo.ExecutedCommandInfo(line, commandOk));
                    this.printExecutingCommands(terminal, commandsInfo, true);
                }
                pulsarShellCommandsProvider.cleanupState(this.properties);
            }
            boolean bl = willExitWithError = this.mainOptions.failOnError && !commandOk;
            if (commandsInfo != null && !willExitWithError) {
                commandsInfo.executingCommand = null;
                commandsInfo.executedCommands.add(new CommandsInfo.ExecutedCommandInfo(line, commandOk));
                this.printExecutingCommands(terminal, commandsInfo, true);
            }
            pulsarShellCommandsProvider.cleanupState(this.properties);
            if (this.mainOptions.failOnError && !commandOk) break;
        }
        this.exit(1);
    }

    private boolean isNonInteractiveMode() {
        boolean commandOk = true;
        if (this.mainOptions.inlineCommand != null) {
            if (this.mainOptions.readFromStdin || this.mainOptions.filename != null) {
                commandOk = false;
            }
        } else if (this.mainOptions.readFromStdin && this.mainOptions.filename != null) {
            commandOk = false;
        }
        if (!commandOk) {
            throw new IllegalArgumentException("Cannot use stdin, -e/--execute-command and -f/--filename option at the same time");
        }
        return this.mainOptions.filename != null || this.mainOptions.readFromStdin || this.mainOptions.inlineCommand != null;
    }

    private void printExecutingCommands(Terminal terminal, CommandsInfo commandsInfo, boolean printExecuted) {
        if (commandsInfo == null) {
            return;
        }
        terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
        terminal.flush();
        int index = 1;
        if (printExecuted) {
            for (CommandsInfo.ExecutedCommandInfo executedCommand : commandsInfo.executedCommands) {
                String icon = executedCommand.ok ? CHECKMARK : XMARK;
                String ansiLog = new AttributedStringBuilder().style(LOG_STYLE).append((CharSequence)String.format("[%d/%d] %s %s", index++, commandsInfo.totalCommands, icon, executedCommand.command)).toAnsi();
                PulsarShell.output(ansiLog, terminal);
            }
        } else {
            index = commandsInfo.executedCommands.size() + 1;
        }
        if (commandsInfo.executingCommand != null) {
            String ansiLog = new AttributedStringBuilder().style(LOG_STYLE).append((CharSequence)String.format("[%d/%d] Executing %s", index, commandsInfo.totalCommands, commandsInfo.executingCommand)).toAnsi();
            PulsarShell.output(ansiLog, terminal);
        }
    }

    private static ShellCommandsProvider getProviderFromArgs(JCommander mainCommander, List<String> words) {
        String providerCmd = words.get(0);
        JCommander commander = (JCommander)mainCommander.getCommands().get(providerCmd);
        if (commander == null) {
            return null;
        }
        return (ShellCommandsProvider)commander.getObjects().get(0);
    }

    private static String createPrompt(String hostname) {
        String string = (hostname == null ? "pulsar" : hostname) + ">";
        return new AttributedStringBuilder().style(LOG_STYLE).append((CharSequence)string).style(AttributedStyle.DEFAULT).append((CharSequence)" ").toAnsi();
    }

    static List<String> substituteVariables(List<String> line, Map<String, String> vars) {
        return line.stream().map(s -> PulsarShell.substituteVariables(s, vars)).collect(Collectors.toList());
    }

    private static String substituteVariables(String string, Map<String, String> vars) {
        for (Substitutor stringSubstitutor : SUBSTITUTORS) {
            string = stringSubstitutor.replace(string, vars);
        }
        return string;
    }

    private static void quit(Terminal terminal) {
        PulsarShell.output(EXIT_MESSAGE, terminal);
    }

    private static void output(String message, Terminal terminal) {
        terminal.writer().println(message);
        terminal.writer().flush();
    }

    private static boolean isQuitCommand(String line) {
        return line.equalsIgnoreCase("quit") || line.equalsIgnoreCase("exit");
    }

    private static String[] extractAndConvertArgs(List<String> words) {
        ArrayList<String> parsed = new ArrayList<String>();
        for (String s : words.subList(1, words.size())) {
            if (s.startsWith("-") && s.contains("=")) {
                String[] split = s.split("=", 2);
                parsed.add(split[0]);
                parsed.add(split[1]);
                continue;
            }
            parsed.add(s);
        }
        String[] argv = parsed.toArray(new String[parsed.size()]);
        return argv;
    }

    private Map<String, ShellCommandsProvider> registerProviders(JCommander commander, Properties properties) throws Exception {
        HashMap<String, ShellCommandsProvider> providerMap = new HashMap<String, ShellCommandsProvider>();
        PulsarShell.registerProvider(this.createAdminShell(properties), commander, providerMap);
        PulsarShell.registerProvider(this.createClientShell(properties), commander, providerMap);
        PulsarShell.registerProvider(this.configShell, commander, providerMap);
        return providerMap;
    }

    protected AdminShell createAdminShell(Properties properties) throws Exception {
        return new AdminShell(properties);
    }

    protected ClientShell createClientShell(Properties properties) {
        return new ClientShell(properties);
    }

    private static void registerProvider(ShellCommandsProvider provider, JCommander commander, Map<String, ShellCommandsProvider> providerMap) {
        String name = provider.getName();
        commander.addCommand(name, (Object)provider);
        providerMap.put(name, provider);
    }

    protected void exit(int exitCode) {
        System.exit(exitCode);
    }

    private static boolean filterLine(String line) {
        return !StringUtils.isBlank((CharSequence)line) && !line.startsWith("#");
    }

    private static String getHostFromUrl(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URI.create(url).getHost();
        }
        catch (IllegalArgumentException iea) {
            return null;
        }
    }

    public ConfigStore getConfigStore() {
        return this.configStore;
    }

    static enum ExecState {
        IDLE,
        RUNNING;

    }

    static final class MainOptions {
        @Parameter(names={"-c", "--config"}, description="Client configuration file.")
        String configFile;
        @Parameter(names={"-f", "--filename"}, description="Input filename with a list of commands to be executed. Each command must be separated by a newline.")
        String filename;
        @Parameter(names={"--fail-on-error"}, description="If true, the shell will be interrupted if a command throws an exception.")
        boolean failOnError;
        @Parameter(names={"-"}, description="Read commands from the standard input.")
        boolean readFromStdin;
        @Parameter(names={"-e", "--execute-command"}, description="Execute this command and exit.")
        String inlineCommand;
        @Parameter(names={"-np", "--no-progress"}, description="Display raw output of the commands without the fancy progress visualization.")
        boolean noProgress;

        MainOptions() {
        }
    }

    static interface InteractiveLineReader {
        public String readLine();

        public List<String> parseLine(String var1);
    }

    static final class ShellOptions {
        @Parameter(names={"-h", "--help"}, help=true, description="Show this help.")
        boolean help;

        ShellOptions() {
        }
    }

    private static class CommandsInfo {
        int totalCommands;
        List<ExecutedCommandInfo> executedCommands = new ArrayList<ExecutedCommandInfo>();
        String executingCommand;

        private CommandsInfo() {
        }

        static class ExecutedCommandInfo {
            String command;
            boolean ok;

            public ExecutedCommandInfo(String command, boolean ok) {
                this.command = command;
                this.ok = ok;
            }
        }
    }

    private static interface CommandReader {
        public List<String> readCommand() throws InterruptShellException;
    }

    private static class InterruptShellException
    extends RuntimeException {
        private InterruptShellException() {
        }
    }

    static interface Substitutor {
        public String replace(String var1, Map<String, String> var2);
    }
}

