/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.CommaParameterSplitter;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.CmdUsageFormatter;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.OffloadProcessStatus;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Topics;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.InactiveTopicDeleteMode;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.ManagedLedgerInternalStats;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.OffloadedReadPriority;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.util.DateFormatter;
import org.apache.pulsar.common.util.RelativeTimeUtil;

@Parameters(commandDescription="Operations on persistent topics")
public class CmdTopics
extends CmdBase {
    public CmdTopics(Supplier<PulsarAdmin> admin) {
        super("topics", admin);
        this.jcommander.addCommand("list", (Object)new ListCmd());
        this.jcommander.addCommand("list-partitioned-topics", (Object)new PartitionedTopicListCmd());
        this.jcommander.addCommand("permissions", (Object)new Permissions());
        this.jcommander.addCommand("grant-permission", (Object)new GrantPermissions());
        this.jcommander.addCommand("revoke-permission", (Object)new RevokePermissions());
        this.jcommander.addCommand("lookup", (Object)new Lookup());
        this.jcommander.addCommand("partitioned-lookup", (Object)new PartitionedLookup());
        this.jcommander.addCommand("bundle-range", (Object)new GetBundleRange());
        this.jcommander.addCommand("delete", (Object)new DeleteCmd());
        this.jcommander.addCommand("truncate", (Object)new TruncateCmd());
        this.jcommander.addCommand("unload", (Object)new UnloadCmd());
        this.jcommander.addCommand("subscriptions", (Object)new ListSubscriptions());
        this.jcommander.addCommand("unsubscribe", (Object)new DeleteSubscription());
        this.jcommander.addCommand("create-subscription", (Object)new CreateSubscription());
        this.jcommander.addCommand("stats", (Object)new GetStats());
        this.jcommander.addCommand("stats-internal", (Object)new GetInternalStats());
        this.jcommander.addCommand("info-internal", (Object)new GetInternalInfo());
        this.jcommander.addCommand("partitioned-stats", (Object)new GetPartitionedStats());
        this.jcommander.addCommand("partitioned-stats-internal", (Object)new GetPartitionedStatsInternal());
        this.jcommander.addCommand("skip", (Object)new Skip());
        this.jcommander.addCommand("clear-backlog", (Object)new ClearBacklog());
        this.jcommander.addCommand("expire-messages", (Object)new ExpireMessages());
        this.jcommander.addCommand("expire-messages-all-subscriptions", (Object)new ExpireMessagesForAllSubscriptions());
        this.jcommander.addCommand("create-partitioned-topic", (Object)new CreatePartitionedCmd());
        this.jcommander.addCommand("create-missed-partitions", (Object)new CreateMissedPartitionsCmd());
        this.jcommander.addCommand("create", (Object)new CreateNonPartitionedCmd());
        this.jcommander.addCommand("update-partitioned-topic", (Object)new UpdatePartitionedCmd());
        this.jcommander.addCommand("get-partitioned-topic-metadata", (Object)new GetPartitionedTopicMetadataCmd());
        this.jcommander.addCommand("delete-partitioned-topic", (Object)new DeletePartitionedCmd());
        this.jcommander.addCommand("peek-messages", (Object)new PeekMessages());
        this.jcommander.addCommand("examine-messages", (Object)new ExamineMessages());
        this.jcommander.addCommand("get-message-by-id", (Object)new GetMessageById());
        this.jcommander.addCommand("get-message-id", (Object)new GetMessageId());
        this.jcommander.addCommand("reset-cursor", (Object)new ResetCursor());
        this.jcommander.addCommand("terminate", (Object)new Terminate());
        this.jcommander.addCommand("compact", (Object)new Compact());
        this.jcommander.addCommand("compaction-status", (Object)new CompactionStatusCmd());
        this.jcommander.addCommand("offload", (Object)new Offload());
        this.jcommander.addCommand("offload-status", (Object)new OffloadStatusCmd());
        this.jcommander.addCommand("last-message-id", (Object)new GetLastMessageId());
        this.jcommander.addCommand("get-backlog-quotas", (Object)new GetBacklogQuotaMap());
        this.jcommander.addCommand("set-backlog-quota", (Object)new SetBacklogQuota());
        this.jcommander.addCommand("remove-backlog-quota", (Object)new RemoveBacklogQuota());
        this.jcommander.addCommand("get-message-ttl", (Object)new GetMessageTTL());
        this.jcommander.addCommand("set-message-ttl", (Object)new SetMessageTTL());
        this.jcommander.addCommand("remove-message-ttl", (Object)new RemoveMessageTTL());
        this.jcommander.addCommand("get-retention", (Object)new GetRetention());
        this.jcommander.addCommand("set-retention", (Object)new SetRetention());
        this.jcommander.addCommand("remove-retention", (Object)new RemoveRetention());
        this.jcommander.addCommand("enable-deduplication", (Object)new EnableDeduplication());
        this.jcommander.addCommand("disable-deduplication", (Object)new DisableDeduplication());
        this.jcommander.addCommand("get-deduplication-enabled", (Object)new GetDeduplicationStatus());
        this.jcommander.addCommand("set-deduplication", (Object)new SetDeduplicationStatus());
        this.jcommander.addCommand("get-deduplication", (Object)new GetDeduplicationStatus());
        this.jcommander.addCommand("remove-deduplication", (Object)new RemoveDeduplicationStatus());
        this.jcommander.addCommand("get-deduplication-snapshot-interval", (Object)new GetDeduplicationSnapshotInterval());
        this.jcommander.addCommand("set-deduplication-snapshot-interval", (Object)new SetDeduplicationSnapshotInterval());
        this.jcommander.addCommand("remove-deduplication-snapshot-interval", (Object)new RemoveDeduplicationSnapshotInterval());
        this.jcommander.addCommand("get-delayed-delivery", (Object)new GetDelayedDelivery());
        this.jcommander.addCommand("set-delayed-delivery", (Object)new SetDelayedDelivery());
        this.jcommander.addCommand("remove-delayed-delivery", (Object)new RemoveDelayedDelivery());
        this.jcommander.addCommand("get-persistence", (Object)new GetPersistence());
        this.jcommander.addCommand("set-persistence", (Object)new SetPersistence());
        this.jcommander.addCommand("remove-persistence", (Object)new RemovePersistence());
        this.jcommander.addCommand("get-offload-policies", (Object)new GetOffloadPolicies());
        this.jcommander.addCommand("set-offload-policies", (Object)new SetOffloadPolicies());
        this.jcommander.addCommand("remove-offload-policies", (Object)new RemoveOffloadPolicies());
        this.jcommander.addCommand("get-dispatch-rate", (Object)new GetDispatchRate());
        this.jcommander.addCommand("set-dispatch-rate", (Object)new SetDispatchRate());
        this.jcommander.addCommand("remove-dispatch-rate", (Object)new RemoveDispatchRate());
        this.jcommander.addCommand("get-subscription-dispatch-rate", (Object)new GetSubscriptionDispatchRate());
        this.jcommander.addCommand("set-subscription-dispatch-rate", (Object)new SetSubscriptionDispatchRate());
        this.jcommander.addCommand("remove-subscription-dispatch-rate", (Object)new RemoveSubscriptionDispatchRate());
        this.jcommander.addCommand("get-replicator-dispatch-rate", (Object)new GetReplicatorDispatchRate());
        this.jcommander.addCommand("set-replicator-dispatch-rate", (Object)new SetReplicatorDispatchRate());
        this.jcommander.addCommand("remove-replicator-dispatch-rate", (Object)new RemoveReplicatorDispatchRate());
        this.jcommander.addCommand("get-compaction-threshold", (Object)new GetCompactionThreshold());
        this.jcommander.addCommand("set-compaction-threshold", (Object)new SetCompactionThreshold());
        this.jcommander.addCommand("remove-compaction-threshold", (Object)new RemoveCompactionThreshold());
        this.jcommander.addCommand("get-max-unacked-messages-on-consumer", (Object)new GetMaxUnackedMessagesOnConsumer());
        this.jcommander.addCommand("set-max-unacked-messages-on-consumer", (Object)new SetMaxUnackedMessagesOnConsumer());
        this.jcommander.addCommand("remove-max-unacked-messages-on-consumer", (Object)new RemoveMaxUnackedMessagesOnConsumer());
        this.jcommander.addCommand("get-max-unacked-messages-on-subscription", (Object)new GetMaxUnackedMessagesOnSubscription());
        this.jcommander.addCommand("set-max-unacked-messages-on-subscription", (Object)new SetMaxUnackedMessagesOnSubscription());
        this.jcommander.addCommand("remove-max-unacked-messages-on-subscription", (Object)new RemoveMaxUnackedMessagesOnSubscription());
        this.jcommander.addCommand("get-max-unacked-messages-per-consumer", (Object)new GetMaxUnackedMessagesOnConsumer());
        this.jcommander.addCommand("set-max-unacked-messages-per-consumer", (Object)new SetMaxUnackedMessagesOnConsumer());
        this.jcommander.addCommand("remove-max-unacked-messages-per-consumer", (Object)new RemoveMaxUnackedMessagesOnConsumer());
        this.jcommander.addCommand("get-max-unacked-messages-per-subscription", (Object)new GetMaxUnackedMessagesOnSubscription());
        this.jcommander.addCommand("set-max-unacked-messages-per-subscription", (Object)new SetMaxUnackedMessagesOnSubscription());
        this.jcommander.addCommand("remove-max-unacked-messages-per-subscription", (Object)new RemoveMaxUnackedMessagesOnSubscription());
        this.jcommander.addCommand("get-publish-rate", (Object)new GetPublishRate());
        this.jcommander.addCommand("set-publish-rate", (Object)new SetPublishRate());
        this.jcommander.addCommand("remove-publish-rate", (Object)new RemovePublishRate());
        this.jcommander.addCommand("set-subscription-types-enabled", (Object)new SetSubscriptionTypesEnabled());
        this.jcommander.addCommand("get-subscription-types-enabled", (Object)new GetSubscriptionTypesEnabled());
        this.jcommander.addCommand("get-maxProducers", (Object)new GetMaxProducers());
        this.jcommander.addCommand("set-maxProducers", (Object)new SetMaxProducers());
        this.jcommander.addCommand("remove-maxProducers", (Object)new RemoveMaxProducers());
        this.jcommander.addCommand("get-max-producers", (Object)new GetMaxProducers());
        this.jcommander.addCommand("set-max-producers", (Object)new SetMaxProducers());
        this.jcommander.addCommand("remove-max-producers", (Object)new RemoveMaxProducers());
        this.jcommander.addCommand("get-max-subscriptions", (Object)new GetMaxSubscriptionsPerTopic());
        this.jcommander.addCommand("set-max-subscriptions", (Object)new SetMaxSubscriptionsPerTopic());
        this.jcommander.addCommand("remove-max-subscriptions", (Object)new RemoveMaxSubscriptionsPerTopic());
        this.jcommander.addCommand("get-max-message-size", (Object)new GetMaxMessageSize());
        this.jcommander.addCommand("set-max-message-size", (Object)new SetMaxMessageSize());
        this.jcommander.addCommand("remove-max-message-size", (Object)new RemoveMaxMessageSize());
        this.jcommander.addCommand("get-max-consumers-per-subscription", (Object)new GetMaxConsumersPerSubscription());
        this.jcommander.addCommand("set-max-consumers-per-subscription", (Object)new SetMaxConsumersPerSubscription());
        this.jcommander.addCommand("remove-max-consumers-per-subscription", (Object)new RemoveMaxConsumersPerSubscription());
        this.jcommander.addCommand("get-inactive-topic-policies", (Object)new GetInactiveTopicPolicies());
        this.jcommander.addCommand("set-inactive-topic-policies", (Object)new SetInactiveTopicPolicies());
        this.jcommander.addCommand("remove-inactive-topic-policies", (Object)new RemoveInactiveTopicPolicies());
        this.jcommander.addCommand("get-max-consumers", (Object)new GetMaxConsumers());
        this.jcommander.addCommand("set-max-consumers", (Object)new SetMaxConsumers());
        this.jcommander.addCommand("remove-max-consumers", (Object)new RemoveMaxConsumers());
        this.jcommander.addCommand("get-subscribe-rate", (Object)new GetSubscribeRate());
        this.jcommander.addCommand("set-subscribe-rate", (Object)new SetSubscribeRate());
        this.jcommander.addCommand("remove-subscribe-rate", (Object)new RemoveSubscribeRate());
        this.jcommander.addCommand("set-replicated-subscription-status", (Object)new SetReplicatedSubscriptionStatus());
        this.initDeprecatedCommands();
    }

    private void initDeprecatedCommands() {
        IUsageFormatter usageFormatter = this.jcommander.getUsageFormatter();
        if (usageFormatter instanceof CmdUsageFormatter) {
            CmdUsageFormatter cmdUsageFormatter = (CmdUsageFormatter)usageFormatter;
            cmdUsageFormatter.addDeprecatedCommand("enable-deduplication");
            cmdUsageFormatter.addDeprecatedCommand("disable-deduplication");
            cmdUsageFormatter.addDeprecatedCommand("get-deduplication-enabled");
            cmdUsageFormatter.addDeprecatedCommand("get-max-unacked-messages-on-consumer");
            cmdUsageFormatter.addDeprecatedCommand("remove-max-unacked-messages-on-consumer");
            cmdUsageFormatter.addDeprecatedCommand("set-max-unacked-messages-on-consumer");
            cmdUsageFormatter.addDeprecatedCommand("get-max-unacked-messages-on-subscription");
            cmdUsageFormatter.addDeprecatedCommand("remove-max-unacked-messages-on-subscription");
            cmdUsageFormatter.addDeprecatedCommand("set-max-unacked-messages-on-subscription");
            cmdUsageFormatter.addDeprecatedCommand("get-maxProducers");
            cmdUsageFormatter.addDeprecatedCommand("set-maxProducers");
            cmdUsageFormatter.addDeprecatedCommand("remove-maxProducers");
        }
    }

    static MessageId findFirstLedgerWithinThreshold(List<ManagedLedgerInternalStats.LedgerInfo> ledgers, long sizeThreshold) {
        long suffixSize = 0L;
        ledgers = Lists.reverse(ledgers);
        long previousLedger = ((ManagedLedgerInternalStats.LedgerInfo)ledgers.get((int)0)).ledgerId;
        for (ManagedLedgerInternalStats.LedgerInfo l : ledgers) {
            if ((suffixSize += l.size) > sizeThreshold) {
                return new MessageIdImpl(previousLedger, 0L, -1);
            }
            previousLedger = l.ledgerId;
        }
        return null;
    }

    private Topics getTopics() {
        return this.getAdmin().topics();
    }

    @Parameters(commandDescription="Enable or disable a replicated subscription on a topic")
    private class SetReplicatedSubscriptionStatus
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-s", "--subscription"}, description="Subscription name to enable or disable replication", required=true)
        private String subName;
        @Parameter(names={"--enable", "-e"}, description="Enable replication")
        private boolean enable = false;
        @Parameter(names={"--disable", "-d"}, description="Disable replication")
        private boolean disable = false;

        private SetReplicatedSubscriptionStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetReplicatedSubscriptionStatus.validatePersistentTopic(this.params);
            if (this.enable == this.disable) {
                throw new ParameterException("Need to specify either --enable or --disable");
            }
            CmdTopics.this.getTopics().setReplicatedSubscriptionStatus(persistentTopic, this.subName, this.enable);
        }
    }

    @Parameters(commandDescription="Remove consumer subscribe rate for a topic")
    private class RemoveSubscribeRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveSubscribeRate.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeSubscribeRate(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set consumer subscribe rate for a topic")
    private class SetSubscribeRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--subscribe-rate", "-sr"}, description="subscribe-rate (default -1 will be overwrite if not passed)", required=false)
        private int subscribeRate = -1;
        @Parameter(names={"--subscribe-rate-period", "-st"}, description="subscribe-rate-period in second type (default 30 second will be overwrite if not passed)", required=false)
        private int subscribeRatePeriodSec = 30;

        private SetSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetSubscribeRate.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setSubscribeRate(persistentTopic, new SubscribeRate(this.subscribeRate, this.subscribeRatePeriodSec));
        }
    }

    @Parameters(commandDescription="Get consumer subscribe rate for a topic")
    private class GetSubscribeRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetSubscribeRate.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getSubscribeRate(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Remove max number of consumers for a topic")
    private class RemoveMaxConsumers
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveMaxConsumers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxConsumers.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeMaxConsumers(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set max number of consumers for a topic")
    private class SetMaxConsumers
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--max-consumers", "-c"}, description="Max consumers for a topic", required=true)
        private int maxConsumers;

        private SetMaxConsumers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxConsumers.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setMaxConsumers(persistentTopic, this.maxConsumers);
        }
    }

    @Parameters(commandDescription="Get max number of consumers for a topic")
    private class GetMaxConsumers
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetMaxConsumers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxConsumers.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getMaxConsumers(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Remove inactive topic policies from a topic")
    private class RemoveInactiveTopicPolicies
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveInactiveTopicPolicies.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeInactiveTopicPolicies(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set the inactive topic policies on a topic")
    private class SetInactiveTopicPolicies
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--enable-delete-while-inactive", "-e"}, description="Enable delete while inactive")
        private boolean enableDeleteWhileInactive = false;
        @Parameter(names={"--disable-delete-while-inactive", "-d"}, description="Disable delete while inactive")
        private boolean disableDeleteWhileInactive = false;
        @Parameter(names={"--max-inactive-duration", "-t"}, description="Max duration of topic inactivity in seconds,topics that are inactive for longer than this value will be deleted (eg: 1s, 10s, 1m, 5h, 3d)", required=true)
        private String deleteInactiveTopicsMaxInactiveDuration;
        @Parameter(names={"--delete-mode", "-m"}, description="Mode of delete inactive topic,Valid options are: [delete_when_no_subscriptions, delete_when_subscriptions_caught_up]", required=true)
        private String inactiveTopicDeleteMode;

        private SetInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetInactiveTopicPolicies.validatePersistentTopic(this.params);
            long maxInactiveDurationInSeconds = TimeUnit.SECONDS.toSeconds(RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.deleteInactiveTopicsMaxInactiveDuration));
            if (this.enableDeleteWhileInactive == this.disableDeleteWhileInactive) {
                throw new ParameterException("Need to specify either enable-delete-while-inactive or disable-delete-while-inactive");
            }
            InactiveTopicDeleteMode deleteMode = null;
            try {
                deleteMode = InactiveTopicDeleteMode.valueOf((String)this.inactiveTopicDeleteMode);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException("delete mode can only be set to delete_when_no_subscriptions or delete_when_subscriptions_caught_up");
            }
            CmdTopics.this.getTopics().setInactiveTopicPolicies(persistentTopic, new InactiveTopicPolicies(deleteMode, (int)maxInactiveDurationInSeconds, this.enableDeleteWhileInactive));
        }
    }

    @Parameters(commandDescription="Get the inactive topic policies on a topic")
    private class GetInactiveTopicPolicies
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetInactiveTopicPolicies.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getInactiveTopicPolicies(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Remove max consumers per subscription for a topic")
    private class RemoveMaxConsumersPerSubscription
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxConsumersPerSubscription.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeMaxConsumersPerSubscription(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set max consumers per subscription for a topic")
    private class SetMaxConsumersPerSubscription
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--max-consumers-per-subscription", "-c"}, description="maxConsumersPerSubscription for a namespace", required=true)
        private int maxConsumersPerSubscription;

        private SetMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxConsumersPerSubscription.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setMaxConsumersPerSubscription(persistentTopic, this.maxConsumersPerSubscription);
        }
    }

    @Parameters(commandDescription="Get max consumers per subscription for a topic")
    private class GetMaxConsumersPerSubscription
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private GetMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxConsumersPerSubscription.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getMaxConsumersPerSubscription(persistentTopic));
        }
    }

    @Parameters(commandDescription="Remove max message size for a topic")
    private class RemoveMaxMessageSize
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveMaxMessageSize() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxMessageSize.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeMaxMessageSize(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set max message size for a topic")
    private class SetMaxMessageSize
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--max-message-size", "-m"}, description="Max message size for a topic", required=true)
        private int maxMessageSize;

        private SetMaxMessageSize() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxMessageSize.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setMaxMessageSize(persistentTopic, this.maxMessageSize);
        }
    }

    @Parameters(commandDescription="Get max message size for a topic")
    private class GetMaxMessageSize
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private GetMaxMessageSize() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxMessageSize.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getMaxMessageSize(persistentTopic));
        }
    }

    @Parameters(commandDescription="Remove max number of subscriptions for a topic")
    private class RemoveMaxSubscriptionsPerTopic
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxSubscriptionsPerTopic.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeMaxSubscriptionsPerTopic(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set max number of subscriptions for a topic")
    private class SetMaxSubscriptionsPerTopic
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--max-subscriptions-per-topic", "-m"}, description="Maximum subscription limit for a topic", required=true)
        private int maxSubscriptionsPerTopic;

        private SetMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxSubscriptionsPerTopic.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setMaxSubscriptionsPerTopic(persistentTopic, this.maxSubscriptionsPerTopic);
        }
    }

    @Parameters(commandDescription="Get max number of subscriptions for a topic")
    private class GetMaxSubscriptionsPerTopic
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private GetMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxSubscriptionsPerTopic.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getMaxSubscriptionsPerTopic(persistentTopic));
        }
    }

    @Parameters(commandDescription="Remove max number of producers for a topic")
    private class RemoveMaxProducers
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveMaxProducers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxProducers.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeMaxProducers(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set max number of producers for a topic")
    private class SetMaxProducers
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--max-producers", "-p"}, description="Max producers for a topic", required=true)
        private int maxProducers;

        private SetMaxProducers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxProducers.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setMaxProducers(persistentTopic, this.maxProducers);
        }
    }

    @Parameters(commandDescription="Get max number of producers for a topic")
    private class GetMaxProducers
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetMaxProducers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxProducers.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getMaxProducers(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Remove replicator message-dispatch-rate for a topic")
    private class RemoveReplicatorDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveReplicatorDispatchRate.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeReplicatorDispatchRate(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set replicator message-dispatch-rate for a topic")
    private class SetReplicatorDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--msg-dispatch-rate", "-md"}, description="message-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private int msgDispatchRate = -1;
        @Parameter(names={"--byte-dispatch-rate", "-bd"}, description="byte-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private long byteDispatchRate = -1L;
        @Parameter(names={"--dispatch-rate-period", "-dt"}, description="dispatch-rate-period in second type (default 1 second will be overwrite if not passed)", required=false)
        private int dispatchRatePeriodSec = 1;
        @Parameter(names={"--relative-to-publish-rate", "-rp"}, description="dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))", required=false)
        private boolean relativeToPublishRate = false;

        private SetReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetReplicatorDispatchRate.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setReplicatorDispatchRate(persistentTopic, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build());
        }
    }

    @Parameters(commandDescription="Get replicator message-dispatch-rate for a topic")
    private class GetReplicatorDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetReplicatorDispatchRate.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getReplicatorDispatchRate(topic, this.applied));
        }
    }

    @Parameters(commandDescription="Remove subscription message-dispatch-rate for a topic")
    private class RemoveSubscriptionDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveSubscriptionDispatchRate.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeSubscriptionDispatchRate(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set subscription message-dispatch-rate for a topic")
    private class SetSubscriptionDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--msg-dispatch-rate", "-md"}, description="message-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private int msgDispatchRate = -1;
        @Parameter(names={"--byte-dispatch-rate", "-bd"}, description="byte-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private long byteDispatchRate = -1L;
        @Parameter(names={"--dispatch-rate-period", "-dt"}, description="dispatch-rate-period in second type (default 1 second will be overwrite if not passed)", required=false)
        private int dispatchRatePeriodSec = 1;
        @Parameter(names={"--relative-to-publish-rate", "-rp"}, description="dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))", required=false)
        private boolean relativeToPublishRate = false;

        private SetSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetSubscriptionDispatchRate.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setSubscriptionDispatchRate(persistentTopic, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build());
        }
    }

    @Parameters(commandDescription="Get subscription message-dispatch-rate for a topic")
    private class GetSubscriptionDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetSubscriptionDispatchRate.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getSubscriptionDispatchRate(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Remove publish rate for a topic")
    private class RemovePublishRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemovePublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemovePublishRate.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removePublishRate(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set publish rate for a topic")
    private class SetPublishRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--msg-publish-rate", "-m"}, description="message-publish-rate (default -1 will be overwrite if not passed)", required=false)
        private int msgPublishRate = -1;
        @Parameter(names={"--byte-publish-rate", "-b"}, description="byte-publish-rate (default -1 will be overwrite if not passed)", required=false)
        private long bytePublishRate = -1L;

        private SetPublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetPublishRate.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setPublishRate(persistentTopic, new PublishRate(this.msgPublishRate, this.bytePublishRate));
        }
    }

    @Parameters(commandDescription="Get publish rate for a topic")
    private class GetPublishRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private GetPublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetPublishRate.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getPublishRate(persistentTopic));
        }
    }

    @Parameters(commandDescription="Remove compaction threshold for a topic")
    private class RemoveCompactionThreshold
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveCompactionThreshold.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeCompactionThreshold(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set compaction threshold for a topic")
    private class SetCompactionThreshold
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--threshold", "-t"}, description="Maximum number of bytes in a topic backlog before compaction is triggered (eg: 10M, 16G, 3T). 0 disables automatic compaction", required=true)
        private String threshold = "0";

        private SetCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetCompactionThreshold.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setCompactionThreshold(persistentTopic, SetCompactionThreshold.validateSizeString(this.threshold));
        }
    }

    @Parameters(commandDescription="Get compaction threshold for a topic")
    private class GetCompactionThreshold
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetCompactionThreshold.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getCompactionThreshold(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Get subscription types enabled for a topic")
    private class GetSubscriptionTypesEnabled
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private GetSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetSubscriptionTypesEnabled.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getSubscriptionTypesEnabled(persistentTopic));
        }
    }

    @Parameters(commandDescription="Set subscription types enabled for a topic")
    private class SetSubscriptionTypesEnabled
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--types", "-t"}, description="Subscription types enabled list (comma separated values)", required=true)
        private String subTypes;

        private SetSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetSubscriptionTypesEnabled.validatePersistentTopic(this.params);
            HashSet types = new HashSet();
            Lists.newArrayList((Object[])this.subTypes.split(",")).forEach(s -> types.add(SubscriptionType.valueOf((String)s)));
            CmdTopics.this.getTopics().setSubscriptionTypesEnabled(persistentTopic, types);
        }
    }

    @Parameters(commandDescription="Set max unacked messages policy on subscription for a topic")
    private class SetMaxUnackedMessagesOnSubscription
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-m", "--maxNum"}, description="max unacked messages num on subscription", required=true)
        private int maxNum;

        private SetMaxUnackedMessagesOnSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxUnackedMessagesOnSubscription.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setMaxUnackedMessagesOnSubscription(persistentTopic, this.maxNum);
        }
    }

    @Parameters(commandDescription="Remove max unacked messages policy on subscription for a topic")
    private class RemoveMaxUnackedMessagesOnSubscription
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveMaxUnackedMessagesOnSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxUnackedMessagesOnSubscription.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeMaxUnackedMessagesOnSubscription(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get max unacked messages policy on subscription for a topic")
    private class GetMaxUnackedMessagesOnSubscription
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetMaxUnackedMessagesOnSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxUnackedMessagesOnSubscription.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getMaxUnackedMessagesOnSubscription(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Set max unacked messages policy on consumer for a topic")
    private class SetMaxUnackedMessagesOnConsumer
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-m", "--maxNum"}, description="max unacked messages num on consumer", required=true)
        private int maxNum;

        private SetMaxUnackedMessagesOnConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxUnackedMessagesOnConsumer.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setMaxUnackedMessagesOnConsumer(persistentTopic, this.maxNum);
        }
    }

    @Parameters(commandDescription="Remove max unacked messages policy on consumer for a topic")
    private class RemoveMaxUnackedMessagesOnConsumer
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveMaxUnackedMessagesOnConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxUnackedMessagesOnConsumer.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeMaxUnackedMessagesOnConsumer(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get max unacked messages policy on consumer for a topic")
    private class GetMaxUnackedMessagesOnConsumer
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetMaxUnackedMessagesOnConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxUnackedMessagesOnConsumer.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getMaxUnackedMessagesOnConsumer(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Remove message dispatch rate for a topic")
    private class RemoveDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveDispatchRate.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeDispatchRate(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set message dispatch rate for a topic")
    private class SetDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--msg-dispatch-rate", "-md"}, description="message-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private int msgDispatchRate = -1;
        @Parameter(names={"--byte-dispatch-rate", "-bd"}, description="byte-dispatch-rate (default -1 will be overwrite if not passed)", required=false)
        private long byteDispatchRate = -1L;
        @Parameter(names={"--dispatch-rate-period", "-dt"}, description="dispatch-rate-period in second type (default 1 second will be overwrite if not passed)", required=false)
        private int dispatchRatePeriodSec = 1;
        @Parameter(names={"--relative-to-publish-rate", "-rp"}, description="dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))", required=false)
        private boolean relativeToPublishRate = false;

        private SetDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetDispatchRate.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setDispatchRate(persistentTopic, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build());
        }
    }

    @Parameters(commandDescription="Get message dispatch rate for a topic")
    private class GetDispatchRate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetDispatchRate.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getDispatchRate(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Remove the persistence policy for a topic")
    private class RemovePersistence
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemovePersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemovePersistence.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removePersistence(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set the persistence policies for a topic")
    private class SetPersistence
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-e", "--bookkeeper-ensemble"}, description="Number of bookies to use for a topic", required=true)
        private int bookkeeperEnsemble;
        @Parameter(names={"-w", "--bookkeeper-write-quorum"}, description="How many writes to make of each entry", required=true)
        private int bookkeeperWriteQuorum;
        @Parameter(names={"-a", "--bookkeeper-ack-quorum"}, description="Number of acks (garanteed copies) to wait for each entry", required=true)
        private int bookkeeperAckQuorum;
        @Parameter(names={"-r", "--ml-mark-delete-max-rate"}, description="Throttling rate of mark-delete operation (0 means no throttle)", required=true)
        private double managedLedgerMaxMarkDeleteRate;

        private SetPersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetPersistence.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setPersistence(persistentTopic, new PersistencePolicies(this.bookkeeperEnsemble, this.bookkeeperWriteQuorum, this.bookkeeperAckQuorum, this.managedLedgerMaxMarkDeleteRate));
        }
    }

    @Parameters(commandDescription="Set the offload policies for a topic")
    private class SetOffloadPolicies
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-d", "--driver"}, description="ManagedLedger offload driver", required=true)
        private String driver;
        @Parameter(names={"-r", "--region"}, description="ManagedLedger offload region, s3 and google-cloud-storage requires this parameter")
        private String region;
        @Parameter(names={"-b", "--bucket"}, description="ManagedLedger offload bucket, s3 and google-cloud-storage requires this parameter")
        private String bucket;
        @Parameter(names={"-e", "--endpoint"}, description="ManagedLedger offload service endpoint, only s3 requires this parameter")
        private String endpoint;
        @Parameter(names={"-i", "--aws-id"}, description="AWS Credential Id to use when using driver S3 or aws-s3")
        private String awsId;
        @Parameter(names={"-s", "--aws-secret"}, description="AWS Credential Secret to use when using driver S3 or aws-s3")
        private String awsSecret;
        @Parameter(names={"--ro", "--s3-role"}, description="S3 Role used for STSAssumeRoleSessionCredentialsProvider")
        private String s3Role;
        @Parameter(names={"--s3-role-session-name", "-rsn"}, description="S3 role session name used for STSAssumeRoleSessionCredentialsProvider")
        private String s3RoleSessionName;
        @Parameter(names={"-m", "--maxBlockSizeInBytes"}, description="ManagedLedger offload max block Size in bytes,s3 and google-cloud-storage requires this parameter")
        private int maxBlockSizeInBytes;
        @Parameter(names={"-rb", "--readBufferSizeInBytes"}, description="ManagedLedger offload read buffer size in bytes,s3 and google-cloud-storage requires this parameter")
        private int readBufferSizeInBytes;
        @Parameter(names={"-t", "--offloadThresholdInBytes"}, description="ManagedLedger offload threshold in bytes", required=true)
        private long offloadThresholdInBytes;
        @Parameter(names={"-dl", "--offloadDeletionLagInMillis"}, description="ManagedLedger offload deletion lag in bytes")
        private Long offloadDeletionLagInMillis;
        @Parameter(names={"--offloadedReadPriority", "-orp"}, description="Read priority for offloaded messages. By default, once messages are offloaded to long-term storage, brokers read messages from long-term storage, but messages can still exist in BookKeeper for a period depends on your configuration. For messages that exist in both long-term storage and BookKeeper, you can set where to read messages from with the option `tiered-storage-first` or `bookkeeper-first`.", required=false)
        private String offloadReadPriorityStr;

        private SetOffloadPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetOffloadPolicies.validatePersistentTopic(this.params);
            OffloadedReadPriority offloadedReadPriority = OffloadPoliciesImpl.DEFAULT_OFFLOADED_READ_PRIORITY;
            if (this.offloadReadPriorityStr != null) {
                try {
                    offloadedReadPriority = OffloadedReadPriority.fromString((String)this.offloadReadPriorityStr);
                }
                catch (Exception e) {
                    throw new ParameterException("--offloadedReadPriority parameter must be one of " + Arrays.stream(OffloadedReadPriority.values()).map(OffloadedReadPriority::toString).collect(Collectors.joining(",")) + " but got: " + this.offloadReadPriorityStr, (Throwable)e);
                }
            }
            OffloadPoliciesImpl offloadPolicies = OffloadPoliciesImpl.create((String)this.driver, (String)this.region, (String)this.bucket, (String)this.endpoint, (String)this.s3Role, (String)this.s3RoleSessionName, (String)this.awsId, (String)this.awsSecret, (Integer)this.maxBlockSizeInBytes, (Integer)this.readBufferSizeInBytes, (Long)this.offloadThresholdInBytes, (Long)this.offloadDeletionLagInMillis, (OffloadedReadPriority)offloadedReadPriority);
            CmdTopics.this.getTopics().setOffloadPolicies(persistentTopic, (OffloadPolicies)offloadPolicies);
        }
    }

    @Parameters(commandDescription="Remove the offload policies for a topic")
    private class RemoveOffloadPolicies
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveOffloadPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveOffloadPolicies.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeOffloadPolicies(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get the offload policies for a topic")
    private class GetOffloadPolicies
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetOffloadPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetOffloadPolicies.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getOffloadPolicies(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Get the persistence policies for a topic")
    private class GetPersistence
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private GetPersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetPersistence.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getPersistence(persistentTopic));
        }
    }

    @Parameters(commandDescription="Remove the retention policy for a topic")
    private class RemoveRetention
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveRetention.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeRetention(persistentTopic);
        }
    }

    @Parameters(commandDescription="Remove the deduplication policy for a topic")
    private class RemoveDeduplicationStatus
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveDeduplicationStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveDeduplicationStatus.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeDeduplicationStatus(persistentTopic);
        }
    }

    @Parameters(commandDescription="Get the deduplication policy for a topic")
    private class GetDeduplicationStatus
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private GetDeduplicationStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetDeduplicationStatus.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getDeduplicationStatus(persistentTopic));
        }
    }

    @Parameters(commandDescription="Enable or disable deduplication for a topic")
    private class SetDeduplicationStatus
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--enable", "-e"}, description="Enable deduplication")
        private boolean enable = false;
        @Parameter(names={"--disable", "-d"}, description="Disable deduplication")
        private boolean disable = false;

        private SetDeduplicationStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetDeduplicationStatus.validatePersistentTopic(this.params);
            if (this.enable == this.disable) {
                throw new ParameterException("Need to specify either --enable or --disable");
            }
            CmdTopics.this.getTopics().setDeduplicationStatus(persistentTopic, this.enable);
        }
    }

    @Deprecated
    @Parameters(commandDescription="Disable the deduplication policy for a topic")
    private class DisableDeduplication
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private DisableDeduplication() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = DisableDeduplication.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().enableDeduplication(persistentTopic, false);
        }
    }

    @Deprecated
    @Parameters(commandDescription="Enable the deduplication policy for a topic")
    private class EnableDeduplication
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private EnableDeduplication() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = EnableDeduplication.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().enableDeduplication(persistentTopic, true);
        }
    }

    @Parameters(commandDescription="Set the retention policy for a topic")
    private class SetRetention
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--time", "-t"}, description="Retention time in minutes (or minutes, hours,days,weeks eg: 100m, 3h, 2d, 5w). 0 means no retention and -1 means infinite time retention", required=true)
        private String retentionTimeStr;
        @Parameter(names={"--size", "-s"}, description="Retention size limit (eg: 10M, 16G, 3T). 0 or less than 1MB means no retention and -1 means infinite size retention", required=true)
        private String limitStr;

        private SetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetRetention.validatePersistentTopic(this.params);
            long sizeLimit = SetRetention.validateSizeString(this.limitStr);
            long retentionTimeInSec = RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.retentionTimeStr);
            int retentionTimeInMin = retentionTimeInSec != -1L ? (int)TimeUnit.SECONDS.toMinutes(retentionTimeInSec) : -1;
            int retentionSizeInMB = sizeLimit != -1L ? (int)(sizeLimit / 0x100000L) : -1;
            CmdTopics.this.getTopics().setRetention(persistentTopic, new RetentionPolicies(retentionTimeInMin, retentionSizeInMB));
        }
    }

    @Parameters(commandDescription="Get the retention policy for a topic")
    private class GetRetention
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetRetention.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getRetention(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Remove deduplication snapshot interval for a topic")
    private class RemoveDeduplicationSnapshotInterval
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveDeduplicationSnapshotInterval.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeDeduplicationSnapshotInterval(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set deduplication snapshot interval for a topic")
    private class SetDeduplicationSnapshotInterval
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-i", "--interval"}, description="Deduplication snapshot interval for topic in second, allowed range from 0 to Integer.MAX_VALUE", required=true)
        private int interval;

        private SetDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            if (this.interval < 0) {
                throw new ParameterException(String.format("Invalid interval '%d'. ", this.interval));
            }
            String persistentTopic = SetDeduplicationSnapshotInterval.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setDeduplicationSnapshotInterval(persistentTopic, this.interval);
        }
    }

    @Parameters(commandDescription="Get deduplication snapshot interval for a topic")
    private class GetDeduplicationSnapshotInterval
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private GetDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetDeduplicationSnapshotInterval.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getDeduplicationSnapshotInterval(persistentTopic));
        }
    }

    @Parameters(commandDescription="Remove message TTL for a topic")
    private class RemoveMessageTTL
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMessageTTL.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeMessageTTL(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set message TTL for a topic")
    private class SetMessageTTL
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-t", "--ttl"}, description="Message TTL for topic in second, allowed range from 1 to Integer.MAX_VALUE", required=true)
        private int messageTTLInSecond;

        private SetMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            if (this.messageTTLInSecond < 0) {
                throw new ParameterException(String.format("Invalid retention policy type '%d'. ", this.messageTTLInSecond));
            }
            String persistentTopic = SetMessageTTL.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setMessageTTL(persistentTopic, this.messageTTLInSecond);
        }
    }

    @Parameters(commandDescription="Get the message TTL for a topic")
    private class GetMessageTTL
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMessageTTL.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getMessageTTL(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Remove the delayed delivery policy on a topic")
    private class RemoveDelayedDelivery
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private RemoveDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topicName = RemoveDelayedDelivery.validateTopicName(this.params);
            CmdTopics.this.getTopics().removeDelayedDeliveryPolicy(topicName);
        }
    }

    @Parameters(commandDescription="Set the delayed delivery policy on a topic")
    private class SetDelayedDelivery
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"--enable", "-e"}, description="Enable delayed delivery messages")
        private boolean enable = false;
        @Parameter(names={"--disable", "-d"}, description="Disable delayed delivery messages")
        private boolean disable = false;
        @Parameter(names={"--time", "-t"}, description="The tick time for when retrying on delayed delivery messages, affecting the accuracy of the delivery time compared to the scheduled time. (eg: 1s, 10s, 1m, 5h, 3d)")
        private String delayedDeliveryTimeStr = "1s";

        private SetDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topicName = SetDelayedDelivery.validateTopicName(this.params);
            long delayedDeliveryTimeInMills = TimeUnit.SECONDS.toMillis(RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.delayedDeliveryTimeStr));
            if (this.enable == this.disable) {
                throw new ParameterException("Need to specify either --enable or --disable");
            }
            CmdTopics.this.getTopics().setDelayedDeliveryPolicy(topicName, DelayedDeliveryPolicies.builder().tickTime(delayedDeliveryTimeInMills).active(this.enable).build());
        }
    }

    @Parameters(commandDescription="Get the delayed delivery policy for a topic")
    private class GetDelayedDelivery
    extends CliCommand {
        @Parameter(description="tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topicName = GetDelayedDelivery.validateTopicName(this.params);
            this.print(CmdTopics.this.getTopics().getDelayedDeliveryPolicy(topicName, this.applied));
        }
    }

    @Parameters(commandDescription="Remove a backlog quota policy from a topic")
    private class RemoveBacklogQuota
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private RemoveBacklogQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveBacklogQuota.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().removeBacklogQuota(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set a backlog quota policy for a topic")
    private class SetBacklogQuota
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-l", "--limit"}, description="Size limit (eg: 10M, 16G)", required=true)
        private String limitStr;
        @Parameter(names={"-lt", "--limitTime"}, description="Time limit in second, non-positive number for disabling time limit.")
        private int limitTime = -1;
        @Parameter(names={"-p", "--policy"}, description="Retention policy to enforce when the limit is reached. Valid options are: [producer_request_hold, producer_exception, consumer_backlog_eviction]", required=true)
        private String policyStr;

        private SetBacklogQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            BacklogQuota.RetentionPolicy policy;
            try {
                policy = BacklogQuota.RetentionPolicy.valueOf((String)this.policyStr);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException(String.format("Invalid retention policy type '%s'. Valid options are: %s", this.policyStr, Arrays.toString(BacklogQuota.RetentionPolicy.values())));
            }
            long limit = SetBacklogQuota.validateSizeString(this.limitStr);
            String persistentTopic = SetBacklogQuota.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().setBacklogQuota(persistentTopic, BacklogQuota.builder().limitSize(limit).limitTime(this.limitTime).retentionPolicy(policy).build());
        }
    }

    @Parameters(commandDescription="Get the backlog quota policies for a topic")
    private class GetBacklogQuotaMap
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;

        private GetBacklogQuotaMap() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetBacklogQuotaMap.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getBacklogQuotaMap(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="get the last commit message id of topic")
    private class GetLastMessageId
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private GetLastMessageId() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetLastMessageId.validatePersistentTopic(this.params);
            this.print(CmdTopics.this.getTopics().getLastMessageId(persistentTopic));
        }
    }

    @Parameters(commandDescription="Check the status of data offloading from a topic to long-term storage")
    private class OffloadStatusCmd
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-w", "--wait-complete"}, description="Wait for offloading to complete", required=false)
        private boolean wait = false;

        private OffloadStatusCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = OffloadStatusCmd.validatePersistentTopic(this.params);
            try {
                OffloadProcessStatus status = CmdTopics.this.getTopics().offloadStatus(persistentTopic);
                while (this.wait && status.getStatus() == LongRunningProcessStatus.Status.RUNNING) {
                    Thread.sleep(1000L);
                    status = CmdTopics.this.getTopics().offloadStatus(persistentTopic);
                }
                switch (status.getStatus()) {
                    case NOT_RUN: {
                        System.out.println("Offload has not been run for " + persistentTopic + " since broker startup");
                        break;
                    }
                    case RUNNING: {
                        System.out.println("Offload is currently running");
                        break;
                    }
                    case SUCCESS: {
                        System.out.println("Offload was a success");
                        break;
                    }
                    case ERROR: {
                        System.out.println("Error in offload");
                        throw new PulsarAdminException("Error offloading: " + status.getLastError());
                    }
                }
            }
            catch (InterruptedException e) {
                throw new PulsarAdminException((Throwable)e);
            }
        }
    }

    @Parameters(commandDescription="Trigger offload of data from a topic to long-term storage (e.g. Amazon S3)")
    private class Offload
    extends CliCommand {
        @Parameter(names={"-s", "--size-threshold"}, description="Maximum amount of data to keep in BookKeeper for the specified topic (e.g. 10M, 5G).", required=true)
        private String sizeThresholdStr;
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private Offload() {
        }

        @Override
        void run() throws PulsarAdminException {
            long sizeThreshold = Offload.validateSizeString(this.sizeThresholdStr);
            String persistentTopic = Offload.validatePersistentTopic(this.params);
            PersistentTopicInternalStats stats = CmdTopics.this.getTopics().getInternalStats(persistentTopic, false);
            if (stats.ledgers.size() < 1) {
                throw new PulsarAdminException("Topic doesn't have any data");
            }
            LinkedList<ManagedLedgerInternalStats.LedgerInfo> ledgers = new LinkedList<ManagedLedgerInternalStats.LedgerInfo>(stats.ledgers);
            ((ManagedLedgerInternalStats.LedgerInfo)ledgers.get((int)(ledgers.size() - 1))).size = stats.currentLedgerSize;
            MessageId messageId = CmdTopics.findFirstLedgerWithinThreshold(ledgers, sizeThreshold);
            if (messageId == null) {
                System.out.println("Nothing to offload");
                return;
            }
            CmdTopics.this.getTopics().triggerOffload(persistentTopic, messageId);
            System.out.println("Offload triggered for " + persistentTopic + " for messages before " + messageId);
        }
    }

    @Parameters(commandDescription="Status of compaction on a topic")
    private class CompactionStatusCmd
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-w", "--wait-complete"}, description="Wait for compaction to complete", required=false)
        private boolean wait = false;

        private CompactionStatusCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = CompactionStatusCmd.validatePersistentTopic(this.params);
            try {
                LongRunningProcessStatus status = CmdTopics.this.getTopics().compactionStatus(persistentTopic);
                while (this.wait && status.status == LongRunningProcessStatus.Status.RUNNING) {
                    Thread.sleep(1000L);
                    status = CmdTopics.this.getTopics().compactionStatus(persistentTopic);
                }
                switch (status.status) {
                    case NOT_RUN: {
                        System.out.println("Compaction has not been run for " + persistentTopic + " since broker startup");
                        break;
                    }
                    case RUNNING: {
                        System.out.println("Compaction is currently running");
                        break;
                    }
                    case SUCCESS: {
                        System.out.println("Compaction was a success");
                        break;
                    }
                    case ERROR: {
                        System.out.println("Error in compaction");
                        throw new PulsarAdminException("Error compacting: " + status.lastError);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new PulsarAdminException((Throwable)e);
            }
        }
    }

    @Parameters(commandDescription="Compact a topic")
    private class Compact
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private Compact() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = Compact.validatePersistentTopic(this.params);
            CmdTopics.this.getTopics().triggerCompaction(persistentTopic);
            System.out.println("Topic compaction requested for " + persistentTopic);
        }
    }

    @Parameters(commandDescription="Get message ID")
    private class GetMessageId
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-d", "--datetime"}, description="datetime at or before this messageId. This datetime is in format of ISO_OFFSET_DATE_TIME, e.g. 2021-06-28T16:53:08Z or 2021-06-28T16:53:08.123456789+08:00", required=true)
        private String datetime;

        private GetMessageId() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMessageId.validatePersistentTopic(this.params);
            long timestamp = DateFormatter.parse((String)this.datetime);
            MessageId messageId = CmdTopics.this.getTopics().getMessageIdByTimestamp(persistentTopic, timestamp);
            if (messageId == null) {
                System.out.println("Cannot find any messages based on timestamp " + timestamp);
            } else {
                this.print(messageId);
            }
        }
    }

    @Parameters(commandDescription="Get message by its ledgerId and entryId")
    private class GetMessageById
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-l", "--ledgerId"}, description="ledger id pointing to the desired ledger", required=true)
        private long ledgerId;
        @Parameter(names={"-e", "--entryId"}, description="entry id pointing to the desired entry", required=true)
        private long entryId;

        private GetMessageById() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMessageById.validatePersistentTopic(this.params);
            MessageImpl message = (MessageImpl)CmdTopics.this.getTopics().getMessageById(persistentTopic, this.ledgerId, this.entryId);
            if (message == null) {
                System.out.println("Cannot find any messages based on ledgerId:" + this.ledgerId + " entryId:" + this.entryId);
            } else {
                BatchMessageIdImpl msgId;
                if (message.getMessageId() instanceof BatchMessageIdImpl) {
                    msgId = (BatchMessageIdImpl)message.getMessageId();
                    System.out.println("Batch Message ID: " + msgId.getLedgerId() + ":" + msgId.getEntryId() + ":" + msgId.getBatchIndex());
                } else {
                    msgId = (MessageIdImpl)message.getMessageId();
                    System.out.println("Message ID: " + msgId.getLedgerId() + ":" + msgId.getEntryId());
                }
                System.out.println("Publish time: " + message.getPublishTime());
                System.out.println("Event time: " + message.getEventTime());
                if (message.getDeliverAtTime() != 0L) {
                    System.out.println("Deliver at time: " + message.getDeliverAtTime());
                }
                if (message.getBrokerEntryMetadata() != null) {
                    if (message.getBrokerEntryMetadata().hasBrokerTimestamp()) {
                        System.out.println("Broker entry metadata timestamp: " + message.getBrokerEntryMetadata().getBrokerTimestamp());
                    }
                    if (message.getBrokerEntryMetadata().hasIndex()) {
                        System.out.println("Broker entry metadata index: " + message.getBrokerEntryMetadata().getIndex());
                    }
                }
                if (message.getProperties().size() > 0) {
                    System.out.println("Properties:");
                    this.print(message.getProperties());
                }
                ByteBuf date = Unpooled.wrappedBuffer((byte[])message.getData());
                System.out.println(ByteBufUtil.prettyHexDump((ByteBuf)date));
            }
        }
    }

    @Parameters(commandDescription="Examine a specific message on a topic by position relative to the earliest or the latest message.")
    private class ExamineMessages
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-i", "--initialPosition"}, description="Relative start position to examine message.It can be 'latest' or 'earliest', default is latest")
        private String initialPosition = "latest";
        @Parameter(names={"-m", "--messagePosition"}, description="The position of messages (default 1)", required=false)
        private long messagePosition = 1L;

        private ExamineMessages() {
        }

        @Override
        void run() throws PulsarAdminException {
            BatchMessageIdImpl msgId;
            String persistentTopic = ExamineMessages.validatePersistentTopic(this.params);
            MessageImpl message = (MessageImpl)CmdTopics.this.getTopics().examineMessage(persistentTopic, this.initialPosition, this.messagePosition);
            if (message.getMessageId() instanceof BatchMessageIdImpl) {
                msgId = (BatchMessageIdImpl)message.getMessageId();
                System.out.println("Batch Message ID: " + msgId.getLedgerId() + ":" + msgId.getEntryId() + ":" + msgId.getBatchIndex());
            } else {
                msgId = (MessageIdImpl)message.getMessageId();
                System.out.println("Message ID: " + msgId.getLedgerId() + ":" + msgId.getEntryId());
            }
            System.out.println("Publish time: " + message.getPublishTime());
            System.out.println("Event time: " + message.getEventTime());
            if (message.getDeliverAtTime() != 0L) {
                System.out.println("Deliver at time: " + message.getDeliverAtTime());
            }
            if (message.getBrokerEntryMetadata() != null) {
                if (message.getBrokerEntryMetadata().hasBrokerTimestamp()) {
                    System.out.println("Broker entry metadata timestamp: " + message.getBrokerEntryMetadata().getBrokerTimestamp());
                }
                if (message.getBrokerEntryMetadata().hasIndex()) {
                    System.out.println("Broker entry metadata index: " + message.getBrokerEntryMetadata().getIndex());
                }
            }
            if (message.getProperties().size() > 0) {
                System.out.println("Properties:");
                this.print(message.getProperties());
            }
            ByteBuf data = Unpooled.wrappedBuffer((byte[])message.getData());
            System.out.println(ByteBufUtil.prettyHexDump((ByteBuf)data));
        }
    }

    @Parameters(commandDescription="Peek some messages for the subscription")
    private class PeekMessages
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-s", "--subscription"}, description="Subscription to get messages from", required=true)
        private String subName;
        @Parameter(names={"-n", "--count"}, description="Number of messages (default 1)", required=false)
        private int numMessages = 1;

        private PeekMessages() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = PeekMessages.validatePersistentTopic(this.params);
            List messages = CmdTopics.this.getTopics().peekMessages(persistentTopic, this.subName, this.numMessages);
            int position = 0;
            for (Message msg : messages) {
                BatchMessageIdImpl msgId;
                MessageImpl message = (MessageImpl)msg;
                if (++position != 1) {
                    System.out.println("-------------------------------------------------------------------------\n");
                }
                if (message.getMessageId() instanceof BatchMessageIdImpl) {
                    msgId = (BatchMessageIdImpl)message.getMessageId();
                    System.out.println("Batch Message ID: " + msgId.getLedgerId() + ":" + msgId.getEntryId() + ":" + msgId.getBatchIndex());
                } else {
                    msgId = (MessageIdImpl)msg.getMessageId();
                    System.out.println("Message ID: " + msgId.getLedgerId() + ":" + msgId.getEntryId());
                }
                System.out.println("Publish time: " + message.getPublishTime());
                System.out.println("Event time: " + message.getEventTime());
                if (message.getDeliverAtTime() != 0L) {
                    System.out.println("Deliver at time: " + message.getDeliverAtTime());
                }
                if (message.getBrokerEntryMetadata() != null) {
                    if (message.getBrokerEntryMetadata().hasBrokerTimestamp()) {
                        System.out.println("Broker entry metadata timestamp: " + message.getBrokerEntryMetadata().getBrokerTimestamp());
                    }
                    if (message.getBrokerEntryMetadata().hasIndex()) {
                        System.out.println("Broker entry metadata index: " + message.getBrokerEntryMetadata().getIndex());
                    }
                }
                if (message.getProperties().size() > 0) {
                    System.out.println("Properties:");
                    this.print(msg.getProperties());
                }
                ByteBuf data = Unpooled.wrappedBuffer((byte[])msg.getData());
                System.out.println(ByteBufUtil.prettyHexDump((ByteBuf)data));
            }
        }
    }

    @Parameters(commandDescription="Terminate a topic and don't allow any more messages to be published")
    private class Terminate
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private Terminate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = Terminate.validatePersistentTopic(this.params);
            try {
                MessageId lastMessageId = (MessageId)CmdTopics.this.getTopics().terminateTopicAsync(persistentTopic).get();
                System.out.println("Topic succesfully terminated at " + lastMessageId);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PulsarAdminException((Throwable)e);
            }
        }
    }

    @Parameters(commandDescription="Reset position for subscription to a position that is closest to timestamp or messageId.")
    private class ResetCursor
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-s", "--subscription"}, description="Subscription to reset position on", required=true)
        private String subName;
        @Parameter(names={"--time", "-t"}, description="time in minutes to reset back to (or minutes, hours,days,weeks eg: 100m, 3h, 2d, 5w)", required=false)
        private String resetTimeStr;
        @Parameter(names={"--messageId", "-m"}, description="messageId to reset back to (ledgerId:entryId)", required=false)
        private String resetMessageIdStr;
        @Parameter(names={"-e", "--exclude-reset-position"}, description="Exclude the reset position, start consume messages from the next position.", required=false)
        private boolean excludeResetPosition = false;

        private ResetCursor() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = ResetCursor.validatePersistentTopic(this.params);
            if (StringUtils.isNotBlank((CharSequence)this.resetMessageIdStr)) {
                MessageId messageId = ResetCursor.validateMessageIdString(this.resetMessageIdStr);
                if (this.excludeResetPosition) {
                    CmdTopics.this.getTopics().resetCursor(persistentTopic, this.subName, messageId, true);
                } else {
                    CmdTopics.this.getTopics().resetCursor(persistentTopic, this.subName, messageId);
                }
            } else if (StringUtils.isNotBlank((CharSequence)this.resetTimeStr)) {
                long resetTimeInMillis = TimeUnit.SECONDS.toMillis(RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.resetTimeStr));
                long timestamp = System.currentTimeMillis() - resetTimeInMillis;
                CmdTopics.this.getTopics().resetCursor(persistentTopic, this.subName, timestamp);
            } else {
                throw new PulsarAdminException("Either Timestamp (--time) or Position (--position) has to be provided to reset cursor");
            }
        }
    }

    @Parameters(commandDescription="Create a new subscription on a topic")
    private class CreateSubscription
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-s", "--subscription"}, description="Subscription to reset position on", required=true)
        private String subscriptionName;
        @Parameter(names={"--messageId", "-m"}, description="messageId where to create the subscription. It can be either 'latest', 'earliest' or (ledgerId:entryId)", required=false)
        private String messageIdStr = "latest";

        private CreateSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = CreateSubscription.validateTopicName(this.params);
            MessageId messageId = this.messageIdStr.equals("latest") ? MessageId.latest : (this.messageIdStr.equals("earliest") ? MessageId.earliest : CreateSubscription.validateMessageIdString(this.messageIdStr));
            CmdTopics.this.getTopics().createSubscription(topic, this.subscriptionName, messageId);
        }
    }

    @Parameters(commandDescription="Expire messages that older than given expiry time (in seconds) for all subscriptions")
    private class ExpireMessagesForAllSubscriptions
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-t", "--expireTime"}, description="Expire messages older than time in seconds", required=true)
        private long expireTimeInSeconds;

        private ExpireMessagesForAllSubscriptions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = ExpireMessagesForAllSubscriptions.validateTopicName(this.params);
            CmdTopics.this.getTopics().expireMessagesForAllSubscriptions(topic, this.expireTimeInSeconds);
        }
    }

    @Parameters(commandDescription="Expire messages that older than given expiry time (in seconds) for the subscription")
    private class ExpireMessages
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-s", "--subscription"}, description="Subscription to be skip messages on", required=true)
        private String subName;
        @Parameter(names={"-t", "--expireTime"}, description="Expire messages older than time in seconds")
        private long expireTimeInSeconds = -1L;
        @Parameter(names={"--position", "-p"}, description="message position to reset back to (ledgerId:entryId)", required=false)
        private String messagePosition;
        @Parameter(names={"-e", "--exclude-reset-position"}, description="Exclude the reset position, start consume messages from the next position.", required=false)
        private boolean excludeResetPosition = false;

        private ExpireMessages() {
        }

        @Override
        void run() throws PulsarAdminException {
            if (this.expireTimeInSeconds >= 0L && StringUtils.isNotBlank((CharSequence)this.messagePosition)) {
                throw new ParameterException(String.format("Can't expire message by time and by message position at the same time.", new Object[0]));
            }
            String topic = ExpireMessages.validateTopicName(this.params);
            if (this.expireTimeInSeconds >= 0L) {
                CmdTopics.this.getTopics().expireMessages(topic, this.subName, this.expireTimeInSeconds);
            } else if (StringUtils.isNotBlank((CharSequence)this.messagePosition)) {
                int partitionIndex = TopicName.get((String)topic).getPartitionIndex();
                MessageId messageId = ExpireMessages.validateMessageIdString(this.messagePosition, partitionIndex);
                CmdTopics.this.getTopics().expireMessages(topic, this.subName, messageId, this.excludeResetPosition);
            } else {
                throw new ParameterException("Either time (--expireTime) or message position (--position) has to be provided to expire messages");
            }
        }
    }

    @Parameters(commandDescription="Skip some messages for the subscription")
    private class Skip
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-s", "--subscription"}, description="Subscription to be skip messages on", required=true)
        private String subName;
        @Parameter(names={"-n", "--count"}, description="Number of messages to skip", required=true)
        private long numMessages;

        private Skip() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = Skip.validateTopicName(this.params);
            CmdTopics.this.getTopics().skipMessages(topic, this.subName, this.numMessages);
        }
    }

    @Parameters(commandDescription="Skip all the messages for the subscription")
    private class ClearBacklog
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-s", "--subscription"}, description="Subscription to be cleared", required=true)
        private String subName;

        private ClearBacklog() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = ClearBacklog.validateTopicName(this.params);
            CmdTopics.this.getTopics().skipAllMessages(topic, this.subName);
        }
    }

    @Parameters(commandDescription="Get the internal stats for the partitioned topic and its connected producers and consumers. All the rates are computed over a 1 minute window and are relative the last completed 1 minute period.")
    private class GetPartitionedStatsInternal
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private GetPartitionedStatsInternal() {
        }

        @Override
        void run() throws Exception {
            String topic = GetPartitionedStatsInternal.validateTopicName(this.params);
            this.print(CmdTopics.this.getTopics().getPartitionedInternalStats(topic));
        }
    }

    @Parameters(commandDescription="Get the stats for the partitioned topic and its connected producers and consumers. All the rates are computed over a 1 minute window and are relative the last completed 1 minute period.")
    private class GetPartitionedStats
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--per-partition"}, description="Get per partition stats")
        private boolean perPartition = false;
        @Parameter(names={"-gpb", "--get-precise-backlog"}, description="Set true to get precise backlog")
        private boolean getPreciseBacklog = false;
        @Parameter(names={"-sbs", "--get-subscription-backlog-size"}, description="Set true to get backlog size for each subscription, locking required.")
        private boolean subscriptionBacklogSize = false;

        private GetPartitionedStats() {
        }

        @Override
        void run() throws Exception {
            String topic = GetPartitionedStats.validateTopicName(this.params);
            this.print(CmdTopics.this.getTopics().getPartitionedStats(topic, this.perPartition, this.getPreciseBacklog, this.subscriptionBacklogSize));
        }
    }

    @Parameters(commandDescription="Get the internal metadata info for the topic")
    private class GetInternalInfo
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private GetInternalInfo() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetInternalInfo.validateTopicName(this.params);
            String result = CmdTopics.this.getTopics().getInternalInfo(topic);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            System.out.println(gson.toJson((Object)result));
        }
    }

    @Parameters(commandDescription="Get the internal stats for the topic")
    private class GetInternalStats
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-m", "--metadata"}, description="Flag to include ledger metadata")
        private boolean metadata = false;

        private GetInternalStats() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetInternalStats.validateTopicName(this.params);
            this.print(CmdTopics.this.getTopics().getInternalStats(topic, this.metadata));
        }
    }

    @Parameters(commandDescription="Get the stats for the topic and its connected producers and consumers. All the rates are computed over a 1 minute window and are relative the last completed 1 minute period.")
    private class GetStats
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-gpb", "--get-precise-backlog"}, description="Set true to get precise backlog")
        private boolean getPreciseBacklog = false;
        @Parameter(names={"-sbs", "--get-subscription-backlog-size"}, description="Set true to get backlog size for each subscription, locking required.")
        private boolean subscriptionBacklogSize = false;

        private GetStats() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetStats.validateTopicName(this.params);
            this.print(CmdTopics.this.getTopics().getStats(topic, this.getPreciseBacklog, this.subscriptionBacklogSize));
        }
    }

    @Parameters(commandDescription="Delete a durable subscriber from a topic. The subscription cannot be deleted if there are any active consumers attached to it")
    private class DeleteSubscription
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-f", "--force"}, description="Disconnect and close all consumers and delete subscription forcefully")
        private boolean force = false;
        @Parameter(names={"-s", "--subscription"}, description="Subscription to be deleted", required=true)
        private String subName;

        private DeleteSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = DeleteSubscription.validateTopicName(this.params);
            CmdTopics.this.getTopics().deleteSubscription(topic, this.subName, this.force);
        }
    }

    @Parameters(commandDescription="Get the list of subscriptions on the topic")
    private class ListSubscriptions
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private ListSubscriptions() {
        }

        @Override
        void run() throws Exception {
            String topic = ListSubscriptions.validateTopicName(this.params);
            this.print(CmdTopics.this.getTopics().getSubscriptions(topic));
        }
    }

    @Parameters(commandDescription="Unload a topic.")
    private class UnloadCmd
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private UnloadCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = UnloadCmd.validateTopicName(this.params);
            CmdTopics.this.getTopics().unload(topic);
        }
    }

    @Parameters(commandDescription="Truncate a topic. \n\t\tThe truncate operation will move all cursors to the end of the topic and delete all inactive ledgers. ")
    private class TruncateCmd
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic\n", required=true)
        private List<String> params;

        private TruncateCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = TruncateCmd.validateTopicName(this.params);
            CmdTopics.this.getTopics().truncate(topic);
        }
    }

    @Parameters(commandDescription="Delete a topic. The topic cannot be deleted if there's any active subscription or producers connected to it.")
    private class DeleteCmd
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-f", "--force"}, description="Close all producer/consumer/replicator and delete topic forcefully")
        private boolean force = false;
        @Parameter(names={"-d", "--deleteSchema"}, description="Delete schema while deleting topic")
        private boolean deleteSchema = false;

        private DeleteCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = DeleteCmd.validateTopicName(this.params);
            CmdTopics.this.getTopics().delete(topic, this.force, this.deleteSchema);
        }
    }

    @Parameters(commandDescription="Delete a partitioned topic. It will also delete all the partitions of the topic if it exists.")
    private class DeletePartitionedCmd
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-f", "--force"}, description="Close all producer/consumer/replicator and delete topic forcefully")
        private boolean force = false;
        @Parameter(names={"-d", "--deleteSchema"}, description="Delete schema while deleting topic")
        private boolean deleteSchema = false;

        private DeletePartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String topic = DeletePartitionedCmd.validateTopicName(this.params);
            CmdTopics.this.getTopics().deletePartitionedTopic(topic, this.force, this.deleteSchema);
        }
    }

    @Parameters(commandDescription="Get the partitioned topic metadata. If the topic is not created or is a non-partitioned topic, it returns empty topic with 0 partitions")
    private class GetPartitionedTopicMetadataCmd
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private GetPartitionedTopicMetadataCmd() {
        }

        @Override
        void run() throws Exception {
            String topic = GetPartitionedTopicMetadataCmd.validateTopicName(this.params);
            this.print(CmdTopics.this.getTopics().getPartitionedTopicMetadata(topic));
        }
    }

    @Parameters(commandDescription="Update existing non-global partitioned topic. New updating number of partitions must be greater than existing number of partitions.")
    private class UpdatePartitionedCmd
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-p", "--partitions"}, description="Number of partitions for the topic", required=true)
        private int numPartitions;

        private UpdatePartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String topic = UpdatePartitionedCmd.validateTopicName(this.params);
            CmdTopics.this.getTopics().updatePartitionedTopic(topic, this.numPartitions);
        }
    }

    @Parameters(commandDescription="Create a non-partitioned topic.")
    private class CreateNonPartitionedCmd
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private CreateNonPartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String topic = CreateNonPartitionedCmd.validateTopicName(this.params);
            CmdTopics.this.getTopics().createNonPartitionedTopic(topic);
        }
    }

    @Parameters(commandDescription="Try to create partitions for partitioned topic. The partitions of partition topic has to be created, can be used by repair partitions when topic auto creation is disabled")
    private class CreateMissedPartitionsCmd
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private CreateMissedPartitionsCmd() {
        }

        @Override
        void run() throws Exception {
            String topic = CreateMissedPartitionsCmd.validateTopicName(this.params);
            CmdTopics.this.getTopics().createMissedPartitions(topic);
        }
    }

    @Parameters(commandDescription="Create a partitioned topic. The partitioned topic has to be created before creating a producer on it.")
    private class CreatePartitionedCmd
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-p", "--partitions"}, description="Number of partitions for the topic", required=true)
        private int numPartitions;

        private CreatePartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String topic = CreatePartitionedCmd.validateTopicName(this.params);
            CmdTopics.this.getTopics().createPartitionedTopic(topic, this.numPartitions);
        }
    }

    @Parameters(commandDescription="Get Namespace bundle range of a topic")
    private class GetBundleRange
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private GetBundleRange() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetBundleRange.validateTopicName(this.params);
            this.print(CmdTopics.this.getAdmin().lookups().getBundleRange(topic));
        }
    }

    @Parameters(commandDescription="Lookup a partitioned topic from the current serving broker")
    private class PartitionedLookup
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/partitionedTopic", required=true)
        private List<String> params;

        private PartitionedLookup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = PartitionedLookup.validateTopicName(this.params);
            this.print(CmdTopics.this.getAdmin().lookups().lookupPartitionedTopic(topic));
        }
    }

    @Parameters(commandDescription="Lookup a topic from the current serving broker")
    private class Lookup
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private Lookup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = Lookup.validateTopicName(this.params);
            this.print(CmdTopics.this.getAdmin().lookups().lookupTopic(topic));
        }
    }

    @Parameters(commandDescription="Get the permissions on a topic. Retrieve the effective permissions for a topic. These permissions are defined by the permissions set at the namespace level combined (union) with any eventual specific permission set on the topic.")
    private class Permissions
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;

        private Permissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = Permissions.validateTopicName(this.params);
            this.print(CmdTopics.this.getTopics().getPermissions(topic));
        }
    }

    @Parameters(commandDescription="Revoke permissions on a topic. Revoke permissions to a client role on a single topic. If the permission was not set at the topic level, but rather at the namespace level, this operation will return an error (HTTP status code 412).")
    private class RevokePermissions
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--role"}, description="Client role to which revoke permissions", required=true)
        private String role;

        private RevokePermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = RevokePermissions.validateTopicName(this.params);
            CmdTopics.this.getTopics().revokePermissions(topic, this.role);
        }
    }

    @Parameters(commandDescription="Grant a new permission to a client role on a single topic.")
    private class GrantPermissions
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--role"}, description="Client role to which grant permissions", required=true)
        private String role;
        @Parameter(names={"--actions"}, description="Actions to be granted (produce,consume)", required=true, splitter=CommaParameterSplitter.class)
        private List<String> actions;

        private GrantPermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GrantPermissions.validateTopicName(this.params);
            CmdTopics.this.getTopics().grantPermission(topic, this.role, GrantPermissions.getAuthActions(this.actions));
        }
    }

    @Parameters(commandDescription="Get the list of partitioned topics under a namespace.")
    private class PartitionedTopicListCmd
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;

        private PartitionedTopicListCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = PartitionedTopicListCmd.validateNamespace(this.params);
            this.print(CmdTopics.this.getTopics().getPartitionedTopicList(namespace));
        }
    }

    @Parameters(commandDescription="Get the list of topics under a namespace.")
    private class ListCmd
    extends CliCommand {
        @Parameter(description="tenant/namespace", required=true)
        private List<String> params;
        @Parameter(names={"-td", "--topic-domain"}, description="Allowed topic domain (persistent, non_persistent).")
        private TopicDomain topicDomain;

        private ListCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = ListCmd.validateNamespace(this.params);
            this.print(CmdTopics.this.getTopics().getList(namespace, this.topicDomain));
        }
    }
}

