/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.CommaParameterSplitter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Topics;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.util.RelativeTimeUtil;

@Parameters(commandDescription="Operations on persistent topics. The persistent-topics has been deprecated in favor of topics", hidden=true)
public class CmdPersistentTopics
extends CmdBase {
    private Topics persistentTopics;

    public CmdPersistentTopics(Supplier<PulsarAdmin> admin) {
        super("persistent", admin);
        this.jcommander.addCommand("list", (Object)new ListCmd());
        this.jcommander.addCommand("list-partitioned-topics", (Object)new PartitionedTopicListCmd());
        this.jcommander.addCommand("permissions", (Object)new Permissions());
        this.jcommander.addCommand("grant-permission", (Object)new GrantPermissions());
        this.jcommander.addCommand("revoke-permission", (Object)new RevokePermissions());
        this.jcommander.addCommand("lookup", (Object)new Lookup());
        this.jcommander.addCommand("bundle-range", (Object)new GetBundleRange());
        this.jcommander.addCommand("delete", (Object)new DeleteCmd());
        this.jcommander.addCommand("unload", (Object)new UnloadCmd());
        this.jcommander.addCommand("truncate", (Object)new TruncateCmd());
        this.jcommander.addCommand("subscriptions", (Object)new ListSubscriptions());
        this.jcommander.addCommand("unsubscribe", (Object)new DeleteSubscription());
        this.jcommander.addCommand("create-subscription", (Object)new CreateSubscription());
        this.jcommander.addCommand("stats", (Object)new GetStats());
        this.jcommander.addCommand("stats-internal", (Object)new GetInternalStats());
        this.jcommander.addCommand("info-internal", (Object)new GetInternalInfo());
        this.jcommander.addCommand("partitioned-stats", (Object)new GetPartitionedStats());
        this.jcommander.addCommand("partitioned-stats-internal", (Object)new GetPartitionedStatsInternal());
        this.jcommander.addCommand("skip", (Object)new Skip());
        this.jcommander.addCommand("skip-all", (Object)new SkipAll());
        this.jcommander.addCommand("expire-messages", (Object)new ExpireMessages());
        this.jcommander.addCommand("expire-messages-all-subscriptions", (Object)new ExpireMessagesForAllSubscriptions());
        this.jcommander.addCommand("create-partitioned-topic", (Object)new CreatePartitionedCmd());
        this.jcommander.addCommand("update-partitioned-topic", (Object)new UpdatePartitionedCmd());
        this.jcommander.addCommand("get-partitioned-topic-metadata", (Object)new GetPartitionedTopicMetadataCmd());
        this.jcommander.addCommand("delete-partitioned-topic", (Object)new DeletePartitionedCmd());
        this.jcommander.addCommand("peek-messages", (Object)new PeekMessages());
        this.jcommander.addCommand("get-message-by-id", (Object)new GetMessageById());
        this.jcommander.addCommand("last-message-id", (Object)new GetLastMessageId());
        this.jcommander.addCommand("reset-cursor", (Object)new ResetCursor());
        this.jcommander.addCommand("terminate", (Object)new Terminate());
        this.jcommander.addCommand("compact", (Object)new Compact());
        this.jcommander.addCommand("compaction-status", (Object)new CompactionStatusCmd());
    }

    private Topics getPersistentTopics() {
        if (this.persistentTopics == null) {
            this.persistentTopics = this.getAdmin().topics();
        }
        return this.persistentTopics;
    }

    @Parameters(commandDescription="Status of compaction on a topic")
    private class CompactionStatusCmd
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-w", "--wait-complete"}, description="Wait for compaction to complete", required=false)
        private boolean wait = false;

        private CompactionStatusCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = CompactionStatusCmd.validatePersistentTopic(this.params);
            try {
                LongRunningProcessStatus status = CmdPersistentTopics.this.getPersistentTopics().compactionStatus(persistentTopic);
                while (this.wait && status.status == LongRunningProcessStatus.Status.RUNNING) {
                    Thread.sleep(1000L);
                    status = CmdPersistentTopics.this.getPersistentTopics().compactionStatus(persistentTopic);
                }
                switch (status.status) {
                    case NOT_RUN: {
                        System.out.println("Compaction has not been run for " + persistentTopic + " since broker startup");
                        break;
                    }
                    case RUNNING: {
                        System.out.println("Compaction is currently running");
                        break;
                    }
                    case SUCCESS: {
                        System.out.println("Compaction was a success");
                        break;
                    }
                    case ERROR: {
                        System.out.println("Error in compaction");
                        throw new PulsarAdminException("Error compacting: " + status.lastError);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new PulsarAdminException((Throwable)e);
            }
        }
    }

    @Parameters(commandDescription="Compact a topic")
    private class Compact
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;

        private Compact() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = Compact.validatePersistentTopic(this.params);
            CmdPersistentTopics.this.getPersistentTopics().triggerCompaction(persistentTopic);
            System.out.println("Topic compaction requested for " + persistentTopic);
        }
    }

    @Parameters(commandDescription="Get last message Id of the topic")
    private class GetLastMessageId
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;

        private GetLastMessageId() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetLastMessageId.validatePersistentTopic(this.params);
            MessageId messageId = CmdPersistentTopics.this.getPersistentTopics().getLastMessageId(persistentTopic);
            this.print(messageId);
        }
    }

    @Parameters(commandDescription="Get message by its ledgerId and entryId")
    private class GetMessageById
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-l", "--ledgerId"}, description="ledger id pointing to the desired ledger", required=true)
        private long ledgerId;
        @Parameter(names={"-e", "--entryId"}, description="entry id pointing to the desired entry", required=true)
        private long entryId;

        private GetMessageById() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMessageById.validatePersistentTopic(this.params);
            Message message = CmdPersistentTopics.this.getPersistentTopics().getMessageById(persistentTopic, this.ledgerId, this.entryId);
            ByteBuf date = Unpooled.wrappedBuffer((byte[])message.getData());
            System.out.println(ByteBufUtil.prettyHexDump((ByteBuf)date));
        }
    }

    @Parameters(commandDescription="Peek some messages for the subscription")
    private class PeekMessages
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-s", "--subscription"}, description="Subscription to get messages from", required=true)
        private String subName;
        @Parameter(names={"-n", "--count"}, description="Number of messages (default 1)", required=false)
        private int numMessages = 1;

        private PeekMessages() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = PeekMessages.validatePersistentTopic(this.params);
            List messages = CmdPersistentTopics.this.getPersistentTopics().peekMessages(persistentTopic, this.subName, this.numMessages);
            int position = 0;
            for (Message msg : messages) {
                BatchMessageIdImpl msgId;
                if (++position != 1) {
                    System.out.println("-------------------------------------------------------------------------\n");
                }
                if (msg.getMessageId() instanceof BatchMessageIdImpl) {
                    msgId = (BatchMessageIdImpl)msg.getMessageId();
                    System.out.println("Batch Message ID: " + msgId.getLedgerId() + ":" + msgId.getEntryId() + ":" + msgId.getBatchIndex());
                } else {
                    msgId = (MessageIdImpl)msg.getMessageId();
                    System.out.println("Message ID: " + msgId.getLedgerId() + ":" + msgId.getEntryId());
                }
                if (msg.getProperties().size() > 0) {
                    System.out.println("Properties:");
                    this.print(msg.getProperties());
                }
                ByteBuf data = Unpooled.wrappedBuffer((byte[])msg.getData());
                System.out.println(ByteBufUtil.prettyHexDump((ByteBuf)data));
            }
        }
    }

    @Parameters(commandDescription="Terminate a topic and don't allow any more messages to be published")
    private class Terminate
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;

        private Terminate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = Terminate.validatePersistentTopic(this.params);
            try {
                MessageId lastMessageId = (MessageId)CmdPersistentTopics.this.getPersistentTopics().terminateTopicAsync(persistentTopic).get();
                System.out.println("Topic succesfully terminated at " + lastMessageId);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PulsarAdminException((Throwable)e);
            }
        }
    }

    @Parameters(commandDescription="Reset position for subscription to position closest to timestamp or messageId")
    private class ResetCursor
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-s", "--subscription"}, description="Subscription to reset position on", required=true)
        private String subName;
        @Parameter(names={"--time", "-t"}, description="time in minutes to reset back to (or minutes, hours,days,weeks eg: 100m, 3h, 2d, 5w)", required=false)
        private String resetTimeStr;
        @Parameter(names={"--messageId", "-m"}, description="messageId to reset back to (ledgerId:entryId)", required=false)
        private String resetMessageIdStr;

        private ResetCursor() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = ResetCursor.validatePersistentTopic(this.params);
            if (StringUtils.isNotBlank((CharSequence)this.resetMessageIdStr)) {
                MessageId messageId = ResetCursor.validateMessageIdString(this.resetMessageIdStr);
                CmdPersistentTopics.this.getPersistentTopics().resetCursor(persistentTopic, this.subName, messageId);
            } else if (StringUtils.isNotBlank((CharSequence)this.resetTimeStr)) {
                long resetTimeInMillis = TimeUnit.SECONDS.toMillis(RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.resetTimeStr));
                long timestamp = System.currentTimeMillis() - resetTimeInMillis;
                CmdPersistentTopics.this.getPersistentTopics().resetCursor(persistentTopic, this.subName, timestamp);
            } else {
                throw new PulsarAdminException("Either Timestamp (--time) or Position (--position) has to be provided to reset cursor");
            }
        }
    }

    @Parameters(commandDescription="Create a new subscription on a topic")
    private class CreateSubscription
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-s", "--subscription"}, description="Subscription to reset position on", required=true)
        private String subscriptionName;
        @Parameter(names={"--messageId", "-m"}, description="messageId where to create the subscription. It can be either 'latest', 'earliest' or (ledgerId:entryId)", required=false)
        private String messageIdStr = "latest";

        private CreateSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = CreateSubscription.validatePersistentTopic(this.params);
            MessageId messageId = this.messageIdStr.equals("latest") ? MessageId.latest : (this.messageIdStr.equals("earliest") ? MessageId.earliest : CreateSubscription.validateMessageIdString(this.messageIdStr));
            CmdPersistentTopics.this.getPersistentTopics().createSubscription(persistentTopic, this.subscriptionName, messageId);
        }
    }

    @Parameters(commandDescription="Expire messages that older than given expiry time (in seconds) for all subscriptions")
    private class ExpireMessagesForAllSubscriptions
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-t", "--expireTime"}, description="Expire messages older than time in seconds", required=true)
        private long expireTimeInSeconds;

        private ExpireMessagesForAllSubscriptions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = ExpireMessagesForAllSubscriptions.validatePersistentTopic(this.params);
            CmdPersistentTopics.this.getPersistentTopics().expireMessagesForAllSubscriptions(persistentTopic, this.expireTimeInSeconds);
        }
    }

    @Parameters(commandDescription="Expire messages that older than given expiry time (in seconds) for the subscription")
    private class ExpireMessages
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-s", "--subscription"}, description="Subscription to be skip messages on", required=true)
        private String subName;
        @Parameter(names={"-t", "--expireTime"}, description="Expire messages older than time in seconds", required=true)
        private long expireTimeInSeconds;

        private ExpireMessages() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = ExpireMessages.validatePersistentTopic(this.params);
            CmdPersistentTopics.this.getPersistentTopics().expireMessages(persistentTopic, this.subName, this.expireTimeInSeconds);
        }
    }

    @Parameters(commandDescription="Skip some messages for the subscription")
    private class Skip
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-s", "--subscription"}, description="Subscription to be skip messages on", required=true)
        private String subName;
        @Parameter(names={"-n", "--count"}, description="Number of messages to skip", required=true)
        private long numMessages;

        private Skip() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = Skip.validatePersistentTopic(this.params);
            CmdPersistentTopics.this.getPersistentTopics().skipMessages(persistentTopic, this.subName, this.numMessages);
        }
    }

    @Parameters(commandDescription="Skip all the messages for the subscription")
    private class SkipAll
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-s", "--subscription"}, description="Subscription to be cleared", required=true)
        private String subName;

        private SkipAll() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SkipAll.validatePersistentTopic(this.params);
            CmdPersistentTopics.this.getPersistentTopics().skipAllMessages(persistentTopic, this.subName);
        }
    }

    @Parameters(commandDescription="Get the stats-internal for the partitioned topic and its connected producers and consumers. All the rates are computed over a 1 minute window and are relative the last completed 1 minute period.")
    private class GetPartitionedStatsInternal
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;

        private GetPartitionedStatsInternal() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = GetPartitionedStatsInternal.validatePersistentTopic(this.params);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getPartitionedInternalStats(persistentTopic));
        }
    }

    @Parameters(commandDescription="Get the stats for the partitioned topic and its connected producers and consumers. All the rates are computed over a 1 minute window and are relative the last completed 1 minute period.")
    private class GetPartitionedStats
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--per-partition"}, description="Get per partition stats")
        private boolean perPartition = false;

        private GetPartitionedStats() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = GetPartitionedStats.validatePersistentTopic(this.params);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getPartitionedStats(persistentTopic, this.perPartition));
        }
    }

    @Parameters(commandDescription="Get the internal metadata info for the topic")
    private class GetInternalInfo
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;

        private GetInternalInfo() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetInternalInfo.validatePersistentTopic(this.params);
            JsonObject result = CmdPersistentTopics.this.getPersistentTopics().getInternalInfo(persistentTopic);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            System.out.println(gson.toJson((JsonElement)result));
        }
    }

    @Parameters(commandDescription="Get the internal stats for the topic")
    private class GetInternalStats
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-m", "--metadata"}, description="Flag to include ledger metadata")
        private boolean metadata = false;

        private GetInternalStats() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetInternalStats.validatePersistentTopic(this.params);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getInternalStats(persistentTopic, this.metadata));
        }
    }

    @Parameters(commandDescription="Get the stats for the topic and its connected producers and consumers. All the rates are computed over a 1 minute window and are relative the last completed 1 minute period.")
    private class GetStats
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;

        private GetStats() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetStats.validatePersistentTopic(this.params);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getStats(persistentTopic));
        }
    }

    @Parameters(commandDescription="Delete a durable subscriber from a topic. The subscription cannot be deleted if there are any active consumers attached to it")
    private class DeleteSubscription
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-f", "--force"}, description="Disconnect and close all consumers and delete subscription forcefully")
        private boolean force = false;
        @Parameter(names={"-s", "--subscription"}, description="Subscription to be deleted", required=true)
        private String subName;

        private DeleteSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = DeleteSubscription.validatePersistentTopic(this.params);
            CmdPersistentTopics.this.getPersistentTopics().deleteSubscription(persistentTopic, this.subName, this.force);
        }
    }

    @Parameters(commandDescription="Get the list of subscriptions on the topic")
    private class ListSubscriptions
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;

        private ListSubscriptions() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = ListSubscriptions.validatePersistentTopic(this.params);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getSubscriptions(persistentTopic));
        }
    }

    @Parameters(commandDescription="Truncate a topic. \n\t\tThe truncate operation will move all cursors to the end of the topic and delete all inactive ledgers. ")
    private class TruncateCmd
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic\n", required=true)
        private List<String> params;

        private TruncateCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = TruncateCmd.validateTopicName(this.params);
            CmdPersistentTopics.this.getPersistentTopics().truncate(topic);
        }
    }

    @Parameters(commandDescription="Unload a topic.")
    private class UnloadCmd
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;

        private UnloadCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = UnloadCmd.validatePersistentTopic(this.params);
            CmdPersistentTopics.this.getPersistentTopics().unload(persistentTopic);
        }
    }

    @Parameters(commandDescription="Delete a topic. The topic cannot be deleted if there's any active subscription or producers connected to it.")
    private class DeleteCmd
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--force"}, description="Close all producer/consumer/replicator and delete topic forcefully")
        private boolean force = false;

        private DeleteCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = DeleteCmd.validatePersistentTopic(this.params);
            CmdPersistentTopics.this.getPersistentTopics().delete(persistentTopic, this.force);
        }
    }

    @Parameters(commandDescription="Delete a partitioned topic. It will also delete all the partitions of the topic if it exists.")
    private class DeletePartitionedCmd
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--force"}, description="Close all producer/consumer/replicator and delete topic forcefully")
        private boolean force = false;

        private DeletePartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = DeletePartitionedCmd.validatePersistentTopic(this.params);
            CmdPersistentTopics.this.getPersistentTopics().deletePartitionedTopic(persistentTopic, this.force);
        }
    }

    @Parameters(commandDescription="Get the partitioned topic metadata. If the topic is not created or is a non-partitioned topic, it returns empty topic with 0 partitions")
    private class GetPartitionedTopicMetadataCmd
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;

        private GetPartitionedTopicMetadataCmd() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = GetPartitionedTopicMetadataCmd.validatePersistentTopic(this.params);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getPartitionedTopicMetadata(persistentTopic));
        }
    }

    @Parameters(commandDescription="Update existing non-global partitioned topic. New updating number of partitions must be greater than existing number of partitions.")
    private class UpdatePartitionedCmd
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-p", "--partitions"}, description="Number of partitions for the topic", required=true)
        private int numPartitions;

        private UpdatePartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = UpdatePartitionedCmd.validatePersistentTopic(this.params);
            CmdPersistentTopics.this.getPersistentTopics().updatePartitionedTopic(persistentTopic, this.numPartitions);
        }
    }

    @Parameters(commandDescription="Create a partitioned topic. The partitioned topic has to be created before creating a producer on it.")
    private class CreatePartitionedCmd
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-p", "--partitions"}, description="Number of partitions for the topic", required=true)
        private int numPartitions;

        private CreatePartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = CreatePartitionedCmd.validatePersistentTopic(this.params);
            CmdPersistentTopics.this.getPersistentTopics().createPartitionedTopic(persistentTopic, this.numPartitions);
        }
    }

    @Parameters(commandDescription="Get Namespace bundle range of a topic")
    private class GetBundleRange
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;

        private GetBundleRange() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetBundleRange.validateTopicName(this.params);
            this.print(CmdPersistentTopics.this.getAdmin().lookups().getBundleRange(topic));
        }
    }

    @Parameters(commandDescription="Lookup a topic from the current serving broker")
    private class Lookup
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;

        private Lookup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = Lookup.validateTopicName(this.params);
            this.print(CmdPersistentTopics.this.getAdmin().lookups().lookupTopic(topic));
        }
    }

    @Parameters(commandDescription="Get the permissions on a topic. Retrieve the effective permissions for a topic. These permissions are defined by the permissions set at the namespace level combined (union) with any eventual specific permission set on the topic.")
    private class Permissions
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;

        private Permissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = Permissions.validateTopicName(this.params);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getPermissions(topic));
        }
    }

    @Parameters(commandDescription="Revoke permissions on a topic. Revoke permissions to a client role on a single topic. If the permission was not set at the topic level, but rather at the namespace level, this operation will return an error (HTTP status code 412).")
    private class RevokePermissions
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--role"}, description="Client role to which revoke permissions", required=true)
        private String role;

        private RevokePermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = RevokePermissions.validateTopicName(this.params);
            CmdPersistentTopics.this.getPersistentTopics().revokePermissions(topic, this.role);
        }
    }

    @Parameters(commandDescription="Grant a new permission to a client role on a single topic.")
    private class GrantPermissions
    extends CliCommand {
        @Parameter(description="persistent://property/cluster/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--role"}, description="Client role to which grant permissions", required=true)
        private String role;
        @Parameter(names={"--actions"}, description="Actions to be granted (produce,consume)", required=true, splitter=CommaParameterSplitter.class)
        private List<String> actions;

        private GrantPermissions() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GrantPermissions.validateTopicName(this.params);
            CmdPersistentTopics.this.getPersistentTopics().grantPermission(topic, this.role, GrantPermissions.getAuthActions(this.actions));
        }
    }

    @Parameters(commandDescription="Get the list of partitioned topics under a namespace.")
    private class PartitionedTopicListCmd
    extends CliCommand {
        @Parameter(description="property/cluster/namespace", required=true)
        private List<String> params;

        private PartitionedTopicListCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = PartitionedTopicListCmd.validateNamespace(this.params);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getPartitionedTopicList(namespace));
        }
    }

    @Parameters(commandDescription="Get the list of topics under a namespace.")
    private class ListCmd
    extends CliCommand {
        @Parameter(description="property/cluster/namespace", required=true)
        private List<String> params;

        private ListCmd() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = ListCmd.validateNamespace(this.params);
            this.print(CmdPersistentTopics.this.getPersistentTopics().getList(namespace));
        }
    }
}

