/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.transaction.TxnID;

@Parameters(commandDescription="Operations on transactions")
public class CmdTransactions
extends CmdBase {
    public CmdTransactions(Supplier<PulsarAdmin> admin) {
        super("transactions", admin);
        this.jcommander.addCommand("coordinator-status", (Object)new GetCoordinatorStatus());
        this.jcommander.addCommand("transaction-in-buffer-stats", (Object)new GetTransactionInBufferStats());
        this.jcommander.addCommand("transaction-in-pending-ack-stats", (Object)new GetTransactionInPendingAckStats());
        this.jcommander.addCommand("transaction-metadata", (Object)new GetTransactionMetadata());
    }

    @Parameters(commandDescription="Get transaction metadata")
    private class GetTransactionMetadata
    extends CliCommand {
        @Parameter(names={"-m", "--most-sig-bits"}, description="the most sig bits", required=true)
        private int mostSigBits;
        @Parameter(names={"-l", "--least-sig-bits"}, description="the least sig bits", required=true)
        private long leastSigBits;

        private GetTransactionMetadata() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getTransactionMetadata(new TxnID((long)this.mostSigBits, this.leastSigBits)));
        }
    }

    @Parameters(commandDescription="Get transaction in buffer stats")
    private class GetTransactionInBufferStats
    extends CliCommand {
        @Parameter(names={"-m", "--most-sig-bits"}, description="the most sig bits", required=true)
        private int mostSigBits;
        @Parameter(names={"-l", "--least-sig-bits"}, description="the least sig bits", required=true)
        private long leastSigBits;
        @Parameter(names={"-t", "--topic"}, description="the topic", required=true)
        private String topic;

        private GetTransactionInBufferStats() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdTransactions.this.getAdmin().transactions().getTransactionInBufferStats(new TxnID((long)this.mostSigBits, this.leastSigBits), this.topic));
        }
    }

    @Parameters(commandDescription="Get transaction in pending ack stats")
    private class GetTransactionInPendingAckStats
    extends CliCommand {
        @Parameter(names={"-m", "--most-sig-bits"}, description="the most sig bits", required=true)
        private int mostSigBits;
        @Parameter(names={"-l", "--least-sig-bits"}, description="the least sig bits", required=true)
        private long leastSigBits;
        @Parameter(names={"-t", "--topic"}, description="the topic name", required=true)
        private String topic;
        @Parameter(names={"-s", "--sub-name"}, description="the subscription name", required=true)
        private String subName;

        private GetTransactionInPendingAckStats() {
        }

        @Override
        void run() throws Exception {
            CmdTransactions.this.getAdmin().transactions().getTransactionInPendingAckStats(new TxnID((long)this.mostSigBits, this.leastSigBits), this.topic, this.subName);
        }
    }

    @Parameters(commandDescription="Get transaction coordinator status")
    private class GetCoordinatorStatus
    extends CliCommand {
        @Parameter(names={"-c", "--coordinator-id"}, description="the coordinator id", required=false)
        private Integer coordinatorId;

        private GetCoordinatorStatus() {
        }

        @Override
        void run() throws Exception {
            if (this.coordinatorId != null) {
                this.print(CmdTransactions.this.getAdmin().transactions().getCoordinatorStatusById(this.coordinatorId.intValue()));
            } else {
                this.print(CmdTransactions.this.getAdmin().transactions().getCoordinatorStatus());
            }
        }
    }
}

