/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.FailureDomain;

@Parameters(commandDescription="Operations about clusters")
public class CmdClusters
extends CmdBase {
    public CmdClusters(PulsarAdmin admin) {
        super("clusters", admin);
        this.jcommander.addCommand("get", (Object)new Get());
        this.jcommander.addCommand("create", (Object)new Create());
        this.jcommander.addCommand("update", (Object)new Update());
        this.jcommander.addCommand("delete", (Object)new Delete());
        this.jcommander.addCommand("list", (Object)new List());
        this.jcommander.addCommand("update-peer-clusters", (Object)new UpdatePeerClusters());
        this.jcommander.addCommand("get-peer-clusters", (Object)new GetPeerClusters());
        this.jcommander.addCommand("get-failure-domain", (Object)new GetFailureDomain());
        this.jcommander.addCommand("create-failure-domain", (Object)new CreateFailureDomain());
        this.jcommander.addCommand("update-failure-domain", (Object)new UpdateFailureDomain());
        this.jcommander.addCommand("delete-failure-domain", (Object)new DeleteFailureDomain());
        this.jcommander.addCommand("list-failure-domains", (Object)new ListFailureDomains());
    }

    @Parameters(commandDescription="Get the configuration brokers of a failure-domain")
    private class GetFailureDomain
    extends CliCommand {
        @Parameter(description="cluster-name\n", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--domain-name"}, description="domain-name", required=true)
        private String domainName;

        private GetFailureDomain() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = GetFailureDomain.getOneArgument(this.params);
            this.print(CmdClusters.this.admin.clusters().getFailureDomain(cluster, this.domainName));
        }
    }

    @Parameters(commandDescription="List the existing failure-domains for a cluster")
    private class ListFailureDomains
    extends CliCommand {
        @Parameter(description="cluster-name\n", required=true)
        private java.util.List<String> params;

        private ListFailureDomains() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = ListFailureDomains.getOneArgument(this.params);
            this.print(CmdClusters.this.admin.clusters().getFailureDomains(cluster));
        }
    }

    @Parameters(commandDescription="Deletes an existing failure-domain")
    private class DeleteFailureDomain
    extends CliCommand {
        @Parameter(description="cluster-name\n", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--domain-name"}, description="domain-name", required=true)
        private String domainName;

        private DeleteFailureDomain() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = DeleteFailureDomain.getOneArgument(this.params);
            CmdClusters.this.admin.clusters().deleteFailureDomain(cluster, this.domainName);
        }
    }

    @Parameters(commandDescription="Update failure-domain for a cluster. Creates a new one if not exist.")
    private class UpdateFailureDomain
    extends CliCommand {
        @Parameter(description="cluster-name\n", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--domain-name"}, description="domain-name", required=true)
        private String domainName;
        @Parameter(names={"--broker-list"}, description="Comma separated broker list", required=false)
        private String brokerList;

        private UpdateFailureDomain() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = UpdateFailureDomain.getOneArgument(this.params);
            FailureDomain domain = new FailureDomain();
            domain.setBrokers(StringUtils.isNotBlank((CharSequence)this.brokerList) ? Sets.newHashSet((Object[])this.brokerList.split(",")) : null);
            CmdClusters.this.admin.clusters().updateFailureDomain(cluster, this.domainName, domain);
        }
    }

    @Parameters(commandDescription="Create a new failure-domain for a cluster. updates it if already created.")
    private class CreateFailureDomain
    extends CliCommand {
        @Parameter(description="cluster-name\n", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--domain-name"}, description="domain-name", required=true)
        private String domainName;
        @Parameter(names={"--broker-list"}, description="Comma separated broker list", required=false)
        private String brokerList;

        private CreateFailureDomain() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = CreateFailureDomain.getOneArgument(this.params);
            FailureDomain domain = new FailureDomain();
            domain.setBrokers(StringUtils.isNotBlank((CharSequence)this.brokerList) ? Sets.newHashSet((Object[])this.brokerList.split(",")) : null);
            CmdClusters.this.admin.clusters().createFailureDomain(cluster, this.domainName, domain);
        }
    }

    @Parameters(commandDescription="Get list of peer-clusters")
    private class GetPeerClusters
    extends CliCommand {
        @Parameter(description="cluster-name\n", required=true)
        private java.util.List<String> params;

        private GetPeerClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = GetPeerClusters.getOneArgument(this.params);
            this.print(CmdClusters.this.admin.clusters().getPeerClusterNames(cluster));
        }
    }

    @Parameters(commandDescription="Update peer cluster names")
    private class UpdatePeerClusters
    extends CliCommand {
        @Parameter(description="cluster-name\n", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--peer-clusters"}, description="Comma separated peer-cluster names [Pass empty string \"\" to delete list]", required=true)
        private String peerClusterNames;

        private UpdatePeerClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = UpdatePeerClusters.getOneArgument(this.params);
            LinkedHashSet clusters = StringUtils.isBlank((CharSequence)this.peerClusterNames) ? null : Sets.newLinkedHashSet(Arrays.asList(this.peerClusterNames.split(",")));
            CmdClusters.this.admin.clusters().updatePeerClusterNames(cluster, clusters);
        }
    }

    @Parameters(commandDescription="Deletes an existing cluster")
    private class Delete
    extends CliCommand {
        @Parameter(description="cluster-name\n", required=true)
        private java.util.List<String> params;
        @Parameter(names={"-a", "--all"}, description="Delete all data (tenants) of the cluster\n", required=false)
        private boolean deleteAll = false;

        private Delete() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = Delete.getOneArgument(this.params);
            if (this.deleteAll) {
                for (String tenant : CmdClusters.this.admin.tenants().getTenants()) {
                    for (String namespace : CmdClusters.this.admin.namespaces().getNamespaces(tenant)) {
                        for (String topic : CmdClusters.this.admin.topics().getPartitionedTopicList(namespace)) {
                            CmdClusters.this.admin.topics().deletePartitionedTopic(topic, true, true);
                        }
                        for (String topic : CmdClusters.this.admin.topics().getList(namespace)) {
                            CmdClusters.this.admin.topics().delete(topic, true, true);
                        }
                        CmdClusters.this.admin.namespaces().deleteNamespace(namespace, true);
                    }
                    CmdClusters.this.admin.tenants().deleteTenant(tenant);
                }
            }
            CmdClusters.this.admin.clusters().deleteCluster(cluster);
        }
    }

    @Parameters(commandDescription="Update the configuration for a cluster")
    private class Update
    extends CliCommand {
        @Parameter(description="cluster-name\n", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--url"}, description="service-url", required=true)
        private String serviceUrl;
        @Parameter(names={"--url-secure"}, description="service-url for secure connection", required=false)
        private String serviceUrlTls;
        @Parameter(names={"--broker-url"}, description="broker-service-url", required=false)
        private String brokerServiceUrl;
        @Parameter(names={"--broker-url-secure"}, description="broker-service-url for secure connection", required=false)
        private String brokerServiceUrlTls;
        @Parameter(names={"--proxy-url"}, description="Proxy-service url when client would like to connect to broker via proxy.", required=false)
        private String proxyServiceUrl;
        @Parameter(names={"--proxy-protocol"}, description="protocol to decide type of proxy routing eg: SNI", required=false)
        private ProxyProtocol proxyProtocol;

        private Update() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = Update.getOneArgument(this.params);
            CmdClusters.this.admin.clusters().updateCluster(cluster, new ClusterData(this.serviceUrl, this.serviceUrlTls, this.brokerServiceUrl, this.brokerServiceUrlTls, this.proxyServiceUrl, this.proxyProtocol));
        }
    }

    @Parameters(commandDescription="Provisions a new cluster. This operation requires Pulsar super-user privileges")
    private class Create
    extends CliCommand {
        @Parameter(description="cluster-name\n", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--url"}, description="service-url", required=true)
        private String serviceUrl;
        @Parameter(names={"--url-secure"}, description="service-url for secure connection", required=false)
        private String serviceUrlTls;
        @Parameter(names={"--broker-url"}, description="broker-service-url", required=false)
        private String brokerServiceUrl;
        @Parameter(names={"--broker-url-secure"}, description="broker-service-url for secure connection", required=false)
        private String brokerServiceUrlTls;
        @Parameter(names={"--proxy-url"}, description="Proxy-service url when client would like to connect to broker via proxy.", required=false)
        private String proxyServiceUrl;
        @Parameter(names={"--proxy-protocol"}, description="protocol to decide type of proxy routing eg: SNI", required=false)
        private ProxyProtocol proxyProtocol;

        private Create() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = Create.getOneArgument(this.params);
            CmdClusters.this.admin.clusters().createCluster(cluster, new ClusterData(this.serviceUrl, this.serviceUrlTls, this.brokerServiceUrl, this.brokerServiceUrlTls, this.proxyServiceUrl, this.proxyProtocol));
        }
    }

    @Parameters(commandDescription="Get the configuration data for the specified cluster")
    private class Get
    extends CliCommand {
        @Parameter(description="cluster-name\n", required=true)
        private java.util.List<String> params;

        private Get() {
        }

        @Override
        void run() throws PulsarAdminException {
            String cluster = Get.getOneArgument(this.params);
            this.print(CmdClusters.this.admin.clusters().getCluster(cluster));
        }
    }

    @Parameters(commandDescription="List the existing clusters")
    private class List
    extends CliCommand {
        private List() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdClusters.this.admin.clusters().getClusters());
        }
    }
}

