/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.NonPersistentTopics;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;

@Parameters(commandDescription="Operations on non-persistent topics", hidden=true)
public class CmdNonPersistentTopics
extends CmdBase {
    private final NonPersistentTopics nonPersistentTopics;

    public CmdNonPersistentTopics(PulsarAdmin admin) {
        super("non-persistent", admin);
        this.nonPersistentTopics = admin.nonPersistentTopics();
        this.jcommander.addCommand("create-partitioned-topic", (Object)new CreatePartitionedCmd());
        this.jcommander.addCommand("lookup", (Object)new Lookup());
        this.jcommander.addCommand("stats", (Object)new GetStats());
        this.jcommander.addCommand("stats-internal", (Object)new GetInternalStats());
        this.jcommander.addCommand("get-partitioned-topic-metadata", (Object)new GetPartitionedTopicMetadataCmd());
        this.jcommander.addCommand("list", (Object)new GetList());
        this.jcommander.addCommand("list-in-bundle", (Object)new GetListInBundle());
    }

    @Parameters(commandDescription="Get list of non-persistent topics present under a namespace bundle")
    private class GetListInBundle
    extends CliCommand {
        @Parameter(description="property/cluster/namespace\n", required=true)
        private List<String> params;
        @Parameter(names={"-b", "--bundle"}, description="bundle range", required=true)
        private String bundleRange;

        private GetListInBundle() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetListInBundle.validateNamespace(this.params);
            this.print(CmdNonPersistentTopics.this.nonPersistentTopics.getListInBundle(namespace, this.bundleRange));
        }
    }

    @Parameters(commandDescription="Get list of non-persistent topics present under a namespace")
    private class GetList
    extends CliCommand {
        @Parameter(description="property/cluster/namespace\n", required=true)
        private List<String> params;

        private GetList() {
        }

        @Override
        void run() throws PulsarAdminException {
            String namespace = GetList.validateNamespace(this.params);
            this.print(CmdNonPersistentTopics.this.nonPersistentTopics.getList(namespace));
        }
    }

    @Parameters(commandDescription="Get the partitioned topic metadata. \n\t\tIf the topic is not created or is a non-partitioned topic, it returns empty topic with 0 partitions")
    private class GetPartitionedTopicMetadataCmd
    extends CliCommand {
        @Parameter(description="non-persistent://property/cluster/namespace/topic\n", required=true)
        private List<String> params;

        private GetPartitionedTopicMetadataCmd() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = GetPartitionedTopicMetadataCmd.validateNonPersistentTopic(this.params);
            this.print(CmdNonPersistentTopics.this.nonPersistentTopics.getPartitionedTopicMetadata(persistentTopic));
        }
    }

    @Parameters(commandDescription="Create a partitioned topic. \n\t\tThe partitioned topic has to be created before creating a producer on it.")
    private class CreatePartitionedCmd
    extends CliCommand {
        @Parameter(description="non-persistent://property/cluster/namespace/topic\n", required=true)
        private List<String> params;
        @Parameter(names={"-p", "--partitions"}, description="Number of partitions for the topic", required=true)
        private int numPartitions;

        private CreatePartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = CreatePartitionedCmd.validateNonPersistentTopic(this.params);
            CmdNonPersistentTopics.this.nonPersistentTopics.createPartitionedTopic(persistentTopic, this.numPartitions);
        }
    }

    @Parameters(commandDescription="Get the internal stats for the topic")
    private class GetInternalStats
    extends CliCommand {
        @Parameter(description="non-persistent://property/cluster/namespace/topic\n", required=true)
        private List<String> params;

        private GetInternalStats() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetInternalStats.validateNonPersistentTopic(this.params);
            this.print(CmdNonPersistentTopics.this.nonPersistentTopics.getInternalStats(persistentTopic));
        }
    }

    @Parameters(commandDescription="Get the stats for the topic and its connected producers and consumers. \n\t       All the rates are computed over a 1 minute window and are relative the last completed 1 minute period.")
    private class GetStats
    extends CliCommand {
        @Parameter(description="non-persistent://property/cluster/namespace/topic\n", required=true)
        private List<String> params;

        private GetStats() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetStats.validateNonPersistentTopic(this.params);
            this.print(CmdNonPersistentTopics.this.nonPersistentTopics.getStats(persistentTopic));
        }
    }

    @Parameters(commandDescription="Lookup a topic from the current serving broker")
    private class Lookup
    extends CliCommand {
        @Parameter(description="non-persistent://property/cluster/namespace/topic\n", required=true)
        private List<String> params;

        private Lookup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = Lookup.validateTopicName(this.params);
            this.print(CmdNonPersistentTopics.this.admin.lookups().lookupTopic(topic));
        }
    }
}

