/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli.utils;

import com.beust.jcommander.ParameterException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;

public class CmdUtils {
    public static <T> T loadConfig(String file, Class<T> clazz) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            return (T)mapper.readValue(new File(file), clazz);
        }
        catch (Exception ex) {
            if (ex instanceof UnrecognizedPropertyException) {
                UnrecognizedPropertyException unrecognizedPropertyException = (UnrecognizedPropertyException)ex;
                String exceptionMessage = String.format("Failed to parse config file %s. Invalid field '%s' on line: %d column: %d. Valid fields are %s", file, ((JsonMappingException.Reference)unrecognizedPropertyException.getPath().get(0)).getFieldName(), unrecognizedPropertyException.getLocation().getLineNr(), unrecognizedPropertyException.getLocation().getColumnNr(), unrecognizedPropertyException.getKnownPropertyIds());
                throw new ParameterException(exceptionMessage);
            }
            if (ex instanceof InvalidFormatException) {
                InvalidFormatException invalidFormatException = (InvalidFormatException)ex;
                String exceptionMessage = String.format("Failed to parse config file %s. %s on line: %d column: %d", file, invalidFormatException.getOriginalMessage(), invalidFormatException.getLocation().getLineNr(), invalidFormatException.getLocation().getColumnNr());
                throw new ParameterException(exceptionMessage);
            }
            throw new ParameterException(ex.getMessage());
        }
    }
}

