/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;

@Parameters(commandDescription="Operations about brokers")
public class CmdBrokers
extends CmdBase {
    public CmdBrokers(PulsarAdmin admin) {
        super("brokers", admin);
        this.jcommander.addCommand("list", (Object)new List());
        this.jcommander.addCommand("namespaces", (Object)new Namespaces());
        this.jcommander.addCommand("update-dynamic-config", (Object)new UpdateConfigurationCmd());
        this.jcommander.addCommand("delete-dynamic-config", (Object)new DeleteConfigurationCmd());
        this.jcommander.addCommand("list-dynamic-config", (Object)new GetUpdatableConfigCmd());
        this.jcommander.addCommand("get-all-dynamic-config", (Object)new GetAllConfigurationsCmd());
        this.jcommander.addCommand("get-internal-config", (Object)new GetInternalConfigurationCmd());
        this.jcommander.addCommand("get-runtime-config", (Object)new GetRuntimeConfigCmd());
        this.jcommander.addCommand("healthcheck", (Object)new HealthcheckCmd());
        this.jcommander.addCommand("backlog-quota-check", (Object)new BacklogQuotaCheckCmd());
    }

    @Parameters(commandDescription="Manually trigger backlogQuotaCheck")
    private class BacklogQuotaCheckCmd
    extends CliCommand {
        private BacklogQuotaCheckCmd() {
        }

        @Override
        void run() throws Exception {
            CmdBrokers.this.admin.brokers().backlogQuotaCheckAsync();
            System.out.println("ok");
        }
    }

    @Parameters(commandDescription="Run a health check against the broker")
    private class HealthcheckCmd
    extends CliCommand {
        private HealthcheckCmd() {
        }

        @Override
        void run() throws Exception {
            CmdBrokers.this.admin.brokers().healthcheck();
            System.out.println("ok");
        }
    }

    @Parameters(commandDescription="Get internal configuration information")
    private class GetInternalConfigurationCmd
    extends CliCommand {
        private GetInternalConfigurationCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.admin.brokers().getInternalConfigurationData());
        }
    }

    @Parameters(commandDescription="Get runtime configuration values")
    private class GetRuntimeConfigCmd
    extends CliCommand {
        private GetRuntimeConfigCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.admin.brokers().getRuntimeConfigurations());
        }
    }

    @Parameters(commandDescription="Get list of updatable configuration name")
    private class GetUpdatableConfigCmd
    extends CliCommand {
        private GetUpdatableConfigCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.admin.brokers().getDynamicConfigurationNames());
        }
    }

    @Parameters(commandDescription="Get all overridden dynamic-configuration values")
    private class GetAllConfigurationsCmd
    extends CliCommand {
        private GetAllConfigurationsCmd() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokers.this.admin.brokers().getAllDynamicConfigurations());
        }
    }

    @Parameters(commandDescription="Delete dynamic-serviceConfiguration of broker")
    private class DeleteConfigurationCmd
    extends CliCommand {
        @Parameter(names={"--config"}, description="service-configuration name", required=true)
        private String configName;

        private DeleteConfigurationCmd() {
        }

        @Override
        void run() throws Exception {
            CmdBrokers.this.admin.brokers().deleteDynamicConfiguration(this.configName);
        }
    }

    @Parameters(commandDescription="Update dynamic-serviceConfiguration of broker")
    private class UpdateConfigurationCmd
    extends CliCommand {
        @Parameter(names={"--config"}, description="service-configuration name", required=true)
        private String configName;
        @Parameter(names={"--value"}, description="service-configuration value", required=true)
        private String configValue;

        private UpdateConfigurationCmd() {
        }

        @Override
        void run() throws Exception {
            CmdBrokers.this.admin.brokers().updateDynamicConfiguration(this.configName, this.configValue);
        }
    }

    @Parameters(commandDescription="List namespaces owned by the broker")
    private class Namespaces
    extends CliCommand {
        @Parameter(description="cluster-name\n", required=true)
        private java.util.List<String> params;
        @Parameter(names={"--url"}, description="broker-url\n", required=true)
        private String brokerUrl;

        private Namespaces() {
        }

        @Override
        void run() throws Exception {
            String cluster = Namespaces.getOneArgument(this.params);
            this.print(CmdBrokers.this.admin.brokers().getOwnedNamespaces(cluster, this.brokerUrl));
        }
    }

    @Parameters(commandDescription="List active brokers of the cluster")
    private class List
    extends CliCommand {
        @Parameter(description="cluster-name\n", required=true)
        private java.util.List<String> params;

        private List() {
        }

        @Override
        void run() throws Exception {
            String cluster = List.getOneArgument(this.params);
            this.print(CmdBrokers.this.admin.brokers().getActiveBrokers(cluster));
        }
    }
}

