/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.utils.SchemaExtractor;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.common.protocol.schema.PostSchemaPayload;

@Parameters(commandDescription="Operations about schemas")
public class CmdSchemas
extends CmdBase {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public CmdSchemas(Supplier<PulsarAdmin> admin) {
        super("schemas", admin);
        this.jcommander.addCommand("get", (Object)new GetSchema());
        this.jcommander.addCommand("delete", (Object)new DeleteSchema());
        this.jcommander.addCommand("upload", (Object)new UploadSchema());
        this.jcommander.addCommand("extract", (Object)new ExtractSchema());
    }

    @Parameters(commandDescription="Get the schema for a topic")
    private class GetSchema
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-v", "--version"}, description="version", required=false)
        private Long version;
        @Parameter(names={"-a", "--all-version"}, description="all version", required=false)
        private boolean all = false;

        private GetSchema() {
        }

        @Override
        void run() throws Exception {
            String topic = GetSchema.validateTopicName(this.params);
            if (this.version != null && this.all) {
                throw new ParameterException("Only one or neither of --version and --all-version can be specified.");
            }
            if (this.version == null && !this.all) {
                System.out.println(CmdSchemas.this.getAdmin().schemas().getSchemaInfoWithVersion(topic));
            } else if (!this.all) {
                if (this.version < 0L) {
                    throw new ParameterException("Option --version must be greater than 0, but found " + this.version);
                }
                System.out.println(CmdSchemas.this.getAdmin().schemas().getSchemaInfo(topic, this.version.longValue()));
            } else {
                this.print(CmdSchemas.this.getAdmin().schemas().getAllSchemas(topic));
            }
        }
    }

    @Parameters(commandDescription="Delete the latest schema for a topic")
    private class DeleteSchema
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-f", "--force"}, description="whether to delete schema completely. If true, delete all resources (including metastore and ledger), otherwise only do a mark deletion and not remove any resources indeed")
        private boolean force = false;

        private DeleteSchema() {
        }

        @Override
        void run() throws Exception {
            String topic = DeleteSchema.validateTopicName(this.params);
            CmdSchemas.this.getAdmin().schemas().deleteSchema(topic, this.force);
        }
    }

    @Parameters(commandDescription="Update the schema for a topic")
    private class UploadSchema
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-f", "--filename"}, description="filename", required=true)
        private String schemaFileName;

        private UploadSchema() {
        }

        @Override
        void run() throws Exception {
            String topic = UploadSchema.validateTopicName(this.params);
            PostSchemaPayload input = (PostSchemaPayload)MAPPER.readValue(new File(this.schemaFileName), PostSchemaPayload.class);
            CmdSchemas.this.getAdmin().schemas().createSchema(topic, input);
        }
    }

    @Parameters(commandDescription="Provide the schema via a topic")
    private class ExtractSchema
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-j", "--jar"}, description="jar filepath", required=true)
        private String jarFilePath;
        @Parameter(names={"-t", "--type"}, description="type avro or json", required=true)
        private String type;
        @Parameter(names={"-c", "--classname"}, description="class name of pojo", required=true)
        private String className;
        @Parameter(names={"-a", "--always-allow-null"}, arity=1, description="set schema whether always allow null or not")
        private boolean alwaysAllowNull = true;
        @Parameter(names={"-n", "--dry-run"}, description="dost not apply to schema registry, just prints the post schema payload")
        private boolean dryRun = false;

        private ExtractSchema() {
        }

        @Override
        void run() throws Exception {
            String topic = ExtractSchema.validateTopicName(this.params);
            File file = new File(this.jarFilePath);
            URLClassLoader cl = new URLClassLoader(new URL[]{file.toURI().toURL()});
            Class<?> cls = cl.loadClass(this.className);
            PostSchemaPayload input = new PostSchemaPayload();
            SchemaDefinition schemaDefinition = SchemaDefinition.builder().withPojo(cls).withAlwaysAllowNull(this.alwaysAllowNull).build();
            if (this.type.equalsIgnoreCase("avro")) {
                input.setType("AVRO");
                input.setSchema(SchemaExtractor.getAvroSchemaInfo(schemaDefinition));
            } else if (this.type.equalsIgnoreCase("json")) {
                input.setType("JSON");
                input.setSchema(SchemaExtractor.getJsonSchemaInfo(schemaDefinition));
            } else {
                throw new ParameterException("Invalid schema type " + this.type + ". Valid options are: avro, json");
            }
            input.setProperties(schemaDefinition.getProperties());
            if (this.dryRun) {
                System.out.println(topic);
                System.out.println(MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)input));
            } else {
                CmdSchemas.this.getAdmin().schemas().createSchema(topic, input);
            }
        }
    }
}

