/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.PulsarAdminTool;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;

public class PulsarAdminSupplier
implements Supplier<PulsarAdmin> {
    private final PulsarAdminBuilder adminBuilder;
    private RootParamsKey currentParamsKey;
    private PulsarAdmin admin;

    public PulsarAdminSupplier(PulsarAdminBuilder baseAdminBuilder, PulsarAdminTool.RootParams rootParams) {
        this.adminBuilder = baseAdminBuilder;
        this.rootParamsUpdated(rootParams);
    }

    @Override
    public PulsarAdmin get() {
        if (this.admin == null) {
            try {
                this.admin = this.adminBuilder.build();
            }
            catch (Exception ex) {
                System.err.println(ex.getClass() + ": " + ex.getMessage());
                throw new RuntimeException("Not able to create pulsar admin: " + ex.getMessage(), ex);
            }
        }
        return this.admin;
    }

    void rootParamsUpdated(PulsarAdminTool.RootParams newParams) {
        RootParamsKey newParamsKey = RootParamsKey.fromRootParams(newParams);
        if (newParamsKey.equals(this.currentParamsKey)) {
            return;
        }
        PulsarAdminSupplier.applyRootParamsToAdminBuilder(this.adminBuilder, newParams);
        this.currentParamsKey = newParamsKey;
        if (this.admin != null) {
            this.admin.close();
        }
        this.admin = null;
    }

    private static void applyRootParamsToAdminBuilder(PulsarAdminBuilder adminBuilder, PulsarAdminTool.RootParams rootParams) {
        adminBuilder.serviceHttpUrl(rootParams.serviceUrl);
        adminBuilder.authentication(rootParams.authPluginClassName, rootParams.authParams);
        adminBuilder.requestTimeout(rootParams.requestTimeout, TimeUnit.SECONDS);
        if (rootParams.tlsAllowInsecureConnection != null) {
            adminBuilder.allowTlsInsecureConnection(rootParams.tlsAllowInsecureConnection.booleanValue());
        }
        if (rootParams.tlsEnableHostnameVerification != null) {
            adminBuilder.enableTlsHostnameVerification(rootParams.tlsEnableHostnameVerification.booleanValue());
        }
        if (StringUtils.isNotBlank((CharSequence)rootParams.tlsProvider)) {
            adminBuilder.sslProvider(rootParams.tlsProvider);
        }
    }

    private static final class RootParamsKey {
        String serviceUrl;
        String authPluginClassName;
        int requestTimeout;
        String authParams;
        Boolean tlsAllowInsecureConnection;
        String tlsTrustCertsFilePath;
        Boolean tlsEnableHostnameVerification;
        String tlsProvider;

        static RootParamsKey fromRootParams(PulsarAdminTool.RootParams params) {
            RootParamsKey key = new RootParamsKey();
            key.setServiceUrl(params.getServiceUrl());
            key.setAuthParams(params.getAuthParams());
            key.setAuthPluginClassName(params.getAuthPluginClassName());
            key.setRequestTimeout(params.getRequestTimeout());
            key.setTlsAllowInsecureConnection(params.getTlsAllowInsecureConnection());
            key.setTlsTrustCertsFilePath(params.getTlsTrustCertsFilePath());
            key.setTlsEnableHostnameVerification(params.getTlsEnableHostnameVerification());
            key.setTlsProvider(params.getTlsProvider());
            return key;
        }

        public String getServiceUrl() {
            return this.serviceUrl;
        }

        public String getAuthPluginClassName() {
            return this.authPluginClassName;
        }

        public int getRequestTimeout() {
            return this.requestTimeout;
        }

        public String getAuthParams() {
            return this.authParams;
        }

        public Boolean getTlsAllowInsecureConnection() {
            return this.tlsAllowInsecureConnection;
        }

        public String getTlsTrustCertsFilePath() {
            return this.tlsTrustCertsFilePath;
        }

        public Boolean getTlsEnableHostnameVerification() {
            return this.tlsEnableHostnameVerification;
        }

        public String getTlsProvider() {
            return this.tlsProvider;
        }

        public void setServiceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        public void setAuthPluginClassName(String authPluginClassName) {
            this.authPluginClassName = authPluginClassName;
        }

        public void setRequestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
        }

        public void setAuthParams(String authParams) {
            this.authParams = authParams;
        }

        public void setTlsAllowInsecureConnection(Boolean tlsAllowInsecureConnection) {
            this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        }

        public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
            this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
        }

        public void setTlsEnableHostnameVerification(Boolean tlsEnableHostnameVerification) {
            this.tlsEnableHostnameVerification = tlsEnableHostnameVerification;
        }

        public void setTlsProvider(String tlsProvider) {
            this.tlsProvider = tlsProvider;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RootParamsKey)) {
                return false;
            }
            RootParamsKey other = (RootParamsKey)o;
            if (this.getRequestTimeout() != other.getRequestTimeout()) {
                return false;
            }
            Boolean this$tlsAllowInsecureConnection = this.getTlsAllowInsecureConnection();
            Boolean other$tlsAllowInsecureConnection = other.getTlsAllowInsecureConnection();
            if (this$tlsAllowInsecureConnection == null ? other$tlsAllowInsecureConnection != null : !((Object)this$tlsAllowInsecureConnection).equals(other$tlsAllowInsecureConnection)) {
                return false;
            }
            Boolean this$tlsEnableHostnameVerification = this.getTlsEnableHostnameVerification();
            Boolean other$tlsEnableHostnameVerification = other.getTlsEnableHostnameVerification();
            if (this$tlsEnableHostnameVerification == null ? other$tlsEnableHostnameVerification != null : !((Object)this$tlsEnableHostnameVerification).equals(other$tlsEnableHostnameVerification)) {
                return false;
            }
            String this$serviceUrl = this.getServiceUrl();
            String other$serviceUrl = other.getServiceUrl();
            if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
                return false;
            }
            String this$authPluginClassName = this.getAuthPluginClassName();
            String other$authPluginClassName = other.getAuthPluginClassName();
            if (this$authPluginClassName == null ? other$authPluginClassName != null : !this$authPluginClassName.equals(other$authPluginClassName)) {
                return false;
            }
            String this$authParams = this.getAuthParams();
            String other$authParams = other.getAuthParams();
            if (this$authParams == null ? other$authParams != null : !this$authParams.equals(other$authParams)) {
                return false;
            }
            String this$tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
            String other$tlsTrustCertsFilePath = other.getTlsTrustCertsFilePath();
            if (this$tlsTrustCertsFilePath == null ? other$tlsTrustCertsFilePath != null : !this$tlsTrustCertsFilePath.equals(other$tlsTrustCertsFilePath)) {
                return false;
            }
            String this$tlsProvider = this.getTlsProvider();
            String other$tlsProvider = other.getTlsProvider();
            return !(this$tlsProvider == null ? other$tlsProvider != null : !this$tlsProvider.equals(other$tlsProvider));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRequestTimeout();
            Boolean $tlsAllowInsecureConnection = this.getTlsAllowInsecureConnection();
            result = result * 59 + ($tlsAllowInsecureConnection == null ? 43 : ((Object)$tlsAllowInsecureConnection).hashCode());
            Boolean $tlsEnableHostnameVerification = this.getTlsEnableHostnameVerification();
            result = result * 59 + ($tlsEnableHostnameVerification == null ? 43 : ((Object)$tlsEnableHostnameVerification).hashCode());
            String $serviceUrl = this.getServiceUrl();
            result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
            String $authPluginClassName = this.getAuthPluginClassName();
            result = result * 59 + ($authPluginClassName == null ? 43 : $authPluginClassName.hashCode());
            String $authParams = this.getAuthParams();
            result = result * 59 + ($authParams == null ? 43 : $authParams.hashCode());
            String $tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
            result = result * 59 + ($tlsTrustCertsFilePath == null ? 43 : $tlsTrustCertsFilePath.hashCode());
            String $tlsProvider = this.getTlsProvider();
            result = result * 59 + ($tlsProvider == null ? 43 : $tlsProvider.hashCode());
            return result;
        }

        public String toString() {
            return "PulsarAdminSupplier.RootParamsKey(serviceUrl=" + this.getServiceUrl() + ", authPluginClassName=" + this.getAuthPluginClassName() + ", requestTimeout=" + this.getRequestTimeout() + ", authParams=" + this.getAuthParams() + ", tlsAllowInsecureConnection=" + this.getTlsAllowInsecureConnection() + ", tlsTrustCertsFilePath=" + this.getTlsTrustCertsFilePath() + ", tlsEnableHostnameVerification=" + this.getTlsEnableHostnameVerification() + ", tlsProvider=" + this.getTlsProvider() + ")";
        }
    }
}

