/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shell;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.WrappedParameter;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.shell.OptionStrictArgumentCompleter;
import org.apache.pulsar.shell.config.ConfigStore;
import org.jline.builtins.Completers;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;

public class JCommanderCompleter {
    private JCommanderCompleter() {
    }

    public static List<Completer> createCompletersForCommand(String program, JCommander command, ShellContext shellContext) {
        command.setProgramName(program);
        return JCommanderCompleter.createCompletersForCommand(Collections.emptyList(), command, Arrays.asList(NullCompleter.INSTANCE), shellContext);
    }

    private static List<Completer> createCompletersForCommand(List<Completer> preCompleters, JCommander command, List<Completer> postCompleters, ShellContext shellContext) {
        ArrayList<Completer> all = new ArrayList<Completer>();
        JCommanderCompleter.addCompletersForCommand(preCompleters, postCompleters, all, command, shellContext);
        return all;
    }

    private static void addCompletersForCommand(List<Completer> preCompleters, List<Completer> postCompleters, List<Completer> result, JCommander command, ShellContext shellContext) {
        Collection options;
        ParameterDescription mainParameterValue;
        Map subCommands;
        if (command.getObjects().get(0) instanceof CmdBase) {
            CmdBase cmdBase = (CmdBase)command.getObjects().get(0);
            subCommands = cmdBase.getJcommander().getCommands();
            mainParameterValue = cmdBase.getJcommander().getMainParameter() == null ? null : cmdBase.getJcommander().getMainParameterValue();
            options = cmdBase.getJcommander().getParameters().stream().map(option -> JCommanderCompleter.createOptionDescriptors(option, shellContext)).collect(Collectors.toList());
        } else {
            subCommands = command.getCommands();
            mainParameterValue = command.getMainParameter() == null ? null : command.getMainParameterValue();
            options = command.getParameters().stream().map(option -> JCommanderCompleter.createOptionDescriptors(option, shellContext)).collect(Collectors.toList());
        }
        StringsCompleter cmdStringsCompleter = new StringsCompleter(new String[]{command.getProgramName()});
        for (int i = 0; i < options.size() + 1; ++i) {
            Completer customCompleter;
            ArrayList<Completer> completersChain = new ArrayList<Completer>();
            completersChain.addAll(preCompleters);
            completersChain.add((Completer)cmdStringsCompleter);
            for (int j = 0; j < i; ++j) {
                completersChain.add((Completer)new Completers.OptionCompleter(options, preCompleters.size() + 1 + j));
            }
            for (Map.Entry subCommand : subCommands.entrySet()) {
                JCommanderCompleter.addCompletersForCommand(completersChain, postCompleters, result, (JCommander)subCommand.getValue(), shellContext);
            }
            if (mainParameterValue != null && (customCompleter = JCommanderCompleter.getCustomCompleter(mainParameterValue, shellContext)) != null) {
                completersChain.add(customCompleter);
            }
            completersChain.addAll(postCompleters);
            result.add(new OptionStrictArgumentCompleter(completersChain));
        }
    }

    private static Completers.OptDesc createOptionDescriptors(ParameterDescription param, ShellContext shellContext) {
        String[] parameterNames;
        Completer valueCompleter = JCommanderCompleter.getCompleter(param, shellContext);
        WrappedParameter parameter = param.getParameter();
        String shortOption = null;
        String longOption = null;
        for (String parameterName : parameterNames = parameter.names()) {
            if (parameterName.startsWith("--")) {
                longOption = parameterName;
                continue;
            }
            if (!parameterName.startsWith("-")) continue;
            shortOption = parameterName;
        }
        return new Completers.OptDesc(shortOption, longOption, param.getDescription(), valueCompleter);
    }

    private static Completer getCompleter(ParameterDescription param, ShellContext shellContext) {
        boolean isBooleanArg;
        Completer valueCompleter = null;
        boolean bl = isBooleanArg = param.getObject() instanceof Boolean || param.getDefault() instanceof Boolean || param.getObject().getClass().isAssignableFrom(Boolean.class);
        if (!isBooleanArg && (valueCompleter = JCommanderCompleter.getCustomCompleter(param, shellContext)) == null) {
            valueCompleter = Completers.AnyCompleter.INSTANCE;
        }
        return valueCompleter;
    }

    private static Completer getCustomCompleter(ParameterDescription param, final ShellContext shellContext) {
        Completer valueCompleter = null;
        Field reflField = param.getParameterized().getClass().getDeclaredField("field");
        reflField.setAccessible(true);
        Field field = (Field)reflField.get(param.getParameterized());
        ParameterCompleter parameterCompleter = field.getAnnotation(ParameterCompleter.class);
        if (parameterCompleter != null) {
            ParameterCompleter.Type completer = parameterCompleter.type();
            if (completer == ParameterCompleter.Type.FILES) {
                valueCompleter = new Completers.FilesCompleter(new File(System.getProperty("user.dir")));
            } else if (completer == ParameterCompleter.Type.CONFIGS) {
                valueCompleter = new Completer(){

                    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
                        new StringsCompleter((Iterable)shellContext.configStore.listConfigs().stream().map(ConfigStore.ConfigEntry::getName).collect(Collectors.toList())).complete(reader, line, candidates);
                    }
                };
            }
        }
        return valueCompleter;
    }

    public static class ShellContext {
        private final ConfigStore configStore;

        public ShellContext(ConfigStore configStore) {
            this.configStore = configStore;
        }

        public ConfigStore getConfigStore() {
            return this.configStore;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ParameterCompleter {
        public Type type();

        public static enum Type {
            FILES,
            CONFIGS;

        }
    }
}

