/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shell;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.pulsar.shell.JCommanderCompleter;
import org.apache.pulsar.shell.PulsarShell;
import org.apache.pulsar.shell.ShellCommandsProvider;
import org.apache.pulsar.shell.config.ConfigStore;

@Parameters(commandDescription="Manage Pulsar shell configurations.")
public class ConfigShell
implements ShellCommandsProvider {
    private JCommander jcommander;
    private Params params;
    private final PulsarShell pulsarShell;
    private final Map<String, RunnableWithResult> commands = new HashMap<String, RunnableWithResult>();
    private final ConfigStore configStore;
    private final ObjectMapper writer = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private String currentConfig = "default";

    public ConfigShell(PulsarShell pulsarShell) {
        this.configStore = pulsarShell.getConfigStore();
        this.pulsarShell = pulsarShell;
    }

    @Override
    public String getName() {
        return "config";
    }

    @Override
    public String getServiceUrl() {
        return null;
    }

    @Override
    public String getAdminUrl() {
        return null;
    }

    @Override
    public void setupState(Properties properties) {
        this.params = new Params();
        this.jcommander = new JCommander();
        this.jcommander.addObject((Object)this.params);
        this.commands.put("list", new CmdConfigList());
        this.commands.put("create", new CmdConfigCreate());
        this.commands.put("update", new CmdConfigUpdate());
        this.commands.put("delete", new CmdConfigDelete());
        this.commands.put("use", new CmdConfigUse());
        this.commands.put("view", new CmdConfigView());
        this.commands.forEach((k, v) -> this.jcommander.addCommand(k, v));
    }

    @Override
    public void cleanupState(Properties properties) {
        this.setupState(properties);
    }

    @Override
    public JCommander getJCommander() {
        return this.jcommander;
    }

    @Override
    public boolean runCommand(String[] args) throws Exception {
        try {
            this.jcommander.parse(args);
            if (this.params.help) {
                this.jcommander.usage();
                return true;
            }
            String chosenCommand = this.jcommander.getParsedCommand();
            RunnableWithResult command = this.commands.get(chosenCommand);
            if (command == null) {
                this.jcommander.usage();
                return false;
            }
            return command.run();
        }
        catch (Throwable e) {
            this.jcommander.getConsole().println(e.getMessage());
            String chosenCommand = this.jcommander.getParsedCommand();
            if (e instanceof ParameterException) {
                try {
                    this.jcommander.getUsageFormatter().usage(chosenCommand);
                }
                catch (ParameterException noCmd) {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
            return false;
        }
    }

    <T> void print(List<T> items) {
        for (T item : items) {
            this.print(item);
        }
    }

    <T> void print(T item) {
        try {
            if (item instanceof String) {
                this.jcommander.getConsole().println((String)item);
            } else {
                this.jcommander.getConsole().println(this.writer.writeValueAsString(item));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getCurrentConfig() {
        return this.currentConfig;
    }

    @Parameters
    public static class Params {
        @Parameter(names={"-h", "--help"}, help=true, description="Show this help.")
        boolean help;

        public boolean isHelp() {
            return this.help;
        }
    }

    @Parameters(commandDescription="List configurations")
    private class CmdConfigList
    implements RunnableWithResult {
        private CmdConfigList() {
        }

        @Override
        public boolean run() {
            ConfigShell.this.print(ConfigShell.this.configStore.listConfigs().stream().map(e -> this.formatEntry((ConfigStore.ConfigEntry)e)).collect(Collectors.toList()));
            return true;
        }

        private String formatEntry(ConfigStore.ConfigEntry entry) {
            String name = entry.getName();
            if (name.equals(ConfigShell.this.currentConfig)) {
                return name + " (*)";
            }
            return name;
        }
    }

    @Parameters(commandDescription="Create a new configuration.")
    private class CmdConfigCreate
    extends CmdConfigPut {
        private CmdConfigCreate() {
        }

        @Override
        boolean verifyCondition() {
            boolean exists;
            boolean bl = exists = ConfigShell.this.configStore.getConfig(this.name) != null;
            if (exists) {
                ConfigShell.this.print("Config '" + this.name + "' already exists.");
                return false;
            }
            return true;
        }
    }

    @Parameters(commandDescription="Update an existing configuration.")
    private class CmdConfigUpdate
    extends CmdConfigPut {
        private CmdConfigUpdate() {
        }

        @Override
        boolean verifyCondition() {
            boolean exists;
            if ("default".equals(this.name)) {
                ConfigShell.this.print("'" + this.name + "' can't be updated.");
                return false;
            }
            boolean bl = exists = ConfigShell.this.configStore.getConfig(this.name) != null;
            if (!exists) {
                ConfigShell.this.print("Config '" + this.name + "' does not exist.");
                return false;
            }
            return true;
        }
    }

    @Parameters(commandDescription="Delete a configuration")
    private class CmdConfigDelete
    implements RunnableWithResult {
        @Parameter(description="Name of the config", required=true)
        @JCommanderCompleter.ParameterCompleter(type=JCommanderCompleter.ParameterCompleter.Type.CONFIGS)
        private String name;

        private CmdConfigDelete() {
        }

        @Override
        public boolean run() {
            if ("default".equals(this.name)) {
                ConfigShell.this.print("'" + this.name + "' can't be deleted.");
                return false;
            }
            if (ConfigShell.this.currentConfig != null && ConfigShell.this.currentConfig.equals(this.name)) {
                ConfigShell.this.print("'" + this.name + "' is currently used and it can't be deleted.");
                return false;
            }
            ConfigShell.this.configStore.deleteConfig(this.name);
            return true;
        }
    }

    @Parameters(commandDescription="Use the configuration for next commands")
    private class CmdConfigUse
    implements RunnableWithResult {
        @Parameter(description="Name of the config", required=true)
        @JCommanderCompleter.ParameterCompleter(type=JCommanderCompleter.ParameterCompleter.Type.CONFIGS)
        private String name;

        private CmdConfigUse() {
        }

        @Override
        public boolean run() {
            ConfigStore.ConfigEntry config = ConfigShell.this.configStore.getConfig(this.name);
            if (config == null) {
                ConfigShell.this.print("Config " + this.name + " not found");
                return false;
            }
            String value = config.getValue();
            ConfigShell.this.currentConfig = this.name;
            Properties properties = new Properties();
            properties.load(new StringReader(value));
            ConfigShell.this.pulsarShell.reload(properties);
            ConfigShell.this.configStore.setLastUsed(this.name);
            return true;
        }
    }

    @Parameters(commandDescription="View configuration")
    private class CmdConfigView
    implements RunnableWithResult {
        @Parameter(description="Name of the config", required=true)
        @JCommanderCompleter.ParameterCompleter(type=JCommanderCompleter.ParameterCompleter.Type.CONFIGS)
        private String name;

        private CmdConfigView() {
        }

        @Override
        public boolean run() {
            ConfigStore.ConfigEntry config = ConfigShell.this.configStore.getConfig(this.name);
            if (config == null) {
                ConfigShell.this.print("Config " + this.name + " not found");
                return false;
            }
            ConfigShell.this.print(config.getValue());
            return true;
        }
    }

    private static interface RunnableWithResult {
        public boolean run() throws Exception;
    }

    private abstract class CmdConfigPut
    implements RunnableWithResult {
        @Parameter(description="Configuration name", required=true)
        @JCommanderCompleter.ParameterCompleter(type=JCommanderCompleter.ParameterCompleter.Type.CONFIGS)
        protected String name;
        @Parameter(names={"--url"}, description="URL of the config")
        protected String url;
        @Parameter(names={"--file"}, description="File path of the config")
        @JCommanderCompleter.ParameterCompleter(type=JCommanderCompleter.ParameterCompleter.Type.FILES)
        protected String file;
        @Parameter(names={"--value"}, description="Inline value of the config")
        protected String inlineValue;

        private CmdConfigPut() {
        }

        @Override
        public boolean run() {
            String value;
            if (!this.verifyCondition()) {
                return false;
            }
            if (this.inlineValue != null) {
                if (this.inlineValue.startsWith("base64:")) {
                    byte[] bytes = Base64.getDecoder().decode(this.inlineValue.substring("base64:".length()));
                    value = new String(bytes, StandardCharsets.UTF_8);
                } else {
                    value = this.inlineValue;
                }
            } else if (this.file != null) {
                File f = new File(this.file);
                if (!f.exists()) {
                    ConfigShell.this.print("File " + f.getAbsolutePath() + " not found.");
                    return false;
                }
                value = new String(Files.readAllBytes(f.toPath()), StandardCharsets.UTF_8);
            } else if (this.url != null) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try (InputStream in = URI.create(this.url).toURL().openStream();){
                    IOUtils.copy((InputStream)in, (OutputStream)bout);
                }
                catch (IOException | IllegalArgumentException e) {
                    ConfigShell.this.print("Failed to download configuration: " + e.getMessage());
                    return false;
                }
                value = new String(bout.toByteArray(), StandardCharsets.UTF_8);
            } else {
                ConfigShell.this.print("At least one between --file, --url or --value is required.");
                return false;
            }
            ConfigShell.this.configStore.putConfig(new ConfigStore.ConfigEntry(this.name, value));
            if (ConfigShell.this.currentConfig.equals(this.name)) {
                Properties properties = new Properties();
                properties.load(new StringReader(value));
                ConfigShell.this.pulsarShell.reload(properties);
            }
            return true;
        }

        abstract boolean verifyCondition();
    }
}

