/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.annotations.VisibleForTesting;
import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.CmdBookies;
import org.apache.pulsar.admin.cli.CmdBrokerStats;
import org.apache.pulsar.admin.cli.CmdBrokers;
import org.apache.pulsar.admin.cli.CmdClusters;
import org.apache.pulsar.admin.cli.CmdFunctionWorker;
import org.apache.pulsar.admin.cli.CmdFunctions;
import org.apache.pulsar.admin.cli.CmdGenerateDocument;
import org.apache.pulsar.admin.cli.CmdNamespaceIsolationPolicy;
import org.apache.pulsar.admin.cli.CmdNamespaces;
import org.apache.pulsar.admin.cli.CmdNonPersistentTopics;
import org.apache.pulsar.admin.cli.CmdPackages;
import org.apache.pulsar.admin.cli.CmdPersistentTopics;
import org.apache.pulsar.admin.cli.CmdProxyStats;
import org.apache.pulsar.admin.cli.CmdResourceGroups;
import org.apache.pulsar.admin.cli.CmdResourceQuotas;
import org.apache.pulsar.admin.cli.CmdSchemas;
import org.apache.pulsar.admin.cli.CmdSinks;
import org.apache.pulsar.admin.cli.CmdSources;
import org.apache.pulsar.admin.cli.CmdTenants;
import org.apache.pulsar.admin.cli.CmdTopicPolicies;
import org.apache.pulsar.admin.cli.CmdTopics;
import org.apache.pulsar.admin.cli.CmdTransactions;
import org.apache.pulsar.admin.cli.CustomCommandsUtils;
import org.apache.pulsar.admin.cli.extensions.CommandExecutionContext;
import org.apache.pulsar.admin.cli.extensions.CustomCommandFactory;
import org.apache.pulsar.admin.cli.extensions.CustomCommandGroup;
import org.apache.pulsar.admin.cli.utils.CustomCommandFactoryProvider;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;

public class PulsarAdminTool {
    private static boolean allowSystemExit = true;
    private static int lastExitCode = Integer.MIN_VALUE;
    protected List<CustomCommandFactory> customCommandFactories = new ArrayList<CustomCommandFactory>();
    protected Map<String, Class<?>> commandMap;
    protected JCommander jcommander;
    protected final PulsarAdminBuilder adminBuilder;
    protected RootParams rootParams;
    private final Properties properties;

    public PulsarAdminTool(Properties properties) throws Exception {
        this.properties = properties;
        this.rootParams = new RootParams();
        this.initRootParamsFromProperties(properties);
        this.adminBuilder = this.createAdminBuilder(properties);
        this.initJCommander();
    }

    protected PulsarAdminBuilder createAdminBuilder(Properties properties) {
        boolean useKeyStoreTls = Boolean.parseBoolean(properties.getProperty("useKeyStoreTls", "false"));
        String tlsTrustStoreType = properties.getProperty("tlsTrustStoreType", "JKS");
        String tlsTrustStorePath = properties.getProperty("tlsTrustStorePath");
        String tlsTrustStorePassword = properties.getProperty("tlsTrustStorePassword");
        String tlsKeyStoreType = properties.getProperty("tlsKeyStoreType", "JKS");
        String tlsKeyStorePath = properties.getProperty("tlsKeyStorePath");
        String tlsKeyStorePassword = properties.getProperty("tlsKeyStorePassword");
        String tlsKeyFilePath = properties.getProperty("tlsKeyFilePath");
        String tlsCertificateFilePath = properties.getProperty("tlsCertificateFilePath");
        boolean tlsAllowInsecureConnection = this.rootParams.tlsAllowInsecureConnection != null ? this.rootParams.tlsAllowInsecureConnection : Boolean.parseBoolean(properties.getProperty("tlsAllowInsecureConnection", "false"));
        boolean tlsEnableHostnameVerification = this.rootParams.tlsEnableHostnameVerification != null ? this.rootParams.tlsEnableHostnameVerification : Boolean.parseBoolean(properties.getProperty("tlsEnableHostnameVerification", "false"));
        String tlsTrustCertsFilePath = StringUtils.isNotBlank((CharSequence)this.rootParams.tlsTrustCertsFilePath) ? this.rootParams.tlsTrustCertsFilePath : properties.getProperty("tlsTrustCertsFilePath");
        return PulsarAdmin.builder().allowTlsInsecureConnection(tlsAllowInsecureConnection).enableTlsHostnameVerification(tlsEnableHostnameVerification).tlsTrustCertsFilePath(tlsTrustCertsFilePath).useKeyStoreTls(useKeyStoreTls).tlsTrustStoreType(tlsTrustStoreType).tlsTrustStorePath(tlsTrustStorePath).tlsTrustStorePassword(tlsTrustStorePassword).tlsKeyStoreType(tlsKeyStoreType).tlsKeyStorePath(tlsKeyStorePath).tlsKeyStorePassword(tlsKeyStorePassword).tlsKeyFilePath(tlsKeyFilePath).tlsCertificateFilePath(tlsCertificateFilePath);
    }

    protected void initRootParamsFromProperties(Properties properties) {
        this.rootParams.serviceUrl = StringUtils.isNotBlank((CharSequence)properties.getProperty("webServiceUrl")) ? properties.getProperty("webServiceUrl") : properties.getProperty("serviceUrl");
        this.rootParams.authPluginClassName = properties.getProperty("authPlugin");
        this.rootParams.authParams = properties.getProperty("authParams");
    }

    public void setupCommands(Function<PulsarAdminBuilder, ? extends PulsarAdmin> adminFactory) {
        try {
            final PulsarAdminSupplier admin = new PulsarAdminSupplier(this.adminBuilder, adminFactory);
            for (Map.Entry<String, Class<?>> c : this.commandMap.entrySet()) {
                this.addCommand(c, admin);
            }
            CommandExecutionContext context = new CommandExecutionContext(){

                public PulsarAdmin getPulsarAdmin() {
                    return (PulsarAdmin)admin.get();
                }

                public Properties getConfiguration() {
                    return PulsarAdminTool.this.properties;
                }
            };
            this.loadCustomCommandFactories();
            for (CustomCommandFactory factory : this.customCommandFactories) {
                List customCommandGroups = factory.commandGroups(context);
                for (CustomCommandGroup group : customCommandGroups) {
                    Object generated = CustomCommandsUtils.generateCliCommand(group, context, admin);
                    this.jcommander.addCommand(group.name(), generated);
                    this.commandMap.put(group.name(), null);
                }
            }
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException && null != e.getCause() ? e.getCause() : e;
            System.err.println(cause.getClass() + ": " + cause.getMessage());
            System.exit(1);
        }
    }

    private void loadCustomCommandFactories() throws Exception {
        this.customCommandFactories.addAll(CustomCommandFactoryProvider.createCustomCommandFactories(this.properties));
    }

    private void addCommand(Map.Entry<String, Class<?>> c, Supplier<PulsarAdmin> admin) throws Exception {
        if (c.getKey().equals("sources") || c.getKey().equals("source")) {
            this.jcommander.addCommand("sources", c.getValue().getConstructor(Supplier.class).newInstance(admin), new String[]{"source"});
        } else if (c.getKey().equals("sinks") || c.getKey().equals("sink")) {
            this.jcommander.addCommand("sinks", c.getValue().getConstructor(Supplier.class).newInstance(admin), new String[]{"sink"});
        } else if (c.getKey().equals("functions")) {
            this.jcommander.addCommand(c.getKey(), c.getValue().getConstructor(Supplier.class).newInstance(admin));
        } else if (c.getValue() != null) {
            this.jcommander.addCommand(c.getKey(), c.getValue().getConstructor(Supplier.class).newInstance(admin));
        }
    }

    protected boolean run(String[] args) {
        Function<PulsarAdminBuilder, ? extends PulsarAdmin> adminFactory = this.createAdminFactory(args);
        return this.run(args, adminFactory);
    }

    boolean run(String[] args, Function<PulsarAdminBuilder, ? extends PulsarAdmin> adminFactory) {
        int cmdPos;
        this.setupCommands(adminFactory);
        if (args.length == 0) {
            this.jcommander.usage();
            return false;
        }
        for (cmdPos = 0; cmdPos < args.length && !this.commandMap.containsKey(args[cmdPos]); ++cmdPos) {
        }
        try {
            this.jcommander.parse(Arrays.copyOfRange(args, 0, Math.min(cmdPos, args.length)));
            this.adminBuilder.serviceHttpUrl(this.rootParams.serviceUrl);
            this.adminBuilder.authentication(this.rootParams.authPluginClassName, this.rootParams.authParams);
            this.adminBuilder.requestTimeout(this.rootParams.requestTimeout, TimeUnit.SECONDS);
            if (StringUtils.isBlank((CharSequence)this.rootParams.tlsProvider)) {
                this.rootParams.tlsProvider = this.properties.getProperty("webserviceTlsProvider");
            }
            if (StringUtils.isNotBlank((CharSequence)this.rootParams.tlsProvider)) {
                this.adminBuilder.sslProvider(this.rootParams.tlsProvider);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println();
            this.jcommander.usage();
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.rootParams.serviceUrl)) {
            System.out.println("Can't find any admin url to use");
            this.jcommander.usage();
            return false;
        }
        if (this.rootParams.version) {
            System.out.println("Current version of pulsar admin client is: " + PulsarVersion.getVersion());
            return true;
        }
        if (this.rootParams.help) {
            this.jcommander.usage();
            return true;
        }
        if (cmdPos == args.length) {
            this.jcommander.usage();
            return false;
        }
        String cmd = args[cmdPos];
        if (cmd.equals("source")) {
            cmd = "sources";
        } else if (cmd.equals("sink")) {
            cmd = "sinks";
        }
        JCommander obj = (JCommander)this.jcommander.getCommands().get(cmd);
        CmdBase cmdObj = (CmdBase)obj.getObjects().get(0);
        return cmdObj.run(Arrays.copyOfRange(args, cmdPos + 1, args.length));
    }

    public static void main(String[] args) throws Exception {
        PulsarAdminTool tool;
        lastExitCode = 0;
        if (args.length == 0) {
            System.out.println("Usage: pulsar-admin CONF_FILE_PATH [options] [command] [command options]");
            PulsarAdminTool.exit(0);
            return;
        }
        String configFile = args[0];
        Properties properties = new Properties();
        if (configFile != null) {
            try (FileInputStream fis = new FileInputStream(configFile);){
                properties.load(fis);
            }
        }
        if ((tool = new PulsarAdminTool(properties)).run(args = Arrays.copyOfRange(args, 1, args.length))) {
            PulsarAdminTool.exit(0);
        } else {
            PulsarAdminTool.exit(1);
        }
    }

    private static void exit(int code) {
        lastExitCode = code;
        if (allowSystemExit) {
            Runtime.getRuntime().halt(code);
        } else {
            System.out.println("Exit code is " + code + " (System.exit not called, as we are in test mode)");
        }
    }

    private Function<PulsarAdminBuilder, ? extends PulsarAdmin> createAdminFactory(String[] args) {
        int cmdPos;
        for (cmdPos = 0; cmdPos < args.length && !this.commandMap.containsKey(args[cmdPos]); ++cmdPos) {
        }
        boolean isLocalRun = ++cmdPos < args.length && "localrun".equalsIgnoreCase(args[cmdPos]);
        Function<PulsarAdminBuilder, PulsarAdmin> adminFactory = isLocalRun ? adminBuilder -> null : adminBuilder -> {
            try {
                return adminBuilder.build();
            }
            catch (Exception ex) {
                System.err.println(ex.getClass() + ": " + ex.getMessage());
                PulsarAdminTool.exit(1);
                return null;
            }
        };
        return adminFactory;
    }

    static void setAllowSystemExit(boolean allowSystemExit) {
        PulsarAdminTool.allowSystemExit = allowSystemExit;
    }

    static int getLastExitCode() {
        return lastExitCode;
    }

    @VisibleForTesting
    static void resetLastExitCode() {
        lastExitCode = Integer.MIN_VALUE;
    }

    protected void initJCommander() {
        this.jcommander = new JCommander();
        this.jcommander.setProgramName("pulsar-admin");
        this.jcommander.addObject((Object)this.rootParams);
        this.commandMap = new HashMap();
        this.commandMap.put("clusters", CmdClusters.class);
        this.commandMap.put("ns-isolation-policy", CmdNamespaceIsolationPolicy.class);
        this.commandMap.put("brokers", CmdBrokers.class);
        this.commandMap.put("broker-stats", CmdBrokerStats.class);
        this.commandMap.put("tenants", CmdTenants.class);
        this.commandMap.put("resourcegroups", CmdResourceGroups.class);
        this.commandMap.put("properties", CmdTenants.CmdProperties.class);
        this.commandMap.put("namespaces", CmdNamespaces.class);
        this.commandMap.put("topics", CmdTopics.class);
        this.commandMap.put("topicPolicies", CmdTopicPolicies.class);
        this.commandMap.put("schemas", CmdSchemas.class);
        this.commandMap.put("bookies", CmdBookies.class);
        this.commandMap.put("persistent", CmdPersistentTopics.class);
        this.commandMap.put("non-persistent", CmdNonPersistentTopics.class);
        this.commandMap.put("resource-quotas", CmdResourceQuotas.class);
        this.commandMap.put("proxy-stats", CmdProxyStats.class);
        this.commandMap.put("functions", CmdFunctions.class);
        this.commandMap.put("functions-worker", CmdFunctionWorker.class);
        this.commandMap.put("sources", CmdSources.class);
        this.commandMap.put("sinks", CmdSinks.class);
        this.commandMap.put("documents", CmdGenerateDocument.class);
        this.commandMap.put("source", CmdSources.class);
        this.commandMap.put("sink", CmdSinks.class);
        this.commandMap.put("packages", CmdPackages.class);
        this.commandMap.put("transactions", CmdTransactions.class);
    }

    public static class RootParams {
        @Parameter(names={"--admin-url"}, description="Admin Service URL to which to connect.")
        String serviceUrl = null;
        @Parameter(names={"--auth-plugin"}, description="Authentication plugin class name.")
        String authPluginClassName = null;
        @Parameter(names={"--request-timeout"}, description="Request time out in seconds for the pulsar admin client for any request")
        int requestTimeout = 300;
        @Parameter(names={"--auth-params"}, description="Authentication parameters, whose format is determined by the implementation of method `configure` in authentication plugin class, for example \"key1:val1,key2:val2\" or \"{\"key1\":\"val1\",\"key2\":\"val2\"}.")
        String authParams = null;
        @Parameter(names={"--tls-allow-insecure"}, description="Allow TLS insecure connection")
        Boolean tlsAllowInsecureConnection;
        @Parameter(names={"--tls-trust-cert-path"}, description="Allow TLS trust cert file path")
        String tlsTrustCertsFilePath;
        @Parameter(names={"--tls-enable-hostname-verification"}, description="Enable TLS common name verification")
        Boolean tlsEnableHostnameVerification;
        @Parameter(names={"--tls-provider"}, description="Set up TLS provider. When TLS authentication with CACert is used, the valid value is either OPENSSL or JDK. When TLS authentication with KeyStore is used, available options can be SunJSSE, Conscrypt and so on.")
        String tlsProvider;
        @Parameter(names={"-v", "--version"}, description="Get version of pulsar admin client")
        boolean version;
        @Parameter(names={"-h", "--help"}, help=true, description="Show this help.")
        boolean help;

        public String getServiceUrl() {
            return this.serviceUrl;
        }

        public String getAuthPluginClassName() {
            return this.authPluginClassName;
        }

        public int getRequestTimeout() {
            return this.requestTimeout;
        }

        public String getAuthParams() {
            return this.authParams;
        }

        public Boolean getTlsAllowInsecureConnection() {
            return this.tlsAllowInsecureConnection;
        }

        public String getTlsTrustCertsFilePath() {
            return this.tlsTrustCertsFilePath;
        }

        public Boolean getTlsEnableHostnameVerification() {
            return this.tlsEnableHostnameVerification;
        }

        public String getTlsProvider() {
            return this.tlsProvider;
        }

        public boolean isVersion() {
            return this.version;
        }

        public boolean isHelp() {
            return this.help;
        }
    }

    private static class PulsarAdminSupplier
    implements Supplier<PulsarAdmin> {
        private final PulsarAdminBuilder pulsarAdminBuilder;
        private final Function<PulsarAdminBuilder, ? extends PulsarAdmin> adminFactory;
        private PulsarAdmin admin;

        private PulsarAdminSupplier(PulsarAdminBuilder pulsarAdminBuilder, Function<PulsarAdminBuilder, ? extends PulsarAdmin> adminFactory) {
            this.pulsarAdminBuilder = pulsarAdminBuilder;
            this.adminFactory = adminFactory;
        }

        @Override
        public PulsarAdmin get() {
            if (this.admin == null) {
                this.admin = this.adminFactory.apply(this.pulsarAdminBuilder);
            }
            return this.admin;
        }
    }
}

