/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.common.stats.AllocatorStats;
import org.apache.pulsar.common.util.ObjectMapperFactory;

@Parameters(commandDescription="Operations to collect broker statistics")
public class CmdBrokerStats
extends CmdBase {
    private static final String DEFAULT_INDENTATION = "    ";

    public CmdBrokerStats(Supplier<PulsarAdmin> admin) {
        super("broker-stats", admin);
        this.jcommander.addCommand("monitoring-metrics", (Object)new CmdMonitoringMetrics());
        this.jcommander.addCommand("mbeans", (Object)new CmdDumpMBeans());
        this.jcommander.addCommand("topics", (Object)new CmdTopics(), new String[]{"destinations"});
        this.jcommander.addCommand("allocator-stats", (Object)new CmdAllocatorStats());
        this.jcommander.addCommand("load-report", (Object)new CmdLoadReport());
    }

    @Parameters(commandDescription="dump allocator stats")
    private class CmdAllocatorStats
    extends CliCommand {
        @Parameter(description="allocator-name", required=true)
        private List<String> params;

        private CmdAllocatorStats() {
        }

        @Override
        void run() throws Exception {
            AllocatorStats stats = CmdBrokerStats.this.getAdmin().brokerStats().getAllocatorStats(this.params.get(0));
            ObjectMapper mapper = ObjectMapperFactory.create();
            ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);){
                out.write(writer.writeValueAsString((Object)stats));
                ((Writer)out).flush();
            }
        }
    }

    @Parameters(commandDescription="dump topics stats")
    private class CmdTopics
    extends CliCommand {
        @Parameter(names={"-i", "--indent"}, description="Indent JSON output", required=false)
        private boolean indent = false;

        private CmdTopics() {
        }

        @Override
        void run() throws Exception {
            String s = CmdBrokerStats.this.getAdmin().brokerStats().getTopics();
            JsonObject result = (JsonObject)new Gson().fromJson(s, JsonObject.class);
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);
                 JsonWriter jsonWriter = new JsonWriter((Writer)out);){
                if (this.indent) {
                    jsonWriter.setIndent(CmdBrokerStats.DEFAULT_INDENTATION);
                }
                new Gson().toJson((JsonElement)result, jsonWriter);
                ((Writer)out).flush();
            }
        }
    }

    @Parameters(commandDescription="dump broker load-report")
    private class CmdLoadReport
    extends CliCommand {
        private CmdLoadReport() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokerStats.this.getAdmin().brokerStats().getLoadReport());
        }
    }

    @Parameters(commandDescription="dump mbean stats")
    private class CmdDumpMBeans
    extends CliCommand {
        @Parameter(names={"-i", "--indent"}, description="Indent JSON output", required=false)
        private boolean indent = false;

        private CmdDumpMBeans() {
        }

        @Override
        void run() throws Exception {
            String s = CmdBrokerStats.this.getAdmin().brokerStats().getMBeans();
            JsonArray result = (JsonArray)new Gson().fromJson(s, JsonArray.class);
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);
                 JsonWriter jsonWriter = new JsonWriter((Writer)out);){
                if (this.indent) {
                    jsonWriter.setIndent(CmdBrokerStats.DEFAULT_INDENTATION);
                }
                new Gson().toJson((JsonElement)result, jsonWriter);
                ((Writer)out).flush();
            }
        }
    }

    @Parameters(commandDescription="dump metrics for Monitoring")
    private class CmdMonitoringMetrics
    extends CliCommand {
        @Parameter(names={"-i", "--indent"}, description="Indent JSON output", required=false)
        private boolean indent = false;

        private CmdMonitoringMetrics() {
        }

        @Override
        void run() throws Exception {
            String s = CmdBrokerStats.this.getAdmin().brokerStats().getMetrics();
            JsonArray metrics = (JsonArray)new Gson().fromJson(s, JsonArray.class);
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);
                 JsonWriter jsonWriter = new JsonWriter((Writer)out);){
                for (int i = 0; i < metrics.size(); ++i) {
                    JsonObject m = (JsonObject)metrics.get(i);
                    if (this.indent) {
                        jsonWriter.setIndent(CmdBrokerStats.DEFAULT_INDENTATION);
                        new Gson().toJson((JsonElement)m, jsonWriter);
                        ((Writer)out).write(10);
                        ((Writer)out).write(10);
                    } else {
                        new Gson().toJson((JsonElement)m, jsonWriter);
                    }
                    ((Writer)out).flush();
                }
            }
        }
    }
}

