/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.StringConverter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.utils.CmdUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.common.functions.ConsumerConfig;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.Resources;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.functions.UpdateOptionsImpl;
import org.apache.pulsar.common.functions.Utils;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.io.SinkConfig;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Interface for managing Pulsar IO sinks (egress data from Pulsar)")
public class CmdSinks
extends CmdBase {
    private static final Logger log = LoggerFactory.getLogger(CmdSinks.class);
    private final CreateSink createSink = new CreateSink();
    private final UpdateSink updateSink = new UpdateSink();
    private final DeleteSink deleteSink = new DeleteSink();
    private final ListSinks listSinks = new ListSinks();
    private final GetSink getSink = new GetSink();
    private final GetSinkStatus getSinkStatus = new GetSinkStatus();
    private final StopSink stopSink = new StopSink();
    private final StartSink startSink = new StartSink();
    private final RestartSink restartSink = new RestartSink();
    private final LocalSinkRunner localSinkRunner = new LocalSinkRunner();

    public CmdSinks(Supplier<PulsarAdmin> admin) {
        super("sinks", admin);
        this.jcommander.addCommand("create", (Object)this.createSink);
        this.jcommander.addCommand("update", (Object)this.updateSink);
        this.jcommander.addCommand("delete", (Object)this.deleteSink);
        this.jcommander.addCommand("list", (Object)this.listSinks);
        this.jcommander.addCommand("get", (Object)this.getSink);
        this.jcommander.addCommand("status", (Object)this.getSinkStatus, new String[]{"getstatus"});
        this.jcommander.addCommand("stop", (Object)this.stopSink);
        this.jcommander.addCommand("start", (Object)this.startSink);
        this.jcommander.addCommand("restart", (Object)this.restartSink);
        this.jcommander.addCommand("localrun", (Object)this.localSinkRunner);
        this.jcommander.addCommand("available-sinks", (Object)new ListBuiltInSinks());
        this.jcommander.addCommand("reload", (Object)new ReloadBuiltInSinks());
    }

    public CreateSink getCreateSink() {
        return this.createSink;
    }

    public UpdateSink getUpdateSink() {
        return this.updateSink;
    }

    public DeleteSink getDeleteSink() {
        return this.deleteSink;
    }

    public ListSinks getListSinks() {
        return this.listSinks;
    }

    public GetSink getGetSink() {
        return this.getSink;
    }

    public GetSinkStatus getGetSinkStatus() {
        return this.getSinkStatus;
    }

    public StopSink getStopSink() {
        return this.stopSink;
    }

    public StartSink getStartSink() {
        return this.startSink;
    }

    public RestartSink getRestartSink() {
        return this.restartSink;
    }

    public LocalSinkRunner getLocalSinkRunner() {
        return this.localSinkRunner;
    }

    @Parameters(commandDescription="Reload the available built-in connectors")
    public class ReloadBuiltInSinks
    extends BaseCommand {
        @Override
        void runCmd() throws Exception {
            CmdSinks.this.getAdmin().sinks().reloadBuiltInSinks();
        }
    }

    @Parameters(commandDescription="Get the list of Pulsar IO connector sinks supported by Pulsar cluster")
    public class ListBuiltInSinks
    extends BaseCommand {
        @Override
        void runCmd() throws Exception {
            CmdSinks.this.getAdmin().sinks().getBuiltInSinks().stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getSinkClass())).forEach(connector -> {
                System.out.println(connector.getName());
                System.out.println(WordUtils.wrap((String)connector.getDescription(), (int)80));
                System.out.println("----------------------------------------");
            });
        }
    }

    @Parameters(commandDescription="Starts sink instance")
    class StartSink
    extends SinkCommand {
        @Parameter(names={"--instance-id"}, description="The sink instanceId (start all instances if instance-id is not provided")
        protected String instanceId;

        StartSink() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)this.instanceId)) {
                try {
                    CmdSinks.this.getAdmin().sinks().startSink(this.tenant, this.namespace, this.sinkName, Integer.parseInt(this.instanceId));
                }
                catch (NumberFormatException e) {
                    System.err.println("instance-id must be a number");
                }
            } else {
                CmdSinks.this.getAdmin().sinks().startSink(this.tenant, this.namespace, this.sinkName);
            }
            System.out.println("Started successfully");
        }
    }

    @Parameters(commandDescription="Stops sink instance")
    class StopSink
    extends SinkCommand {
        @Parameter(names={"--instance-id"}, description="The sink instanceId (stop all instances if instance-id is not provided")
        protected String instanceId;

        StopSink() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)this.instanceId)) {
                try {
                    CmdSinks.this.getAdmin().sinks().stopSink(this.tenant, this.namespace, this.sinkName, Integer.parseInt(this.instanceId));
                }
                catch (NumberFormatException e) {
                    System.err.println("instance-id must be a number");
                }
            } else {
                CmdSinks.this.getAdmin().sinks().stopSink(this.tenant, this.namespace, this.sinkName);
            }
            System.out.println("Stopped successfully");
        }
    }

    @Parameters(commandDescription="Restart sink instance")
    class RestartSink
    extends SinkCommand {
        @Parameter(names={"--instance-id"}, description="The sink instanceId (restart all instances if instance-id is not provided")
        protected String instanceId;

        RestartSink() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)this.instanceId)) {
                try {
                    CmdSinks.this.getAdmin().sinks().restartSink(this.tenant, this.namespace, this.sinkName, Integer.parseInt(this.instanceId));
                }
                catch (NumberFormatException e) {
                    System.err.println("instance-id must be a number");
                }
            } else {
                CmdSinks.this.getAdmin().sinks().restartSink(this.tenant, this.namespace, this.sinkName);
            }
            System.out.println("Restarted successfully");
        }
    }

    @Parameters(commandDescription="Check the current status of a Pulsar Sink")
    class GetSinkStatus
    extends SinkCommand {
        @Parameter(names={"--instance-id"}, description="The sink instanceId (Get-status of all instances if instance-id is not provided")
        protected String instanceId;

        GetSinkStatus() {
        }

        @Override
        void runCmd() throws Exception {
            if (StringUtils.isBlank((CharSequence)this.instanceId)) {
                this.print(CmdSinks.this.getAdmin().sinks().getSinkStatus(this.tenant, this.namespace, this.sinkName));
            } else {
                this.print(CmdSinks.this.getAdmin().sinks().getSinkStatus(this.tenant, this.namespace, this.sinkName, Integer.parseInt(this.instanceId)));
            }
        }
    }

    @Parameters(commandDescription="List all running Pulsar IO sink connectors")
    protected class ListSinks
    extends BaseCommand {
        @Parameter(names={"--tenant"}, description="The sink's tenant")
        protected String tenant;
        @Parameter(names={"--namespace"}, description="The sink's namespace")
        protected String namespace;

        protected ListSinks() {
        }

        @Override
        public void processArguments() {
            if (this.tenant == null) {
                this.tenant = "public";
            }
            if (this.namespace == null) {
                this.namespace = "default";
            }
        }

        @Override
        void runCmd() throws Exception {
            List sinks = CmdSinks.this.getAdmin().sinks().listSinks(this.tenant, this.namespace);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            System.out.println(gson.toJson((Object)sinks));
        }
    }

    @Parameters(commandDescription="Gets the information about a Pulsar IO sink connector")
    protected class GetSink
    extends SinkCommand {
        protected GetSink() {
        }

        @Override
        void runCmd() throws Exception {
            SinkConfig sinkConfig = CmdSinks.this.getAdmin().sinks().getSink(this.tenant, this.namespace, this.sinkName);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            System.out.println(gson.toJson((Object)sinkConfig));
        }
    }

    @Parameters(commandDescription="Stops a Pulsar IO sink connector")
    protected class DeleteSink
    extends SinkCommand {
        protected DeleteSink() {
        }

        @Override
        void runCmd() throws Exception {
            CmdSinks.this.getAdmin().sinks().deleteSink(this.tenant, this.namespace, this.sinkName);
            this.print("Deleted successfully");
        }
    }

    abstract class SinkCommand
    extends BaseCommand {
        @Parameter(names={"--tenant"}, description="The sink's tenant")
        protected String tenant;
        @Parameter(names={"--namespace"}, description="The sink's namespace")
        protected String namespace;
        @Parameter(names={"--name"}, description="The sink's name")
        protected String sinkName;

        SinkCommand() {
        }

        @Override
        void processArguments() throws Exception {
            super.processArguments();
            if (this.tenant == null) {
                this.tenant = "public";
            }
            if (this.namespace == null) {
                this.namespace = "default";
            }
            if (null == this.sinkName) {
                throw new RuntimeException("You must specify a name for the sink");
            }
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getSinkName() {
            return this.sinkName;
        }
    }

    abstract class SinkDetailsCommand
    extends BaseCommand {
        @Parameter(names={"--tenant"}, description="The sink's tenant")
        protected String tenant;
        @Parameter(names={"--namespace"}, description="The sink's namespace")
        protected String namespace;
        @Parameter(names={"--name"}, description="The sink's name")
        protected String name;
        @Parameter(names={"-t", "--sink-type"}, description="The sinks's connector provider")
        protected String sinkType;
        @Parameter(names={"-i", "--inputs"}, description="The sink's input topic or topics (multiple topics can be specified as a comma-separated list)")
        protected String inputs;
        @Parameter(names={"--topicsPattern"}, description="TopicsPattern to consume from list of topics under a namespace that match the pattern. [--input] and [--topicsPattern] are mutually exclusive. Add SerDe class name for a pattern in --customSerdeInputs  (supported for java fun only)", hidden=true)
        protected String deprecatedTopicsPattern;
        @Parameter(names={"--topics-pattern"}, description="TopicsPattern to consume from list of topics under a namespace that match the pattern. [--input] and [--topicsPattern] are mutually exclusive. Add SerDe class name for a pattern in --customSerdeInputs  (supported for java fun only)")
        protected String topicsPattern;
        @Parameter(names={"--subsName"}, description="Pulsar source subscription name if user wants a specific subscription-name for input-topic consumer", hidden=true)
        protected String deprecatedSubsName;
        @Parameter(names={"--subs-name"}, description="Pulsar source subscription name if user wants a specific subscription-name for input-topic consumer")
        protected String subsName;
        @Parameter(names={"--subs-position"}, description="Pulsar source subscription position if user wants to consume messages from the specified location")
        protected SubscriptionInitialPosition subsPosition;
        @Parameter(names={"--customSerdeInputs"}, description="The map of input topics to SerDe class names (as a JSON string)", hidden=true)
        protected String deprecatedCustomSerdeInputString;
        @Parameter(names={"--custom-serde-inputs"}, description="The map of input topics to SerDe class names (as a JSON string)")
        protected String customSerdeInputString;
        @Parameter(names={"--custom-schema-inputs"}, description="The map of input topics to Schema types or class names (as a JSON string)")
        protected String customSchemaInputString;
        @Parameter(names={"--input-specs"}, description="The map of inputs to custom configuration (as a JSON string)")
        protected String inputSpecs;
        @Parameter(names={"--max-redeliver-count"}, description="Maximum number of times that a message will be redelivered before being sent to the dead letter queue")
        protected Integer maxMessageRetries;
        @Parameter(names={"--dead-letter-topic"}, description="Name of the dead topic where the failing messages will be sent.")
        protected String deadLetterTopic;
        @Parameter(names={"--processingGuarantees"}, description="The processing guarantees (aka delivery semantics) applied to the sink", hidden=true)
        protected FunctionConfig.ProcessingGuarantees deprecatedProcessingGuarantees;
        @Parameter(names={"--processing-guarantees"}, description="The processing guarantees (aka delivery semantics) applied to the sink")
        protected FunctionConfig.ProcessingGuarantees processingGuarantees;
        @Parameter(names={"--retainOrdering"}, description="Sink consumes and sinks messages in order", hidden=true)
        protected Boolean deprecatedRetainOrdering;
        @Parameter(names={"--retain-ordering"}, description="Sink consumes and sinks messages in order")
        protected Boolean retainOrdering;
        @Parameter(names={"--parallelism"}, description="The sink's parallelism factor (i.e. the number of sink instances to run)")
        protected Integer parallelism;
        @Parameter(names={"--retain-key-ordering"}, description="Sink consumes and processes messages in key order")
        protected Boolean retainKeyOrdering;
        @Parameter(names={"-a", "--archive"}, description="Path to the archive file for the sink. It also supports url-path [http/https/file (file protocol assumes that file already exists on worker host)] from which worker can download the package.", listConverter=StringConverter.class)
        protected String archive;
        @Parameter(names={"--className"}, description="The sink's class name if archive is file-url-path (file://)", hidden=true)
        protected String deprecatedClassName;
        @Parameter(names={"--classname"}, description="The sink's class name if archive is file-url-path (file://)")
        protected String className;
        @Parameter(names={"--sinkConfigFile"}, description="The path to a YAML config file specifying the sink's configuration", hidden=true)
        protected String deprecatedSinkConfigFile;
        @Parameter(names={"--sink-config-file"}, description="The path to a YAML config file specifying the sink's configuration")
        protected String sinkConfigFile;
        @Parameter(names={"--cpu"}, description="The CPU (in cores) that needs to be allocated per sink instance (applicable only to Docker runtime)")
        protected Double cpu;
        @Parameter(names={"--ram"}, description="The RAM (in bytes) that need to be allocated per sink instance (applicable only to the process and Docker runtimes)")
        protected Long ram;
        @Parameter(names={"--disk"}, description="The disk (in bytes) that need to be allocated per sink instance (applicable only to Docker runtime)")
        protected Long disk;
        @Parameter(names={"--sinkConfig"}, description="User defined configs key/values", hidden=true)
        protected String deprecatedSinkConfigString;
        @Parameter(names={"--sink-config"}, description="User defined configs key/values")
        protected String sinkConfigString;
        @Parameter(names={"--auto-ack"}, description="Whether or not the framework will automatically acknowledge messages", arity=1)
        protected Boolean autoAck;
        @Parameter(names={"--timeout-ms"}, description="The message timeout in milliseconds")
        protected Long timeoutMs;
        @Parameter(names={"--negative-ack-redelivery-delay-ms"}, description="The negative ack message redelivery delay in milliseconds")
        protected Long negativeAckRedeliveryDelayMs;
        @Parameter(names={"--custom-runtime-options"}, description="A string that encodes options to customize the runtime, see docs for configured runtime for details")
        protected String customRuntimeOptions;
        @Parameter(names={"--secrets"}, description="The map of secretName to an object that encapsulates how the secret is fetched by the underlying secrets provider")
        protected String secretsString;
        protected SinkConfig sinkConfig;

        SinkDetailsCommand() {
        }

        private void mergeArgs() {
            if (StringUtils.isBlank((CharSequence)this.subsName) && !StringUtils.isBlank((CharSequence)this.deprecatedSubsName)) {
                this.subsName = this.deprecatedSubsName;
            }
            if (StringUtils.isBlank((CharSequence)this.topicsPattern) && !StringUtils.isBlank((CharSequence)this.deprecatedTopicsPattern)) {
                this.topicsPattern = this.deprecatedTopicsPattern;
            }
            if (StringUtils.isBlank((CharSequence)this.customSerdeInputString) && !StringUtils.isBlank((CharSequence)this.deprecatedCustomSerdeInputString)) {
                this.customSerdeInputString = this.deprecatedCustomSerdeInputString;
            }
            if (this.processingGuarantees == null && this.deprecatedProcessingGuarantees != null) {
                this.processingGuarantees = this.deprecatedProcessingGuarantees;
            }
            if (this.retainOrdering == null && this.deprecatedRetainOrdering != null) {
                this.retainOrdering = this.deprecatedRetainOrdering;
            }
            if (StringUtils.isBlank((CharSequence)this.className) && !StringUtils.isBlank((CharSequence)this.deprecatedClassName)) {
                this.className = this.deprecatedClassName;
            }
            if (StringUtils.isBlank((CharSequence)this.sinkConfigFile) && !StringUtils.isBlank((CharSequence)this.deprecatedSinkConfigFile)) {
                this.sinkConfigFile = this.deprecatedSinkConfigFile;
            }
            if (StringUtils.isBlank((CharSequence)this.sinkConfigString) && !StringUtils.isBlank((CharSequence)this.deprecatedSinkConfigString)) {
                this.sinkConfigString = this.deprecatedSinkConfigString;
            }
        }

        @Override
        void processArguments() throws Exception {
            Type type;
            super.processArguments();
            this.mergeArgs();
            this.sinkConfig = null != this.sinkConfigFile ? CmdUtils.loadConfig(this.sinkConfigFile, SinkConfig.class) : new SinkConfig();
            if (null != this.tenant) {
                this.sinkConfig.setTenant(this.tenant);
            }
            if (null != this.namespace) {
                this.sinkConfig.setNamespace(this.namespace);
            }
            if (null != this.className) {
                this.sinkConfig.setClassName(this.className);
            }
            if (null != this.name) {
                this.sinkConfig.setName(this.name);
            }
            if (null != this.processingGuarantees) {
                this.sinkConfig.setProcessingGuarantees(this.processingGuarantees);
            }
            if (this.retainOrdering != null) {
                this.sinkConfig.setRetainOrdering(this.retainOrdering);
            }
            if (this.retainKeyOrdering != null) {
                this.sinkConfig.setRetainKeyOrdering(this.retainKeyOrdering);
            }
            if (null != this.inputs) {
                this.sinkConfig.setInputs(Arrays.asList(this.inputs.split(",")));
            }
            if (null != this.customSerdeInputString) {
                type = new TypeToken<Map<String, String>>(){}.getType();
                Map customSerdeInputMap = (Map)new Gson().fromJson(this.customSerdeInputString, type);
                this.sinkConfig.setTopicToSerdeClassName(customSerdeInputMap);
            }
            if (null != this.customSchemaInputString) {
                type = new TypeToken<Map<String, String>>(){}.getType();
                Map customSchemaInputMap = (Map)new Gson().fromJson(this.customSchemaInputString, type);
                this.sinkConfig.setTopicToSchemaType(customSchemaInputMap);
            }
            if (null != this.inputSpecs) {
                type = new TypeToken<Map<String, ConsumerConfig>>(){}.getType();
                this.sinkConfig.setInputSpecs((Map)new Gson().fromJson(this.inputSpecs, type));
            }
            this.sinkConfig.setMaxMessageRetries(this.maxMessageRetries);
            if (null != this.deadLetterTopic) {
                this.sinkConfig.setDeadLetterTopic(this.deadLetterTopic);
            }
            if (StringUtils.isNotBlank((CharSequence)this.subsName)) {
                this.sinkConfig.setSourceSubscriptionName(this.subsName);
            }
            if (null != this.subsPosition) {
                this.sinkConfig.setSourceSubscriptionPosition(this.subsPosition);
            }
            if (null != this.topicsPattern) {
                this.sinkConfig.setTopicsPattern(this.topicsPattern);
            }
            if (this.parallelism != null) {
                this.sinkConfig.setParallelism(this.parallelism);
            }
            if (this.archive != null && this.sinkType != null) {
                throw new ParameterException("Cannot specify both archive and sink-type");
            }
            if (null != this.archive) {
                this.sinkConfig.setArchive(this.archive);
            }
            if (this.sinkType != null) {
                this.sinkConfig.setArchive(this.validateSinkType(this.sinkType));
            }
            Resources resources = this.sinkConfig.getResources();
            if (this.cpu != null) {
                if (resources == null) {
                    resources = new Resources();
                }
                resources.setCpu(this.cpu);
            }
            if (this.ram != null) {
                if (resources == null) {
                    resources = new Resources();
                }
                resources.setRam(this.ram);
            }
            if (this.disk != null) {
                if (resources == null) {
                    resources = new Resources();
                }
                resources.setDisk(this.disk);
            }
            if (resources != null) {
                this.sinkConfig.setResources(resources);
            }
            try {
                if (null != this.sinkConfigString) {
                    this.sinkConfig.setConfigs(this.parseConfigs(this.sinkConfigString));
                }
            }
            catch (Exception ex) {
                throw new ParameterException("Cannot parse sink-config", (Throwable)ex);
            }
            if (this.autoAck != null) {
                this.sinkConfig.setAutoAck(this.autoAck);
            }
            if (this.timeoutMs != null) {
                this.sinkConfig.setTimeoutMs(this.timeoutMs);
            }
            if (this.negativeAckRedeliveryDelayMs != null && this.negativeAckRedeliveryDelayMs > 0L) {
                this.sinkConfig.setNegativeAckRedeliveryDelayMs(this.negativeAckRedeliveryDelayMs);
            }
            if (this.customRuntimeOptions != null) {
                this.sinkConfig.setCustomRuntimeOptions(this.customRuntimeOptions);
            }
            if (this.secretsString != null) {
                Type type2 = new TypeToken<Map<String, Object>>(){}.getType();
                Map secretsMap = (Map)new Gson().fromJson(this.secretsString, type2);
                if (secretsMap == null) {
                    secretsMap = Collections.emptyMap();
                }
                this.sinkConfig.setSecrets(secretsMap);
            }
            this.validateSinkConfigs(this.sinkConfig);
        }

        protected Map<String, Object> parseConfigs(String str) throws JsonProcessingException {
            ObjectMapper mapper = ObjectMapperFactory.getThreadLocal();
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            return (Map)mapper.readValue(str, (TypeReference)typeRef);
        }

        protected void validateSinkConfigs(SinkConfig sinkConfig) {
            if (StringUtils.isBlank((CharSequence)sinkConfig.getArchive())) {
                throw new ParameterException("Sink archive not specfied");
            }
            Utils.inferMissingArguments((SinkConfig)sinkConfig);
            if (!(Utils.isFunctionPackageUrlSupported((String)sinkConfig.getArchive()) || sinkConfig.getArchive().startsWith("builtin") || new File(sinkConfig.getArchive()).exists())) {
                throw new IllegalArgumentException(String.format("Sink Archive file %s does not exist", sinkConfig.getArchive()));
            }
        }

        protected String validateSinkType(String sinkType) throws IOException {
            Set availableSinks;
            try {
                availableSinks = CmdSinks.this.getAdmin().sinks().getBuiltInSinks().stream().map(ConnectorDefinition::getName).collect(Collectors.toSet());
            }
            catch (PulsarAdminException e) {
                throw new IOException(e);
            }
            if (!availableSinks.contains(sinkType)) {
                throw new ParameterException("Invalid sink type '" + sinkType + "' -- Available sinks are: " + availableSinks);
            }
            return "builtin://" + sinkType;
        }
    }

    @Parameters(commandDescription="Update a Pulsar IO sink connector")
    protected class UpdateSink
    extends SinkDetailsCommand {
        @Parameter(names={"--update-auth-data"}, description="Whether or not to update the auth data")
        protected boolean updateAuthData;

        protected UpdateSink() {
        }

        @Override
        void runCmd() throws Exception {
            UpdateOptionsImpl updateOptions = new UpdateOptionsImpl();
            updateOptions.setUpdateAuthData(this.updateAuthData);
            if (Utils.isFunctionPackageUrlSupported((String)this.archive)) {
                CmdSinks.this.getAdmin().sinks().updateSinkWithUrl(this.sinkConfig, this.sinkConfig.getArchive(), (UpdateOptions)updateOptions);
            } else {
                CmdSinks.this.getAdmin().sinks().updateSink(this.sinkConfig, this.sinkConfig.getArchive(), (UpdateOptions)updateOptions);
            }
            this.print("Updated successfully");
        }

        @Override
        protected void validateSinkConfigs(SinkConfig sinkConfig) {
            if (sinkConfig.getTenant() == null) {
                sinkConfig.setTenant("public");
            }
            if (sinkConfig.getNamespace() == null) {
                sinkConfig.setNamespace("default");
            }
        }
    }

    @Parameters(commandDescription="Submit a Pulsar IO sink connector to run in a Pulsar cluster")
    protected class CreateSink
    extends SinkDetailsCommand {
        protected CreateSink() {
        }

        @Override
        void runCmd() throws Exception {
            if (Utils.isFunctionPackageUrlSupported((String)this.archive)) {
                CmdSinks.this.getAdmin().sinks().createSinkWithUrl(this.sinkConfig, this.sinkConfig.getArchive());
            } else {
                CmdSinks.this.getAdmin().sinks().createSink(this.sinkConfig, this.sinkConfig.getArchive());
            }
            this.print("Created successfully");
        }
    }

    @Parameters(commandDescription="Run a Pulsar IO sink connector locally (rather than deploying it to the Pulsar cluster)")
    protected class LocalSinkRunner
    extends CreateSink {
        @Parameter(names={"--state-storage-service-url"}, description="The URL for the state storage service (the default is Apache BookKeeper)")
        protected String stateStorageServiceUrl;
        @Parameter(names={"--brokerServiceUrl"}, description="The URL for the Pulsar broker", hidden=true)
        protected String deprecatedBrokerServiceUrl;
        @Parameter(names={"--broker-service-url"}, description="The URL for the Pulsar broker")
        protected String brokerServiceUrl;
        @Parameter(names={"--clientAuthPlugin"}, description="Client authentication plugin using which function-process can connect to broker", hidden=true)
        protected String deprecatedClientAuthPlugin;
        @Parameter(names={"--client-auth-plugin"}, description="Client authentication plugin using which function-process can connect to broker")
        protected String clientAuthPlugin;
        @Parameter(names={"--clientAuthParams"}, description="Client authentication param", hidden=true)
        protected String deprecatedClientAuthParams;
        @Parameter(names={"--client-auth-params"}, description="Client authentication param")
        protected String clientAuthParams;
        @Parameter(names={"--use_tls"}, description="Use tls connection", hidden=true)
        protected Boolean deprecatedUseTls;
        @Parameter(names={"--use-tls"}, description="Use tls connection")
        protected boolean useTls;
        @Parameter(names={"--tls_allow_insecure"}, description="Allow insecure tls connection", hidden=true)
        protected Boolean deprecatedTlsAllowInsecureConnection;
        @Parameter(names={"--tls-allow-insecure"}, description="Allow insecure tls connection")
        protected boolean tlsAllowInsecureConnection;
        @Parameter(names={"--hostname_verification_enabled"}, description="Enable hostname verification", hidden=true)
        protected Boolean deprecatedTlsHostNameVerificationEnabled;
        @Parameter(names={"--hostname-verification-enabled"}, description="Enable hostname verification")
        protected boolean tlsHostNameVerificationEnabled;
        @Parameter(names={"--tls_trust_cert_path"}, description="tls trust cert file path", hidden=true)
        protected String deprecatedTlsTrustCertFilePath;
        @Parameter(names={"--tls-trust-cert-path"}, description="tls trust cert file path")
        protected String tlsTrustCertFilePath;
        @Parameter(names={"--secrets-provider-classname"}, description="Whats the classname for secrets provider")
        protected String secretsProviderClassName;
        @Parameter(names={"--secrets-provider-config"}, description="Config that needs to be passed to secrets provider")
        protected String secretsProviderConfig;
        @Parameter(names={"--metrics-port-start"}, description="The starting port range for metrics server")
        protected String metricsPortStart;

        protected LocalSinkRunner() {
        }

        private void mergeArgs() {
            if (StringUtils.isBlank((CharSequence)this.brokerServiceUrl) && !StringUtils.isBlank((CharSequence)this.deprecatedBrokerServiceUrl)) {
                this.brokerServiceUrl = this.deprecatedBrokerServiceUrl;
            }
            if (StringUtils.isBlank((CharSequence)this.clientAuthPlugin) && !StringUtils.isBlank((CharSequence)this.deprecatedClientAuthPlugin)) {
                this.clientAuthPlugin = this.deprecatedClientAuthPlugin;
            }
            if (StringUtils.isBlank((CharSequence)this.clientAuthParams) && !StringUtils.isBlank((CharSequence)this.deprecatedClientAuthParams)) {
                this.clientAuthParams = this.deprecatedClientAuthParams;
            }
            if (!this.useTls && this.deprecatedUseTls != null) {
                this.useTls = this.deprecatedUseTls;
            }
            if (!this.tlsAllowInsecureConnection && this.deprecatedTlsAllowInsecureConnection != null) {
                this.tlsAllowInsecureConnection = this.deprecatedTlsAllowInsecureConnection;
            }
            if (!this.tlsHostNameVerificationEnabled && this.deprecatedTlsHostNameVerificationEnabled != null) {
                this.tlsHostNameVerificationEnabled = this.deprecatedTlsHostNameVerificationEnabled;
            }
            if (StringUtils.isBlank((CharSequence)this.tlsTrustCertFilePath) && !StringUtils.isBlank((CharSequence)this.deprecatedTlsTrustCertFilePath)) {
                this.tlsTrustCertFilePath = this.deprecatedTlsTrustCertFilePath;
            }
        }

        @Override
        public void runCmd() throws Exception {
            this.mergeArgs();
            LinkedList<String> localRunArgs = new LinkedList<String>();
            localRunArgs.add(System.getenv("PULSAR_HOME") + "/bin/function-localrunner");
            localRunArgs.add("--sinkConfig");
            localRunArgs.add(new Gson().toJson((Object)this.sinkConfig));
            for (Field field : this.getClass().getDeclaredFields()) {
                Object value;
                if (field.getName().startsWith("DEPRECATED") || field.getName().contains("$") || (value = field.get(this)) == null) continue;
                localRunArgs.add("--" + field.getName());
                localRunArgs.add(value.toString());
            }
            ProcessBuilder processBuilder = new ProcessBuilder(localRunArgs).inheritIO();
            Process process = processBuilder.start();
            process.waitFor();
        }

        @Override
        protected String validateSinkType(String sinkType) {
            return sinkType;
        }
    }

    abstract class BaseCommand
    extends CliCommand {
        BaseCommand() {
        }

        @Override
        void run() throws Exception {
            try {
                this.processArguments();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.err.println();
                String chosenCommand = CmdSinks.this.jcommander.getParsedCommand();
                CmdSinks.this.getUsageFormatter().usage(chosenCommand);
                return;
            }
            this.runCmd();
        }

        void processArguments() throws Exception {
        }

        abstract void runCmd() throws Exception;
    }
}

