/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Strings;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.common.policies.data.BookieInfo;

@Parameters(commandDescription="Operations about bookies rack placement")
public class CmdBookies
extends CmdBase {
    public CmdBookies(Supplier<PulsarAdmin> admin) {
        super("bookies", admin);
        this.jcommander.addCommand("racks-placement", (Object)new GetAll());
        this.jcommander.addCommand("list-bookies", (Object)new ListBookies());
        this.jcommander.addCommand("get-bookie-rack", (Object)new GetBookie());
        this.jcommander.addCommand("delete-bookie-rack", (Object)new RemoveBookie());
        this.jcommander.addCommand("set-bookie-rack", (Object)new UpdateBookie());
    }

    @Parameters(commandDescription="Updates the rack placement information for a specific bookie in the cluster (note. bookie address format:`address:port`)")
    private class UpdateBookie
    extends CliCommand {
        private static final String PATH_SEPARATOR = "/";
        @Parameter(names={"-g", "--group"}, description="Bookie group name", required=false)
        private String group = "default";
        @Parameter(names={"-b", "--bookie"}, description="Bookie address (format: `address:port`)", required=true)
        private String bookieAddress;
        @Parameter(names={"-r", "--rack"}, description="Bookie rack name. If you set a bookie rack name to slash (/) or an empty string (\"\"): when using Pulsar earlier than 2.7.5, 2.8.3, and 2.9.2, an exception is thrown; if you use Pulsar 2.7.5, 2.8.3, 2.9.2 or later versions, it falls back to /default-rack or /default-region/default-rack.When `RackawareEnsemblePlacementPolicy` is enabled, the rack name is not allowed to contain slash (/) except for the beginning and end of the rack name string. For example, rack name like /rack0 is okay, but /rack/0 is not allowed. When `RegionawareEnsemblePlacementPolicy` is enabled, the rack name can only contain one slash (/) except for the beginning and end of the rack name string. For example, rack name like /region0/rack0 is okay, but /region0rack0 and /region0/rack/0 are not allowed.", required=true)
        private String bookieRack;
        @Parameter(names={"-hn", "--hostname"}, description="Bookie host name", required=false)
        private String bookieHost;

        private UpdateBookie() {
        }

        @Override
        void run() throws Exception {
            this.checkArgument(!Strings.isNullOrEmpty((String)this.bookieRack) && !this.bookieRack.trim().equals(PATH_SEPARATOR), "rack name is invalid, it should not be null, empty or '/'");
            CmdBookies.this.getAdmin().bookies().updateBookieRackInfo(this.bookieAddress, this.group, BookieInfo.builder().rack(this.bookieRack).hostname(this.bookieHost).build());
        }

        private void checkArgument(boolean expression, @NonNull Object errorMessage) {
            if (errorMessage == null) {
                throw new NullPointerException("errorMessage is marked non-null but is null");
            }
            if (!expression) {
                throw new IllegalArgumentException(String.valueOf(errorMessage));
            }
        }
    }

    @Parameters(commandDescription="Remove rack placement information for a specific bookie in the cluster")
    private class RemoveBookie
    extends CliCommand {
        @Parameter(names={"-b", "--bookie"}, description="Bookie address (format: `address:port`)", required=true)
        private String bookieAddress;

        private RemoveBookie() {
        }

        @Override
        void run() throws Exception {
            CmdBookies.this.getAdmin().bookies().deleteBookieRackInfo(this.bookieAddress);
        }
    }

    @Parameters(commandDescription="List bookies")
    private class ListBookies
    extends CliCommand {
        private ListBookies() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBookies.this.getAdmin().bookies().getBookies());
        }
    }

    @Parameters(commandDescription="Gets the rack placement information for a specific bookie in the cluster")
    private class GetBookie
    extends CliCommand {
        @Parameter(names={"-b", "--bookie"}, description="Bookie address (format: `address:port`)", required=true)
        private String bookieAddress;

        private GetBookie() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBookies.this.getAdmin().bookies().getBookieRackInfo(this.bookieAddress));
        }
    }

    @Parameters(commandDescription="Gets the rack placement information for all the bookies in the cluster")
    private class GetAll
    extends CliCommand {
        private GetAll() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBookies.this.getAdmin().bookies().getBookiesRackInfo());
        }
    }
}

