/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.TopicPolicies;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.util.RelativeTimeUtil;

@Parameters(commandDescription="Operations on persistent topics")
public class CmdTopicPolicies
extends CmdBase {
    public CmdTopicPolicies(Supplier<PulsarAdmin> admin) {
        super("topicPolicies", admin);
        this.jcommander.addCommand("get-retention", (Object)new GetRetention());
        this.jcommander.addCommand("set-retention", (Object)new SetRetention());
        this.jcommander.addCommand("remove-retention", (Object)new RemoveRetention());
        this.jcommander.addCommand("get-backlog-quota", (Object)new GetBacklogQuotaMap());
        this.jcommander.addCommand("set-backlog-quota", (Object)new SetBacklogQuota());
        this.jcommander.addCommand("remove-backlog-quota", (Object)new RemoveBacklogQuota());
        this.jcommander.addCommand("get-persistence", (Object)new GetPersistence());
        this.jcommander.addCommand("set-persistence", (Object)new SetPersistence());
        this.jcommander.addCommand("remove-persistence", (Object)new RemovePersistence());
    }

    private TopicPolicies getTopicPolicies(boolean isGlobal) {
        return this.getAdmin().topicPolicies(isGlobal);
    }

    @Parameters(commandDescription="Remove the persistence policy for a topic")
    private class RemovePersistence
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously", arity=0)
        private boolean isGlobal = false;

        private RemovePersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemovePersistence.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removePersistence(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set the persistence policies for a topic")
    private class SetPersistence
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-e", "--bookkeeper-ensemble"}, description="Number of bookies to use for a topic", required=true)
        private int bookkeeperEnsemble;
        @Parameter(names={"-w", "--bookkeeper-write-quorum"}, description="How many writes to make of each entry", required=true)
        private int bookkeeperWriteQuorum;
        @Parameter(names={"-a", "--bookkeeper-ack-quorum"}, description="Number of acks (guaranteed copies) to wait for each entry", required=true)
        private int bookkeeperAckQuorum;
        @Parameter(names={"-r", "--ml-mark-delete-max-rate"}, description="Throttling rate of mark-delete operation (0 means no throttle)", required=true)
        private double managedLedgerMaxMarkDeleteRate;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously", arity=0)
        private boolean isGlobal = false;

        private SetPersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetPersistence.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setPersistence(persistentTopic, new PersistencePolicies(this.bookkeeperEnsemble, this.bookkeeperWriteQuorum, this.bookkeeperAckQuorum, this.managedLedgerMaxMarkDeleteRate));
        }
    }

    @Parameters(commandDescription="Get the persistence policies for a topic")
    private class GetPersistence
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies", arity=0)
        private boolean isGlobal = false;

        private GetPersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetPersistence.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getPersistence(persistentTopic));
        }
    }

    @Parameters(commandDescription="Remove a backlog quota policy from a topic")
    private class RemoveBacklogQuota
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-t", "--type"}, description="Backlog quota type to remove")
        private String backlogQuotaType = BacklogQuota.BacklogQuotaType.destination_storage.name();
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private RemoveBacklogQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveBacklogQuota.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeBacklogQuota(persistentTopic, BacklogQuota.BacklogQuotaType.valueOf((String)this.backlogQuotaType));
        }
    }

    @Parameters(commandDescription="Set a backlog quota policy for a topic")
    private class SetBacklogQuota
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-l", "--limit"}, description="Size limit (eg: 10M, 16G)")
        private String limitStr = "-1";
        @Parameter(names={"-lt", "--limitTime"}, description="Time limit in second, non-positive number for disabling time limit.")
        private int limitTime = -1;
        @Parameter(names={"-p", "--policy"}, description="Retention policy to enforce when the limit is reached. Valid options are: [producer_request_hold, producer_exception, consumer_backlog_eviction]", required=true)
        private String policyStr;
        @Parameter(names={"-t", "--type"}, description="Backlog quota type to set. Valid options are: destination_storage and message_age. destination_storage limits backlog by size (in bytes). message_age limits backlog by time, that is, message timestamp (broker or publish timestamp). You can set size or time to control the backlog, or combine them together to control the backlog. ")
        private String backlogQuotaTypeStr = BacklogQuota.BacklogQuotaType.destination_storage.name();
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private SetBacklogQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            BacklogQuota.BacklogQuotaType backlogQuotaType;
            BacklogQuota.RetentionPolicy policy;
            try {
                policy = BacklogQuota.RetentionPolicy.valueOf((String)this.policyStr);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException(String.format("Invalid retention policy type '%s'. Valid options are: %s", this.policyStr, Arrays.toString(BacklogQuota.RetentionPolicy.values())));
            }
            long limit = SetBacklogQuota.validateSizeString(this.limitStr);
            try {
                backlogQuotaType = BacklogQuota.BacklogQuotaType.valueOf((String)this.backlogQuotaTypeStr);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException(String.format("Invalid backlog quota type '%s'. Valid options are: %s", this.backlogQuotaTypeStr, Arrays.toString(BacklogQuota.BacklogQuotaType.values())));
            }
            String persistentTopic = SetBacklogQuota.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setBacklogQuota(persistentTopic, BacklogQuota.builder().limitSize(limit).limitTime(this.limitTime).retentionPolicy(policy).build(), backlogQuotaType);
        }
    }

    @Parameters(commandDescription="Get the backlog quota policies for a topic")
    private class GetBacklogQuotaMap
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private GetBacklogQuotaMap() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetBacklogQuotaMap.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getBacklogQuotaMap(persistentTopic, this.applied));
        }
    }

    @Parameters(commandDescription="Remove the retention policy for a topic")
    private class RemoveRetention
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously", arity=0)
        private boolean isGlobal = false;

        private RemoveRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveRetention.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeRetention(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set the retention policy for a topic")
    private class SetRetention
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--time", "-t"}, description="Retention time in minutes (or minutes, hours,days,weeks eg: 100m, 3h, 2d, 5w). 0 means no retention and -1 means infinite time retention", required=true)
        private String retentionTimeStr;
        @Parameter(names={"--size", "-s"}, description="Retention size limit (eg: 10M, 16G, 3T). 0 or less than 1MB means no retention and -1 means infinite size retention", required=true)
        private String limitStr;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously")
        private boolean isGlobal = false;

        private SetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetRetention.validatePersistentTopic(this.params);
            long sizeLimit = SetRetention.validateSizeString(this.limitStr);
            long retentionTimeInSec = RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.retentionTimeStr);
            int retentionTimeInMin = retentionTimeInSec != -1L ? (int)TimeUnit.SECONDS.toMinutes(retentionTimeInSec) : -1;
            int retentionSizeInMB = sizeLimit != -1L ? (int)(sizeLimit / 0x100000L) : -1;
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setRetention(persistentTopic, new RetentionPolicies(retentionTimeInMin, retentionSizeInMB));
        }
    }

    @Parameters(commandDescription="Get the retention policy for a topic")
    private class GetRetention
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies")
        private boolean isGlobal = false;

        private GetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetRetention.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getRetention(persistentTopic, this.applied));
        }
    }
}

