/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.TopicPolicies;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.util.RelativeTimeUtil;

@Parameters(commandDescription="Operations on persistent topics")
public class CmdTopicPolicies
extends CmdBase {
    public CmdTopicPolicies(Supplier<PulsarAdmin> admin) {
        super("topicPolicies", admin);
        this.jcommander.addCommand("get-retention", (Object)new GetRetention());
        this.jcommander.addCommand("set-retention", (Object)new SetRetention());
        this.jcommander.addCommand("remove-retention", (Object)new RemoveRetention());
    }

    private TopicPolicies getTopicPolicies(boolean isGlobal) {
        return this.getAdmin().topicPolicies(isGlobal);
    }

    @Parameters(commandDescription="Remove the retention policy for a topic")
    private class RemoveRetention
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously", arity=0)
        private boolean isGlobal = false;

        private RemoveRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveRetention.validatePersistentTopic(this.params);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeRetention(persistentTopic);
        }
    }

    @Parameters(commandDescription="Set the retention policy for a topic")
    private class SetRetention
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"--time", "-t"}, description="Retention time in minutes (or minutes, hours,days,weeks eg: 100m, 3h, 2d, 5w). 0 means no retention and -1 means infinite time retention", required=true)
        private String retentionTimeStr;
        @Parameter(names={"--size", "-s"}, description="Retention size limit (eg: 10M, 16G, 3T). 0 or less than 1MB means no retention and -1 means infinite size retention", required=true)
        private String limitStr;
        @Parameter(names={"--global", "-g"}, description="Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously", arity=0)
        private boolean isGlobal = false;

        private SetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetRetention.validatePersistentTopic(this.params);
            long sizeLimit = SetRetention.validateSizeString(this.limitStr);
            long retentionTimeInSec = RelativeTimeUtil.parseRelativeTimeInSeconds((String)this.retentionTimeStr);
            int retentionTimeInMin = retentionTimeInSec != -1L ? (int)TimeUnit.SECONDS.toMinutes(retentionTimeInSec) : -1;
            int retentionSizeInMB = sizeLimit != -1L ? (int)(sizeLimit / 0x100000L) : -1;
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setRetention(persistentTopic, new RetentionPolicies(retentionTimeInMin, retentionSizeInMB));
        }
    }

    @Parameters(commandDescription="Get the retention policy for a topic")
    private class GetRetention
    extends CliCommand {
        @Parameter(description="persistent://tenant/namespace/topic", required=true)
        private List<String> params;
        @Parameter(names={"-ap", "--applied"}, description="Get the applied policy of the topic")
        private boolean applied = false;
        @Parameter(names={"--global", "-g"}, description="Whether to get this policy globally. If set to true, broker returned global topic policies", arity=0)
        private boolean isGlobal = false;

        private GetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetRetention.validatePersistentTopic(this.params);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getRetention(persistentTopic, this.applied));
        }
    }
}

