/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.beust.jcommander.ParameterException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.util.ObjectMapperFactory;

abstract class CliCommand {
    private static ObjectMapper mapper = ObjectMapperFactory.create();
    private static ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();

    CliCommand() {
    }

    static String[] validatePropertyCluster(List<String> params) {
        return CliCommand.splitParameter(params, 2);
    }

    static String validateNamespace(List<String> params) {
        String namespace = CliCommand.checkArgument(params);
        return NamespaceName.get((String)namespace).toString();
    }

    static String validateTopicName(List<String> params) {
        String topic = CliCommand.checkArgument(params);
        return TopicName.get((String)topic).toString();
    }

    static String validatePersistentTopic(List<String> params) {
        String topic = CliCommand.checkArgument(params);
        TopicName topicName = TopicName.get((String)topic);
        if (topicName.getDomain() != TopicDomain.persistent) {
            throw new ParameterException("Need to provide a persistent topic name");
        }
        return topicName.toString();
    }

    static String validateNonPersistentTopic(List<String> params) {
        String topic = CliCommand.checkArgument(params);
        TopicName topicName = TopicName.get((String)topic);
        if (topicName.getDomain() != TopicDomain.non_persistent) {
            throw new ParameterException("Need to provide a non-persistent topic name");
        }
        return topicName.toString();
    }

    static void validateLatencySampleRate(int sampleRate) {
        if (sampleRate < 0) {
            throw new ParameterException("Latency sample rate should be positive and non-zero (found " + sampleRate + ")");
        }
    }

    static long validateSizeString(String s) {
        char last = s.charAt(s.length() - 1);
        String subStr = s.substring(0, s.length() - 1);
        switch (last) {
            case 'K': 
            case 'k': {
                return Long.parseLong(subStr) * 1024L;
            }
            case 'M': 
            case 'm': {
                return Long.parseLong(subStr) * 1024L * 1024L;
            }
            case 'G': 
            case 'g': {
                return Long.parseLong(subStr) * 1024L * 1024L * 1024L;
            }
            case 'T': 
            case 't': {
                return Long.parseLong(subStr) * 1024L * 1024L * 1024L * 1024L;
            }
        }
        return Long.parseLong(s);
    }

    static MessageId validateMessageIdString(String resetMessageIdStr) throws PulsarAdminException {
        return CliCommand.validateMessageIdString(resetMessageIdStr, -1);
    }

    static MessageId validateMessageIdString(String resetMessageIdStr, int partitionIndex) throws PulsarAdminException {
        String[] messageId = resetMessageIdStr.split(":");
        try {
            Preconditions.checkArgument((messageId.length == 2 ? 1 : 0) != 0);
            return new MessageIdImpl(Long.parseLong(messageId[0]), Long.parseLong(messageId[1]), partitionIndex);
        }
        catch (Exception e) {
            throw new PulsarAdminException("Invalid message id (must be in format: ledgerId:entryId) value " + resetMessageIdStr);
        }
    }

    static String checkArgument(List<String> arguments) {
        if (arguments.size() != 1) {
            throw new ParameterException("Need to provide just 1 parameter");
        }
        return arguments.get(0);
    }

    private static String[] splitParameter(List<String> params, int n) {
        if (params.size() != 1) {
            throw new ParameterException("Need to provide just 1 parameter");
        }
        String[] parts = params.get(0).split("/");
        if (parts.length != n) {
            throw new ParameterException("Parameter format is incorrect");
        }
        return parts;
    }

    static String getOneArgument(List<String> params) {
        if (params.size() != 1) {
            throw new ParameterException("Need to provide just 1 parameter");
        }
        return params.get(0);
    }

    static String getOneArgument(List<String> params, int pos, int maxArguments) {
        if (params.size() != maxArguments) {
            throw new ParameterException(String.format("Need to provide %s parameters", maxArguments));
        }
        return params.get(pos);
    }

    static Set<AuthAction> getAuthActions(List<String> actions) {
        TreeSet res = Sets.newTreeSet();
        for (String action : actions) {
            res.add(AuthAction.valueOf((String)action));
        }
        return res;
    }

    <T> void print(List<T> items) {
        for (T item : items) {
            this.print(item);
        }
    }

    <K, V> void print(Map<K, V> items) {
        for (Map.Entry<K, V> entry : items.entrySet()) {
            this.print(entry.getKey() + "    " + entry.getValue());
        }
    }

    <T> void print(T item) {
        try {
            if (item instanceof String) {
                System.out.println(item);
            } else {
                System.out.println(writer.writeValueAsString(item));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    abstract void run() throws Exception;
}

