/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli.examples;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.admin.cli.extensions.CommandExecutionContext;
import org.apache.pulsar.admin.cli.extensions.CustomCommand;
import org.apache.pulsar.admin.cli.extensions.CustomCommandFactory;
import org.apache.pulsar.admin.cli.extensions.CustomCommandGroup;
import org.apache.pulsar.admin.cli.extensions.ParameterDescriptor;
import org.apache.pulsar.admin.cli.extensions.ParameterType;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyCommandFactory
implements CustomCommandFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MyCommandFactory.class);

    public List<CustomCommandGroup> commandGroups(CommandExecutionContext context) {
        return Arrays.asList(new MyCustomCommandGroup());
    }

    private static class MyCustomCommandGroup
    implements CustomCommandGroup {
        private MyCustomCommandGroup() {
        }

        public String name() {
            return "customgroup";
        }

        public String description() {
            return "Custom group 1 description";
        }

        public List<CustomCommand> commands(CommandExecutionContext context) {
            return Arrays.asList(new Command1(), new Command2());
        }

        private static class Command1
        implements CustomCommand {
            private Command1() {
            }

            public String name() {
                return "command1";
            }

            public String description() {
                return "Command 1 description";
            }

            public List<ParameterDescriptor> parameters() {
                return Arrays.asList(ParameterDescriptor.builder().description("Operation type").type(ParameterType.STRING).names(Arrays.asList("--type", "-t")).required(true).build(), ParameterDescriptor.builder().description("Topic").type(ParameterType.STRING).mainParameter(true).names(Arrays.asList("topic")).required(true).build());
            }

            public boolean execute(Map<String, Object> parameters, CommandExecutionContext context) throws Exception {
                System.out.println("Execute: " + parameters + " properties " + context.getConfiguration());
                String destination = parameters.getOrDefault("topic", "").toString();
                TopicStats stats = context.getPulsarAdmin().topics().getStats(destination);
                System.out.println("Topic stats: " + stats);
                return false;
            }
        }

        private static class Command2
        implements CustomCommand {
            private Command2() {
            }

            public String name() {
                return "command2";
            }

            public String description() {
                return "Command 2 description";
            }

            public List<ParameterDescriptor> parameters() {
                return Arrays.asList(ParameterDescriptor.builder().description("mystring").type(ParameterType.STRING).names(Arrays.asList("-s")).build(), ParameterDescriptor.builder().description("myint").type(ParameterType.INTEGER).names(Arrays.asList("-i")).build(), ParameterDescriptor.builder().description("myboolean").type(ParameterType.BOOLEAN).names(Arrays.asList("-b")).build(), ParameterDescriptor.builder().description("mybooleanflag").type(ParameterType.BOOLEAN_FLAG).names(Arrays.asList("-bf")).build(), ParameterDescriptor.builder().description("main").type(ParameterType.STRING).mainParameter(true).names(Arrays.asList("main")).build());
            }

            public boolean execute(Map<String, Object> parameters, CommandExecutionContext context) throws Exception {
                System.out.println("Execute: " + parameters + " properties " + context.getConfiguration());
                return false;
            }
        }
    }
}

