/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.io.IOUtils;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarAdminException
extends Exception {
    private static final Logger log = LoggerFactory.getLogger(PulsarAdminException.class);
    private static final int DEFAULT_STATUS_CODE = 500;
    private final String httpError;
    private final int statusCode;

    private static String getReasonFromServer(WebApplicationException e) {
        try {
            ErrorData errorData = (ErrorData)e.getResponse().readEntity(ErrorData.class);
            if (errorData == null) {
                return e.getMessage();
            }
            return errorData.reason.toString();
        }
        catch (Exception ex) {
            try {
                Object entity = e.getResponse().getEntity();
                String errorAsString = entity instanceof InputStream ? IOUtils.toString((InputStream)((InputStream)entity), (String)StandardCharsets.UTF_8.name()) : entity.toString();
                return ((ErrorData)ObjectMapperFactory.getThreadLocal().readValue((String)errorAsString, ErrorData.class)).reason;
            }
            catch (Exception ex1) {
                try {
                    return ((ErrorData)ObjectMapperFactory.getThreadLocal().readValue((String)e.getMessage(), ErrorData.class)).reason;
                }
                catch (Exception ex2) {
                    return e.getMessage();
                }
            }
        }
    }

    public PulsarAdminException(ClientErrorException e) {
        super(PulsarAdminException.getReasonFromServer((WebApplicationException)e), (Throwable)e);
        this.httpError = PulsarAdminException.getReasonFromServer((WebApplicationException)e);
        this.statusCode = e.getResponse().getStatus();
    }

    public PulsarAdminException(ClientErrorException e, String message) {
        super(message, (Throwable)e);
        this.httpError = PulsarAdminException.getReasonFromServer((WebApplicationException)e);
        this.statusCode = e.getResponse().getStatus();
    }

    public PulsarAdminException(ServerErrorException e) {
        super(PulsarAdminException.getReasonFromServer((WebApplicationException)e), (Throwable)e);
        this.httpError = PulsarAdminException.getReasonFromServer((WebApplicationException)e);
        this.statusCode = e.getResponse().getStatus();
    }

    public PulsarAdminException(ServerErrorException e, String message) {
        super(PulsarAdminException.getReasonFromServer((WebApplicationException)e) + (message != null ? " " + message : ""), (Throwable)e);
        this.httpError = PulsarAdminException.getReasonFromServer((WebApplicationException)e);
        this.statusCode = e.getResponse().getStatus();
    }

    public PulsarAdminException(Throwable t) {
        super(t);
        this.httpError = null;
        this.statusCode = 500;
    }

    public PulsarAdminException(WebApplicationException e) {
        super(PulsarAdminException.getReasonFromServer(e), (Throwable)e);
        this.httpError = PulsarAdminException.getReasonFromServer(e);
        this.statusCode = e.getResponse().getStatus();
    }

    public PulsarAdminException(String message, Throwable t) {
        super(message, t);
        this.httpError = null;
        this.statusCode = 500;
    }

    public PulsarAdminException(String message) {
        super(message);
        this.httpError = null;
        this.statusCode = 500;
    }

    public String getHttpError() {
        return this.httpError;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static class GettingAuthenticationDataException
    extends PulsarAdminException {
        public GettingAuthenticationDataException(Throwable t) {
            super(t);
        }

        public GettingAuthenticationDataException(String msg) {
            super(msg);
        }
    }

    public static class ConnectException
    extends PulsarAdminException {
        public ConnectException(Throwable t) {
            super(t);
        }

        public ConnectException(String message, Throwable t) {
            super(message, t);
        }
    }

    public static class HttpErrorException
    extends PulsarAdminException {
        public HttpErrorException(Exception e) {
            super(e);
        }

        public HttpErrorException(Throwable t) {
            super(t);
        }
    }

    public static class ServerSideErrorException
    extends PulsarAdminException {
        public ServerSideErrorException(ServerErrorException e, String msg) {
            super(e, msg);
        }

        public ServerSideErrorException(ServerErrorException e) {
            super(e, "Some error occourred on the server");
        }
    }

    public static class TimeoutException
    extends PulsarAdminException {
        public TimeoutException(Throwable t) {
            super(t);
        }
    }

    public static class PreconditionFailedException
    extends PulsarAdminException {
        public PreconditionFailedException(ClientErrorException e) {
            super(e);
        }
    }

    public static class ConflictException
    extends PulsarAdminException {
        public ConflictException(ClientErrorException e) {
            super(e);
        }
    }

    public static class NotAllowedException
    extends PulsarAdminException {
        public NotAllowedException(ClientErrorException e) {
            super(e);
        }
    }

    public static class NotFoundException
    extends PulsarAdminException {
        public NotFoundException(ClientErrorException e) {
            super(e);
        }
    }

    public static class NotAuthorizedException
    extends PulsarAdminException {
        public NotAuthorizedException(ClientErrorException e) {
            super(e);
        }
    }
}

